--
-- AdditionalSettingsUtil
--
-- @author Rockstar
-- @date 27/03/2021
--


AdditionalSettingsUtil = {
	eventListeners = {}
}

function AdditionalSettingsUtil.registerEvent(eventName)
	AdditionalSettingsUtil.eventListeners[eventName] = {}
end

function AdditionalSettingsUtil.registerEventListener(eventName, object)
	table.insert(AdditionalSettingsUtil.eventListeners[eventName], object)
end

function AdditionalSettingsUtil.raiseEvent(eventName, ...)
	for _, object in pairs(AdditionalSettingsUtil.eventListeners[eventName]) do
		object[eventName](object, ...)
	end
end

function AdditionalSettingsUtil.prependedFunction(oldTarget, oldFunc, newTarget, newFunc)
	oldTarget[oldFunc] = Utils.prependedFunction(oldTarget[oldFunc], function(...) newTarget[newFunc](newTarget, ...) end)
end

function AdditionalSettingsUtil.appendedFunction(oldTarget, oldFunc, newTarget, newFunc)
	oldTarget[oldFunc] = Utils.appendedFunction(oldTarget[oldFunc], function(...) newTarget[newFunc](newTarget, ...) end)
end

function AdditionalSettingsUtil.overwrittenFunction(oldTarget, oldFunc, newTarget, newFunc)
	oldTarget[oldFunc] = Utils.overwrittenFunction(oldTarget[oldFunc], function(...) return newTarget[newFunc](newTarget, ...) end)
end

function AdditionalSettingsUtil.overwrittenStaticFunction(oldTarget, oldFunc, newTarget, newFunc)
	local func = oldTarget[oldFunc]

	oldTarget[oldFunc] = function(...)
		return newTarget[newFunc](newTarget, func, ...)
	end
end

function AdditionalSettingsUtil.callFunction(object, funcName, ...)
	local func = object[funcName]

	if func ~= nil then
		func(object, ...)
	end
end