--
-- AdditionalSettingsFrame
--
-- @author Rockstar
-- @date 27/03/2021
--


AdditionalSettingsFrame = {
	CONTROLS = {
		SETTINGS_CONTAINER = "settingsContainer",
		BOX_LAYOUT = "boxLayout",
		HELP_BOX = "additionalSettingsHelpBox",
		HELP_BOX_TEXT = "additionalSettingsHelpBoxText",
		CHECKBOX_HUD = "checkHUD",
		OPTION_CROSSHAIR = "multiCrosshair",
		OPTION_CURRENT_DATE = "multiCurrentDate",
		OPTION_CLOCK_POSITION = "multiClockPosition",
		CHECKBOX_HOUR_FORMAT = "checkHourFormat",
		OPTION_FADE_EFFECT = "multiFadeEffect",
		CHECK_DIALOG_BOXES = "checkDialogBoxes",
		CHECK_FILL_LEVEL_HUD = "checkFillLevelHUD",
		OPTION_VEHICLE_CAMERA_MOVEMENT = "multiVehicleCameraMovement",
		OPTION_PLAYER_CAMERA_MOVEMENT = "multiPlayerCameraMovement",
		CHECK_EASY_MOTOR_START = "checkEasyMotorStart",
		CHECK_AUTOSTART = "checkAutostart",
		OPTION_STORE_ITEMS = "mulitStoreItems",
		OPTION_LIGHTING = "multiLighting",
		OPTION_BRIGHTNESS = "multiBrightness",
		CHECK_DOF = "checkDOF",
		CHECK_BIRDS = "checkBirds",
		CHECK_ANIMALS_COLLISIONS = "checkAnimalsCollisions",
		CHECK_CAMERA_COLLISIONS = "checkCameraCollisions",
		CHECK_GUI_CAMERA = "checkGuiCamera"
	}
}

local AdditionalSettingsFrame_mt = Class(AdditionalSettingsFrame, TabbedMenuFrameElement)

function AdditionalSettingsFrame:new(subclass_mt)
	local subclass_mt = subclass_mt or AdditionalSettingsFrame_mt
	local self = TabbedMenuFrameElement:new(nil, subclass_mt or AdditionalSettingsFrame_mt)

	self:registerControls(AdditionalSettingsFrame.CONTROLS)

	self.isDirty = false

	self.checkboxMapping = {}
	self.optionMapping = {}

	return self
end

function AdditionalSettingsFrame:getMainElementSize()
	return self.settingsContainer.size
end

function AdditionalSettingsFrame:getMainElementPosition()
	return self.settingsContainer.absPosition
end

function AdditionalSettingsFrame:onFrameOpen(element)
	AdditionalSettingsFrame:superClass().onFrameOpen(self)

	self:updateAdditionalSettings()
	self.isDirty = false

	self.boxLayout:invalidateLayout()
	FocusManager:setFocus(self.boxLayout)
end

function AdditionalSettingsFrame:onFrameClose()
	AdditionalSettingsFrame:superClass().onFrameClose(self)

	if self.isDirty then
		self.settingsManager:saveSettingsToXMLFile()
		self.isDirty = false
	end
end

function AdditionalSettingsFrame:initialize(settingsManager)
	local addittionalSettings = settingsManager.addittionalSettings

	self.checkboxMapping[self.checkHUD] = addittionalSettings.hud
	self.checkboxMapping[self.checkHourFormat] = addittionalSettings.hourFormat
	self.checkboxMapping[self.checkDialogBoxes] = addittionalSettings.dialogBoxes
	self.checkboxMapping[self.checkFillLevelHUD] = addittionalSettings.fillLevelHud
	self.checkboxMapping[self.checkEasyMotorStart] = addittionalSettings.easyMotorStart
	self.checkboxMapping[self.checkAutostart] = addittionalSettings.autostart
	self.checkboxMapping[self.checkDOF] = addittionalSettings.dof
	self.checkboxMapping[self.checkBirds] = addittionalSettings.birds
	self.checkboxMapping[self.checkAnimalsCollisions] = addittionalSettings.animalsCollisions
	self.checkboxMapping[self.checkCameraCollisions] = addittionalSettings.cameraCollisions
	self.checkboxMapping[self.checkGuiCamera] = addittionalSettings.guiCamera

	self.optionMapping[self.multiCrosshair] = addittionalSettings.crosshair
	self.optionMapping[self.multiCurrentDate] = addittionalSettings.currentDate
	self.optionMapping[self.multiClockPosition] = addittionalSettings.clockPosition
	self.optionMapping[self.multiFadeEffect] = addittionalSettings.fadeEffect
	self.optionMapping[self.multiVehicleCameraMovement] = addittionalSettings.vehicleCameraMovement
	self.optionMapping[self.multiPlayerCameraMovement] = addittionalSettings.playerCameraMovement
	self.optionMapping[self.mulitStoreItems] = addittionalSettings.storeItems
	self.optionMapping[self.multiLighting] = addittionalSettings.lighting
	self.optionMapping[self.multiBrightness] = addittionalSettings.brightness

	for checkboxElement, settingsKey in pairs(self.checkboxMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onCreateElement", checkboxElement)
	end

	for optionElement, settingsKey in pairs(self.optionMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onCreateElement", optionElement)
	end

	self.settingsManager = settingsManager
end

function AdditionalSettingsFrame:updateAdditionalSettings()
	for checkboxElement, settingsKey in pairs(self.checkboxMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onFrameOpen", checkboxElement)
		checkboxElement:setIsChecked(settingsKey.active)
	end

	for optionElement, settingsKey in pairs(self.optionMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onFrameOpen", optionElement)
		optionElement:setState(settingsKey.state + 1)
	end
end

function AdditionalSettingsFrame:updateToolTipBoxVisibility()
	local hasText = self.additionalSettingsHelpBoxText.text ~= nil and self.additionalSettingsHelpBoxText.text ~= ""

	self.additionalSettingsHelpBox:setVisible(hasText)
end

function AdditionalSettingsFrame:onToolTipBoxTextChanged(element, text)
	self:updateToolTipBoxVisibility()
end

function AdditionalSettingsFrame:onClickCheckbox(state, checkboxElement)
	local checkboxMapping = self.checkboxMapping[checkboxElement]

	if checkboxMapping ~= nil then
		local newState = state == CheckedOptionElement.STATE_CHECKED
		checkboxMapping.active = newState

		AdditionalSettingsUtil.callFunction(checkboxMapping, "onStateChange", newState, checkboxElement, false)
		self.isDirty = true
	else
		print("Warning: Invalid settings checkbox event or key configuration for element " .. checkboxElement:toString())
	end
end

function AdditionalSettingsFrame:onClickMultiOption(state, optionElement)
	local optionMapping = self.optionMapping[optionElement]

	if optionMapping ~= nil then
		local newState = state - 1
		optionMapping.state = newState

		AdditionalSettingsUtil.callFunction(optionMapping, "onStateChange", newState, optionElement, false)
		self.isDirty = true
	else
		print("Warning: Invalid settings multi option event or key configuration for element " .. optionElement:toString())
	end
end