--
-- main
--
-- @author Rockstar
-- @date 27/03/2021
--


local function init(modDir, modName)
	source(Utils.getFilename("scripts/AdditionalSettingsUtil.lua", modDir))
	source(Utils.getFilename("scripts/AdditionalSettingsManager.lua", modDir))
	source(Utils.getFilename("scripts/Settings.lua", modDir))
	source(Utils.getFilename("scripts/gui/AdditionalSettingsFrameReference.lua", modDir))
	source(Utils.getFilename("scripts/gui/AdditionalSettingsFrame.lua", modDir))
	source(Utils.getFilename("scripts/gui/hud/TrailerFillLevelHUD.lua", modDir))

	Mission00.setMissionInfo = Utils.prependedFunction(Mission00.setMissionInfo, function(object, missionInfo, missionDynamicInfo)
		getfenv(0).g_additionalSettingsManager = AdditionalSettingsManager:new(modDir, modName)
	end)

	VehicleTypeManager.finalizeVehicleTypes = Utils.prependedFunction(VehicleTypeManager.finalizeVehicleTypes, function(object)
		for typeName, typeEntry in pairs(object:getVehicleTypes()) do
			local addSpecialization = SpecializationUtil.hasSpecialization(Trailer, typeEntry.specializations) or typeName == "manureSpreader"

			if addSpecialization then
				object:addSpecialization(typeName, modName .. ".trailerHUDSpec")
			end
		end
	end)
end

init(g_currentModDirectory, g_currentModName)