--
-- TrailerHUDSpec
--
-- @author Rockstar
-- @date 27/03/2021
--


TrailerHUDSpec = {
	specEntryName = string.format("spec_%s.trailerHUDSpec", g_currentModName)
}

function TrailerHUDSpec.prerequisitesPresent(specializations)
	return true
end

function TrailerHUDSpec.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", TrailerHUDSpec)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", TrailerHUDSpec)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", TrailerHUDSpec)
	SpecializationUtil.registerEventListener(vehicleType, "onChangedFillType", TrailerHUDSpec)
	SpecializationUtil.registerEventListener(vehicleType, "onFillUnitFillLevelChanged", TrailerHUDSpec)
end

function TrailerHUDSpec:onLoad(savegame)
	local spec = self[TrailerHUDSpec.specEntryName]
	local hudSettings = g_additionalSettingsManager:getSettingByName("fillLevelHud")
	local hud = hudSettings:loadHUD()

	if hud ~= nil then
		spec.hud = hud
		spec.lastFillUnitIndex = 1
		spec.fillLevelHUDEnabled = 0
		spec.fillLevelHUDEnabledTime = 2500
		spec.maxDrawDistance = 35
	end
end

function TrailerHUDSpec:onDelete()
	local spec = self[TrailerHUDSpec.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		local hudSettings = g_additionalSettingsManager:getSettingByName("fillLevelHud")
		hudSettings:deleteHUD(hud)
	end
end

function TrailerHUDSpec:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local spec = self[TrailerHUDSpec.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		local hudVisible = false

		if g_additionalSettingsManager:getSettingStateByName("fillLevelHud") and not isActiveForInputIgnoreSelection then
			spec.fillLevelHUDEnabled = math.max(spec.fillLevelHUDEnabled - dt, 0)

			if spec.fillLevelHUDEnabled > 0 then
				local canFarmAccess = g_currentMission.accessHandler:canFarmAccess(g_currentMission:getFarmId(), self)
				local fillType = self:getFillUnitLastValidFillType(spec.lastFillUnitIndex)

				if canFarmAccess and fillType ~= nil and fillType ~= FillType.UNKNOWN then
					local x, y, z = getWorldTranslation(self.rootNode)
					y = y + 3.5

					local sx, sy, sz = project(x, y, z)

					if sx > -1 and sx < 2 and sy > -1 and sy < 2 and sz <= 1 then
						local vx, vy, vz = getWorldTranslation(getCamera())
						local distance = MathUtil.vector3Length(x - vx, y - vy, z - vz)

						if distance <= spec.maxDrawDistance then
							local scale = 1 / distance * 10
							local fillLevelName = g_fillTypeManager:getFillTypeByIndex(fillType).title
							local fillLevel = self:getFillUnitFillLevel(spec.lastFillUnitIndex)
							local fillLevelPercentage = self:getFillUnitFillLevelPercentage(spec.lastFillUnitIndex)
							local fillLevelText = string.format("%d (%d%%)", MathUtil.round(fillLevel), 100 * fillLevelPercentage)

							hud:updateData(dt, sx, sy, scale, fillLevelPercentage, fillLevelText, fillLevelName)
							hudVisible = true
						end
					end
				end

				self:raiseActive()
			end
		end

		hud:setVisible(hudVisible)
	end
end

function TrailerHUDSpec:onChangedFillType(fillUnitIndex, fillTypeIndex, oldFillTypeIndex)
	local spec = self[TrailerHUDSpec.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		hud:updateFillTypeIcon(g_fillTypeManager:getFillTypeByIndex(self:getFillUnitFillType(fillUnitIndex)).hudOverlayFilenameSmall)
	end
end

function TrailerHUDSpec:onFillUnitFillLevelChanged(fillUnitIndex, fillLevelDelta, fillTypeIndex, toolType, fillPositionData, appliedDelta)
	local spec = self[TrailerHUDSpec.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		if g_additionalSettingsManager:getSettingStateByName("fillLevelHud") and fillLevelDelta > 0 then
			spec.fillLevelHUDEnabled = spec.fillLevelHUDEnabledTime
			spec.lastFillUnitIndex = fillUnitIndex
		end
	end
end