---Advanced Stats

---@author King of Modding
---@version 2.2.0.0
---@date 04/11/2020

---@class ExtendedLivestockTrailer : AdvancedStatsExtendedSpecialization
---@field spec_livestockTrailer any
ExtendedLivestockTrailer = {}
ExtendedLivestockTrailer.MOD_NAME = g_currentModName
ExtendedLivestockTrailer.SPEC_TABLE_NAME = string.format("spec_%s.extendedLivestockTrailer", ExtendedLivestockTrailer.MOD_NAME)

function ExtendedLivestockTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AdvancedStats, specializations)
end

function ExtendedLivestockTrailer.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoadStats", ExtendedLivestockTrailer)
end

function ExtendedLivestockTrailer.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "addAnimal", ExtendedLivestockTrailer.addAnimal)
end

function ExtendedLivestockTrailer:onLoadStats()
    local spec = self:getAdvancedStatsSpecTable(ExtendedLivestockTrailer.SPEC_TABLE_NAME)

    spec.hasAdvancedStats = true
    spec.advancedStatisticsPrefix = "LivestockTrailer"

    if self.isServer then
        spec.advancedStatistics =
            self:registerStats(
            spec.advancedStatisticsPrefix,
            {
                {"LoadedAnimals", AdvancedStats.UNITS.ND}
            }
        )
    end
end

function ExtendedLivestockTrailer:addAnimal(superFunc, animal, ...)
    if self.isServer then
        local place = self.spec_livestockTrailer.animalTypeToPlaces[animal.subType.type]
        local used = place.numUsed
        superFunc(self, animal, ...)
        if place.numUsed > used then
            local spec = self:getAdvancedStatsSpecTable(ExtendedLivestockTrailer.SPEC_TABLE_NAME)
            self:updateStat(spec.advancedStatistics["LoadedAnimals"], 1)
        end
    else
        superFunc(self, animal, ...)
    end
end
