--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionSellMilkEvent = {}

local AnimalPenExtensionSellMilkEvent_mt = Class(AnimalPenExtensionSellMilkEvent, Event)
InitEventClass(AnimalPenExtensionSellMilkEvent, "AnimalPenExtensionSellMilkEvent")

function AnimalPenExtensionSellMilkEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionSellMilkEvent_mt)
    return self
end

function AnimalPenExtensionSellMilkEvent:new(animalPen, amountToSell, contractorFee, sellPoint)
    local self = AnimalPenExtensionSellMilkEvent:emptyNew()

    self.animalPen = animalPen
    self.amountToSell = amountToSell
    self.contractorFee = contractorFee
    self.sellPoint = sellPoint

    return self
end

function AnimalPenExtensionSellMilkEvent:readStream(streamId, connection)
    self.animalPen = NetworkUtil.readNodeObject(streamId)
    self.amountToSell = streamReadFloat32(streamId)
    self.contractorFee = streamReadFloat32(streamId)
    self.sellPoint = NetworkUtil.readNodeObject(streamId)

    if g_server ~= nil and self.animalPen ~= nil and self.sellPoint ~= nil then
        self.animalPen:sellMilkCallback(self.amountToSell, self.contractorFee, self.sellPoint)
    end
end

function AnimalPenExtensionSellMilkEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.animalPen)
    streamWriteFloat32(streamId, self.amountToSell)
    streamWriteFloat32(streamId, self.contractorFee)
    NetworkUtil.writeNodeObject(streamId, self.sellPoint)
end

function AnimalPenExtensionSellMilkEvent:run(connection)
    print("  Error: AnimalPenExtensionSellMilkEvent is a client to server only event")
end
