--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 17.07.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.1.0.0 @ 25.09.2020 - Added support for scaling and syncing of different parts.

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionUniversalPartsEvent = {}
AnimalPenExtensionUniversalPartsEvent_mt = Class(AnimalPenExtensionUniversalPartsEvent, Event)
InitEventClass(AnimalPenExtensionUniversalPartsEvent, "AnimalPenExtensionUniversalPartsEvent")

function AnimalPenExtensionUniversalPartsEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionUniversalPartsEvent_mt)
    return self
end

function AnimalPenExtensionUniversalPartsEvent:new(animalPen, parts, isWaterAddon, selectedColourIndex)
    local self = AnimalPenExtensionUniversalPartsEvent:emptyNew()

    self.animalPen = animalPen
    self.parts = parts
    self.isWaterAddon = isWaterAddon
    self.selectedColourIndex = math.max(selectedColourIndex or 0, 0)

    return self
end

function AnimalPenExtensionUniversalPartsEvent:readStream(streamId, connection)
    local parts = {}

    local animalPen = NetworkUtil.readNodeObject(streamId)
    local numParts = streamReadUInt8(streamId)

    for i = 1, numParts do
        local part = {}

        part.x = streamReadFloat32(streamId)
        part.y = streamReadFloat32(streamId)
        part.z = streamReadFloat32(streamId)

        part.ry = NetworkUtil.readCompressedAngle(streamId)

        part.sx = streamReadFloat32(streamId)
        part.sy = streamReadFloat32(streamId)
        part.sz = streamReadFloat32(streamId)

        table.insert(parts, part)
    end

    local isWaterAddon = streamReadBool(streamId)
    local selectedColourIndex = streamReadUInt8(streamId)

    if animalPen ~= nil and animalPen:setUniversalParts(parts, isWaterAddon, true, selectedColourIndex) then
        if g_server ~= nil then
            g_server:broadcastEvent(AnimalPenExtensionUniversalPartsEvent:new(animalPen, parts, isWaterAddon, selectedColourIndex))
        end
    end
end

function AnimalPenExtensionUniversalPartsEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.animalPen)

    local numParts = #self.parts
    streamWriteUInt8(streamId, numParts)

    for i = 1, numParts do
        local part = self.parts[i]

        streamWriteFloat32(streamId, part.x)
        streamWriteFloat32(streamId, part.y)
        streamWriteFloat32(streamId, part.z)

        NetworkUtil.writeCompressedAngle(streamId, part.ry)

        streamWriteFloat32(streamId, part.sx)
        streamWriteFloat32(streamId, part.sy)
        streamWriteFloat32(streamId, part.sz)
    end

    streamWriteBool(streamId, self.isWaterAddon)
    streamWriteUInt8(streamId, self.selectedColourIndex)
end
