--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 25.08.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 25.08.2019 - Release Version

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


ObjectStorageSpecialStoreEvent = {}
local ObjectStorageSpecialStoreEvent_mt = Class(ObjectStorageSpecialStoreEvent, Event)

InitEventClass(ObjectStorageSpecialStoreEvent, "ObjectStorageSpecialStoreEvent")

function ObjectStorageSpecialStoreEvent:emptyNew()
    local self = Event:new(ObjectStorageSpecialStoreEvent_mt)

    return self
end

function ObjectStorageSpecialStoreEvent:new(storage, fillTypeIndex, fillLevel, isFermenting, wrappingColour, bale)
    local self = ObjectStorageSpecialStoreEvent:emptyNew()

    self.storage = storage
    self.fillTypeIndex = fillTypeIndex
    self.fillLevel = fillLevel

    self.isFermenting = isFermenting
    self.wrappingColour = wrappingColour

    if g_seasons ~= nil and (fillLevel == 0 and isFermenting) and bale ~= nil then
        self.bale = bale
        self.baleFillTypeIndex = self.bale:getFillType()
    end

    return self
end

function ObjectStorageSpecialStoreEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.storage)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)

    streamWriteFloat32(streamId, self.fillLevel)
    streamWriteBool(streamId, self.isFermenting)

    if streamWriteBool(streamId, self.wrappingColour ~= nil) then
        streamWriteFloat32(streamId, self.wrappingColour[1])
        streamWriteFloat32(streamId, self.wrappingColour[2])
        streamWriteFloat32(streamId, self.wrappingColour[3])
        streamWriteFloat32(streamId, self.wrappingColour[4])
    end

    if g_seasons ~= nil and self.bale ~= nil then
        NetworkUtil.writeNodeObject(streamId, self.bale)
        streamWriteUIntN(streamId, self.baleFillTypeIndex, FillTypeManager.SEND_NUM_BITS)
    end
end

function ObjectStorageSpecialStoreEvent:readStream(streamId, connection)
    self.storage = NetworkUtil.readNodeObject(streamId)
    self.fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)

    self.fillLevel = streamReadFloat32(streamId)
    self.isFermenting = streamReadBool(streamId)

    if streamReadBool(streamId) then
        local r = streamReadFloat32(streamId)
        local g = streamReadFloat32(streamId)
        local b = streamReadFloat32(streamId)
        local a = streamReadFloat32(streamId)
        self.wrappingColour = {r, g, b, a}
    end

    -- Only for 'Seasons' support if a bale is spawned and not fully fermented yet.
    if g_seasons ~= nil and (self.fillLevel == 0 and self.isFermenting) then
        self.bale = NetworkUtil.readNodeObject(streamId)
        self.baleFillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
    end

    self:run(connection)
end

function ObjectStorageSpecialStoreEvent:run(connection)
    if self.storage ~= nil then
        self.storage:updateStoredObjects(self.fillTypeIndex, self.fillLevel, self.isFermenting, self.wrappingColour, nil, false)

        if g_seasons ~= nil and (self.bale ~= nil and self.baleFillTypeIndex ~= nil) then
            bale.fillType = self.baleFillTypeIndex
            bale:setFillLevel(bale.fillLevel)
        end
    end
end

function ObjectStorageSpecialStoreEvent.sendEvent(storage, fillTypeIndex, fillLevel, isFermenting, bale)
    if g_server ~= nil then
        g_server:broadcastEvent(ObjectStorageSpecialStoreEvent:new(storage, fillTypeIndex, fillLevel, isFermenting, bale), nil, nil, storage)
    else
        print("  Error: [ObjectStorageSpecialStoreEvent] This is a Server > Client event only!")
    end
end
