--- BunkerSiloHUD.lua ---
---    by XPModder    ---
---     14.10.2020    ---

BunkerSiloHUD = {}

BunkerSiloHUD.metadata = {
    name = "Bunker Silo HUD",
    author = "XPModder",
    version = "1.0.0",
    created = "14.10.2020",
    updated = "15.10.2020",
    fsVersion = "19",
    info = "Adds a small HUD for Bunker Silos, so you don#t have to open F1 to see the current progress"
}

BunkerSiloHUD.backgroundOL = createImageOverlay(g_currentModDirectory.."back.dds")

path = tostring(g_currentModDirectory.."back.dds")

posX = 0.88
posY = 0.8
size = 0.018
sizeHeader = 0.020
width = 0.12
height = 0.14

drawOverlay = false

line1 = ""
line2 = ""
line3 = ""


function BunkerSiloHUD.updateSilo(self, superFunc, dt)

    local returnValue = superFunc(self, dt)

    if self == nil then
        return
    end

    if self:getCanInteract(true) then
        if g_currentMission.hud.isVisible then
            if not g_gui:getIsGuiVisible() then

                self.currentFillLevel = math.ceil(self.fillLevel, 0)

                if self.state == BunkerSilo.STATE_FILL then
                    self.currentFermentingPercent = 0
                    self.currentCompactedPercent = self.compactedPercent
                else
                    self.currentFermentingPercent = self.fermentingPercent
                    self.currentCompactedPercent = 100
                end

                local fillTypeIndex = self.inputFillType

                if self.state == BunkerSilo.STATE_CLOSED or self.state == BunkerSilo.STATE_FERMENTED or self.state == BunkerSilo.STATE_DRAIN then
                    fillTypeIndex = self.outputFillType
                end

                local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
                if fillType ~= nil then
                    fillTypeName = fillType.title
                end

                local fillTypeLabel = g_i18n:getText("hud_filltype").." "..tostring(fillTypeName)
                local fillLevelLabel = g_i18n:getText("hud_filllevel").." "..tostring(math.ceil(self.fillLevel)).." L"
                local compacted = g_i18n:getText("hud_compacted").." "..tostring(self.compactedPercent).."%"
                local fermented = g_i18n:getText("hud_fermenting").." "..tostring(self.fermentingPercent).."%"
                
                line1 = tostring(fillTypeLabel)
                line2 = tostring(fillLevelLabel)

                if self.state == BunkerSilo.STATE_CLOSED then
                    line3 = tostring(fermented)
                elseif self.state == BunkerSilo.STATE_FILL then
                    line3 = tostring(compacted)
                end

                drawOverlay = true

            end
        end
    end

    return returnValue

end


function load(mission)
    print("--- Mod: "..BunkerSiloHUD.metadata.name..", Version "..BunkerSiloHUD.metadata.version.." for Farming Simulator "..BunkerSiloHUD.metadata.fsVersion.." loaded! ---")
end


function BunkerSiloHUD:draw()

    if drawOverlay then

        setOverlayColor(BunkerSiloHUD.backgroundOL, 1.0, 1.0, 1.0, 1.0)
        renderOverlay(BunkerSiloHUD.backgroundOL, posX - 0.008, posY - 0.08, width, height)
        setTextColor(1,1,1,1)
        setTextAlignment(RenderText.ALIGN_LEFT)

        setTextBold(true)
        renderText(posX, posY + 0.03, sizeHeader, g_i18n:getText("hud_bunkersilo"))
        setTextBold(false)

        renderText(posX, posY, size, tostring(line1))
        renderText(posX, posY - 0.03, size, tostring(line2))

        renderText(posX, posY - 0.06, size, tostring(line3))

        drawOverlay = false

    end

end


local function init()

    BunkerSilo.update = Utils.overwrittenFunction(BunkerSilo.update, BunkerSiloHUD.updateSilo)
    Mission00.load = Utils.prependedFunction(Mission00.load, load)

end


addModEventListener(BunkerSiloHUD)
init()