--- Call Contractors

---@author Royal Modding
---@version 2.0.0.0
---@date 25/03/2021

---@class SowingContractType : ContractType
SowingContractType = {}
local SowingContractType_mt = Class(SowingContractType, ContractType)

--- SowingContractType base class
---@param id number
---@param contractClass Contract
---@param name string
---@param title string
---@param mt? table custom meta table
---@return SowingContractType
function SowingContractType.new(id, contractClass, name, title, mt)
    ---@type SowingContractType
    local self = ContractType.new(id, contractClass, name, title, mt or SowingContractType_mt)
    self.requireFieldParam = true
    self.requireFruitParam = true
    return self
end

---@param farmId integer
---@param fruit FruitTypeEntry
---@return boolean
function SowingContractType.fruitsFilter(farmId, fruit)
    return fruit.index ~= FruitType.POPLAR and fruit.allowsSeeding
end
