SecondFillTrigger = {}

SecondFillTrigger.specName = string.format("spec_%s.secondFillTrigger", g_currentModName)


function SecondFillTrigger.registerEventListeners(vehicleType)
	local functionNames = {	"onLoad", "onDelete" };
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, SecondFillTrigger);
	end
end

function SecondFillTrigger:onLoad(savegame)
    local spec = self[SecondFillTrigger.specName]
    local triggerNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.fillTriggerVehicle2#triggerNode"), self.i3dMappings)
    if triggerNode ~= nil then
        spec.fillUnitIndex2 = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.fillTriggerVehicle2#fillUnitIndex"), 1)
        spec.litersPerSecond2 = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.fillTriggerVehicle2#litersPerSecond"), 50)
        spec.fillTrigger2 = FillTrigger:new(triggerNode, self, spec.fillUnitIndex2, spec.litersPerSecond2)
        if self:getPropertyState() ~= Vehicle.PROPERTY_STATE_SHOP_CONFIG then
            spec.fillTrigger2:finalize()
        end
    end
end

function SecondFillTrigger:onDelete()
    local spec = self[SecondFillTrigger.specName]
    if spec.fillTrigger2 ~= nil then
        spec.fillTrigger2:delete()
        spec.fillTrigger2 = nil
    end
end

function SecondFillTrigger.prerequisitesPresent(specializations)
    return true
end