-- event class to change the background color of license plates

LicensePlatesBackgroundColorEvent = {}
local LicensePlatesBackgroundColorEvent_mt = Class(LicensePlatesBackgroundColorEvent, Event)
InitEventClass(LicensePlatesBackgroundColorEvent, "LicensePlatesBackgroundColorEvent")

function LicensePlatesBackgroundColorEvent:emptyNew()
	local self = Event:new(LicensePlatesBackgroundColorEvent_mt)

	return self
end

function LicensePlatesBackgroundColorEvent:new(vehicle, backgroundColor)
	local self = LicensePlatesBackgroundColorEvent:emptyNew()
	self.vehicle = vehicle
	self.backgroundColor = backgroundColor

	return self
end

function LicensePlatesBackgroundColorEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.backgroundColor = streamReadUInt8(streamId)

	self:run(connection)
end

function LicensePlatesBackgroundColorEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteUInt8(streamId, self.backgroundColor)
end

function LicensePlatesBackgroundColorEvent:run(connection)
	LicensePlates.setBackgroundColor(self.vehicle, self.backgroundColor, true) -- noEventSend

	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.vehicle)
	end
end

function LicensePlatesBackgroundColorEvent.sendEvent(vehicle, backgroundColor, noEventSend)
	if not noEventSend then
		if g_server then
			g_server:broadcastEvent(LicensePlatesBackgroundColorEvent:new(vehicle, backgroundColor), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(LicensePlatesBackgroundColorEvent:new(vehicle, backgroundColor))
		end
	end
end
