-- event class to change the country code of license plates

LicensePlatesCountryCodeEvent= {}
local LicensePlatesCountryCodeEvent_mt = Class(LicensePlatesCountryCodeEvent, Event)
InitEventClass(LicensePlatesCountryCodeEvent, "LicensePlatesCountryCodeEvent")

function LicensePlatesCountryCodeEvent:emptyNew()
	local self = Event:new(LicensePlatesCountryCodeEvent_mt)

	return self
end

function LicensePlatesCountryCodeEvent:new(vehicle, countryCode)
	local self = LicensePlatesCountryCodeEvent:emptyNew()
	self.vehicle = vehicle
	self.countryCode = countryCode

	return self
end

function LicensePlatesCountryCodeEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.countryCode = streamReadUInt8(streamId)

	self:run(connection)
end

function LicensePlatesCountryCodeEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteUInt8(streamId, self.countryCode)
end

function LicensePlatesCountryCodeEvent:run(connection)
	LicensePlates.setCountryCode(self.vehicle, self.countryCode, true) -- noEventSend

	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.vehicle)
	end
end

function LicensePlatesCountryCodeEvent.sendEvent(vehicle, countryCode, noEventSend)
	if not noEventSend then
		if g_server then
			g_server:broadcastEvent(LicensePlatesCountryCodeEvent:new(vehicle, countryCode), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(LicensePlatesCountryCodeEvent:new(vehicle, countryCode))
		end
	end
end
