-- event class to switch format on small plates

LicensePlatesSmallPlateFormatEvent = {}
local LicensePlatesSmallPlateFormatEvent_mt = Class(LicensePlatesSmallPlateFormatEvent, Event)
InitEventClass(LicensePlatesSmallPlateFormatEvent, "LicensePlatesSmallPlateFormatEvent")

function LicensePlatesSmallPlateFormatEvent:emptyNew()
	local self = Event:new(LicensePlatesSmallPlateFormatEvent_mt)

	return self
end

function LicensePlatesSmallPlateFormatEvent:new(vehicle, useFormat46)
	local self = LicensePlatesSmallPlateFormatEvent:emptyNew()
	self.vehicle = vehicle
	self.useFormat46 = useFormat46

	return self
end

function LicensePlatesSmallPlateFormatEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.useFormat46 = streamReadBool(streamId)

	self:run(connection)
end

function LicensePlatesSmallPlateFormatEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteBool(streamId, self.useFormat46)
end

function LicensePlatesSmallPlateFormatEvent:run(connection)
	LicensePlates.setSmallPlateFormat(self.vehicle, self.useFormat46, true) -- noEventSend

	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.vehicle)
	end
end

function LicensePlatesSmallPlateFormatEvent.sendEvent(vehicle, useFormat46, noEventSend)
	if not noEventSend then
		if g_server then
			g_server:broadcastEvent(LicensePlatesSmallPlateFormatEvent:new(vehicle, useFormat46), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(LicensePlatesSmallPlateFormatEvent:new(vehicle, useFormat46))
		end
	end
end
