-- event class to change the symbol color of license plates

LicensePlatesSymbolColorEvent= {}
local LicensePlatesSymbolColorEvent_mt = Class(LicensePlatesSymbolColorEvent, Event)
InitEventClass(LicensePlatesSymbolColorEvent, "LicensePlatesSymbolColorEvent")

function LicensePlatesSymbolColorEvent:emptyNew()
	local self = Event:new(LicensePlatesSymbolColorEvent_mt)

	return self
end

function LicensePlatesSymbolColorEvent:new(vehicle, symbolColor)
	local self = LicensePlatesSymbolColorEvent:emptyNew()
	self.vehicle = vehicle
	self.symbolColor = symbolColor

	return self
end

function LicensePlatesSymbolColorEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.symbolColor = streamReadUInt8(streamId)

	self:run(connection)
end

function LicensePlatesSymbolColorEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteUInt8(streamId, self.symbolColor)
end

function LicensePlatesSymbolColorEvent:run(connection)
	LicensePlates.setSymbolColor(self.vehicle, self.symbolColor, true) -- noEventSend

	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.vehicle)
	end
end

function LicensePlatesSymbolColorEvent.sendEvent(vehicle, symbolColor, noEventSend)
	if not noEventSend then
		if g_server then
			g_server:broadcastEvent(LicensePlatesSymbolColorEvent:new(vehicle, symbolColor), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(LicensePlatesSymbolColorEvent:new(vehicle, symbolColor))
		end
	end
end
