-- event class to change the text of license plates

LicensePlatesTextEvent = {}
local LicensePlatesTextEvent_mt = Class(LicensePlatesTextEvent, Event)
InitEventClass(LicensePlatesTextEvent, "LicensePlatesTextEvent")

function LicensePlatesTextEvent:emptyNew()
	local self = Event:new(LicensePlatesTextEvent_mt)

	return self
end

function LicensePlatesTextEvent:new(vehicle, text)
	local self = LicensePlatesTextEvent:emptyNew()
	self.vehicle = vehicle
	self.text = text

	return self
end

function LicensePlatesTextEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.text = streamReadString(streamId)

	self:run(connection)
end

function LicensePlatesTextEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteString(streamId, self.text)
end

function LicensePlatesTextEvent:run(connection)
	LicensePlates.setText(self.vehicle, self.text, true) -- noEventSend

	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.vehicle)
	end
end

function LicensePlatesTextEvent.sendEvent(vehicle, text, noEventSend)
	if not noEventSend then
		if g_server then
			g_server:broadcastEvent(LicensePlatesTextEvent:new(vehicle, text), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(LicensePlatesTextEvent:new(vehicle, text))
		end
	end
end
