-- event class to make license plates (in-)visible

LicensePlatesVisibilityEvent = {}
local LicensePlatesVisibilityEvent_mt = Class(LicensePlatesVisibilityEvent, Event)
InitEventClass(LicensePlatesVisibilityEvent, "LicensePlatesVisibilityEvent")

function LicensePlatesVisibilityEvent:emptyNew()
	local self = Event:new(LicensePlatesVisibilityEvent_mt)

	return self
end

function LicensePlatesVisibilityEvent:new(vehicle, isVisible)
	local self = LicensePlatesVisibilityEvent:emptyNew()
	self.vehicle = vehicle
	self.isVisible = isVisible

	return self
end

function LicensePlatesVisibilityEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.isVisible = streamReadBool(streamId)

	self:run(connection)
end

function LicensePlatesVisibilityEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteBool(streamId, self.isVisible)
end

function LicensePlatesVisibilityEvent:run(connection)
	LicensePlates.setVisible(self.vehicle, self.isVisible, true) -- noEventSend

	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.vehicle)
	end
end

function LicensePlatesVisibilityEvent.sendEvent(vehicle, isVisible, noEventSend)
	if not noEventSend then
		if g_server then
			g_server:broadcastEvent(LicensePlatesVisibilityEvent:new(vehicle, isVisible), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(LicensePlatesVisibilityEvent:new(vehicle, isVisible))
		end
	end
end
