-- gui for license plates

LicensePlatesGui = {}
local LicensePlatesGui_mt = Class(LicensePlatesGui, YesNoDialog)

-- used elements from xml
LicensePlatesGui.CONTROLS = {
	"dialogTitleElement",
	"visibilityElement",
	"visibilityTitleElement",
	"textElement",
	"textTitleElement1",
	"textTitleElement2",
	"textTitleElement3",
	"symbolColorElement",
	"symbolColorTitleElement",
	"backgroundColorElement",
	"backgroundColorTitleElement",
	"countryCodeElement",
	"countryCodeTitleElement",
	"smallPlateFormatElement",
	"smallPlateFormatTitleElement1",
	"smallPlateFormatTitleElement2",
	"smallPlateFormatTitleElement3"
}

-- create new gui
function LicensePlatesGui:new()
	local self = YesNoDialog:new(nil, LicensePlatesGui_mt)

	self:registerControls(LicensePlatesGui.CONTROLS)

	return self
end

-- set current values
function LicensePlatesGui:setData(isVisible, text, symbolColor, backgroundColor, countryCode, useFormat46)
	self.dialogTitleElement:setText(g_i18n:getText("input_LICENSE_PLATE_CHANGE"))

	self.visibilityTitleElement:setText(g_i18n:getText("licensePlatesVisibilityTitle"))
	self.visibilityElement:setTexts({
		g_i18n:getText("licensePlatesInvisible"),
		g_i18n:getText("licensePlatesVisible")
	})
	self.visibilityElement:setState(isVisible and 2 or 1, true)

	self.textTitleElement1:setText(g_i18n:getText("licensePlatesTextTitle1"))
	self.textTitleElement2:setText(g_i18n:getText("licensePlatesTextTitle2"))
	self.textTitleElement3:setText(g_i18n:getText("licensePlatesTextTitle3"))
	self.textElement:setText(text)

	self.symbolColorTitleElement:setText(g_i18n:getText("licensePlatesSymbolColorTitle"))
	self.symbolColorElement:setTexts({
		g_i18n:getText("licensePlatesSymbolColorBlack"),
		g_i18n:getText("licensePlatesSymbolColorGreen"),
		g_i18n:getText("licensePlatesSymbolColorRed")
	})
	self.symbolColorElement:setState(symbolColor)

	self.backgroundColorTitleElement:setText(g_i18n:getText("licensePlatesBackgroundColorTitle"))
	self.backgroundColorElement:setTexts({
		g_i18n:getText("licensePlatesBackgroundColorWhite"),
		g_i18n:getText("licensePlatesBackgroundColorYellow"),
		g_i18n:getText("licensePlatesBackgroundColorRed"),
		g_i18n:getText("licensePlatesBackgroundColorGreen")
	})
	self.backgroundColorElement:setState(backgroundColor)

	self.countryCodeTitleElement:setText(g_i18n:getText("licensePlatesCountryCodeTitle"))
	-- works because gui uses only number as index
	self.countryCodeElement:setTexts(LicensePlates.COUNTRY_CODES)
	self.countryCodeElement:setState(countryCode)

	self.smallPlateFormatTitleElement1:setText(g_i18n:getText("licensePlatesSmallPlateFormatTitle1"))
	self.smallPlateFormatTitleElement2:setText(g_i18n:getText("licensePlatesSmallPlateFormatTitle2"))
	self.smallPlateFormatTitleElement3:setText(g_i18n:getText("licensePlatesSmallPlateFormatTitle3"))
	self.smallPlateFormatElement:setTexts({
		"5-5",
		"4-6"
	})
	self.smallPlateFormatElement:setState(useFormat46 and 2 or 1, true)
end

-- trim text if necessary
function LicensePlatesGui:onTextChanged()
	local text = self.textElement:getText()

	-- trim if too long
	if #text > 10 then
		self.textElement:setText(text:sub(1,10))
	end
end

-- close gui and send new values to callback
function LicensePlatesGui:onClickOk()
	local isVisible = self.visibilityElement:getIsChecked()
	local text = self.textElement:getText()
	local symbolColor = self.symbolColorElement:getState()
	local backgroundColor = self.backgroundColorElement:getState()
	local countryCode = self.countryCodeElement:getState()
	local useFormat46 = self.smallPlateFormatElement:getIsChecked()

	self:close()
	self.callbackFunc(self.target, isVisible, text, symbolColor, backgroundColor, countryCode, useFormat46)
end

-- just close gui
function LicensePlatesGui:onClickBack()
	self:close()
end
