--[[

Game:	Farming Simulator 19
Title:	FillTypeNames
Author:	ThundR - Grouminait

--]]

-- [Declarations] ***********************************************************************************************************************************

FillTypeNames = {}
FillTypeNames.InGameMenuPricesFrame = {}
FillTypeNames.MixerWagonHUDExtension = {}

-- [General Functions] ******************************************************************************************************************************

-- pack -------------------------------------------------------------------------------------------
function FillTypeNames:pack(...)
-- wrapper function for pack()
-- normal pack() stops at the first nil entry, even if other entries exist
-- this version adds ALL entries, including nil ones
-- useful for returning proper function return values
	-- [...]: values to pack

	return {n = select("#", ...), ...}
end

-- unpack -----------------------------------------------------------------------------------------
function FillTypeNames:unpack(tbl, index)
-- wrapper function for unpack()
-- allows values to be unpacked in the proper order, including nil entries
	-- [tbl]: 	table to unpack
	-- [index]: index to start >> optional

	index = Utils.getNoNil(index, 1)

	local numEntries = tbl.n
	if index <= numEntries then
		return unpack(tbl, index, numEntries)
	end
end

-- [InGameMenuPricesFrame Overrides] ****************************************************************************************************************

-- hook_updatePriceTable --------------------------------------------------------------------------
function FillTypeNames.InGameMenuPricesFrame:hook_updatePriceTable(superFunc, ...)
-- called from InGameMenuPricesFrame.updatePriceTable()

	local runFunction = not (g_ucLite or g_harvestMaster)

	if runFunction then
		local pageTitleElement = self.mainBox.parent.elements[1].elements[2]

		-- Initialize prices menu
		if not self.maizePlusInitialized then
			-- Create fill type name elements
			self.fillTypeNameHeaders = {}
			local tableHeaderBox = self.tableHeaderBox
			for i, element in ipairs(tableHeaderBox.elements) do
				if i > 1 then
					local fillTypeNameElement = TextElement:new(self)
					element:addElement(fillTypeNameElement)
					fillTypeNameElement:applyProfile("ingameMenuPriceRowSiloCapacityValue")
					table.insert(self.fillTypeNameHeaders, fillTypeNameElement)
				end
			end
			self.maizePlusInitialized = true
		end
	end

	local ret = FillTypeNames:pack(superFunc(self, ...))

	if runFunction then
		local fillTypeNameHeaders = self.fillTypeNameHeaders
		local startFillType = self.startFillType

		for columnIdx = 1, self.MAX_NUM_FILLTYPES do
			local fillTypeIndex = startFillType + (columnIdx-1)
			local fillType = self.priceFillTypes[fillTypeIndex]

			local fillTypeNameHeader = fillTypeNameHeaders[columnIdx]
			if fillTypeNameHeader then
				if fillType then
					fillTypeNameHeader:setText(fillType.title) --(HMUtils.properCase(fillType.title))
					fillTypeNameHeader:setVisible(true)
				else
					fillTypeNameHeader:setText("")
					fillTypeNameHeader:setVisible(false)
				end
			end
		end
	end

	return FillTypeNames:unpack(ret)
end
InGameMenuPricesFrame.updatePriceTable = Utils.overwrittenFunction(InGameMenuPricesFrame.updatePriceTable, FillTypeNames.InGameMenuPricesFrame.hook_updatePriceTable)

-- [MixerWagonHUDExtension Overrides] ***************************************************************************************************************

-- hook_draw --------------------------------------------------------------------------------------
function FillTypeNames.MixerWagonHUDExtension:hook_draw(superFunc, ...)
-- called from MixerWagonHUDExtension.draw()

	local mixerWagonTexts = {}

	local renderText_ORIG = getfenv(0).renderText
	getfenv(0).renderText = function(xPos, yPos, textSize, text, ...)
		if type(text) == "string" and string.find(text, "%%$") then -- only add percentage texts
			local textInfo = {
				xPos 	 = xPos,
				yPos 	 = yPos,
				textSize = textSize,
				text	 = text,
			}
			table.insert(mixerWagonTexts, textInfo)
		else
			renderText_ORIG(xPos, yPos, textSize, text, ...)
		end
	end

	local ret = FillTypeNames:pack(superFunc(self, ...))

	getfenv(0).renderText = renderText_ORIG

	for i, fillTypeDisplay in ipairs(self.fillTypeStatus) do
		local mixerWagonTextInfo = mixerWagonTexts[i]
		if mixerWagonTextInfo then
			local fillTypeInfo = fillTypeDisplay.fillType
			if fillTypeInfo then
				local mixerWagonText = mixerWagonTextInfo.text
				if type(mixerWagonText) == "string" then
					local xPos = mixerWagonTextInfo.xPos
					local yPos = mixerWagonTextInfo.yPos
					local textSize = mixerWagonTextInfo.textSize
					local text = fillTypeInfo.title.." "..mixerWagonText

					renderText(xPos, yPos, textSize, text)
				end
			end
		end
	end

	return FillTypeNames:unpack(ret)
end
MixerWagonHUDExtension.draw = Utils.overwrittenFunction(MixerWagonHUDExtension.draw, FillTypeNames.MixerWagonHUDExtension.hook_draw)
