-- 	GreenMowingMower Script
--
-- 	Author: 	Silas770
-- 	Date:		03.05.2020
--	Version:	1.0.0.0 (FS19)
--

GreenMowingMower = {};

function GreenMowingMower.prerequisitesPresent()
    return true;
end;

function GreenMowingMower.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "processMowerArea", GreenMowingMower.processMowerArea)
end;

function GreenMowingMower:processMowerArea(superFunc, workArea, dt)
    superFunc(self, workArea, dt);

    local spec = self.spec_mower;

    local xs,_,zs = getWorldTranslation(workArea.start);
    local xw,_,zw = getWorldTranslation(workArea.width);
    local xh,_,zh = getWorldTranslation(workArea.height);

    for inputFruitType, converterData in pairs(spec.fruitTypeConverters) do
        local changedArea, totalArea, sprayFactor, plowFactor, limeFactor, weedFactor, _, _ = FSDensityMapUtil.cutFruitArea(inputFruitType, xs,zs, xw,zw, xh,zh, true, true, true);

        if changedArea > 0 then
            local multiplier = g_currentMission:getHarvestScaleMultiplier(inputFruitType, sprayFactor, plowFactor, limeFactor, weedFactor);
            changedArea = changedArea * multiplier;

            local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
            local sqm = changedArea * pixelToSqm;
            local litersToDrop = sqm * g_fruitTypeManager:getFillTypeLiterPerSqm(converterData.fillTypeIndex, 1);

            workArea.lastPickupLiters = litersToDrop;

            local dropArea = self:getDropArea(workArea);
            if dropArea ~= nil then
                dropArea.litersToDrop = dropArea.litersToDrop + litersToDrop;
                dropArea.fillType = converterData.fillTypeIndex;
                dropArea.workAreaIndex = workArea.index;
            elseif spec.fillUnitIndex ~= nil then
                if self.isServer then
                    self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.fillUnitIndex, litersToDrop, converterData.fillTypeIndex, ToolType.UNDEFINED);
                end;
            end;

            spec.workAreaParameters.lastChangedArea = spec.workAreaParameters.lastChangedArea + changedArea;
            spec.workAreaParameters.lastStatsArea = spec.workAreaParameters.lastStatsArea + changedArea;
            spec.workAreaParameters.lastTotalArea   = spec.workAreaParameters.lastTotalArea + totalArea;

            spec.workAreaParameters.lastUsedAreas = spec.workAreaParameters.lastUsedAreas + 1;
        end;
    end;

    spec.workAreaParameters.lastUsedAreasSum = spec.workAreaParameters.lastUsedAreasSum + 1;

    return spec.workAreaParameters.lastChangedArea, spec.workAreaParameters.lastTotalArea;
end;
