-- by modelleicher
-- www.ls-modcompany.com
-- 03.01.2020 

-- maizePlus: A global mod/script that adds the possibility to differentiate between maize, grass and wcs silage. Also adds the ability to bale maize silage.
-- also adds CCM 

-- Big thanks to Wopster for his help with making this script work without conflict due to heap indexing issues and with other stuff. Also I took a bunch of inspiration from seasons.

-- V 1.1 Update:
-- fixed Selling Station bug without ccm-extension
-- removed fresh chopped maize from selling stations 
-- added seasons economy fix to sellable filltypes 
-- added seasons bale fermenting over time support 

-- V 1.2 Update:
-- added frutTypeConverters for corn2, crop_windrow, alfalfa (all) and clover (all) 
-- fermented stuff can be tipped back into the bunker silos 
-- crop_windrow added as chaff to bunkerSilos if exists in map 
-- fruitType mass adjusted to Giants values 
-- bale-limit increased if patch 1.6 isn't installed 
-- sellpoints fixed 

-- V 1.3 Update:
-- adjust pricing
-- added semiDry fruits to hunkerSilo accepted filltypes 
-- added siloClover, siloAlfalfa and semidry-horsegrass to selling stations
-- adjust Seasons pricing curve

-- V 1.4 Update:
-- added Seasons pricing curve for Bales
-- change heightType Fillplane for Silo Clover and Alfalfa

-- V 1.5 Update:
-- bunkerSiloChanges: 
-- -- removed wetClover and wetAlfalfa
-- -- fixed bug where clover didn't ferment
-- -- brewersGrain added
-- -- beetPulp added 
-- -- composting feature added 
-- -- fixed bug with silos not based on chaff e.g. not maizePlus 

-- added loadingVehicle to fillTypes so Ropa Maus can load stuff 
-- added grasslandSubsoiler

-- V 1.5.1 Hotfix:
-- Line 1083 Error on non-HE Maps fixed


MaizePlus = {}

local modDirectory = g_currentModDirectory
local modName = g_currentModName

MaizePlus.isActive = true
MaizePlus.ccmIsEnabled = false
MaizePlus.forageExtensionEnabled = false

function MaizePlus.loadFillType(hudName, price, massPerLiter, fillTypeName, textName, heapAngle, categoryTable)

	local hudFile = "hud/hud_fill_"..tostring(hudName)..".png"
	local hudFileSmall = "hud/hud_fill_"..tostring(hudName).."_sml.png"

    local fillType = g_fillTypeManager:addFillType(fillTypeName, g_i18n:getText(textName), true, price, massPerLiter, heapAngle, hudFile, hudFileSmall, modDirectory, nil, {1, 1, 1}, nil, false)
    
    if fillType == nil then
        print("MaizePlus: Error, could not add FillType "..tostring(fillTypeName))       
    else
		local fillTypeIndex = g_fillTypeManager:getFillTypeIndexByName(fillTypeName)
		
		for _, category in pairs(categoryTable) do
			g_fillTypeManager:addFillTypeToCategory(fillTypeIndex, g_fillTypeManager.nameToCategoryIndex[category])
		end	       
    end
end

function MaizePlus.fillTypeInit(directory, fillTypeManager, i18n)

	-- enable CCM if CCM Extension is active 
	if g_modIsLoaded.FS19_MaizePlus_ccmExtension then
		MaizePlus.ccmIsEnabled = true
	end

	-- check if Forage Extension is enabled, we need to disable a few things in MaizePlus then
	if g_modIsLoaded.FS19_MaizePlus_forageExtension then
		MaizePlus.forageExtensionEnabled = true
	end

	-- load fillTypes 
	local forkable ={"WINDROW", "BULK", "FORAGEWAGON", "FORAGEHARVESTER", "SILAGETRAILER", "FORK", "LOADINGVEHICLE"} -- categories for not forkable 

	local silage = fillTypeManager:getFillTypeByName("SILAGE")
	local chaff = fillTypeManager:getFillTypeByName("CHAFF")
	local grass_windrow = fillTypeManager:getFillTypeByName("GRASS_WINDROW")
	local drygrass_windrow = fillTypeManager:getFillTypeByName("DRYGRASS_WINDROW")
	local maize = fillTypeManager:getFillTypeByName("MAIZE")
	grass_windrow.pricePerLiter =0.048
	drygrass_windrow.pricePerLiter =0.06

	MaizePlus.loadFillType("choppedMaize", silage.pricePerLiter*0.3, chaff.massPerLiter*2, "CHOPPEDMAIZE", "fillType_choppedMaize", 35, forkable)
	
	MaizePlus.loadFillType("choppedMaize_fermented", silage.pricePerLiter, silage.massPerLiter*2, "CHOPPEDMAIZE_FERMENTED", "fillType_choppedMaize_fermented", 50, forkable)
	
	MaizePlus.loadFillType("grass_fermented", silage.pricePerLiter*0.7, silage.massPerLiter*2, "GRASS_FERMENTED", "fillType_grass_fermented", 50, forkable)
	
	MaizePlus.loadFillType("siloGrass", grass_windrow.pricePerLiter, grass_windrow.massPerLiter*2, "SILOGRASS", "fillType_siloGrass", 35, forkable)
	
	local notForkable = {"WINDROW", "BULK", "FORAGEWAGON", "FORAGEHARVESTER", "SILAGETRAILER", "LOADINGVEHICLE"} -- categories for CCM, we have a lot of forkable here aswell in case somebody wants to make mods in the future that need that

	if MaizePlus.ccmIsEnabled then
		MaizePlus.loadFillType("ccm", maize.pricePerLiter*2, maize.massPerLiter*2, "CCM", "fillType_ccm", 40, notForkable)

		MaizePlus.loadFillType("ccmraw", maize.pricePerLiter, 0.0008, "CCMRAW", "fillType_ccmraw", 30, notForkable)
	end

	-- check if CLOVER_FERMENTED is active in map
	local cloverIndex = g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")
	if cloverIndex ~= nil then
		MaizePlus.loadFillType("siloClover", grass_windrow.pricePerLiter, grass_windrow.massPerLiter*2, "SILOCLOVER", "fillType_siloClover", 35, forkable)
		MaizePlus.siloCloverActive = true
	end	
	local alfalfaIndex = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")
	if alfalfaIndex ~= nil then
		MaizePlus.loadFillType("siloAlfalfa", grass_windrow.pricePerLiter, grass_windrow.massPerLiter*2, "SILOALFALFA", "fillType_siloAlfalfa", 35, forkable)	
		MaizePlus.siloAlfalfaActive = true
	end	
	local compostIndex = g_fillTypeManager:getFillTypeIndexByName("COMPOST")
	if compostIndex ~= nil then
		MaizePlus.loadFillType("compost", 0.0125, 0.00083, "COMPOST", "fillType_compost", 40, forkable)																									  
		MaizePlus.loadFillType("compostRaw", 0.0125, 0.00083, "COMPOSTRAW", "fillType_compostRaw", 40, forkable)	
		MaizePlus.compostRawActive = true
	end;
  
end

function MaizePlus.addHeightType(fillType, diffuseName, normalName, distanceName, heapAngle, colScale, baseOffset, minOffset, maxOffset, fillToGroundScale, allowSmoothing, soundFillType)
	local fillTypeIndex = g_fillTypeManager:getFillTypeIndexByName(fillType)

	g_fillTypeManager.fillTypeToSample[fillTypeIndex] = g_fillTypeManager.fillTypeToSample[g_fillTypeManager:getFillTypeIndexByName(soundFillType)]

	local diffuseMapFilename = Utils.getFilename("fillTypes/"..diffuseName.."_diffuse.png", modDirectory)
	local normalMapFilename = Utils.getFilename("fillTypes/"..normalName.."_normal.png", modDirectory)	
	local distanceMapFilename = Utils.getFilename("fillTypes/"..distanceName.."_distance_diffuse.png", modDirectory)	

    local ht = g_densityMapHeightManager:addDensityMapHeightType(fillType, math.rad(heapAngle), colScale, baseOffset, minOffset, maxOffset, fillToGroundScale, allowSmoothing, diffuseMapFilename, normalMapFilename, distanceMapFilename, false)
	if ht ~= nil then
		return 1
	else
		print("MaizePlus: Error, HeightType "..tostring(fillType).." could not be added.")
		return 0
	end
end

	
---Hook into the loadMapFinished to load the fillTypes, material holders and add new bale types.
function MaizePlus.finalizeFillTypes(mission, node)

	local x = 0;
	-- add MaizePlus default heightTypes 	
	x = x + MaizePlus.addHeightType("CHOPPEDMAIZE", "choppedMaize", "chaff", "choppedMaize", 35, 0.8, 0.1, 0.1, 1.2, 1.0, true, "CHAFF") 
	x = x + MaizePlus.addHeightType("CHOPPEDMAIZE_FERMENTED", "choppedMaize_fermented", "chaff", "silage", 50, 0.95, 0.0, 0.0, 0.0, 1.0, true, "SILAGE")  
	x = x + MaizePlus.addHeightType("GRASS_FERMENTED", "grass_fermented", "grass_fermented", "grass_fermented", 50, 0.95, 0.0, 0.0, 0.0, 1.0, true, "SILAGE") 
	x = x + MaizePlus.addHeightType("SILOGRASS", "siloGrass", "grass_fermented", "siloGrass", 35, 0.8, 0.1, 0.1, 1.2, 1.0, true, "GRASS_WINDROW") 
	-- add CCM heightTypes if CCM Extension is active
	if MaizePlus.ccmIsEnabled then
		x = x + MaizePlus.addHeightType("CCM", "ccm", "ccm", "ccm", 40, 0.95, 0.0, 0.0, 0.0, 1.0, true, "SILAGE")
		x = x + MaizePlus.addHeightType("CCMRAW", "ccmraw", "ccm", "ccmraw", 30, 0.8, 0.1, 0.1, 1.2, 1.0, true, "CHAFF")	
	end
	if (x > 4 and not MaizePlus.ccmIsEnabled) or (x > 6 and MaizePlus.ccmIsEnabled) then
		print("MaizePlus: Error, something went wrong with adding additional height types.")
		print("You most likely have too many high types already registered.")
		print("MaizePlus won't work properly.")
		MaizePlus.isActive = false
		return	
	end

	-- check if CLOVER_FERMENTED and CLOVER_FERMENTED-ht is active in map
	local cloverIndex = g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")
	if cloverIndex ~= nil then
		local cloverHeightIndex = g_densityMapHeightManager:getDensityMapHeightTypeByFillTypeIndex(cloverIndex)
		if cloverHeightIndex ~= nil then 
			-- add siloClover 
            local returnVal = MaizePlus.addHeightType("SILOCLOVER", "clover", "clover", "clover", 35, 0.8, 0.1, 0.1, 1.2, 1.0, true, "GRASS_WINDROW")
			if returnVal == 1 then
				MaizePlus.siloCloverActive = true
			end
		end
	end
	-- check if ALFALFA_FERMENTED and ALFALFA_FERMENTED-ht is active in map
	local alfalfaIndex = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")
	if alfalfaIndex ~= nil then
		local cloverHeightIndex = g_densityMapHeightManager:getDensityMapHeightTypeByFillTypeIndex(alfalfaIndex)
		if cloverHeightIndex ~= nil then 
			-- add siloAlfalfa
            local returnVal = MaizePlus.addHeightType("SILOALFALFA", "alfalfa_windrow", "alfalfa_windrow", "alfalfa_windrow", 35, 0.8, 0.1, 0.1, 1.2, 1.0, true, "GRASS_WINDROW")
			if returnVal == 1 then
				MaizePlus.siloAlfalfaActive = true
			end
		end
	end
	
	local compostIndex = g_fillTypeManager:getFillTypeIndexByName("COMPOST")
	if compostIndex ~= nil then
		local compostHeightIndex = g_densityMapHeightManager:getDensityMapHeightTypeByFillTypeIndex(compostIndex)
		if compostHeightIndex ~= nil then
			MaizePlus.addHeightType("COMPOSTRAW", "compostRaw", "compostRaw", "compostRaw", 40, 0.8, 0.1, 0.1, 1.2, 1.0, true, "GRASS_WINDROW")
		end;
	end;


    -- refreshing the vehicle fillLevels HUD
    g_currentMission.hud.fillLevelsDisplay:refreshFillTypes(g_fillTypeManager)

    -- add chopped maize to forage harvester converter
    g_fruitTypeManager.nameToConverter.FORAGEHARVESTER[g_fruitTypeManager.nameToIndex.MAIZE].fillTypeIndex = g_fillTypeManager.nameToIndex.CHOPPEDMAIZE

	-- change grass to not be chaff out of a chopper 
    g_fruitTypeManager.nameToConverter.FORAGEHARVESTER[g_fruitTypeManager.nameToIndex.GRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
	
	-- V 1.2 corn2 addition stuff 
	local forageHarvesterConverter = g_fruitTypeManager.nameToConverter.FORAGEHARVESTER;
	local mowerConverter = g_fruitTypeManager.nameToConverter.MOWER;

	local corn2 = g_fruitTypeManager.nameToIndex.CORN2
	if corn2 ~= nil then
		if forageHarvesterConverter[corn2] ~= nil then
			forageHarvesterConverter[corn2].fillTypeIndex = g_fillTypeManager.nameToIndex.CHOPPEDMAIZE
		end
	end;	
	
	-- V 1.2 crop_windrow addition 
	local crop_windrow = g_fruitTypeManager.nameToIndex.CROP_WINDROW
	if crop_windrow ~= nil then
		if forageHarvesterConverter[crop_windrow] ~= nil then
			forageHarvesterConverter[crop_windrow].fillTypeIndex = g_fillTypeManager.nameToIndex.CHAFF
		end
		if mowerConverter[wheat] ~= nil then
			mowerConverter[wheat].fillTypeIndex = g_fillTypeManager.nameToIndex.CROP_WINDROW
		end
		if mowerConverter[barley] ~= nil then
			mowerConverter[barley].fillTypeIndex = g_fillTypeManager.nameToIndex.CROP_WINDROW
		end
		if mowerConverter[oat] ~= nil then
			mowerConverter[oat].fillTypeIndex = g_fillTypeManager.nameToIndex.CROP_WINDROW
		end
		if mowerConverter[rye] ~= nil then
			mowerConverter[rye].fillTypeIndex = g_fillTypeManager.nameToIndex.CROP_WINDROW
		end
		if mowerConverter[triticale] ~= nil then
			mowerConverter[triticale].fillTypeIndex = g_fillTypeManager.nameToIndex.CROP_WINDROW
		end
	end;	
	-- V1.2 additional Grass types and change Vanilla to Wet
		local FIELD_GRASS = g_fruitTypeManager.nameToIndex.FIELD_GRASS
		local WETGRASS_WINDROW = g_fillTypeManager.nameToIndex.WETGRASS_WINDROW
		if FIELD_GRASS ~= nil then
			if forageHarvesterConverter[FIELD_GRASS] ~= nil then
				forageHarvesterConverter[FIELD_GRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
			if mowerConverter[FIELD_GRASS] ~= nil then
				if WETGRASS_WINDROW ~=nil then
					mowerConverter[FIELD_GRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.WETGRASS_WINDROW
				else
					mowerConverter[FIELD_GRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW				
				end
			end
		end
		local PASTUREGRASS = g_fruitTypeManager.nameToIndex.PASTUREGRASS
		if PASTUREGRASS ~= nil then
			if forageHarvesterConverter[PASTUREGRASS] ~= nil then
				forageHarvesterConverter[PASTUREGRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
			if mowerConverter[PASTUREGRASS] ~= nil then
				if WETGRASS_WINDROW ~=nil then
					mowerConverter[PASTUREGRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.WETGRASS_WINDROW
				else
					mowerConverter[PASTUREGRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW				
				end
			end
		end
		
		local GRASS = g_fruitTypeManager.nameToIndex.GRASS
		if GRASS ~= nil then
			if forageHarvesterConverter[GRASS] ~= nil then
				forageHarvesterConverter[GRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
			if mowerConverter[GRASS] ~= nil then
				if WETGRASS_WINDROW ~=nil then
					mowerConverter[GRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.WETGRASS_WINDROW
				else
					mowerConverter[GRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW				
				end
			end
		end
		local HORSEGRASS = g_fruitTypeManager.nameToIndex.HORSEGRASS
		if HORSEGRASS ~= nil then
			if forageHarvesterConverter[HORSEGRASS] ~= nil then
				forageHarvesterConverter[HORSEGRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
			if mowerConverter[HORSEGRASS] ~= nil then
				mowerConverter[HORSEGRASS].fillTypeIndex = g_fillTypeManager.nameToIndex.WETHORSEGRASS_WINDROW
			end
		end
		
		local WETHORSEGRASS_WINDROW = g_fruitTypeManager.nameToIndex.WETHORSEGRASS_WINDROW
		if WETHORSEGRASS_WINDROW ~= nil then
			if forageHarvesterConverter[WETHORSEGRASS_WINDROW] ~= nil then
				forageHarvesterConverter[WETHORSEGRASS_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
		end
		
		local HORSEGRASS_WINDROW = g_fruitTypeManager.nameToIndex.HORSEGRASS_WINDROW
		if HORSEGRASS_WINDROW ~= nil then
			if forageHarvesterConverter[HORSEGRASS_WINDROW] ~= nil then
				forageHarvesterConverter[HORSEGRASS_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
		end
		
		local SEMIDRYHORSEGRASS_WINDROW = g_fruitTypeManager.nameToIndex.SEMIDRYHORSEGRASS_WINDROW
		if SEMIDRYHORSEGRASS_WINDROW ~= nil then
			if forageHarvesterConverter[SEMIDRYHORSEGRASS_WINDROW] ~= nil then
				forageHarvesterConverter[SEMIDRYHORSEGRASS_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
		end
		
		local SEMIDRY_GRASS_WINDROW = g_fruitTypeManager.nameToIndex.SEMIDRY_GRASS_WINDROW
		if SEMIDRY_GRASS_WINDROW ~= nil then
			if forageHarvesterConverter[SEMIDRY_GRASS_WINDROW] ~= nil then
				forageHarvesterConverter[SEMIDRY_GRASS_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
		end

		local DRYHORSEGRASS_WINDROW = g_fruitTypeManager.nameToIndex.DRYHORSEGRASS_WINDROW
		if DRYHORSEGRASS_WINDROW ~= nil then
			if forageHarvesterConverter[DRYHORSEGRASS_WINDROW] ~= nil then
				forageHarvesterConverter[DRYHORSEGRASS_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.GRASS_WINDROW
			end
		end		
		
		
	-- V 1.2 -> move alfalfa and clover conversion script-side so its not dependend on correct maps_fruitTypes.xml
	if MaizePlus.siloAlfalfaActive then
		local ALFALFA = g_fruitTypeManager.nameToIndex.ALFALFA
		if ALFALFA ~= nil then
			if forageHarvesterConverter[ALFALFA] ~= nil then
				forageHarvesterConverter[ALFALFA].fillTypeIndex = g_fillTypeManager.nameToIndex.ALFALFA_WINDROW
			end
		end
		local WETALFALFA = g_fruitTypeManager.nameToIndex.WETALFALFA_WINDROW
		if WETALFALFA ~= nil then
			if forageHarvesterConverter[WETALFALFA] ~= nil then
				forageHarvesterConverter[WETALFALFA].fillTypeIndex = g_fillTypeManager.nameToIndex.ALFALFA_WINDROW
			end
		end
		if WETALFALFA ~=nil and ALFALFA ~=nil then		
			if mowerConverter[ALFALFA] ~= nil then
				mowerConverter[ALFALFA].fillTypeIndex = g_fillTypeManager.nameToIndex.WETALFALFA_WINDROW
			end
		end

		local DRYALFALFA = g_fruitTypeManager.nameToIndex.DRYALFALFA
		if DRYALFALFA ~= nil then
			if forageHarvesterConverter[DRYALFALFA] ~= nil then
				forageHarvesterConverter[DRYALFALFA].fillTypeIndex = g_fillTypeManager.nameToIndex.ALFALFA_WINDROW
			end
		end
		local DRYALFALFA = g_fruitTypeManager.nameToIndex.SEMIDRYALFALFA
		if SEMIDRYALFALFA ~= nil then
			if forageHarvesterConverter[SEMIDRYALFALFA] ~= nil then
				forageHarvesterConverter[SEMIDRYALFALFA].fillTypeIndex = g_fillTypeManager.nameToIndex.ALFALFA_WINDROW
			end
		end
		local ALFALFA_WINDROW = g_fruitTypeManager.nameToIndex.ALFALFA_WINDROW
		if ALFALFA_WINDROW ~= nil then
			if forageHarvesterConverter[ALFALFA_WINDROW] ~= nil then
				forageHarvesterConverter[ALFALFA_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.ALFALFA_WINDROW
			end
		end	
		local SEMIDRYALFALFA_WINDROW = g_fruitTypeManager.nameToIndex.SEMIDRYALFALFA_WINDROW
		if SEMIDRYALFALFA_WINDROW ~= nil then
			if forageHarvesterConverter[SEMIDRYALFALFA_WINDROW] ~= nil then
				forageHarvesterConverter[SEMIDRYALFALFA_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.ALFALFA_WINDROW
			end
		end			
	end
	if MaizePlus.siloCloverActive then
		local CLOVER = g_fruitTypeManager.nameToIndex.CLOVER
		if CLOVER ~= nil then
			if forageHarvesterConverter[CLOVER] ~= nil then
				forageHarvesterConverter[CLOVER].fillTypeIndex = g_fillTypeManager.nameToIndex.CLOVER_WINDROW
			end
		end		
		local WETCLOVER = g_fruitTypeManager.nameToIndex.WETCLOVER_WINDROW
		if WETCLOVER ~= nil then
			if forageHarvesterConverter[WETCLOVER] ~= nil then
				forageHarvesterConverter[WETCLOVER].fillTypeIndex = g_fillTypeManager.nameToIndex.CLOVER_WINDROW
			end
		end	
		if WETCLOVER ~=nil and CLOVER ~=nil then
			if mowerConverter[CLOVER] ~= nil then
				mowerConverter[CLOVER].fillTypeIndex = g_fillTypeManager.nameToIndex.WETCLOVER_WINDROW
			end
		end
		local DRYCLOVER = g_fruitTypeManager.nameToIndex.DRYCLOVER
		if DRYCLOVER ~= nil then
			if forageHarvesterConverter[DRYCLOVER] ~= nil then
				forageHarvesterConverter[DRYCLOVER].fillTypeIndex = g_fillTypeManager.nameToIndex.CLOVER_WINDROW
			end
		end				
		local SEMIDRYCLOVER = g_fruitTypeManager.nameToIndex.SEMIDRYCLOVER
		if SEMIDRYCLOVER ~= nil then
			if forageHarvesterConverter[SEMIDRYCLOVER] ~= nil then
				forageHarvesterConverter[SEMIDRYCLOVER].fillTypeIndex = g_fillTypeManager.nameToIndex.CLOVER_WINDROW
			end
		end				
		local CLOVER_WINDROW = g_fruitTypeManager.nameToIndex.CLOVER_WINDROW
		if CLOVER_WINDROW ~= nil then
			if forageHarvesterConverter[CLOVER_WINDROW] ~= nil then
				forageHarvesterConverter[CLOVER_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.CLOVER_WINDROW
			end
		end	
		local SEMIDRYCLOVER_WINDROW = g_fruitTypeManager.nameToIndex.SEMIDRYCLOVER_WINDROW
		if SEMIDRYCLOVER_WINDROW ~= nil then
			if forageHarvesterConverter[SEMIDRYCLOVER_WINDROW] ~= nil then
				forageHarvesterConverter[SEMIDRYCLOVER_WINDROW].fillTypeIndex = g_fillTypeManager.nameToIndex.CLOVER_WINDROW
			end
		end				
	end
		
	
	-- change names of default silage and chaff 
	g_fillTypeManager.fillTypes[g_fillTypeManager.nameToIndex.SILAGE].title = g_i18n:getText("fillType_silageNew")
	g_fillTypeManager.fillTypes[g_fillTypeManager.nameToIndex.CHAFF].title = g_i18n:getText("fillType_chaffNew")
    

    -- loading material holders 
    local maizePlus_materialHolderFilename = Utils.getFilename("materialHolder/maizePlus_materialHolder.i3d", modDirectory)
    MaizePlus.maizePlus_materialHolder = loadI3DFile(maizePlus_materialHolderFilename, false, true, false)
	
    local maizePlus_effect_materialHolderFilename = Utils.getFilename("materialHolder/maizePlus_effect_materialHolder.i3d", modDirectory)
    MaizePlus.maizePlus_effect_materialHolder = loadI3DFile(maizePlus_effect_materialHolderFilename, false, true, false)
	
    local maizePlus_icons_materialHolderFilename = Utils.getFilename("hud/iconsMaterialHolder.i3d", modDirectory)
    MaizePlus.maizePlus_icons_materialHolder = loadI3DFile(maizePlus_icons_materialHolderFilename, false, true, false)	
	
	if MaizePlus.ccmIsEnabled then
	    local maizePlus_ccmExtension_materialHolderFilename = Utils.getFilename("materialHolder/maizePlus_ccmExtension_materialHolder.i3d", modDirectory)
	    MaizePlus.maizePlus_ccmExtension_materialHolder = loadI3DFile(maizePlus_ccmExtension_materialHolderFilename, false, true, false)
	    local maizePlus_ccmExtension_effect_materialHolderFilename = Utils.getFilename("materialHolder/maizePlus_ccmExtension_effect_materialHolder.i3d", modDirectory)
	    MaizePlus.maizePlus_ccmExtension_effect_materialHolder = loadI3DFile(maizePlus_ccmExtension_effect_materialHolderFilename, false, true, false)	
		local maizePlus_ccmExtension_icons_materialHolderFilename = Utils.getFilename("hud/iconsMaterialHolder_ccm.i3d", modDirectory)
		MaizePlus.maizePlus_ccmExtension_icons_materialHolder = loadI3DFile(maizePlus_ccmExtension_icons_materialHolderFilename, false, true, false)		
	end
	
	if MaizePlus.siloAlfalfaActive then
		local maizePlus_forageExtension_siloAlfalfa_effect_materialHolder = Utils.getFilename("materialHolder/maizePlus_forageExtension_siloAlfalfa_effect_materialHolder.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_effect_materialHolder = loadI3DFile(maizePlus_forageExtension_siloAlfalfa_effect_materialHolder, false, true, false)
		
		local maizePlus_forageExtension_siloAlfalfa_fillPlane_materialHolder = Utils.getFilename("materialHolder/maizePlus_forageExtension_siloAlfalfa_fillPlane_materialHolder.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_fillPlane_materialHolder = loadI3DFile(maizePlus_forageExtension_siloAlfalfa_fillPlane_materialHolder, false, true, false)
				
		local maizePlus_forageExtension_siloAlfalfa_particle_materialHolder = Utils.getFilename("materialHolder/maizePlus_forageExtension_siloAlfalfa_particle_materialHolder.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_particle_materialHolder = loadI3DFile(maizePlus_forageExtension_siloAlfalfa_particle_materialHolder, false, true, false)
		
		local maizePlus_forageExtension_siloAlfalfa_icons_materialHolderFilename = Utils.getFilename("hud/iconsMaterialHolder_siloAlfalfa.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_icons_materialHolder = loadI3DFile(maizePlus_forageExtension_siloAlfalfa_icons_materialHolderFilename, false, true, false)			
	end
	
	if MaizePlus.siloCloverActive then
		local maizePlus_forageExtension_siloClover_effect_materialHolder = Utils.getFilename("materialHolder/maizePlus_forageExtension_siloClover_effect_materialHolder.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloClover_effect_materialHolder = loadI3DFile(maizePlus_forageExtension_siloClover_effect_materialHolder, false, true, false)
			
		local maizePlus_forageExtension_siloClover_fillPlane_materialHolder = Utils.getFilename("materialHolder/maizePlus_forageExtension_siloClover_fillPlane_materialHolder.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloClover_fillPlane_materialHolder = loadI3DFile(maizePlus_forageExtension_siloClover_fillPlane_materialHolder, false, true, false)

		local maizePlus_forageExtension_siloClover_particle_materialHolder = Utils.getFilename("materialHolder/maizePlus_forageExtension_siloClover_particle_materialHolder.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloClover_particle_materialHolder = loadI3DFile(maizePlus_forageExtension_siloClover_particle_materialHolder, false, true, false)

		local maizePlus_forageExtension_siloClover_icons_materialHolderFilename = Utils.getFilename("hud/iconsMaterialHolder_siloClover.i3d", modDirectory)
		MaizePlus.maizePlus_forageExtension_siloClover_icons_materialHolder = loadI3DFile(maizePlus_forageExtension_siloClover_icons_materialHolderFilename, false, true, false)			
	end
	
	if MaizePlus.compostRawActive then
		loadI3DFile(Utils.getFilename("materialHolder/compostRaw/particle_materialHolder.i3d", modDirectory), false, true, false)
		loadI3DFile(Utils.getFilename("materialHolder/compostRaw/fillPlane_materialHolder.i3d", modDirectory), false, true, false)
		loadI3DFile(Utils.getFilename("materialHolder/compostRaw/effect_materialHolder.i3d", modDirectory), false, true, false)
	end;
		

	-- add chopped maize bale type
    g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/roundbale_choppedMaize_w112_d130.i3d", modDirectory), "CHOPPEDMAIZE", true, 1.12, 0.9, 2.4, 1.3)
    g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/roundbale_silograss_w112_d130.i3d", modDirectory), "SILOGRASS", true, 1.12, 0.9, 2.4, 1.3)

    -- add chopped maize fermented bale types
    g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/roundbale_choppedMaize_fermented_w112_d130.i3d", modDirectory), "CHOPPEDMAIZE_FERMENTED", true, 1.12, 0.9, 2.4, 1.3)
    g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/kuhnFBP3135_roundbale_choppedMaize_fermented_w112_d130.i3d", modDirectory), "CHOPPEDMAIZE_FERMENTED", true, 1.12, 0.9, 2.4, 1.3)
    g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/kuhnSW4014_roundbale_choppedMaize_fermented_w112_d130.i3d", modDirectory), "CHOPPEDMAIZE_FERMENTED", true, 1.12, 0.9, 2.4, 1.3)

	-- add grass fermented bale types 
	g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/roundbale_grass_fermented_w112_d130.i3d", modDirectory), "GRASS_FERMENTED", true, 1.12, 0.9, 2.4, 1.3)
	g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/kuhnFBP3135_roundbale_grass_fermented_w112_d130.i3d", modDirectory), "GRASS_FERMENTED", true, 1.12, 0.9, 2.4, 1.3)
	g_baleTypeManager:addBaleType(Utils.getFilename("roundbales/kuhnSW4014_roundbale_grass_fermented_w112_d130.i3d", modDirectory), "GRASS_FERMENTED", true, 1.12, 0.9, 2.4, 1.3)

	-- add square grass bale for fillType silograss
	g_baleTypeManager:addBaleType(Utils.getFilename("squarebales/squarebale_siloGrass.i3d", modDirectory), "SILOGRASS", false, 1.20, 0.9, 2.4)

	-- overwrite Seasons updateBaleFermentation function to add our custom fermented types 
	if g_seasons ~= nil then
		
		FS19_RM_Seasons.SeasonsGrass.updateBaleFermentation = Utils.overwrittenFunction(FS19_RM_Seasons.SeasonsGrass.updateBaleFermentation, MaizePlus.override_seasons_updateBaleFermentation)

	end
end

-- remove bale Limit, thanks to Rahkiin :) 
function MaizePlus.addBaleTypeNew(self, superFunc, ...)

	if #self.baleTypes < 64 then return superFunc(self, ...) end
	
	local oldBaleTypes = self.baleTypes
	local oldNameToBaleType = self.nameToBaleType
	local oldNameToIndex = self.nameToIndex
	
	self.baleTypes = {}
	self.nameToBaleType = {}
	self.nameToIndex = {}
	
	local newBaleType = superFunc(self, ...)
	
	local name;
	for n, _ in pairs(self.nameToBaleType) do
		name = n
		break
	end
	
	self.baleTypes = oldBaleTypes
	self.nameToBaleType = oldNameToBaleType
	self.nameToIndex = oldNameToIndex
	
	newBaleType.index = #self.baleTypes + 1
	self.nameToBaleType[name] = newBaleType
	self.nameToIndex[name] = newBaleType.index
	
	return newBaleType;
end

-- add to seasons economy so prices aren't way too much 
function MaizePlus.addSeasonsRepricing(mission)
	if g_seasons ~= nil then
		if g_seasons.economy.data.repricing.fillTypes.CCM  == nil then
			g_seasons.economy.data.repricing.fillTypes.CCM = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.MAIZE) do
				g_seasons.economy.data.repricing.fillTypes.CCM[i]=j
			end
		end
		if g_seasons.economy.data.repricing.fillTypes.SILOGRASS  == nil then
			g_seasons.economy.data.repricing.fillTypes.SILOGRASS = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.fillTypes.SILOGRASS[i]=j
			end
		end
		if g_seasons.economy.data.repricing.bales.SILOGRASS  == nil then
			g_seasons.economy.data.repricing.bales.SILOGRASS = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.bales.SILOGRASS[i]=j
			end
		end
		if g_seasons.economy.data.repricing.fillTypes.GRASS_FERMENTED  == nil then
			g_seasons.economy.data.repricing.fillTypes.GRASS_FERMENTED = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.fillTypes.GRASS_FERMENTED[i]=j
			end
		end
		if g_seasons.economy.data.repricing.bales.GRASS_FERMENTED  == nil then
			g_seasons.economy.data.repricing.bales.GRASS_FERMENTED = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.bales.GRASS_FERMENTED[i]=j
			end
		end
		if g_seasons.economy.data.repricing.fillTypes.CHOPPEDMAIZE  == nil then
			g_seasons.economy.data.repricing.fillTypes.CHOPPEDMAIZE = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.fillTypes.CHOPPEDMAIZE[i]=j
			end
		end	
		if g_seasons.economy.data.repricing.bales.CHOPPEDMAIZE  == nil then
			g_seasons.economy.data.repricing.bales.CHOPPEDMAIZE = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.bales.CHOPPEDMAIZE[i]=j
			end
		end	
		if g_seasons.economy.data.repricing.fillTypes.CHOPPEDMAIZE_FERMENTED  == nil then
			g_seasons.economy.data.repricing.fillTypes.CHOPPEDMAIZE_FERMENTED = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.fillTypes.CHOPPEDMAIZE_FERMENTED[i]=j
			end
		end	
		if g_seasons.economy.data.repricing.bales.CHOPPEDMAIZE_FERMENTED  == nil then
			g_seasons.economy.data.repricing.bales.CHOPPEDMAIZE_FERMENTED = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
				g_seasons.economy.data.repricing.bales.CHOPPEDMAIZE_FERMENTED[i]=j
			end
		end	
		if g_seasons.economy.data.repricing.fillTypes.CCMRAW  == nil then
			g_seasons.economy.data.repricing.fillTypes.CCMRAW = {}
			for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.MAIZE) do
				g_seasons.economy.data.repricing.fillTypes.CCMRAW[i]=j
			end
		end		

		-- additional fillTypes Silages
		local cloverFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("SILOCLOVER")
		if cloverFermentedIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.SILOCLOVER  == nil then
				g_seasons.economy.data.repricing.fillTypes.SILOCLOVER = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.fillTypes.SILOCLOVER[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.SILOCLOVER  == nil then
				g_seasons.economy.data.repricing.bales.SILOCLOVER = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.bales.SILOCLOVER[i]=j
				end
			end	
		end
		local cloverFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")
		if cloverFermentedIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.CLOVER_FERMENTED  == nil then
				g_seasons.economy.data.repricing.fillTypes.CLOVER_FERMENTED = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.fillTypes.CLOVER_FERMENTED[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.CLOVER_FERMENTED  == nil then
				g_seasons.economy.data.repricing.bales.CLOVER_FERMENTED = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.bales.CLOVER_FERMENTED[i]=j
				end
			end	
		end
		local alfalfaFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("SILOALFALFA")
		if alfalfaFermentedIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.SILOALFALFA  == nil then
				g_seasons.economy.data.repricing.fillTypes.SILOALFALFA = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.fillTypes.SILOALFALFA[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.SILOALFALFA  == nil then
				g_seasons.economy.data.repricing.bales.SILOALFALFA = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.bales.SILOALFALFA[i]=j
				end
			end	
		end
		local alfalfaFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")
		if alfalfaFermentedIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.ALFALFA_FERMENTED  == nil then
				g_seasons.economy.data.repricing.fillTypes.ALFALFA_FERMENTED = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.fillTypes.ALFALFA_FERMENTED[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.ALFALFA_FERMENTED  == nil then
				g_seasons.economy.data.repricing.bales.ALFALFA_FERMENTED = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.bales.ALFALFA_FERMENTED[i]=j
				end
			end	
		end
		local alfalfaFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_FERMENTED")
		if alfalfaFermentedIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.HORSEGRASS_FERMENTED  == nil then
				g_seasons.economy.data.repricing.fillTypes.HORSEGRASS_FERMENTED = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.fillTypes.HORSEGRASS_FERMENTED[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.HORSEGRASS_FERMENTED  == nil then
				g_seasons.economy.data.repricing.bales.HORSEGRASS_FERMENTED = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.SILAGE) do
					g_seasons.economy.data.repricing.bales.HORSEGRASS_FERMENTED[i]=j
				end
			end	
		end
		-- additional fillTypes grasses
		-- Clover
		local dryCloverWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("WETCLOVER_WINDROW")
		if dryCloverWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.WETCLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.WETCLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.WETCLOVER_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.WETCLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.WETCLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.WETCLOVER_WINDROW[i]=j
				end
			end	
		end	
		local dryCloverWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("CLOVER_WINDROW")
		if dryCloverWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.CLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.CLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.CLOVER_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.CLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.CLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.CLOVER_WINDROW[i]=j
				end
			end	
		end	
		local dryCloverWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("SEMIDRYCLOVER_WINDROW")
		if dryCloverWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.SEMIDRYCLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.SEMIDRYCLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.SEMIDRYCLOVER_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.SEMIDRYCLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.SEMIDRYCLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.SEMIDRYCLOVER_WINDROW[i]=j
				end
			end	
		end	
		local dryCloverWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("DRYCLOVER_WINDROW")
		if dryCloverWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.DRYCLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.DRYCLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.DRYGRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.DRYCLOVER_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.DRYCLOVER_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.DRYCLOVER_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.DRYGRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.DRYCLOVER_WINDROW[i]=j
				end
			end	
		end	
				
		--ALFALFA
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("WETALFALFA_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.WETALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.WETALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.WETALFALFA_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.WETALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.WETALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.WETALFALFA_WINDROW[i]=j
				end
			end	
		end	
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.ALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.ALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.ALFALFA_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.ALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.ALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.ALFALFA_WINDROW[i]=j
				end
			end	
		end	
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("SEMIDRYALFALFA_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.SEMIDRYALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.SEMIDRYALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.SEMIDRYALFALFA_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.SEMIDRYALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.SEMIDRYALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.SEMIDRYALFALFA_WINDROW[i]=j
				end
			end	
		end	
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("DRYALFALFA_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.DRYALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.DRYALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.DRYGRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.DRYALFALFA_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.DRYALFALFA_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.DRYALFALFA_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.DRYGRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.DRYALFALFA_WINDROW[i]=j
				end
			end	
		end	
		
		--HORSEGRASS
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("WETHORSEGRASS_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.WETHORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.WETHORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.WETHORSEGRASS_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.WETHORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.WETHORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.WETHORSEGRASS_WINDROW[i]=j
				end
			end	
		end	
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.HORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.HORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.HORSEGRASS_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.HORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.HORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.HORSEGRASS_WINDROW[i]=j
				end
			end	
		end	
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("SEMIDRYHORSEGRASS_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.SEMIDRYHORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.SEMIDRYHORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.SEMIDRYHORSEGRASS_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.SEMIDRYHORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.SEMIDRYHORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.GRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.SEMIDRYHORSEGRASS_WINDROW[i]=j
				end
			end	
		end	
		local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("DRYHORSEGRASS_WINDROW")
		if dryAlfalfaWindrowIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.DRYHORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.fillTypes.DRYHORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.DRYGRASS_WINDROW) do
					g_seasons.economy.data.repricing.fillTypes.DRYHORSEGRASS_WINDROW[i]=j
				end
			end	
			if g_seasons.economy.data.repricing.bales.DRYHORSEGRASS_WINDROW  == nil then
				g_seasons.economy.data.repricing.bales.DRYHORSEGRASS_WINDROW = {}
				for i,j in pairs(g_seasons.economy.data.repricing.bales.DRYGRASS_WINDROW) do
					g_seasons.economy.data.repricing.bales.DRYHORSEGRASS_WINDROW[i]=j
				end
			end	
		end	
		
		
		local onionIndex = g_fillTypeManager:getFillTypeIndexByName("ONION")
		if onionIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.ONION  == nil then
				g_seasons.economy.data.repricing.fillTypes.ONION = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.POTATO) do
					g_seasons.economy.data.repricing.fillTypes.ONION[i]=j
				end
			end	
		end	
		local carrotIndex = g_fillTypeManager:getFillTypeIndexByName("CARROT")
		if carrotIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.CARROT  == nil then
				g_seasons.economy.data.repricing.fillTypes.CARROT = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.POTATO) do
					g_seasons.economy.data.repricing.fillTypes.CARROT[i]=j
				end
			end	
		end	

		local incaraseGrassIndex = g_fillTypeManager:getFillTypeIndexByName("INCARASE_GRASS")
		if incaraseGrassIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.INCARASE_GRASS  == nil then
				g_seasons.economy.data.repricing.fillTypes.INCARASE_GRASS = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.WHEAT) do
					g_seasons.economy.data.repricing.fillTypes.INCARASE_GRASS[i]=j
				end
			end	
		end	
		
		local incaraseGrassIndex = g_fillTypeManager:getFillTypeIndexByName("FIELD_GRASS")
		if incaraseGrassIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.FIELD_GRASS  == nil then
				g_seasons.economy.data.repricing.fillTypes.FIELD_GRASS = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.WHEAT) do
					g_seasons.economy.data.repricing.fillTypes.FIELD_GRASS[i]=j
				end
			end	
		end	
		local incaraseGrassIndex = g_fillTypeManager:getFillTypeIndexByName("TRITICALE")
		if incaraseGrassIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.TRITICALE  == nil then
				g_seasons.economy.data.repricing.fillTypes.TRITICALE = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.WHEAT) do
					g_seasons.economy.data.repricing.fillTypes.TRITICALE[i]=j
				end
			end	
		end	
		local incaraseGrassIndex = g_fillTypeManager:getFillTypeIndexByName("RYE")
		if incaraseGrassIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.RYE  == nil then
				g_seasons.economy.data.repricing.fillTypes.RYE = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.WHEAT) do
					g_seasons.economy.data.repricing.fillTypes.RYE[i]=j
				end
			end	
		end	
		local incaraseGrassIndex = g_fillTypeManager:getFillTypeIndexByName("SPELT")
		if incaraseGrassIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.SPELT  == nil then
				g_seasons.economy.data.repricing.fillTypes.SPELT = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.WHEAT) do
					g_seasons.economy.data.repricing.fillTypes.SPELT[i]=j
				end
			end	
		end	
		local incaraseGrassIndex = g_fillTypeManager:getFillTypeIndexByName("MISCANTHUS")
		if incaraseGrassIndex ~= nil then
			if g_seasons.economy.data.repricing.fillTypes.MISCANTHUS  == nil then
				g_seasons.economy.data.repricing.fillTypes.MISCANTHUS = {}
				for i,j in pairs(g_seasons.economy.data.repricing.fillTypes.WOODCHIPS) do
					g_seasons.economy.data.repricing.fillTypes.MISCANTHUS[i]=j
				end
			end	
		end	

	end
end

---Change baler so they can bale non-windrow choppedMaize
function MaizePlus.balerOnPostLoadAdd(vehicle, savegame)
	if MaizePlus.isActive then
		local spec = vehicle.spec_baler
		for fillTypeIndex, enabled in pairs(vehicle:getFillUnitSupportedFillTypes(spec.fillUnitIndex)) do
			if enabled and fillTypeIndex ~= FillType.UNKNOWN then
				if fillTypeIndex == FillType.CHOPPEDMAIZE then
					table.insert(spec.pickupFillTypes, fillTypeIndex)
				end
				if fillTypeIndex == FillType.SILOGRASS then
					table.insert(spec.pickupFillTypes, fillTypeIndex)
				end				
			end
		end
	end
end

---Add choppedMaize_fermented to "silage" category on mixer wagon
function MaizePlus.mixerWagonOnLoadAdd(vehicle, savegame)
	if MaizePlus.isActive and not MaizePlus.forageExtensionEnabled then
		local spec = vehicle.spec_mixerWagon

		local fillTypeIndex_choppedMaize = g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE")
		local fillTypeIndex_choppedMaize_fermented = g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE_FERMENTED")
		local fillTypeIndex_grass_fermented = g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")

		-- add choppedMaize and choppedMaize_fermented and grass_fermented and grass_fermented to mixer wagon fillTypes
		for fillUnitIndex, fillUnit in pairs(vehicle.spec_fillUnit.fillUnits) do
			-- go through fillUnits
			if fillUnit.supportedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILAGE")] then
				-- if we have a fillUnit that supports silage, we found the right one (99%)
				fillUnit.supportedFillTypes[fillTypeIndex_choppedMaize] = true
				fillUnit.supportedFillTypes[fillTypeIndex_choppedMaize_fermented] = true
				fillUnit.supportedFillTypes[fillTypeIndex_grass_fermented] = true
			end
		end

		-- add choppedMaize_fermented to "silage" category in mixerWagon, add choppedMaize to "dryGrass" category in mixer wagon
		for _, fillType in pairs(spec.mixerWagonFillTypes) do
			if fillType.name == "silage" then
				if spec.fillTypeToMixerWagonFillType[fillTypeIndex_choppedMaize_fermented] == nil then
					fillType.fillTypes[fillTypeIndex_choppedMaize_fermented] = true
					spec.fillTypeToMixerWagonFillType[fillTypeIndex_choppedMaize_fermented] = fillType
				end
				if spec.fillTypeToMixerWagonFillType[fillTypeIndex_grass_fermented] == nil then
					fillType.fillTypes[fillTypeIndex_grass_fermented] = true
					spec.fillTypeToMixerWagonFillType[fillTypeIndex_grass_fermented] = fillType
				end				
			end
			if fillType.name == "dryGrass" then
				if spec.fillTypeToMixerWagonFillType[fillTypeIndex_choppedMaize] == nil then
					fillType.fillTypes[fillTypeIndex_choppedMaize] = true
					spec.fillTypeToMixerWagonFillType[fillTypeIndex_choppedMaize] = fillType
				end
			end
		end
	end
end

---Change bale wrapper so they will wrap choppedmaize bales into choppedmaize_fermented bales
function MaizePlus.loadWrapperFromXMLAdd(self, wrapper, xmlFile, baseKey)
	if MaizePlus.isActive then
		-- only add maize bale to roundbale wrapper 
		if wrapper.allowedBaleTypes ~= nil and wrapper.allowedBaleTypes[FillType.GRASS_WINDROW] ~= nil then
			
			-- round bale wrapper 
			if wrapper.allowedBaleTypes[FillType.GRASS_WINDROW][1].minBaleDiameter ~= nil then
			
				-- we need to check if we are the default KuhnFBP3135 or KuhnSW4014 because those have special bales 
				-- (we would need to do the same for the Claas baler but we can't since that bale is locked away)
				-- split path and check for the name in the path 
				local isKuhnSW4014 = false
				local isKuhnFBP3135 = false
				local splitPath = StringUtil.splitString("/", wrapper.allowedBaleTypes[FillType.GRASS_WINDROW][1].wrapperBaleFilename)
				for _, pathPart in pairs(splitPath) do
					if pathPart == "kuhnSW4014" then 
						isKuhnSW4014 = true
					end
					if pathPart == "kuhnFBP3135" then
						isKuhnFBP3135 = true
					end
				end
		
				-- set up path depending on which wrapper we are 
				local roundbale_choppedMaize_fermented_w112_d130 = Utils.getFilename("roundbales/roundbale_choppedMaize_fermented_w112_d130.i3d", modDirectory)
				local roundbale_grass_fermented_w112_d130 = Utils.getFilename("roundbales/roundbale_grass_fermented_w112_d130.i3d", modDirectory)

				-- new filltypes for V 1.2 
				local roundbale_clover_fermented_w112_d130 = Utils.getFilename("roundbales/roundbale_clover_fermented_w112_d130.i3d", modDirectory)
				local roundbale_alfalfa_fermented_w112_d130 = Utils.getFilename("roundbales/roundbale_alfalfa_fermented_w112_d130.i3d", modDirectory)
				local roundbale_horseGrass_fermented_w112_d130 = Utils.getFilename("roundbales/roundbale_horseGrass_fermented_w112_d130.i3d", modDirectory)
				local roundbale_cropWindrow_fermented_w112_d130 = Utils.getFilename("roundbales/roundbale_cropWindrow_fermented_w112_d130.i3d", modDirectory)
				
				if isKuhnFBP3135 then
					roundbale_choppedMaize_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnFBP3135_roundbale_choppedMaize_fermented_w112_d130.i3d", modDirectory)
					roundbale_grass_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnFBP3135_roundbale_grass_fermented_w112_d130.i3d", modDirectory)
				
					-- new filltypes for V 1.2 
					roundbale_clover_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnFBP3135_roundbale_clover_fermented_w112_d130.i3d", modDirectory)
					roundbale_alfalfa_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnFBP3135_roundbale_alfalfa_fermented_w112_d130.i3d", modDirectory)
					roundbale_horseGrass_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnFBP3135_roundbale_horseGrass_fermented_w112_d130.i3d", modDirectory)
					roundbale_cropWindrow_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnFBP3135_roundbale_cropWindrow_fermented_w112_d130.i3d", modDirectory)										
				elseif isKuhnSW4014 then
					roundbale_choppedMaize_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnSW4014_roundbale_choppedMaize_fermented_w112_d130.i3d", modDirectory)
					roundbale_grass_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnSW4014_roundbale_grass_fermented_w112_d130.i3d", modDirectory)

					-- new filltypes for V 1.2 
					roundbale_clover_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnSW4014_roundbale_clover_fermented_w112_d130.i3d", modDirectory)
					roundbale_alfalfa_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnSW4014_roundbale_alfalfa_fermented_w112_d130.i3d", modDirectory)
					roundbale_horseGrass_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnSW4014_roundbale_horseGrass_fermented_w112_d130.i3d", modDirectory)	
					roundbale_cropWindrow_fermented_w112_d130 = Utils.getFilename("roundbales/kuhnSW4014_roundbale_cropWindrow_fermented_w112_d130.i3d", modDirectory)								
				end
				-- add chopped maize to allowed bale types and add bale 
				wrapper.allowedBaleTypes[FillType.CHOPPEDMAIZE] = {}
				table.insert(wrapper.allowedBaleTypes[FillType.CHOPPEDMAIZE], { fillType = FillType.CHOPPEDMAIZE, wrapperBaleFilename = roundbale_choppedMaize_fermented_w112_d130, minBaleDiameter = 1.1, maxBaleDiameter = 1.3, minBaleWidth = 1.1, maxBaleWidth = 1.3 })
				
				-- add grass silage bale to grass 
				wrapper.allowedBaleTypes[FillType.GRASS_WINDROW][1].wrapperBaleFilename = roundbale_grass_fermented_w112_d130

				-- add silograss to allowed bale types and add bale 
				wrapper.allowedBaleTypes[FillType.SILOGRASS] = {}
				table.insert(wrapper.allowedBaleTypes[FillType.SILOGRASS], { fillType = FillType.SILOGRASS, wrapperBaleFilename = roundbale_grass_fermented_w112_d130, minBaleDiameter = 1.1, maxBaleDiameter = 1.3, minBaleWidth = 1.1, maxBaleWidth = 1.3 })
							
				-- new V 1.2 type 
				if MaizePlus.siloCloverActive then
					wrapper.allowedBaleTypes[FillType.CLOVER_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.CLOVER_WINDROW], { fillType = FillType.CLOVER_WINDROW, wrapperBaleFilename = roundbale_clover_fermented_w112_d130, minBaleDiameter = 1.1, maxBaleDiameter = 1.3, minBaleWidth = 1.1, maxBaleWidth = 1.3 })
				end
				if MaizePlus.siloAlfalfaActive then
					wrapper.allowedBaleTypes[FillType.ALFALFA_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.ALFALFA_WINDROW], { fillType = FillType.ALFALFA_WINDROW, wrapperBaleFilename = roundbale_alfalfa_fermented_w112_d130, minBaleDiameter = 1.1, maxBaleDiameter = 1.3, minBaleWidth = 1.1, maxBaleWidth = 1.3 })
				end
				if g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_FERMENTED") ~= nil and g_fillTypeManager:getFillTypeIndexByName("SEMIDRYHORSEGRASS_WINDROW") ~= nil then 
					wrapper.allowedBaleTypes[FillType.SEMIDRYHORSEGRASS_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.SEMIDRYHORSEGRASS_WINDROW], { fillType = FillType.SEMIDRYHORSEGRASS_WINDROW, wrapperBaleFilename = roundbale_horseGrass_fermented_w112_d130, minBaleDiameter = 1.1, maxBaleDiameter = 1.3, minBaleWidth = 1.1, maxBaleWidth = 1.3 })
				end
				if g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW") ~= nil then
					wrapper.allowedBaleTypes[FillType.CROP_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.CROP_WINDROW], { fillType = FillType.CROP_WINDROW, wrapperBaleFilename = roundbale_cropWindrow_fermented_w112_d130, minBaleDiameter = 1.1, maxBaleDiameter = 1.3, minBaleWidth = 1.1, maxBaleWidth = 1.3 })
				end				

			elseif wrapper.allowedBaleTypes[FillType.GRASS_WINDROW][1].minBaleLength ~= nil then -- square bale wrapper
				-- square silage bale from Kuhn bale wrapper, use this for all square balers if there's any
				local squarebale_grass_fermented = Utils.getFilename("squarebales/squarebale_grass_fermented.i3d", modDirectory)

				-- new V 1.2 type 
				local squarebale_clover_fermented = Utils.getFilename("squarebales/squarebale_clover_fermented.i3d", modDirectory)
				local squarebale_alfalfa_fermented = Utils.getFilename("squarebales/squarebale_alfalfa_fermented.i3d", modDirectory)
				local squarebale_horseGrass_fermented = Utils.getFilename("squarebales/squarebale_horseGrass_fermented.i3d", modDirectory)
				local squarebale_cropWindrow_fermented = Utils.getFilename("squarebales/squarebale_cropWindrow_fermented.i3d", modDirectory)

				-- add silograss to allowed bale types and add bale 
				wrapper.allowedBaleTypes[FillType.SILOGRASS] = {}
				table.insert(wrapper.allowedBaleTypes[FillType.SILOGRASS], { fillType = FillType.SILOGRASS, wrapperBaleFilename = squarebale_grass_fermented, minBaleWidth = 1.15, maxBaleWidth = 1.25, maxBaleHeight = 0.85, minBaleHeight = 0.75, minBaleLength = 2.35, maxBaleLength = 2.45})
				
				-- add grass silage bale to grass 
				wrapper.allowedBaleTypes[FillType.GRASS_WINDROW][1].wrapperBaleFilename = squarebale_grass_fermented			
				
				if MaizePlus.siloCloverActive then
					wrapper.allowedBaleTypes[FillType.CLOVER_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.CLOVER_WINDROW], { fillType = FillType.CLOVER_WINDROW, wrapperBaleFilename = squarebale_clover_fermented, minBaleWidth = 1.15, maxBaleWidth = 1.25, maxBaleHeight = 0.85, minBaleHeight = 0.75, minBaleLength = 2.35, maxBaleLength = 2.45})
				end
				if MaizePlus.siloAlfalfaActive then
					wrapper.allowedBaleTypes[FillType.ALFALFA_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.ALFALFA_WINDROW], { fillType = FillType.ALFALFA_WINDROW, wrapperBaleFilename = squarebale_alfalfa_fermented, minBaleWidth = 1.15, maxBaleWidth = 1.25, maxBaleHeight = 0.85, minBaleHeight = 0.75, minBaleLength = 2.35, maxBaleLength = 2.45})
				end

				if g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_FERMENTED") ~= nil and g_fillTypeManager:getFillTypeIndexByName("SEMIDRYHORSEGRASS_WINDROW") ~= nil then
					wrapper.allowedBaleTypes[FillType.SEMIDRYHORSEGRASS_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.SEMIDRYHORSEGRASS_WINDROW], { fillType = FillType.SEMIDRYHORSEGRASS_WINDROW, wrapperBaleFilename = squarebale_horseGrass_fermented, minBaleWidth = 1.15, maxBaleWidth = 1.25, maxBaleHeight = 0.85, minBaleHeight = 0.75, minBaleLength = 2.35, maxBaleLength = 2.45})
				end
				if g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW") ~= nil then
					wrapper.allowedBaleTypes[FillType.CROP_WINDROW] = {}
					table.insert(wrapper.allowedBaleTypes[FillType.CROP_WINDROW], { fillType = FillType.CROP_WINDROW, wrapperBaleFilename = squarebale_cropWindrow_fermented, minBaleWidth = 1.15, maxBaleWidth = 1.25, maxBaleHeight = 0.85, minBaleHeight = 0.75, minBaleLength = 2.35, maxBaleLength = 2.45})
				end
			end
		end
	end
end


function MaizePlus.inj_baleWrapper_doStateChange_MaizePlus(vehicle, id, nearestBaleServerId)
	
	local spec = vehicle.spec_baleWrapper

    if g_seasons ~= nil and vehicle.isServer then
        if id == BaleWrapper.CHANGE_WRAPPER_BALE_DROPPED and spec.lastDroppedBale ~= nil then
			local bale = spec.lastDroppedBale

			
			if bale:getFillType() == FillType.CHOPPEDMAIZE_FERMENTED and bale.wrappingState >= 0.999 then

                bale:setFillType(FillType.CHOPPEDMAIZE)
                bale.fermentingProcess = 0
                bale.wrappingState = 1 -- normalize

                FS19_RM_Seasons.SeasonsBaleFermentEvent:sendEvent(bale)
			elseif bale:getFillType() == FillType.GRASS_FERMENTED and bale.wrappingState >= 0.999 then
				bale:setFillType(FillType.SILOGRASS)
                bale.fermentingProcess = 0
                bale.wrappingState = 1 -- normalize

				FS19_RM_Seasons.SeasonsBaleFermentEvent:sendEvent(bale)
			elseif FillType.CLOVER_FERMENTED ~= nil and bale:getFillType() == FillType.CLOVER_FERMENTED and bale.wrappingState >= 0.999 then
				bale:setFillType(FillType.SILOCLOVER)
                bale.fermentingProcess = 0
                bale.wrappingState = 1 -- normalize

				FS19_RM_Seasons.SeasonsBaleFermentEvent:sendEvent(bale)	
			elseif FillType.ALFALFA_FERMENTED ~= nil and bale:getFillType() == FillType.ALFALFA_FERMENTED and bale.wrappingState >= 0.999 then
				bale:setFillType(FillType.SILOALFALFA)
                bale.fermentingProcess = 0
                bale.wrappingState = 1 -- normalize

				FS19_RM_Seasons.SeasonsBaleFermentEvent:sendEvent(bale)								
			elseif FillType.HORSEGRASS_FERMENTED ~= nil and bale:getFillType() == FillType.HORSEGRASS_FERMENTED and bale.wrappingState >= 0.999 then
				bale:setFillType(FillType.SEMIDRYHORSEGRASS_WINDROW)
                bale.fermentingProcess = 0
                bale.wrappingState = 1 -- normalize

				FS19_RM_Seasons.SeasonsBaleFermentEvent:sendEvent(bale)								
			elseif FillType.SILAGE ~= nil and bale:getFillType() == FillType.SILAGE and bale.wrappingState >= 0.999 then
				bale:setFillType(FillType.CROP_WINDROW)
				bale.fermentingProcess = 0
				bale.wrappingState = 1 -- normalize

				FS19_RM_Seasons.SeasonsBaleFermentEvent:sendEvent(bale)								
			end
        end
    end
end

function MaizePlus.override_seasons_updateBaleFermentation(self, superFunc, deltaTime)
    local bales = self.mission.limitedObjects[FSBaseMission.LIMITED_OBJECT_TYPE_BALE].objects
    local timeScale = self.mission.missionInfo.timeScale

    for i = 1, #bales do
        local bale = bales[i]

        if bale:getIsFermenting() then
            bale.fermentingProcess = bale.fermentingProcess + (deltaTime / self:getFermentationDuration())

			if bale.fermentingProcess >= 1 then
				-- Finish fermenting process
				-- maizePlus addition, check if its silograss or choppedmaize and set fruitType accordingly
				if bale:getFillType() == FillType.SILOGRASS then
					bale:setFillType(FillType.GRASS_FERMENTED)
				elseif bale:getFillType() == FillType.CHOPPEDMAIZE then
					bale:setFillType(FillType.CHOPPEDMAIZE_FERMENTED)
				elseif bale:getFillType() == FillType.SILOALFALFA then
					bale:setFillType(FillType.ALFALFA_FERMENTED)
				elseif bale:getFillType() == FillType.SILOCLOVER then
					bale:setFillType(FillType.CLOVER_FERMENTED)										
				elseif bale:getFillType() == FillType.SEMIDRYHORSEGRASS_WINDROW then
					bale:setFillType(FillType.HORSEGRASS_FERMENTED)										
				else
					bale:setFillType(FillType.SILAGE)	
				end
                bale.fermentingProcess = nil

                FS19_RM_Seasons.SeasonsBaleFermentEvent:sendEvent(bale)
            end
        end
    end
end

---Add choppedmaize and choppedmaize_fermented to animal food groups so it can be fed
function MaizePlus.loadFoodGroupsAdd()
	if MaizePlus.isActive and not MaizePlus.forageExtensionEnabled then
		local foodManager = g_animalFoodManager
		
		-- go through all food groups for "cow"
		local animalType = "COW"
		for _, foodGroup in pairs(foodManager.foodGroups[animalType].content) do
			for _, fillType in pairs(foodGroup.fillTypes) do
				-- go through all the fillTypes for the current food group
				if fillType == g_fillTypeManager:getFillTypeIndexByName("SILAGE") then
					-- check if we have silage listed
					-- add choppedMaize_fermented to silage category
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE_FERMENTED"))
				end
				if fillType == g_fillTypeManager:getFillTypeIndexByName("GRASS_WINDROW") then
					-- check if we have grass listed
					-- add choppedMaize grass category
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE"))
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED"))
				end
			end
		end

		-- same for sheep
		animalType = "SHEEP"
		for _, foodGroup in pairs(foodManager.foodGroups[animalType].content) do
			for _, fillType in pairs(foodGroup.fillTypes) do
				-- go through all the fillTypes for the current food group
				if fillType == g_fillTypeManager:getFillTypeIndexByName("GRASS_WINDROW") then
					-- check if we have grass listed
					-- add choppedMaize and choppedMaize_fermented grass category
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE"))
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE_FERMENTED"))
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED"))
				end
			end
		end

		-- pigs.. now pigs are a different kind of animal )
		animalType = "PIG"
		for _, foodGroup in pairs(foodManager.foodGroups[animalType].content) do
			for _, fillType in pairs(foodGroup.fillTypes) do
				-- go through all the fillTypes for the current food group
				if fillType == g_fillTypeManager:getFillTypeIndexByName("WHEAT") then
					-- check if we have wheat listed
					-- add choppedMaize to wheat category
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE"))
				end
				if MaizePlus.ccmIsEnabled and fillType == g_fillTypeManager:getFillTypeIndexByName("MAIZE") then
					-- check if we have maize listed
					-- add ccm to maize category
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("CCM"))
				end				
			end
		end
		
		animalType = "CHICKEN"
		for _, foodGroup in pairs(foodManager.foodGroups[animalType].content) do
			for _, fillType in pairs(foodGroup.fillTypes) do
				-- go through all the fillTypes for the current food group
				if MaizePlus.ccmIsEnabled and fillType == g_fillTypeManager:getFillTypeIndexByName("WHEAT") then
					-- check if we have maize listed
					-- add ccm to maize category
					table.insert(foodGroup.fillTypes, g_fillTypeManager:getFillTypeIndexByName("CCMRAW"))
				end				
			end
		end		
		
	end
end

---Add choppedMaize to selling stations that sell grass and add choppedMaize_fermented to selling stations that sell silage
function MaizePlus.sellingStationLoad(self, superFunc, ...)
	local returnValue = superFunc(self, ...);
	if MaizePlus.isActive then
		if self ~= nil then
			local choppedMaizeFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE_FERMENTED")
			local ccmrawIndex = g_fillTypeManager:getFillTypeIndexByName("CCMRAW")
			local ccmIndex = g_fillTypeManager:getFillTypeIndexByName("CCM")
			local grassFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")
			local silograssIndex = g_fillTypeManager:getFillTypeIndexByName("SILOGRASS")

			-- check if selling station sells grass
			if self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("GRASS_WINDROW")] then
			
				if MaizePlus.ccmIsEnabled then -- V 1.1 Fix
					self:addAcceptedFillType(ccmrawIndex, g_fillTypeManager:getFillTypeByName("CCMRAW").pricePerLiter, true, false)
					self.priceMultipliers[ccmrawIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("GRASS_WINDROW")]
				end


				self:initPricingDynamics()
			end

			if self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("DRYGRASS_WINDROW")] then
				-- additional fillTypes loaded via the map (fillTypes usually added to MaizePlus ready maps)
				local dryCloverWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("DRYCLOVER_WINDROW")
				if dryCloverWindrowIndex ~= nil then 
					self:addAcceptedFillType(dryCloverWindrowIndex, g_fillTypeManager:getFillTypeByName("DRYCLOVER_WINDROW").pricePerLiter, true, false)
					self.priceMultipliers[dryCloverWindrowIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("DRYGRASS_WINDROW")]					
				end
				local dryAlfalfaWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("DRYALFALFA_WINDROW")
				if dryAlfalfaWindrowIndex ~= nil then 
					self:addAcceptedFillType(dryAlfalfaWindrowIndex, g_fillTypeManager:getFillTypeByName("DRYALFALFA_WINDROW").pricePerLiter, true, false)
					self.priceMultipliers[dryAlfalfaWindrowIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("DRYGRASS_WINDROW")]					
				end	
				local dryHorseGrassWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("DRYHORSEGRASS_WINDROW")
				if dryHorseGrassWindrowIndex ~= nil then 
					self:addAcceptedFillType(dryHorseGrassWindrowIndex, g_fillTypeManager:getFillTypeByName("DRYHORSEGRASS_WINDROW").pricePerLiter, true, false)
					self.priceMultipliers[dryHorseGrassWindrowIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("DRYHORSEGRASS_WINDROW")]					
				end					
			end

			-- check if selling station sells silage
			if self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILAGE")] then
				-- add chopped maize fermented  fill type

				self:addAcceptedFillType(choppedMaizeFermentedIndex, g_fillTypeManager:getFillTypeByName("CHOPPEDMAIZE_FERMENTED").pricePerLiter, true, false)
				self.priceMultipliers[choppedMaizeFermentedIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]
				
				self:addAcceptedFillType(grassFermentedIndex, g_fillTypeManager:getFillTypeByName("GRASS_FERMENTED").pricePerLiter, true, false)
				self.priceMultipliers[grassFermentedIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]	
				
				self:addAcceptedFillType(silograssIndex, g_fillTypeManager:getFillTypeByName("SILOGRASS").pricePerLiter, true, false) -- need silograss for silage missions
				self.priceMultipliers[silograssIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")] 	
				
				-- V 1.3 stuffs
				local siloCloverIndex = g_fillTypeManager:getFillTypeIndexByName("SILOCLOVER")
				if siloCloverIndex ~= nil then -- clover exists 
					self:addAcceptedFillType(siloCloverIndex, g_fillTypeManager:getFillTypeByName("SILOCLOVER").pricePerLiter, true, false)
					self.priceMultipliers[siloCloverIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]			
				end
				local siloAlfalfaIndex = g_fillTypeManager:getFillTypeIndexByName("SILOALFALFA")
				if siloAlfalfaIndex ~= nil then -- clover exists 
					self:addAcceptedFillType(siloAlfalfaIndex, g_fillTypeManager:getFillTypeByName("SILOALFALFA").pricePerLiter, true, false)
					self.priceMultipliers[siloAlfalfaIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]			
				end		
				local semidryHorsegrassWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("SEMIDRYHORSEGRASS_WINDROW")
				if semidryHorsegrassWindrowIndex ~= nil then -- clover exists 
					self:addAcceptedFillType(semidryHorsegrassWindrowIndex, g_fillTypeManager:getFillTypeByName("SEMIDRYHORSEGRASS_WINDROW").pricePerLiter, true, false)
					self.priceMultipliers[semidryHorsegrassWindrowIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]			
				end		
				local cropWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW")
				if cropWindrowIndex ~= nil then -- clover exists 
					self:addAcceptedFillType(cropWindrowIndex, g_fillTypeManager:getFillTypeByName("CROP_WINDROW").pricePerLiter, true, false)
					self.priceMultipliers[cropWindrowIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]			
				end							
				
				if MaizePlus.ccmIsEnabled then -- V 1.1 Fix
					self:addAcceptedFillType(ccmIndex, g_fillTypeManager:getFillTypeByName("CCM").pricePerLiter, true, false)
					self.priceMultipliers[ccmIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]		
				end

				-- additional fillTypes loaded via the map (fillTypes usually added to MaizePlus ready maps)
				local cloverFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")
				if cloverFermentedIndex ~= nil then -- clover exists 
					self:addAcceptedFillType(cloverFermentedIndex, g_fillTypeManager:getFillTypeByName("CLOVER_FERMENTED").pricePerLiter, true, false)
					self.priceMultipliers[cloverFermentedIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]			
				end
				local alfalfaFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")
				if alfalfaFermentedIndex ~= nil then -- clover exists 
					self:addAcceptedFillType(alfalfaFermentedIndex, g_fillTypeManager:getFillTypeByName("ALFALFA_FERMENTED").pricePerLiter, true, false)
					self.priceMultipliers[alfalfaFermentedIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]			
				end
				local horseGrassFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_FERMENTED")
				if horseGrassFermentedIndex ~= nil then -- clover exists 
					self:addAcceptedFillType(horseGrassFermentedIndex, g_fillTypeManager:getFillTypeByName("HORSEGRASS_FERMENTED").pricePerLiter, true, false)
					self.priceMultipliers[horseGrassFermentedIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("SILAGE")]			
				end

				self:initPricingDynamics()
			end

			if self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("POTATO")] then	
				
				local carrotIndex = g_fillTypeManager:getFillTypeIndexByName("CARROT")
				if carrotIndex ~= nil then
					self:addAcceptedFillType(carrotIndex, g_fillTypeManager:getFillTypeByName("CARROT").pricePerLiter, true, false)
					self.priceMultipliers[carrotIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("POTATO")]			
				end	
				
				local onionIndex = g_fillTypeManager:getFillTypeIndexByName("ONION")
				if onionIndex ~= nil then
					self:addAcceptedFillType(onionIndex, g_fillTypeManager:getFillTypeByName("ONION").pricePerLiter, true, false)
					self.priceMultipliers[onionIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("POTATO")]			
				end					
			end

			if self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WHEAT")] then
				
				local incaraseGrassIndex = g_fillTypeManager:getFillTypeIndexByName("INCARASE_GRASS")
				if incaraseGrassIndex ~= nil then
					self:addAcceptedFillType(incaraseGrassIndex, g_fillTypeManager:getFillTypeByName("INCARASE_GRASS").pricePerLiter, true, false)
					self.priceMultipliers[incaraseGrassIndex] = self.priceMultipliers[g_fillTypeManager:getFillTypeIndexByName("WHEAT")]			
				end					
				
			end
			self:initPricingDynamics()
		end
	end
	return returnValue;
end

-- add choppedMaize_fermented to BGA bunker stations
function MaizePlus.bgaLoad(self, superFunc, xmlFile, key, customEnvironment)
    local returnValue = superFunc(self, xmlFile, key, customEnvironment)

	if MaizePlus.isActive then
		if self ~= nil then

			local silageIndex = g_fillTypeManager:getFillTypeIndexByName("SILAGE")
			local choppedMaizeFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE_FERMENTED")
			local choppedMaizeIndex = g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE")
			local grassWindrowIndex = g_fillTypeManager:getFillTypeIndexByName("GRASS_WINDROW")
			local grassFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")

			local cloverFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")
			local alfalfaFermentedIndex = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")
			local carrotIndex = g_fillTypeManager:getFillTypeIndexByName("CARROT")		
		
			-- go through all BGA slots and check their fillTypes for "silage"
			for _, slot in pairs(self.bunker.slots) do

				if slot.fillTypes[silageIndex] then
					-- add attributes for new fillType
					-- add choppedMaize_fermented
					local fillType = {}
					fillType.fillLevel = 0
					fillType.scale = slot.fillTypes[silageIndex].scale
					fillType.pricePerLiter = slot.fillTypes[silageIndex].pricePerLiter

					-- add new fillType to fillTypes
					slot.fillTypes[choppedMaizeFermentedIndex] = fillType

					-- add slot to fillType-to-slot table
					if self.bunker.fillTypeToSlot[choppedMaizeFermentedIndex] == nil then
						self.bunker.fillTypeToSlot[choppedMaizeFermentedIndex] = slot
					end
					
					fillType = {}
					-- add grass_fermented
					fillType.fillLevel = 0
					fillType.scale = slot.fillTypes[silageIndex].scale * 0.7
					fillType.pricePerLiter = slot.fillTypes[silageIndex].pricePerLiter * 0.7

					-- add new fillType to fillTypes
					slot.fillTypes[grassFermentedIndex] = fillType

					-- add slot to fillType-to-slot table
					if self.bunker.fillTypeToSlot[grassFermentedIndex] == nil then
						self.bunker.fillTypeToSlot[grassFermentedIndex] = slot
					end				

					if cloverFermentedIndex ~= nil then
						fillType = {}
						-- add grass_fermented
						fillType.fillLevel = 0
						fillType.scale = slot.fillTypes[silageIndex].scale * 0.7
						fillType.pricePerLiter = slot.fillTypes[silageIndex].pricePerLiter * 0.7
	
						-- add new fillType to fillTypes
						slot.fillTypes[cloverFermentedIndex] = fillType
	
						-- add slot to fillType-to-slot table
						if self.bunker.fillTypeToSlot[cloverFermentedIndex] == nil then
							self.bunker.fillTypeToSlot[cloverFermentedIndex] = slot
						end				
					end
					if alfalfaFermentedIndex ~= nil then
						fillType = {}
						-- add grass_fermented
						fillType.fillLevel = 0
						fillType.scale = slot.fillTypes[silageIndex].scale * 0.7
						fillType.pricePerLiter = slot.fillTypes[silageIndex].pricePerLiter * 0.7
	
						-- add new fillType to fillTypes
						slot.fillTypes[alfalfaFermentedIndex] = fillType
	
						-- add slot to fillType-to-slot table
						if self.bunker.fillTypeToSlot[alfalfaFermentedIndex] == nil then
							self.bunker.fillTypeToSlot[alfalfaFermentedIndex] = slot
						end				
					end					
				end

				if slot.fillTypes[grassWindrowIndex] then
					-- add attributes for new fillType
					-- add raw choppedMaize
					local fillType = {}
					fillType.fillLevel = 0
					fillType.scale = slot.fillTypes[grassWindrowIndex].scale
					fillType.pricePerLiter = slot.fillTypes[grassWindrowIndex].pricePerLiter

					-- add new fillType to fillTypes
					slot.fillTypes[g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE")] = fillType

					-- add slot to fillType-to-slot table
					if self.bunker.fillTypeToSlot[choppedMaizeIndex] == nil then
						self.bunker.fillTypeToSlot[choppedMaizeIndex] = slot
					end
					if carrotIndex ~= nil then
						fillType = {}
						-- add grass_fermented
						fillType.fillLevel = 0
						fillType.scale = slot.fillTypes[grassWindrowIndex].scale 
						fillType.pricePerLiter = slot.fillTypes[grassWindrowIndex].pricePerLiter 
	
						-- add new fillType to fillTypes
						slot.fillTypes[carrotIndex] = fillType
	
						-- add slot to fillType-to-slot table
						if self.bunker.fillTypeToSlot[carrotIndex] == nil then
							self.bunker.fillTypeToSlot[carrotIndex] = slot
						end				
					end	

				end

			end

		end
	end
	
    return returnValue
end

-- load fillTypes
local function registerFillTypes()
    MaizePlus.fillTypeInit(modDirectory, g_fillTypeManager, g_i18n)
end


---Unload the mod when the game is closed.
local function unload()
	if MaizePlus.maizePlus_ccmExtension_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_ccmExtension_materialHolder)
		MaizePlus.maizePlus_ccmExtension_materialHolder = nil
	end
	if MaizePlus.maizePlus_ccmExtension_effect_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_ccmExtension_effect_materialHolder)
		MaizePlus.maizePlus_ccmExtension_effect_materialHolder = nil
	end	
	if MaizePlus.maizePlus_effect_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_effect_materialHolder)
		MaizePlus.maizePlus_effect_materialHolder = nil
	end	
	if MaizePlus.maizePlus_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_materialHolder)
		MaizePlus.maizePlus_materialHolder = nil
	end	
	if MaizePlus.maizePlus_forageExtension_siloAlfalfa_effect_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloAlfalfa_effect_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_effect_materialHolder = nil	
	end
	if MaizePlus.maizePlus_forageExtension_siloAlfalfa_fillPlane_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloAlfalfa_fillPlane_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_fillPlane_materialHolder = nil	
	end	
	if MaizePlus.maizePlus_forageExtension_siloAlfalfa_particle_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloAlfalfa_particle_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_particle_materialHolder = nil	
	end	
	if MaizePlus.maizePlus_forageExtension_siloClover_effect_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloClover_effect_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloClover_effect_materialHolder = nil	
	end	
	if MaizePlus.maizePlus_forageExtension_siloClover_fillPlane_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloClover_fillPlane_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloClover_fillPlane_materialHolder = nil	
	end		
	if MaizePlus.maizePlus_forageExtension_siloClover_particle_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloClover_particle_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloClover_particle_materialHolder = nil	
	end	
	if MaizePlus.maizePlus_forageExtension_siloClover_icons_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloClover_icons_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloClover_icons_materialHolder = nil	
	end	
	if MaizePlus.maizePlus_forageExtension_siloAlfalfa_icons_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_forageExtension_siloAlfalfa_icons_materialHolder)
		MaizePlus.maizePlus_forageExtension_siloAlfalfa_icons_materialHolder = nil	
	end		
	if MaizePlus.maizePlus_ccmExtension_icons_materialHolder ~= nil then
		delete(MaizePlus.maizePlus_ccmExtension_icons_materialHolder)
		MaizePlus.maizePlus_ccmExtension_icons_materialHolder = nil	
	end		
end

-- missions fix so grass and grass silage bales can be sold. Basically all code directly from Seasons-Mod
function MaizePlus.sellingStation_addFillLevelFromTool(station, superFunc, farmId, deltaFillLevel, fillType, fillInfo, toolType)
    local moved = 0
    if deltaFillLevel > 0 and station:getIsFillTypeAllowed(fillType) and station:getIsToolTypeAllowed(toolType) then
        -- Look for wrapped grass bales that are fermenting
		if toolType == ToolType.BALE then
			if fillType == FillType.GRASS_WINDROW or fillType == FillType.GRASS_FERMENTED or fillType == FillType.SILOGRASS then -- changed to grass and grass_fermented 
				-- See if it is for a mission
				for _, mission in pairs(station.missions) do
					if mission.fillSold ~= nil and mission.fillType == FillType.SILAGE and mission.farmId == farmId then
						-- Act as if silage was delivered
						moved = superFunc(station, farmId, deltaFillLevel, FillType.SILAGE, fillInfo, toolType)
						break -- supercall will handle it for any other mission too
					end
				end
			end
        end
        -- If there was no delivery for silage mission, handle normally
        if moved == 0 then
            moved = superFunc(station, farmId, deltaFillLevel, fillType, fillInfo, toolType)
        end
    end
    return moved
end


---Called on first time the MaizePlus script is loaded.
local function init()
    -- Init the fill types that will be used on the heightmap earlier.
    FillTypeManager.loadMapData = Utils.appendedFunction(FillTypeManager.loadMapData, registerFillTypes)
	
    -- Add fillTypes before loadMapFinished to not get stuff mixed up
	FSBaseMission.loadMap = Utils.prependedFunction(FSBaseMission.loadMap, MaizePlus.finalizeFillTypes)
	
	-- add new fillTypes to seasons Economy to avoid big price-differences - V1.1 
	Mission00.loadItemsFinished = Utils.prependedFunction(Mission00.loadItemsFinished, MaizePlus.addSeasonsRepricing)

    -- unload/delete stuff before game closes 
    FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)

	-- hook into loadMapFinished to edit food groups since when foodManager is loaded our fillTypes aren't loaded yet 
    FSBaseMission.loadMapFinished = Utils.appendedFunction(FSBaseMission.loadMapFinished, MaizePlus.loadFoodGroupsAdd)
	
	-- add our stuff to selling stations 
    SellingStation.load = Utils.overwrittenFunction(SellingStation.load, MaizePlus.sellingStationLoad)

	-- add our stuff to BGA 
    Bga.load = Utils.overwrittenFunction(Bga.load, MaizePlus.bgaLoad)
	
	-- remove bale limit 
	if g_gameVersion < 9 then
		BaleTypeManager.addBaleType = Utils.overwrittenFunction(BaleTypeManager.addBaleType, MaizePlus.addBaleTypeNew)
		print("MaizePlus: Since game version is below Patch 1.6 baleLimit was removed via MaizePlus.")
	end
	
	-- a lot of changes to bunkerSilo, thats why its in a separate file now 
    BunkerSilo.load = Utils.overwrittenFunction(BunkerSilo.load, MaizePlus_bunkerSiloChanges.bunkerSiloLoad)
    BunkerSilo.interactionTriggerCallback = Utils.appendedFunction(BunkerSilo.interactionTriggerCallback, MaizePlus_bunkerSiloChanges.bunkerSiloInteractionTriggerCallback)
    BunkerSilo.saveToXMLFile = Utils.appendedFunction(BunkerSilo.saveToXMLFile, MaizePlus_bunkerSiloChanges.bunkerSiloSaveToXMLFile)
    BunkerSilo.loadFromXMLFile = Utils.overwrittenFunction(BunkerSilo.loadFromXMLFile, MaizePlus_bunkerSiloChanges.bunkerSiloLoadFromXMLFile)
	BunkerSilo.updateTick = Utils.appendedFunction(BunkerSilo.updateTick, MaizePlus_bunkerSiloChanges.updateTick)
	
	BunkerSilo.writeStream = Utils.appendedFunction(BunkerSilo.writeStream, MaizePlus_bunkerSiloChanges.writeStream)	
	BunkerSilo.readStream = Utils.appendedFunction(BunkerSilo.readStream, MaizePlus_bunkerSiloChanges.readStream)	

	-- add stuff to vehicles. (no extra specs since I don't think its neccessary in our case, if somebody needs to remove/change something in order for his mod to work, just talk to us)
    Baler.onPostLoad = Utils.appendedFunction(Baler.onPostLoad, MaizePlus.balerOnPostLoadAdd)
    MixerWagon.onLoad = Utils.appendedFunction(MixerWagon.onLoad, MaizePlus.mixerWagonOnLoadAdd)
	BaleWrapper.loadWrapperFromXML = Utils.appendedFunction(BaleWrapper.loadWrapperFromXML, MaizePlus.loadWrapperFromXMLAdd)
	
	SellingStation.addFillLevelFromTool = Utils.overwrittenFunction(SellingStation.addFillLevelFromTool, MaizePlus.sellingStation_addFillLevelFromTool)	
	
	-- add the bale wrapper resetting to non-fermented function if seasons is active  
	BaleWrapper.doStateChange = Utils.appendedFunction(BaleWrapper.doStateChange, MaizePlus.inj_baleWrapper_doStateChange_MaizePlus)
end

init()


-- Thank you Wopster, again ;) 