-- by modelleicher
-- www.ls-modcompany.com
-- 03.01.2020 

-- script containing all the bunkerSilo changes for maizePlus.


MaizePlus_bunkerSiloChanges = {}

-- add maizePlus fillType to bunker silos
function MaizePlus_bunkerSiloChanges.bunkerSiloLoad(self, superFunc, xmlFile, key, customEnvironment)
	local returnValue = superFunc(self, xmlFile, key, customEnvironment)
	
	if MaizePlus.isActive then
	
		-- check if we have chaff, add choppedmaize, silograss and ccmraw to possible input fillTypes 
		if self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CHAFF")] then
			self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE")] = true
			self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILOGRASS")] = true
			-- add CCMRAW only if CCM_Extension is enabled 
			if MaizePlus.ccmIsEnabled then 
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CCMRAW")] = true
			end
			
			if MaizePlus.siloCloverActive then 
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CLOVER_WINDROW")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILOCLOVER")] = true
				self.cloverActive = true;
			end

			if MaizePlus.siloAlfalfaActive then 			
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("ALFALFA_WINDROW")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILOALFALFA")] = true
				self.alfalfaActive = true;
			end		
			
			if g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW") then 			
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW")] = true
			end		
			
			-- V 1.2 addition, horsegrass stuffs 
			if g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_WINDROW") ~= nil and g_fillTypeManager:getFillTypeIndexByName("WETHORSEGRASS_WINDROW") ~= nil then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_WINDROW")] = true				
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETHORSEGRASS_WINDROW")] = true				
			end;

			-- V 1.3 addition, add SEMIDRY_GRASS_WINDROW
			if g_fillTypeManager:getFillTypeIndexByName("SEMIDRY_GRASS_WINDROW") ~= nil then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SEMIDRY_GRASS_WINDROW")] = true							
			end;	
			
			-- V 1.3 addition, SEMIDRYALFALFA_WINDROW and SEMIDRYCLOVER_WINDROW
			if g_fillTypeManager:getFillTypeIndexByName("SEMIDRYALFALFA_WINDROW") ~= nil and  g_fillTypeManager:getFillTypeIndexByName("SEMIDRYCLOVER_WINDROW") ~= nil then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SEMIDRYALFALFA_WINDROW")] = true							
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SEMIDRYCLOVER_WINDROW")] = true							
			end;	

			-- V 1.5 addition, BrewersGrain
			if g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN") ~= nil then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN")] = true													
			end;				
			if g_fillTypeManager:getFillTypeIndexByName("BEETPULP") ~= nil then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("BEETPULP")] = true													
			end;	
			
			-- V1.5 addition, composting
			if g_fillTypeManager:getFillTypeIndexByName("COMPOST") ~= nil then -- compost exists in map												
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("DRYGRASS_WINDROW")] = true													
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("STRAW")] = true																									
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("MANURE")] = true													
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("LIME")] = true	
	
				if g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")] = true		
				end;		
				if g_fillTypeManager:getFillTypeIndexByName("WETGRASS_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETGRASS_WINDROW")] = true		
				end;		
				if g_fillTypeManager:getFillTypeIndexByName("WETCLOVER_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETCLOVER_WINDROW")] = true		
				end;		
				if g_fillTypeManager:getFillTypeIndexByName("WETALFALFA_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETALFALFA_WINDROW")] = true		
				end;					
				if g_fillTypeManager:getFillTypeIndexByName("COMPOST") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("COMPOST")] = true		
				end;				
				if g_fillTypeManager:getFillTypeIndexByName("GREENCUT") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("GREENCUT")] = true	
				end;
				if g_fillTypeManager:getFillTypeIndexByName("HEDGECUT") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("HEDGECUT")] = true	
				end;
				if g_fillTypeManager:getFillTypeIndexByName("MISCANTHUS") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("MISCANTHUS")] = true	
				end;												
			end;				

			-- update the converting fillType areas to convert the new acceptedFillTypes too 
			g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)	

			-- add maizePlus specific variables 
			self.allowFillLevelSwitching = true
			self.fillLevelSwitchingLimit = 4000
		
			-- backup acceptedFillTypes 
			self.acceptedFillTypesBackup = {}
			for index, _ in pairs (self.acceptedFillTypes) do
				self.acceptedFillTypesBackup[index] = true
			end
		end
	end
	
    return returnValue
end

-- save current input and output fillType in savegame, too 
function MaizePlus_bunkerSiloChanges.bunkerSiloSaveToXMLFile(self, xmlFile, key, usedModNames)
	if MaizePlus.isActive and self.fillLevelSwitchingLimit ~= nil then
		setXMLString(xmlFile, key .. "#inputFillType", g_fillTypeManager:getFillTypeByIndex(self.inputFillType).name)
		setXMLString(xmlFile, key .. "#outputFillType", g_fillTypeManager:getFillTypeByIndex(self.outputFillType).name)
	end
end

-- load current input and output fillType from savegame 
function MaizePlus_bunkerSiloChanges.bunkerSiloLoadFromXMLFile(self, superFunc, xmlFile, key)
	local returnValue = superFunc(self, xmlFile, key)

	if MaizePlus.isActive and self.fillLevelSwitchingLimit ~= nil then		
		local inputFillType = getXMLString(xmlFile, key .. "#inputFillType")
		local outputFillType = getXMLString(xmlFile, key .. "#outputFillType")
		
		local fillLevel = getXMLFloat(xmlFile, key .. "#fillLevel")
		if fillLevel > self.fillLevelSwitchingLimit then
			self.allowFillLevelSwitching = false
		end
		
		if inputFillType ~= nil and inputFillType ~= "" and outputFillType ~= nil and outputFillType ~= "" then
			self.inputFillType = g_fillTypeManager:getFillTypeIndexByName(inputFillType)
			self.outputFillType = g_fillTypeManager:getFillTypeIndexByName(outputFillType)

			-- reset convertingFillTypeAreas 
			g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
			g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)

		end
	end
	
	return returnValue
end	

-- get input fillType and output fillType from Server when joining
function MaizePlus_bunkerSiloChanges.readStream(self, streamId, connection)
	if connection:getIsServer() then
		if self.fillLevelSwitchingLimit ~= nil then
		
			local inputFillType = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
			local outputFillType = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)

			if inputFillType ~= nil and outputFillType ~= nil then
				self.inputFillType = inputFillType
				self.outputFillType = outputFillType

				g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
				g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
			end
		end
    end
end

-- send input and output fillType to clients when joining
function MaizePlus_bunkerSiloChanges.writeStream(self, streamId, connection)
    if not connection:getIsServer() then
		if self.fillLevelSwitchingLimit ~= nil then
			streamWriteUIntN(streamId, self.inputFillType, FillTypeManager.SEND_NUM_BITS)
			streamWriteUIntN(streamId, self.outputFillType, FillTypeManager.SEND_NUM_BITS)	
		end
    end
end

-- change/reset the fillLevel switching 
function MaizePlus_bunkerSiloChanges.updateTick(self, dt)
	if MaizePlus.isActive then
		-- we reached the switching limit threshold, disable switching, reset acceptedFillTypes, update convertingArea 
		if self.allowFillLevelSwitching and self.fillLevel > self.fillLevelSwitchingLimit then 
			
			-- reset allowFillLevelSwitching
			self.allowFillLevelSwitching = false
			
			-- reset acceptedFillTypes 
			self.acceptedFillTypes = {}
			
			-- 1.2 change, add fermented type of each silage-type to acceptedFillTypes so it can be tipped back into the silo 
			if self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE")] = true				
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE_FERMENTED")] = true	
			elseif self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("CCMRAW") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CCMRAW")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CCM")] = true				
			elseif self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("SILOGRASS") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("GRASS_WINDROW")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILOGRASS")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")] = true
				-- V 1.2 addition, horsegrass stuffs 
				if g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_WINDROW") ~= nil and g_fillTypeManager:getFillTypeIndexByName("WETHORSEGRASS_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("HORSEGRASS_WINDROW")] = true				
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETHORSEGRASS_WINDROW")] = true				
				end;
				-- V 1.3 addition, SEMIDRY_GRASS_WINDROW
				if g_fillTypeManager:getFillTypeIndexByName("SEMIDRY_GRASS_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SEMIDRY_GRASS_WINDROW")] = true								
				end;
			elseif self.cloverActive and self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("SILOCLOVER") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CLOVER_WINDROW")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILOCLOVER")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")] = true

				-- V 1.3 addition, SEMIDRYCLOVER_WINDROW
				if g_fillTypeManager:getFillTypeIndexByName("SEMIDRYCLOVER_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SEMIDRYCLOVER_WINDROW")] = true							
				end;					
			elseif self.alfalfaActive and self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("SILOALFALFA") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("ALFALFA_WINDROW")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILOALFALFA")] = true				
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")] = true	
		
				-- V 1.3 addition, SEMIDRYALFALFA_WINDROW
				if g_fillTypeManager:getFillTypeIndexByName("SEMIDRYALFALFA_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SEMIDRYALFALFA_WINDROW")] = true							
				end;					
			elseif g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW") ~= nil and self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("CHAFF") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW")] = true
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("CHAFF")] = true				
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("SILAGE")] = true				
			elseif g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN") ~= nil and self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN")] = true			
			elseif g_fillTypeManager:getFillTypeIndexByName("BEETPULP") ~= nil and self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("BEETPULP") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("BEETPULP")] = true	
				
			elseif g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW") ~= nil and self.inputFillType == g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW") then
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")] = true													
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("DRYGRASS_WINDROW")] = true													
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("STRAW")] = true																									
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("MANURE")] = true													
				self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("LIME")] = true	
				
				if g_fillTypeManager:getFillTypeIndexByName("WETGRASS_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETGRASS_WINDROW")] = true		
				end;		
				if g_fillTypeManager:getFillTypeIndexByName("WETCLOVER_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETCLOVER_WINDROW")] = true		
				end;		
				if g_fillTypeManager:getFillTypeIndexByName("WETALFALFA_WINDROW") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("WETALFALFA_WINDROW")] = true		
				end;					
				if g_fillTypeManager:getFillTypeIndexByName("COMPOST") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("COMPOST")] = true		
				end;				
				if g_fillTypeManager:getFillTypeIndexByName("GREENCUT") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("GREENCUT")] = true	
				end;
				if g_fillTypeManager:getFillTypeIndexByName("HEDGECUT") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("HEDGECUT")] = true	
				end;
				if g_fillTypeManager:getFillTypeIndexByName("MISCANTHUS") ~= nil then
					self.acceptedFillTypes[g_fillTypeManager:getFillTypeIndexByName("MISCANTHUS")] = true	
				end;						
			else				
				self.acceptedFillTypes[self.inputFillType] = true
			end
			
			-- reset convertingFillTypeAreas 
			g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
			g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
			
		end
		
		-- reset allowFillLevelSwitching if silo is below switching limit and in fill-mode or empty 
		if self.allowFillLevelSwitching == false and (self.fillLevel < 4000 and self.state == BunkerSilo.STATE_FILL or self.fillLevel == 0) then 
			self.allowFillLevelSwitching = true
			
			self.acceptedFillTypes = self.acceptedFillTypesBackup	
		end
	end	
end


-- change "inputFillType" (visible fillType) and outputFillType	according to what enters the silo. Only allow to switch below certain fillLevel threshold 
function MaizePlus_bunkerSiloChanges.bunkerSiloInteractionTriggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if MaizePlus.isActive and self.fillLevelSwitchingLimit ~= nil then
		if onEnter then
			local vehicle = g_currentMission.nodeToObject[otherShapeId]
			if vehicle ~= nil then
				if vehicle.spec_fillUnit ~= nil then -- we have a fillUnit in the trigger 


					for fillUnitIndex, fillUnit in pairs(vehicle.spec_fillUnit.fillUnits) do
						
						-- if the bunkerSilo fill Level is below our set limit and we have something in the fillUnit continue 
						if self.allowFillLevelSwitching and fillUnit.fillLevel > 0 then
							local oldInputFillType = self.inputFillType
							local newInputFillType = self.inputFillType
							local newOutputFillType = self.outputFillType
							
							-- set input and output fillType of the silo depending on what we have in the vehicle 
							if fillUnit.fillType == FillType.CHOPPEDMAIZE then -- if we have choppedMaize, we want choppedMaize_fermented
								newInputFillType = g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE")
								newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("CHOPPEDMAIZE_FERMENTED")
							elseif fillUnit.fillType == FillType.CHAFF then -- if we have chaff, we want silage (default setting)
								newInputFillType = g_fillTypeManager:getFillTypeIndexByName("CHAFF")
								newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("SILAGE")
							elseif fillUnit.fillType == FillType.GRASS_WINDROW then -- if we have grass we want silograss in the silo (because compressable) and output grass_fermented 
								newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOGRASS")
								newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")
							elseif fillUnit.fillType == FillType.SILOGRASS then -- if we have SILOGRASS we want grass fermented 
								newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOGRASS")
								newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")
							end
							if MaizePlus.ccmIsEnabled and fillUnit.fillType == FillType.CCMRAW then -- if we have CCMRAW we want CCM 
								newInputFillType = g_fillTypeManager:getFillTypeIndexByName("CCMRAW")
								newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("CCM")
							end
							if self.cloverActive then
								if fillUnit.fillType == FillType.CLOVER_WINDROW or fillUnit.fillType == FillType.SILOCLOVER then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOCLOVER")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")
								end
							end
							if self.alfalfaActive then
								if fillUnit.fillType == FillType.ALFALFA_WINDROW or fillUnit.fillType == FillType.SILOALFALFA then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOALFALFA")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")
								end
							end		
							
							-- V 1.2 addition for the horsegrass stuffs 
							if g_fillTypeManager:getFillTypeIndexByName("wetHorseGrass_windrow") ~= nil and g_fillTypeManager:getFillTypeIndexByName("horseGrass_windrow") ~= nil then
								if fillUnit.fillType == FillType.WETHORSEGRASS_WINDROW or fillUnit.fillType == FillType.HORSEGRASS_WINDROW then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOGRASS")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")								
								end;
							end;
							
							if g_fillTypeManager:getFillTypeIndexByName("CROP_WINDROW") ~= nil then
								if fillUnit.fillType == FillType.CROP_WINDROW then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("CHAFF")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("SILAGE")									
								end;								
							end;	
							
							-- V 1.3 addition, semidry stuff 
							if g_fillTypeManager:getFillTypeIndexByName("SEMIDRY_GRASS_WINDROW") ~= nil then
								if fillUnit.fillType == FillType.SEMIDRY_GRASS_WINDROW then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOGRASS")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("GRASS_FERMENTED")									
								end;								
							end;							
							if g_fillTypeManager:getFillTypeIndexByName("SEMIDRYALFALFA_WINDROW") ~= nil then
								if fillUnit.fillType == FillType.SEMIDRYALFALFA_WINDROW then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOALFALFA")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_FERMENTED")									
								end;								
							end;							
							if g_fillTypeManager:getFillTypeIndexByName("SEMIDRYCLOVER_WINDROW") ~= nil then
								if fillUnit.fillType == FillType.SEMIDRYCLOVER_WINDROW then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("SILOCLOVER")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("CLOVER_FERMENTED")								
								end;								
							end;
							if g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN") ~= nil then
								if fillUnit.fillType == FillType.BREWERSGRAIN then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("BREWERSGRAIN_FERMENTED")								
								end;								
							end;			
							if g_fillTypeManager:getFillTypeIndexByName("BEETPULP") ~= nil then
								if fillUnit.fillType == FillType.BEETPULP then
									newInputFillType = g_fillTypeManager:getFillTypeIndexByName("BEETPULP")
									newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("BEETPULP_FERMENTED")								
								end;								
							end;	
							
							-- Compost Creation, any of these will trigger/start compost production in this silo 
							-- WETGRASS_WINDROW, WETCLOVER_WINDROW, WETALFALFA_WINDROW, DRYGRASS_WINDROW, STRAW, MISCANTHUS, MANURE, LIME, GREENCUT, HEDGECUT, COMPOST, COMPOSTRAW
							if g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW") ~= nil then
								if g_fillTypeManager:getFillTypeIndexByName("WETGRASS_WINDROW") ~= nil then
									if fillUnit.fillType == FillType.WETGRASS_WINDROW then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;	
								if g_fillTypeManager:getFillTypeIndexByName("WETCLOVER_WINDROW") ~= nil then
									if fillUnit.fillType == FillType.WETCLOVER_WINDROW then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;							
								if g_fillTypeManager:getFillTypeIndexByName("WETALFALFA_WINDROW") ~= nil then
									if fillUnit.fillType == FillType.WETALFALFA_WINDROW then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;	
								if g_fillTypeManager:getFillTypeIndexByName("DRYGRASS_WINDROW") ~= nil then
									if fillUnit.fillType == FillType.DRYGRASS_WINDROW then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;							
								if g_fillTypeManager:getFillTypeIndexByName("STRAW") ~= nil then
									if fillUnit.fillType == FillType.STRAW then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;							
								if g_fillTypeManager:getFillTypeIndexByName("MISCANTHUS") ~= nil then
									if fillUnit.fillType == FillType.MISCANTHUS then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;								
								if g_fillTypeManager:getFillTypeIndexByName("MANURE") ~= nil then
									if fillUnit.fillType == FillType.MANURE then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;
								if g_fillTypeManager:getFillTypeIndexByName("LIME") ~= nil then
									if fillUnit.fillType == FillType.LIME then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;
								if g_fillTypeManager:getFillTypeIndexByName("GREENCUT") ~= nil then
									if fillUnit.fillType == FillType.GREENCUT then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;
								if g_fillTypeManager:getFillTypeIndexByName("HEDGECUT") ~= nil then
									if fillUnit.fillType == FillType.HEDGECUT then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;							
								if g_fillTypeManager:getFillTypeIndexByName("COMPOST") ~= nil then
									if fillUnit.fillType == FillType.COMPOST then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;
								if g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW") ~= nil then
									if fillUnit.fillType == FillType.COMPOSTRAW then
										newInputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOSTRAW")
										newOutputFillType = g_fillTypeManager:getFillTypeIndexByName("COMPOST")								
									end;								
								end;			
							end;
							--
							--
							
							
							-- finally set the new fillTypes 
							if newInputFillType ~= self.inputFillType then
								g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
								g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, newInputFillType)
								self.inputFillType = newInputFillType
								self.outputFillType = newOutputFillType
								local area = self.bunkerSiloArea
								local offsetFront = self:getBunkerAreaOffset(true, 0, self.inputFillType)
								local offsetBack = self:getBunkerAreaOffset(false, 0, self.inputFillType)
								local changed = DensityMapHeightUtil.changeFillTypeAtArea(area.sx, area.sz, area.wx, area.wz, area.hx, area.hz, oldInputFillType, newInputFillType)
							end
						end
					end
				end
			end
		end
	end
end
