-- [F/A] derelky


mowerConditioner = {}
mowerConditioner.ModName = g_currentModName
mowerConditioner.ModDirectory = g_currentModDirectory
mowerConditioner.eventName = {}
mowerConditioner.Version = "1.0.0.0"


addModEventListener(mowerConditioner)

function mowerConditioner.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Mower, specializations)
end


function mowerConditioner.registerEventListeners(vehicleType)
	local functionNames = {	"onLoad" }
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, mowerConditioner)
	end
end

		
function mowerConditioner:onLoad(savegame)
    local spec = self.spec_mower
		local mcvehiclepath={"kvernelandpack/vehicles/vicon/extra732ft/extra732ft.xml","kvernelandpack/vehicles/vicon/extra7100tbx/extra7100tbx.xml","claaspack/vehicles/claas/disco1100c/disco1100c.xml","claaspack/vehicles/claas/disco3600fc/disco3600fc.xml","data/vehicles/poettinger/poettingernovacatx8/poettingernovacatx8.xml","data/vehicles/poettinger/poettingernovacat301/poettingernovacat301.xml","data/vehicles/newholland/newhollanddiscbine313/newhollanddiscbine313.xml","data/vehicles/krone/bigm450/bigm450.xml","fs19_fellagrasslandequipment/fellaramos3060fp/fellaramos3060fp.xml","fs19_fellagrasslandequipment/fellaramos3670tlx/fellaramos3670tlx.xml","fs19_kroneeasycutpack/krone/easycutf360cv/easycutf360cv.xml","fs19_kroneeasycutpack/krone/easycutb1000cvcollect/easycutb1000cvcollect.xml","fs19_jdmowerpack/jd/jdfc313f.xml","fs19_jdmowerpack/jd/jdfc883.xml","fs19_kongskildegxf3205/kongskildegxf.xml","fs19_kroneeasycutf/data/kroneeasycutf.xml","fs19_kuhnmowerpack/kuhn/kuhnfc313f.xml","fs19_kuhnmowerpack/kuhn/kuhnfc883.xml","fs19_kvernelandmower/kvtaarupmower.xml","fs19_lelysplendimo320fc/lelysplendimo320fc.xml","fs19_lelysplendimo900mc/lelysplendimo900mc.xml","fs19_mower_pack/xml/kuhngmd4411.xml","fs19_mower_pack/xml/poettingernovacat301.xml","fs19_mower_pack/xml/poettingernovacatx8.xml","fs19_novacat_varia_pack/poettingernovacatx8.xml","fs19_novacat_varia_pack/poettingernovacat301.xml","fs19_poettinger_novacat302ed/poettingernovacat302ed.xml","fs19_poettingernovacata10cf/novacata10cf.xml"}
		local usemc = false
		local storeItem = self.configFileName:lower()
		local hasMowerConditioner = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.mower#hasMowerConditioner"),false)
		if hasMowerConditioner then
			usemc = true
		end
		for k, v in pairs(mcvehiclepath) do
			if StringUtil.endsWith(storeItem,v) then
				usemc = true
			end
		end;

	
	if usemc then
		spec.fruitTypeConverters = {}
		local mcconverter = "MOWERCONDITIONER"
		local converter = getXMLString(self.xmlFile, "vehicle.mower#fruitTypeConverter")
		if converter ~= nil then
			local datamc = g_fruitTypeManager:getConverterDataByName(mcconverter)
			local data = g_fruitTypeManager:getConverterDataByName(converter)
			if datamc ~= nil then
				for input, converted in pairs(datamc) do
					spec.fruitTypeConverters[input] = converted
				end        
			elseif data ~= nil then
				for input, converted in pairs(data) do
					spec.fruitTypeConverters[input] = converted
				end
			end
		else
			print(string.format("Warning: Missing fruit type mcconverter in '%s'", self.configFileName))
		end
	end


end

