--[[
ShopControllerExtension.lua
	
Author: 	Ifko[nator]
Date:		28.10.2020
Version:	1.0

History:	v1.0 @28.10.2020 - initial implementation in FS 19
]]

ShopControllerExtension = {};
ShopControllerExtension.currentModDirectory = g_currentModDirectory;

function ShopControllerExtension:onStartMission()
    local modDesc = loadXMLFile("modDesc", ShopControllerExtension.currentModDirectory .. "modDesc.xml");
    local itemNumber = 0;
    local baseKey = "modDesc.shopControllerExtension";
    
    while true do
        local itemKey = baseKey .. ".removeItems.removeItem(" .. tostring(itemNumber) .. ")";

        if not hasXMLProperty(modDesc, itemKey) then
            break;
        end;

        local xmlFilename = Utils.getNoNil(getXMLString(modDesc, itemKey .. "#xmlFilename"), "");

        if xmlFilename ~= "" then
            for i, storeItem in pairs(g_storeManager.items) do
                if string.find(storeItem.xmlFilename, xmlFilename) then
                    storeItem.showInStore = false;
                end;
            end;
        end;

        itemNumber = itemNumber + 1;
    end;

    delete(modDesc);
end;

function ShopControllerExtension:load()
    if not self.isInitialized then
		local foundBrands = {};
        local foundCategory = {};
        
		for _, storeItem in ipairs(self.storeManager:getItems()) do
			if storeItem.categoryName ~= "" then
                local modDesc = loadXMLFile("modDesc", ShopControllerExtension.currentModDirectory .. "modDesc.xml");
                local baseKey = "modDesc.shopControllerExtension";

                local categoryNumber = 0;
            
                while true do
                    local categoryKey = baseKey .. ".removeStoreCategories.removeStoreCategory(" .. tostring(categoryNumber) .. ")";
            
                    if not hasXMLProperty(modDesc, categoryKey) then
                        break;
                    end;
            
                    local name = string.upper(Utils.getNoNil(getXMLString(modDesc, categoryKey .. "#name"), ""));
                    local newCategory = string.upper(Utils.getNoNil(getXMLString(modDesc, categoryKey .. "#newCategory"), "misc"));
                    local removeAllVehiclesFromShop = Utils.getNoNil(getXMLBool(modDesc, categoryKey .. "#removeAllVehiclesFromShop"), false);
            
                    if name ~= "" and self.storeManager:getCategoryByName(name) ~= nil then
                        if string.upper(storeItem.categoryName) == name then    
                            if removeAllVehiclesFromShop then
                                storeItem.showInStore = false;
                            else
                                if self.storeManager:getCategoryByName(newCategory) == nil then
                                    print("::ERROR from the ShopControllerExtension.lua:: The category '" .. newCategory .. "' does not exists! Using MISC instead!");

                                    newCategory = "MISC";
                                end;
                            end;

                            storeItem.categoryName = newCategory;
                        end;
                    end;
            
                    categoryNumber = categoryNumber + 1;
                end;

                local brand = self.brandManager:getBrandByIndex(storeItem.brandIndex);

                if brand ~= nil and not foundBrands[storeItem.brandIndex] then
                    foundBrands[storeItem.brandIndex] = true;
                    
					self:addBrandForDisplay(brand);
                end;

                local category = self.storeManager:getCategoryByName(storeItem.categoryName);
                
                if category ~= nil then
                    local categoryImageNumber = 0;
                
                    while true do
                        local categoryImageKey = baseKey .. ".changeStoreCategoryImages.changeStoreCategoryImage(" .. tostring(categoryImageNumber) .. ")";
                    
                        if not hasXMLProperty(modDesc, categoryImageKey) then
                            break;
                        end;
                    
                        local name = string.upper(Utils.getNoNil(getXMLString(modDesc, categoryImageKey .. "#name"), ""));
                        local newCategoryImage = Utils.getNoNil(getXMLString(modDesc, categoryImageKey .. "#imageFilename"), "");
                    
                        if name ~= "" and newCategoryImage ~= "" and self.storeManager:getCategoryByName(name) ~= nil then
                            if string.upper(category.name) == name then
                                category.image = Utils.getFilename(newCategoryImage, ShopControllerExtension.currentModDirectory);
                            end;
                        end;
                    
                        categoryImageNumber = categoryImageNumber + 1;
                    end;

                    delete(modDesc);

				    if not foundCategory[storeItem.categoryName] then
                        foundCategory[storeItem.categoryName] = true;
                        
                        self:addCategoryForDisplay(category);
                    end;
                end;
			end;
		end;

		table.sort(self.displayBrands, ShopController.brandSortFunction);
		table.sort(self.displayToolCategories, ShopController.categorySortFunction);
		table.sort(self.displayObjectCategories, ShopController.categorySortFunction);
		table.sort(self.displayPlaceableCategories, ShopController.categorySortFunction);
		table.sort(self.displayVehicleCategories, ShopController.categorySortFunction);

		self.isInitialized = true;
	end;
end;

FSBaseMission.onStartMission = Utils.prependedFunction(FSBaseMission.onStartMission, ShopControllerExtension.onStartMission);

ShopController.load = Utils.overwrittenFunction(ShopController.load, ShopControllerExtension.load);

addModEventListener(ShopControllerExtension);