local modDirectory = g_currentModDirectory

function onLoadMapFinished(mission, node)

    if node ~= 0 then
	
        local luprosilHudFile = "Stade_ZW4010_FA/hud/hud_fill_luprosil.png"
        local luprosilHudFileSmall = "Stade_ZW4010_FA/hud/hud_fill_luprosil_sml.png"
        local mischgetreideHudFile = "Stade_ZW4010_FA/hud/hud_fill_grainMix.png"
        local mischgetreideFileSmall = "Stade_ZW4010_FA/hud/hud_fill_grainMix_sml.png"
        local mischgetreidenotHudFile = "Stade_ZW4010_FA/hud/hud_fill_grainMixRaw.png"
        local mischgetreidenotFileSmall = "Stade_ZW4010_FA/hud/hud_fill_grainMixRaw_sml.png"
        local mischgetreideschrotHudFile = "Stade_ZW4010_FA/hud/hud_fill_Getreideschrot.png"
        local mischgetreideschrotFileSmall = "Stade_ZW4010_FA/hud/hud_fill_Getreideschrot_sml.png"
		local wheatmass = g_fillTypeManager:getFillTypeByName("WHEAT").massPerLiter
		
		local graingristHeapDiffuse = Utils.getFilename("Stade_ZW4010_FA/fillPlanes/Getreideschrot_diffuse.png", modDirectory)
        local graingristHeapnormal  = Utils.getFilename("Stade_ZW4010_FA/fillPlanes/Getreideschrot_normal.png", modDirectory)  
        local graingristHeapdistance = Utils.getFilename("Stade_ZW4010_FA/fillPlanes/distance/GetreideschrotDistance_diffuse.png", modDirectory)  

		--register Fill
        local luprosilFilType = g_fillTypeManager:addFillType("luprosil", g_i18n:getText("fillType_luprosil"), false, 1, 0.00045, math.rad(40), luprosilHudFile, luprosilHudFileSmall,modDirectory, nil, { 1, 1, 1 }, nil, false)
        local mischgetreideFilType = g_fillTypeManager:addFillType("grainmix", g_i18n:getText("fillType_grainmix"), false, 0.65, wheatmass*1.3, math.rad(40), mischgetreideHudFile, mischgetreideFileSmall,modDirectory, nil, { 1, 1, 1 }, nil, false)
        local mischgetreidenotFilType = g_fillTypeManager:addFillType("grainmixraw", g_i18n:getText("fillType_grainmixraw"), false, 0.65, wheatmass*1.3, math.rad(40), mischgetreidenotHudFile, mischgetreidenotFileSmall,modDirectory, nil, { 1, 1, 1 }, nil, false)
        local mischgetreideschrotFilType = g_fillTypeManager:addFillType("graingrist", g_i18n:getText("fillType_graingrist"), false, 0.65, wheatmass*1.3, math.rad(40), mischgetreideschrotHudFile, mischgetreideschrotFileSmall,modDirectory, nil, { 1, 1, 1 }, nil, false)
       
		--sound
		g_fillTypeManager.fillTypeToSample[mischgetreideschrotFilType.index] = g_fillTypeManager.fillTypeToSample[g_fillTypeManager:getFillTypeIndexByName("CHAFF")]	

		--height		
		local graingristHeightmapt = g_densityMapHeightManager:addDensityMapHeightType("graingrist", math.rad(40), 1, 0, 0, 1, 1, false, graingristHeapDiffuse, graingristHeapnormal, graingristHeapdistance, false)
		
		loadI3DFile(modDirectory .. "Stade_ZW4010_FA/fillPlanes/fillPlane_materialHolder.i3d");		
		loadI3DFile(modDirectory .. "Stade_ZW4010_FA/particleSystems/effect_materialHolder.i3d")	
		
		--add the new Filltypes to FillCategorys so it can be load in it
		local mischgetreideschrot = {"BULK", "TRAINWAGON", "LOADINGVEHICLE"}
		for _,k in pairs(mischgetreideschrot) do
			g_fillTypeManager:addFillTypeToCategory(mischgetreideschrotFilType.index, g_fillTypeManager.nameToCategoryIndex[k])	
		end
    end
	   g_currentMission.hud.fillLevelsDisplay:refreshFillTypes(g_fillTypeManager)
	
end


FSBaseMission.loadMapFinished = Utils.prependedFunction(FSBaseMission.loadMapFinished, onLoadMapFinished)

