--[[
	Author: 	derelky
	Date:		06.03.2019
	Version:	1.0
	
	History:
				v1.0 @ 06.03.2019 - initial implementation in FS 19
]]

Mill = {}
Mill.ModName = g_currentModName

function Mill.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FillUnit, specializations) and SpecializationUtil.hasSpecialization(Dischargeable, specializations) and SpecializationUtil.hasSpecialization(Mill, specializations)
end

function Mill.registerFunctions(vehicleType)
end

function Mill.registerOverwrittenFunctions(vehicleType)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "dischargeToObject", Mill.dischargeToObject)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "dischargeToGround", Mill.dischargeToGround)
	
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanDischargeToObject", Mill.getCanDischargeToObject)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanDischargeToGround", Mill.getCanDischargeToGround)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanDischargeAtPosition", Mill.getCanDischargeAtPosition)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "updateNearestObjectInTriggers",      Mill.updateNearestObjectInTriggers)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "onDischargeStateChanged",        Mill.onDischargeStateChanged)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "handleDischargeRaycast",        Mill.handleDischargeRaycast)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "raycastCallbackDischargeNode",        Mill.raycastCallbackDischargeNode)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setDischargeEffectActive",        Mill.setDischargeEffectActive)
	
	

end

function Mill.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", Mill)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", Mill)
   -- SpecializationUtil.registerEventListener(vehicleType, "onDischargeStateChanged", Mill)
end




function Mill:onLoad(savegame)
    local spec = self.spec_Mill
	--print("spec: "..tostring(spec))
   	if self.isClient then
        spec.millconvert = {}
        spec.millconvertbonus = {}
		spec.millconvertbonus.use = false
        local i=0
		while true do
            local key = string.format("vehicle.mill.millconvert(%d)", i)
            if not hasXMLProperty(self.xmlFile, key) then
                break
            end
			
			
			local inputstring = getXMLString(self.xmlFile, key.."#input")
			local input= g_fillTypeManager:getFillTypeIndexByName(inputstring)
			local outputstring =	getXMLString(self.xmlFile, key.."#output")
			local outputfilltype=  g_fillTypeManager:getFillTypeIndexByName(outputstring)
			--print("Input: "..tostring(input))
			--print("output: "..tostring(outputfilltype))
			
			local ratefactor= Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#rate"), 1) 
			local usebonus= Utils.getNoNil(getXMLBool(self.xmlFile, key.."#usebonus"), false) 
			
			
			if spec.millconvert[input] == nil then
				spec.millconvert[input] = {}
			end
			spec.millconvert[input].output= outputfilltype
			spec.millconvert[input].rate= ratefactor
			spec.millconvert[input].usebonus= usebonus
			
			for fillUnitIndex, _ in ipairs(self.spec_fillUnit.fillUnits) do
				local currentFillType = self:getFillUnitSupportedFillTypes(fillUnitIndex)
				for Filltypes, Filltypes2nd in pairs(currentFillType) do
					fillType=Filltypes
				--print("Filltypes: "..tostring(Filltypes))
				--print("Filltypes2nd: "..tostring(Filltypes2nd))
                        if fillType ~= nil then
							if spec.millconvert[fillType] == nil then
								spec.millconvert[fillType] = {}
							end
							if spec.millconvert[fillType].output== nil then
								spec.millconvert[fillType].output = fillType
								spec.millconvert[fillType].rate=1
								spec.millconvert[fillType].usebonus=false
							end
							
							if spec.millconvert[fillType].rate== nil then
								spec.millconvert[fillType].rate=1
							end
							if spec.millconvert[fillType].usebonus== nil then
								spec.millconvert[fillType].usebonus=false
							end
						end
				--print("Register Output for: "..tostring(fillType).."  and output is: "..tostring(spec.millconvert[fillType].output))
				end
			end			
            i=i+1
		end	
		
        local i=0
		while true do
            local key = string.format("vehicle.mill.millbonus(%d)", i)
            if not hasXMLProperty(self.xmlFile, key) then
                break
            end
			
			local bonusfuindex = getXMLInt(self.xmlFile, key.."#bonusfillunitIndex")
			local ratefactorbonus= Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#bonusrate"), 1) 
			local usage= Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#usage"), 1) 
			local inputstringb = getXMLString(self.xmlFile, key.."#fillType")
			local bonusfilltype= g_fillTypeManager:getFillTypeIndexByName(inputstringb)
			
				if bonusfuindex == nil then
					spec.millconvertbonus.use = false
				else
					spec.millconvertbonus.use = true
					spec.millconvertbonus.fillUnitIndex=bonusfuindex
					spec.millconvertbonus.bonusrate=ratefactorbonus
					spec.millconvertbonus.usage=usage/1000
					spec.millconvertbonus.fillType=bonusfilltype
				end
            i=i+1
		
		end	
		
		
		
   end
   
    spec.dirtyFlag = self:getNextDirtyFlag()

end



function Mill:dischargeToGround(superFunc,dischargeNode, emptyLiters)
    local spec = self.spec_Mill
	local endrate = 1
    local fillType = self:getDischargeFillType(dischargeNode)
    local fillLevel = self:getFillUnitFillLevel(dischargeNode.fillUnitIndex)
    local fillLevelBonus = Utils.getNoNil(self:getFillUnitFillLevel(spec.millconvertbonus.fillUnitIndex),0)
    local minLiterToDrop = g_densityMapHeightManager:getMinValidLiterValue(spec.millconvert[fillType].output)
	local Bonusused = false 
	
	if fillLevelBonus > 0 and spec.millconvertbonus.use and spec.millconvert[fillType].usebonus then 
		Bonusused =true 
		endrate = spec.millconvert[fillType].rate * spec.millconvertbonus.bonusrate
	else
		endrate = spec.millconvert[fillType].rate
	end
	
    local origlitersToDrop = math.min(dischargeNode.litersToDrop + (emptyLiters), math.max(dischargeNode.emptySpeed*250, minLiterToDrop))
    dischargeNode.litersToDrop = origlitersToDrop*endrate
    local minDropReached = dischargeNode.litersToDrop > minLiterToDrop
    local hasMinDropFillLevel = fillLevel > minLiterToDrop
    local info = dischargeNode.info
    local dischargedLiters = 0
    local sx,sy,sz = localToWorld(info.node, -info.width, 0, info.zOffset)
    local ex,ey,ez = localToWorld(info.node, info.width, 0, info.zOffset)
    sy = sy + info.yOffset
    ey = ey + info.yOffset
    if info.limitToGround then
        sy = math.max(getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, sx, 0, sz)+0.1, sy)
        ey = math.max(getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, ex, 0, ez)+0.1, ey)
    end
    local droppedorrig, lineOffset = DensityMapHeightUtil.tipToGroundAroundLine(self, dischargeNode.litersToDrop, spec.millconvert[fillType].output, sx,sy,sz, ex,ey,ez, info.length, nil, dischargeNode.lineOffset, true, nil, true)
	dropped= droppedorrig/endrate
    dischargeNode.lineOffset = lineOffset
    dischargeNode.litersToDrop = dischargeNode.litersToDrop - dropped
    if dropped > 0 then
			if Bonusused then
				dischargedLitersBonus = self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.millconvertbonus.fillUnitIndex, -(dropped*spec.millconvertbonus.usage), spec.millconvertbonus.fillType, ToolType.UNDEFINED)
			end
		
        local unloadInfo = self:getFillVolumeUnloadInfo(dischargeNode.unloadInfoIndex)
        dischargedLiters = self:addFillUnitFillLevel(self:getOwnerFarmId(), dischargeNode.fillUnitIndex, -(dropped), fillType, ToolType.UNDEFINED, unloadInfo)
    end
    fillLevel = self:getFillUnitFillLevel(dischargeNode.fillUnitIndex)
    if fillLevel > 0 and fillLevel <= minLiterToDrop then
        dischargeNode.litersToDrop = minLiterToDrop
    end
    return dischargedLiters, minDropReached, hasMinDropFillLevel
end

function Mill:dischargeToObject(superFunc,dischargeNode, emptyLiters, object, targetFillUnitIndex)
    local spec = self.spec_Mill
	local endrate = 1
    local fillType = self:getDischargeFillType(dischargeNode)
    local supportsFillType = object:getFillUnitSupportsFillType(targetFillUnitIndex, spec.millconvert[fillType].output)
    local fillLevelBonus = Utils.getNoNil(self:getFillUnitFillLevel(spec.millconvertbonus.fillUnitIndex),0)
    local dischargedLiters = 0
    if supportsFillType then
        local allowFillType = object:getFillUnitAllowsFillType(targetFillUnitIndex, spec.millconvert[fillType].output)
        if allowFillType then
				--print("fillLevelBonus: "..tostring(fillLevelBonus).." Use Bonus: "..tostring(spec.millconvertbonus.use).." EmptyLiters: "..tostring(emptyLiters))
				if fillLevelBonus > 0 and spec.millconvertbonus.use and spec.millconvert[fillType].usebonus then
					dischargedLitersBonus = self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.millconvertbonus.fillUnitIndex, -(emptyLiters*spec.millconvertbonus.usage), spec.millconvertbonus.fillType, ToolType.UNDEFINED)
					endrate = spec.millconvert[fillType].rate * spec.millconvertbonus.bonusrate
				else
					endrate = spec.millconvert[fillType].rate
				end
            dischargeNode.currentDischargeObject = object
            local delta = object:addFillUnitFillLevel(self:getActiveFarm(), targetFillUnitIndex, (emptyLiters*endrate), spec.millconvert[fillType].output, ToolType.DISCHARGEABLE, dischargeNode.info)
            local unloadInfo = self:getFillVolumeUnloadInfo(dischargeNode.unloadInfoIndex)
            dischargedLiters = self:addFillUnitFillLevel(self:getOwnerFarmId(), dischargeNode.fillUnitIndex, -emptyLiters, fillType, ToolType.UNDEFINED, unloadInfo)
        end
    end
    return dischargedLiters
end

function Mill:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local spec = self.spec_dischargeable
    local specm = self.spec_Mill
    local dischargeNode = spec.currentDischargeNode
    if dischargeNode ~= nil then
        if self.isClient then
            Dischargeable.updateActionEvents(self)
        end
        if self:getIsDischargeNodeActive(dischargeNode) then
            local trigger = dischargeNode.trigger
            if trigger.numObjects > 0 then
                dischargeNode.dischargeObject = nil
                dischargeNode.dischargeHitTerrain = false
                dischargeNode.dischargeShape = nil
                dischargeNode.dischargeDistance = 0
                dischargeNode.dischargeFillUnitIndex = nil
                dischargeNode.dischargeHit = false -- any (also unsupported) object hit
                local nearestDistance = math.huge
                for object, data in pairs(trigger.objects) do
                    local fillType = spec.forcedFillTypeIndex
                    if fillType == nil then
                        fillType = self:getDischargeFillType(dischargeNode)
                    end
					--print("Mill Script Line 175 fillType is : "..tostring(fillType).." forced is: "..tostring(spec.forcedFillTypeIndex))
                    dischargeNode.dischargeFailedReason = nil
                    dischargeNode.customNotAllowedWarning = nil
                    if object:getFillUnitSupportsFillType(data.fillUnitIndex, specm.millconvert[fillType].output) then
                        local allowFillType = object:getFillUnitAllowsFillType(data.fillUnitIndex, specm.millconvert[fillType].output)
                        local allowToolType = object:getFillUnitSupportsToolType(data.fillUnitIndex, ToolType.TRIGGER)
                        local freeSpace = object:getFillUnitFreeCapacity(data.fillUnitIndex, specm.millconvert[fillType].output, self:getActiveFarm()) > 0
						--print("Mill Script Line 181 allowFillType is : "..tostring(allowFillType).." allowToolType is : "..tostring(allowToolType).." freeSpace is : "..tostring(freeSpace))
                        if allowFillType and allowToolType and freeSpace then
                            local distance = calcDistanceFrom(dischargeNode.node, object:getFillUnitExactFillRootNode(data.fillUnitIndex))
                            if distance < nearestDistance then
                                dischargeNode.dischargeObject = object
                                dischargeNode.dischargeHitTerrain = false
                                dischargeNode.dischargeShape = data.shape
                                dischargeNode.dischargeDistance = distance
                                dischargeNode.dischargeFillUnitIndex = data.fillUnitIndex
                                nearestDistance = distance
                            end
                        elseif not allowFillType then
                            dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_FILLTYPE_NOT_SUPPORTED
                        elseif not allowToolType then
                            dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_TOOLTYPE_NOT_SUPPORTED
                        elseif not freeSpace then
                            dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_NO_FREE_CAPACITY
                        end
                    else
                        dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_FILLTYPE_NOT_SUPPORTED
                    end
                    if dischargeNode.dischargeFailedReason ~= nil then
                        if object.getCustomDischargeNotAllowedWarning ~= nil then
                            dischargeNode.customNotAllowedWarning = object:getCustomDischargeNotAllowedWarning()
                        end
                    end
                    dischargeNode.dischargeHit = true -- any (also unsupported) object has been hit
                end
            else
                if not spec.isAsyncRaycastActive then
                    self:updateRaycast(dischargeNode)
                end
            end
        else
            if spec.currentDischargeState ~= Dischargeable.DISCHARGE_STATE_OFF then
                self:setDischargeState(Dischargeable.DISCHARGE_STATE_OFF, true)
            end
        end
        self:updateDischargeSound(dischargeNode, dt)
        if self.isServer then
            if VehicleDebug.state == VehicleDebug.DEBUG then
                local info = dischargeNode.info
                local sx,sy,sz = localToWorld(info.node, -info.width, 0, info.zOffset)
                local ex,ey,ez = localToWorld(info.node, info.width, 0, info.zOffset)
                drawDebugLine(sx, sy+info.yOffset, sz, 1, 0, 0, ex, ey+info.yOffset, ez, 1, 0, 0)
            end
            if spec.currentDischargeState == Dischargeable.DISCHARGE_STATE_OFF then
                if dischargeNode.dischargeObject ~= nil then
                    self:handleFoundDischargeObject(dischargeNode)
                end
            else
                local fillLevel = self:getFillUnitFillLevel(dischargeNode.fillUnitIndex)
                local emptySpeed = self:getDischargeNodeEmptyFactor(dischargeNode)
                -- Only allow discharge into a node, or if the land is owned
                local canDischargeToObject = self:getCanDischargeToObject(dischargeNode) and spec.currentDischargeState == Dischargeable.DISCHARGE_STATE_OBJECT
                local canDischargeToGround = self:getCanDischargeToGround(dischargeNode) and spec.currentDischargeState == Dischargeable.DISCHARGE_STATE_GROUND
                local canDischarge = canDischargeToObject or canDischargeToGround
                local allowedToDischarge = dischargeNode.dischargeObject ~= nil or (self:getCanDischargeToLand(dischargeNode) and self:getCanDischargeAtPosition(dischargeNode))
                local isReadyToStartDischarge = fillLevel > 0.0001 and emptySpeed > 0 and allowedToDischarge and canDischarge
                self:setDischargeEffectActive(dischargeNode, isReadyToStartDischarge)
                self:setDischargeEffectDistance(dischargeNode, dischargeNode.dischargeDistance)
                local isReadyForDischarge = dischargeNode.lastEffect == nil or dischargeNode.lastEffect:getIsFullyVisible()
                if isReadyForDischarge and allowedToDischarge and canDischarge then
                    local emptyLiters = math.min(fillLevel, dischargeNode.emptySpeed * emptySpeed * dt)
                    local dischargedLiters, minDropReached, hasMinDropFillLevel = self:discharge(dischargeNode, emptyLiters)
                    spec.dischargedLiters = dischargedLiters
                    self:handleDischarge(dischargeNode, dischargedLiters, minDropReached, hasMinDropFillLevel)
                end
            end
            if dischargeNode.isEffectActive ~= dischargeNode.isEffectActiveSent or  math.abs(dischargeNode.dischargeDistanceSent - dischargeNode.dischargeDistance) > 0.05 then
                self:raiseDirtyFlags(spec.dirtyFlag)
                dischargeNode.dischargeDistanceSent = dischargeNode.dischargeDistance
                dischargeNode.isEffectActiveSent = dischargeNode.isEffectActive
            end
        end
    end
    if spec.currentDischargeState == Dischargeable.DISCHARGE_STATE_OFF then
        local currentDischargeNode = spec.currentDischargeNode
        if self:getIsActiveForInput() and self:getCanDischargeToObject(currentDischargeNode) and self:getCanToggleDischargeToObject() then
            g_currentMission:showTipContext(self:getFillUnitFillType(dischargeNode.fillUnitIndex))
        end
    end
    for _, dischargeNode in ipairs(spec.dischargeNodes) do
        if dischargeNode.stopEffectTime ~= nil and dischargeNode.stopEffectTime < g_time then
            self:setDischargeEffectActive(dischargeNode, false, true)
            dischargeNode.stopEffectTime = nil
        end
    end
end

function Mill:getCanDischargeAtPosition(superFunc,dischargeNode)
    local specm = self.spec_Mill
    if dischargeNode == nil then
        return false
    end
	local isTurnedOn = self:getIsTurnedOn()
	if not isTurnedOn then
		return false
	end
    if self:getFillUnitFillLevel(dischargeNode.fillUnitIndex) > 0 then
        local info = dischargeNode.info
        local sx,sy,sz = localToWorld(info.node, -info.width, 0, info.zOffset)
        local ex,ey,ez = localToWorld(info.node, info.width, 0, info.zOffset)
        -- check if at the ground position is still space for some more
        -- check this only if we wan't to discharge to the ground (farmland check is also done while discharging to objects)
        local spec = self.spec_dischargeable
        if spec.currentDischargeState == Dischargeable.DISCHARGE_STATE_OFF or spec.currentDischargeState == Dischargeable.DISCHARGE_STATE_GROUND then
            sy = sy + info.yOffset
            ey = ey + info.yOffset
            if info.limitToGround then
                sy = math.max(getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, sx, 0, sz)+0.1, sy)
                ey = math.max(getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, ex, 0, ez)+0.1, ey)
            end
            local fillType = self:getDischargeFillType(dischargeNode)
            local testDrop = g_densityMapHeightManager:getMinValidLiterValue(specm.millconvert[fillType].output)
            if not DensityMapHeightUtil.getCanTipToGroundAroundLine(self, testDrop, specm.millconvert[fillType].output, sx,sy,sz, ex,ey,ez, info.length, nil, dischargeNode.lineOffset, true, nil, true) then
                return false
            end
        end
    end
    return true
end

function Mill:getCanDischargeToGround(superFunc,dischargeNode)
    local spec = self.spec_Mill
    if dischargeNode == nil then
        return false
    end
	local isTurnedOn = self:getIsTurnedOn()
	if not isTurnedOn then
		return false
	end
    if not dischargeNode.dischargeHitTerrain then
        return false
    end
    if self:getFillUnitFillLevel(dischargeNode.fillUnitIndex) > 0 then
        local fillTypeIndex = self:getDischargeFillType(dischargeNode)
        if not DensityMapHeightUtil.getCanTipToGround(spec.millconvert[fillTypeIndex].output) then
            return false
        end
    end
    if not self:getCanDischargeToLand(dischargeNode) then
        return false
    end
    if not self:getCanDischargeAtPosition(dischargeNode) then
        return false
    end
    return true
end

function Mill:getCanDischargeToObject(superFunc,dischargeNode)
    local spec = self.spec_Mill
    if dischargeNode == nil then
        return false
    end
    local object = dischargeNode.dischargeObject
    if object == nil then
        return false
    end	

	local fillType = self:getDischargeFillType(dischargeNode)
	if g_fillTypeManager:getFillTypeNameByIndex(fillType)=="UNKNOWN" then
		fillType = self:getDischargeFillType(dischargeNode)
	else
		fillType = spec.millconvert[fillType].output
	end
	
	if not object:getFillUnitSupportsFillType(dischargeNode.dischargeFillUnitIndex, fillType) then
		return false
	end
	local allowFillType = object:getFillUnitAllowsFillType(dischargeNode.dischargeFillUnitIndex, fillType)
	if not allowFillType then
		return false
	end
	if object.getFillUnitFreeCapacity ~= nil and object:getFillUnitFreeCapacity(dischargeNode.dischargeFillUnitIndex, fillType, self:getActiveFarm()) <= 0 then
		return false
	end
    if object.getIsFillAllowedFromFarm ~= nil and not object:getIsFillAllowedFromFarm(self:getActiveFarm()) then
        return false
    end
    -- Adding should only be done if removing is allowed (generally adding is always allowed because it is beneficial to the receiver)
    -- A case where this is not allowed is when this is a pallet where the the controller does not own it (or can access it)
    if self.getMountObject ~= nil then
        local mounter = self:getDynamicMountObject() or self:getMountObject()
        if mounter ~= nil then
            -- if the active farm of the mounter has NO access to farmId fill unit: disallow
            if not g_currentMission.accessHandler:canFarmAccess(mounter:getActiveFarm(), self, true) then
                return false
            end
        end
    end
    return true
end


function Mill:updateNearestObjectInTriggers(superFunc)
    local specm = self.spec_Mill
    local spec = self.spec_pipe
    spec.nearestObjectInTriggers.objectId = nil
    spec.nearestObjectInTriggers.fillUnitIndex = 0
    local minDistance = math.huge
    local dischargeNode = self:getDischargeNodeByIndex(self:getPipeDischargeNodeIndex())
    if dischargeNode ~= nil then
        local checkNode = Utils.getNoNil(dischargeNode.node, self.components[1].node)
        for object, _ in pairs(spec.objectsInTriggers) do
			local outputFillType = self:getFillUnitLastValidFillType(dischargeNode.fillUnitIndex)
			if specm.millconvert[self:getFillUnitLastValidFillType(dischargeNode.fillUnitIndex)] == nil then
			else
				outputFillType = specm.millconvert[self:getFillUnitLastValidFillType(dischargeNode.fillUnitIndex)].output
			end
            for fillUnitIndex, _ in ipairs(object.spec_fillUnit.fillUnits) do
                local allowedToFillByPipe = object:getFillUnitSupportsToolType(fillUnitIndex, ToolType.DISCHARGEABLE)
                local supportsFillType = object:getFillUnitSupportsFillType(fillUnitIndex, outputFillType) or outputFillType == FillType.UNKNOWN
                local fillLevel = object:getFillUnitFreeCapacity(fillUnitIndex, outputFillType, self:getOwnerFarmId())
                if allowedToFillByPipe and supportsFillType and fillLevel > 0 then
                    local targetPoint = object:getFillUnitAutoAimTargetNode(fillUnitIndex)
                    local exactFillRootNode = object:getFillUnitExactFillRootNode(fillUnitIndex)
                    if targetPoint == nil then
                        targetPoint = exactFillRootNode
                    end
                    if targetPoint ~= nil then
                        local distance = calcDistanceFrom(checkNode, targetPoint)
                        if distance < minDistance then
                            minDistance = distance
                            spec.nearestObjectInTriggers.objectId = NetworkUtil.getObjectId(object)
                            spec.nearestObjectInTriggers.fillUnitIndex = fillUnitIndex
                            break
                        end
                    end
                end
            end
        end
    else
        g_logManager:xmlWarning(self.configFileName, "Unable to find discharge node index '%d' for Pipe", self:getPipeDischargeNodeIndex())
    end
end

function Mill:handleDischargeRaycast(superFunc, dischargeNode, hitObject, hitShape, hitDistance, hitFillUnitIndex, hitTerrain)
    local specm = self.spec_Mill
    local stopDischarge = false
    if hitObject ~= nil then
        local fillType = specm.millconvert[self:getDischargeFillType(dischargeNode)].output
        local allowFillType = hitObject:getFillUnitAllowsFillType(hitFillUnitIndex, fillType)
        if allowFillType and hitObject:getFillUnitFreeCapacity(hitFillUnitIndex, fillType, self:getOwnerFarmId()) > 0 then
		-- check if is turned On. If not display warning
			local isTurnedOn = self:getIsTurnedOn()
			if not isTurnedOn then
				g_currentMission:showBlinkingWarning(g_i18n.modEnvironments[Mill.ModName].texts.Warningturnon, 500)
				stopDischarge = true
			else		
				self:setDischargeState(Dischargeable.DISCHARGE_STATE_OBJECT, true)
			end
        else
            stopDischarge = true
        end
    else
        stopDischarge = true
    end
    if stopDischarge and self:getDischargeState() == Dischargeable.DISCHARGE_STATE_OBJECT then
        self:setDischargeState(Dischargeable.DISCHARGE_STATE_OFF, true)
    end
end

function Mill:onDischargeStateChanged(superFunc,state)
    local specm = self.spec_Mill
    if self.isClient then
        local spec = self.spec_pipe
        local dischargeNode = self:getCurrentDischargeNode()
        local dischargeNodeIndex = nil
        if dischargeNode ~= nil then
            dischargeNodeIndex = dischargeNode.index
        end
        if dischargeNodeIndex == spec.dischargeNodeIndex then
            if state == Dischargeable.DISCHARGE_STATE_OFF then
                g_animationManager:stopAnimations(spec.animationNodes)
            else
                g_animationManager:startAnimations(spec.animationNodes)
                g_animationManager:setFillType(spec.animationNodes, specm.millconvert[self:getFillUnitLastValidFillType(dischargeNode.fillUnitIndex)].output)
            end
        end
    end
end

function Mill:setDischargeEffectActive(superFunc,dischargeNode, isActive, force)
    if isActive then
		local specm = self.spec_Mill
        if not dischargeNode.isEffectActive then
            g_effectManager:setFillType(dischargeNode.effects, specm.millconvert[self:getFillUnitLastValidFillType(dischargeNode.fillUnitIndex)].output)
            g_effectManager:startEffects(dischargeNode.effects)
            dischargeNode.isEffectActive = true
        end
        dischargeNode.stopEffectTime = nil
    else
        if force == nil or not force then
            if dischargeNode.stopEffectTime == nil then
                dischargeNode.stopEffectTime = g_time + 500
            end
        else
            if dischargeNode.isEffectActive then
                g_effectManager:stopEffects(dischargeNode.effects)
                dischargeNode.isEffectActive = false
            end
        end
    end
end

function Mill:raycastCallbackDischargeNode(superFunc,hitActorId, x, y, z, distance, nx, ny, nz, subShapeIndex, hitShapeId)
    if hitActorId ~= nil then
		local specm = self.spec_Mill
        local spec = self.spec_dischargeable
        local dischargeNode = spec.currentRaycastDischargeNode
        local object = g_currentMission:getNodeObject(hitActorId)
        distance = distance - dischargeNode.raycast.yOffset
        if VehicleDebug.state == VehicleDebug.DEBUG then
            DebugUtil.drawDebugGizmoAtWorldPos(x,y,z, 0, 0, 1, 0, 1, 0, nil)
        end
        local validObject = object ~= nil and object ~= self
        -- if we hit a object because of the yOffset it has to be a exact fill root node, otherwise we ignore it
        -- is used to get exactFillRootNodes if the dischargeNode of the shovel is already below it
        if validObject and distance < 0 then
            if object.getFillUnitIndexFromNode ~= nil then
                validObject = validObject and object:getFillUnitIndexFromNode(hitShapeId) ~= nil
            end
        end
        if validObject then
            if object.getFillUnitIndexFromNode ~= nil then
                local fillUnitIndex = object:getFillUnitIndexFromNode(hitShapeId)
                if fillUnitIndex ~= nil then
                    local fillType = spec.forcedFillTypeIndex
                    if fillType == nil then
						if g_fillTypeManager:getFillTypeNameByIndex(self:getDischargeFillType(dischargeNode))=="UNKNOWN" then
							fillType = self:getDischargeFillType(dischargeNode)
						else
							fillType = specm.millconvert[self:getDischargeFillType(dischargeNode)].output
						end
                    end
                    dischargeNode.dischargeFailedReason = nil
                    dischargeNode.customNotAllowedWarning = nil
                    if object:getFillUnitSupportsFillType(fillUnitIndex, fillType) then
                        local allowFillType = object:getFillUnitAllowsFillType(fillUnitIndex, fillType)
                        local allowToolType = object:getFillUnitSupportsToolType(fillUnitIndex, ToolType.DISCHARGEABLE)
                        local freeSpace = object:getFillUnitFreeCapacity(fillUnitIndex, fillType, self:getActiveFarm()) > 0
                        if allowFillType and allowToolType and freeSpace then
                            dischargeNode.dischargeObject = object
                            dischargeNode.dischargeShape = hitShapeId
                            dischargeNode.dischargeDistance = distance
                            dischargeNode.dischargeFillUnitIndex = fillUnitIndex
                            if object.getFillUnitExtraDistanceFromNode ~= nil then
                                dischargeNode.dischargeExtraDistance = object:getFillUnitExtraDistanceFromNode(hitShapeId)
                            end
                        elseif not allowFillType then
                            dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_FILLTYPE_NOT_SUPPORTED
                        elseif not allowToolType then
                            dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_TOOLTYPE_NOT_SUPPORTED
                        elseif not freeSpace then
                            dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_NO_FREE_CAPACITY
                        end
                    else
                        dischargeNode.dischargeFailedReason = Dischargeable.DISCHARGE_REASON_FILLTYPE_NOT_SUPPORTED
                    end
                    if dischargeNode.dischargeFailedReason ~= nil then
                        if object.getCustomDischargeNotAllowedWarning ~= nil then
                            dischargeNode.customNotAllowedWarning = object:getCustomDischargeNotAllowedWarning()
                        end
                    end
                    dischargeNode.dischargeHit = true -- any, even unsupported, object has been hit.
                else
                    -- raycast until we hit the object underneath the exact fill root node
                    dischargeNode.dischargeDistance = distance + (dischargeNode.dischargeExtraDistance or 0)
                    dischargeNode.dischargeExtraDistance = nil
                    self:updateDischargeInfo(dischargeNode, x, y, z)
                    return false
                end
            end
        elseif hitActorId == g_currentMission.terrainRootNode then
            dischargeNode.dischargeDistance = math.min(dischargeNode.dischargeDistance, distance)
            dischargeNode.dischargeHitTerrain = true
            self:updateDischargeInfo(dischargeNode, x, y, z)
            return false
        end
        return true
    else
        self:finishDischargeRaycast()
    end
end