-- MixerWagon hud display when on foot or in a vehicle
-- put together by alfalfa6945
-- December 28/2018
-- version 0.1.0.1 
-- use for Mixerwagonconf edit by DerElky

mixerDisplayMill = {}


function mixerDisplayMill:loadMap(name)
	if g_currentMission.millmixerWagons == nil then
		g_currentMission.millmixerWagons = {}
	end
	if not mixerDisplayMill:isDedicatedServer() then
		local uiScale = g_gameSettings:getValue("uiScale")
		mixerDisplayMill.mixerWagonFillLevelTextOffsetX, mixerDisplayMill.mixerWagonFillLevelTextOffsetY = getNormalizedScreenValues(28 * uiScale, 7 * uiScale)
		_, mixerDisplayMill.mixerWagonHelpHeightPerFruit = getNormalizedScreenValues(0, 22 * uiScale)
		_, mixerDisplayMill.mixerWagonHelpHeightOffset = getNormalizedScreenValues(0, 10 * uiScale)
		mixerDisplayMill.width, mixerDisplayMill.height = getNormalizedScreenValues(7 * uiScale, 12 * uiScale)
		local hudWidth, hudHeight = getNormalizedScreenValues(870*uiScale, 15*uiScale)
		mixerDisplayMill.posX = hudWidth
		mixerDisplayMill.posX2 = hudWidth * 1.35
		mixerDisplayMill.textSize = hudHeight
		mixerDisplayMill.nameWidthOffset = 0
		mixerDisplayMill:loadXMLvalue()
	end
end

function mixerDisplayMill:deleteMap()
end

function mixerDisplayMill:mouseEvent(posX, posY, isDown, isUp, button)
end

function mixerDisplayMill:keyEvent(unicode, sym, modifier, isDown)
end

function mixerDisplayMill:update(dt)
end

function mixerDisplayMill:draw()
	if mixerDisplayMill:isDedicatedServer() then
		return
	end
	local mixerWagon = mixerDisplayMill.getNearestVehicle()
	if mixerWagon and mixerWagon.spec_MixerWagonconf then
		if mixerWagon.spec_attachable and mixerWagon.spec_attachable.attacherVehicle then
			if mixerWagon.spec_attachable.attacherVehicle:getIsControlled() then
				return
			end
		end
		if mixerWagon.spec_enterable then
			if mixerWagon.spec_enterable.isEntered then
				return
			end
		end
		local numFillTypes = #mixerWagon.spec_MixerWagonconf.mixerWagonFillTypes
		if numFillTypes > 0 then
			local helpHeight = (numFillTypes + 1) * mixerDisplayMill.mixerWagonHelpHeightPerFruit + mixerDisplayMill.mixerWagonHelpHeightOffset
			mixerDisplayMill:createMixerHud(mixerWagon, helpHeight)
		end
	end
end

function mixerDisplayMill:loadXMLvalue()
	local path = getUserProfileAppPath()
	local file, xmlFile = path.."modsSettings/mixerDisplayMillConfig.xml"
	if fileExists(file) then
		xmlFile = loadXMLFile("mixerDisplayMillXML", file, "mixerDisplayMill")
	else
		xmlFile = createXMLFile("mixerDisplayMillXML", file, "mixerDisplayMill")
		setXMLInt(xmlFile, "mixerDisplayMill.displayDistance", 7)
		setXMLString(xmlFile, "mixerDisplayMill.statusBarColorGood", "0.3763 0.6038 0.0782 1")
		setXMLString(xmlFile, "mixerDisplayMill.statusBarColorBad", "0.8069 0.0097 0.0097 1")
		setXMLString(xmlFile, "mixerDisplayMill.fillLevelStatusBarColor", "0.991 0.3865 0.01 1")
		setXMLString(xmlFile, "mixerDisplayMill.iconColor", "0.6307 0.6307 0.6307 1")
		setXMLString(xmlFile, "mixerDisplayMill.textColor", "0.8 0.8 0.8 0.5")
		setXMLBool(xmlFile, "mixerDisplayMill.backgroundOverlay.useBackgroundOverlay", true)
		setXMLBool(xmlFile, "mixerDisplayMill.useFillTypeNames", true)
		saveXMLFile(xmlFile)
	end
	if xmlFile then
		mixerDisplayMill.distance = getXMLInt(xmlFile, "mixerDisplayMill.displayDistance")
		mixerDisplayMill.statusBarColor = ConfigurationUtil.getColorFromString(getXMLString(xmlFile, "mixerDisplayMill.statusBarColorGood"))
		mixerDisplayMill.statusBarColor2 = ConfigurationUtil.getColorFromString(getXMLString(xmlFile, "mixerDisplayMill.statusBarColorBad"))
		mixerDisplayMill.fillLevelStatusBarColor = ConfigurationUtil.getColorFromString(getXMLString(xmlFile, "mixerDisplayMill.fillLevelStatusBarColor"))
		mixerDisplayMill.iconColor = ConfigurationUtil.getColorFromString(getXMLString(xmlFile, "mixerDisplayMill.iconColor"))
		mixerDisplayMill.textColor = ConfigurationUtil.getColorFromString(getXMLString(xmlFile, "mixerDisplayMill.textColor"))
		mixerDisplayMill.useBackgroundOverlay = getXMLBool(xmlFile, "mixerDisplayMill.backgroundOverlay.useBackgroundOverlay")
		mixerDisplayMill.mixerWagonFillRangeMarkerOverlay = Overlay:new(g_baseUIFilename, 0, 0, mixerDisplayMill.width, mixerDisplayMill.height)
		mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:setAlignment(Overlay.ALIGN_VERTICAL_MIDDLE, Overlay.ALIGN_HORIZONTAL_LEFT)
		mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:setUVs(getNormalizedUVs({880, 395, 18, 25}))
		mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:setColor(unpack(mixerDisplayMill.iconColor))
		mixerDisplayMill.useBackgroundOverlay = getXMLBool(xmlFile, "mixerDisplayMill.backgroundOverlay.useBackgroundOverlay")
		mixerDisplayMill.useFillTypeNames = Utils.getNoNil(getXMLBool(xmlFile, "mixerDisplayMill.useFillTypeNames"),true)
		if mixerDisplayMill.useBackgroundOverlay then
			mixerDisplayMill.hudOverlay = Overlay:new("dataS2/menu/blank.dds", 0, 0, mixerDisplayMill.width, mixerDisplayMill.height)
			mixerDisplayMill.hudFrameElement = HUDFrameElement:new("dataS2/menu/hud/hud_elements_1080p.png", 0, 0, mixerDisplayMill.width, mixerDisplayMill.height)
			mixerDisplayMill.hudFrameElement:setColor(unpack(HUD.COLOR.FRAME_BACKGROUND))
		end
		delete(xmlFile)
	end
end

function mixerDisplayMill.getNearestVehicle()
	for _, vehicle in pairs(g_currentMission.vehicles) do
		if vehicle.spec_MixerWagonconf then
			local distanceToVehicle = calcDistanceFrom(vehicle.rootNode, getCamera())
			if distanceToVehicle < mixerDisplayMill.distance then
				local insertVehicle = true
				for _, rootNode in pairs(g_currentMission.millmixerWagons) do
					if vehicle.rootNode == rootNode then
						insertVehicle = false
					end
				end
				if insertVehicle then
					mixerDisplayMill.setFillTypeOverlays(vehicle)
					table.insert(g_currentMission.millmixerWagons, vehicle.rootNode)
				end
				return vehicle
			end
		end
	end
	return
end

function mixerDisplayMill.setFillTypeOverlays(mixerWagon)
	local uiScale = g_gameSettings:getValue("uiScale")
	local width, height = getNormalizedScreenValues(20 * uiScale, 20 * uiScale)
	if mixerWagon.fillTypeOverlays == nil then
		mixerWagon.fillTypeOverlays = {}
	end
	if mixerWagon.nameOffset == nil then
		mixerWagon.nameOffset = {}
	end
	if mixerWagon.spec_MixerWagonconf ~= nil and mixerWagon.spec_fillUnit ~= nil then
		local primaryFillType
		if mixerWagon.spec_MixerWagonconf.mixedFillType ~= nil then
			primaryFillType = g_fillTypeManager.fillTypes[mixerWagon.spec_MixerWagonconf.mixedFillType]
		else
			primaryFillType = g_fillTypeManager.fillTypes[mixerWagon.spec_MixerWagonconf.outputfillType]
		end
		local forageFillType = g_fillTypeManager.fillTypes[mixerWagon.spec_MixerWagonconf.mixingfillType]
		local tempTable = {}
		for _, fillType in pairs(mixerWagon.spec_MixerWagonconf.mixerWagonFillTypes) do
			table.insert(tempTable, fillType)
			if mixerDisplayMill.useFillTypeNames then
				local typeDesc = g_fillTypeManager:getFillTypeByName(fillType.name)
				table.insert(mixerWagon.nameOffset, string.len(typeDesc.title))
			end
		end
		for _, fillType in pairs({primaryFillType, forageFillType}) do
			table.insert(tempTable, fillType)
		end
		for _, mixerWagonFillType in ipairs(tempTable) do
			if mixerWagonFillType.name == "dryGrass" then
				mixerWagonFillType.name = "dryGrass_windrow"
			end
			local fillTypeDesc = g_fillTypeManager:getFillTypeByName(mixerWagonFillType.name)
			local entry = {}
			if fillTypeDesc ~= nil then
				entry.title = fillTypeDesc.title
				entry.name = fillTypeDesc.name
				entry.index = fillTypeDesc.index
				entry.overlay = Overlay:new(fillTypeDesc.hudOverlayFilenameSmall, 0, 0, width, height)
				entry.hudListElement = HUDElement:new(entry.overlay)
				entry.overlay:setColor(unpack(mixerDisplayMill.iconColor))
			end
			if entry.overlay ~= nil then
				local width, height = getNormalizedScreenValues(208 * uiScale, 8 * uiScale)
				if mixerWagon.spec_MixerWagonconf.fillTypeToMixerWagonFillType[entry.index] ~= nil then
					entry.statusBarColor = mixerDisplayMill.statusBarColor
					entry.statusBarColor2 = mixerDisplayMill.statusBarColor2
					entry.fillLevelStatusBarColor = mixerDisplayMill.fillLevelStatusBarColor
					entry.statusBar = StatusBar:new(g_baseUIFilename, g_colorBgUVs, nil, mixerDisplayMill.textColor, entry.statusBarColor2, nil, 0, 0, width, height)
				else
					entry.fillLevelStatusBarColor = mixerDisplayMill.fillLevelStatusBarColor
					entry.statusBar = StatusBar:new(g_baseUIFilename, g_colorBgUVs, nil, mixerDisplayMill.textColor, entry.fillLevelStatusBarColor, nil, 0, 0, width, height)
				end
			end
			table.insert(mixerWagon.fillTypeOverlays, entry)
		end
	end
	if mixerDisplayMill.useFillTypeNames then
		table.sort(mixerWagon.nameOffset)
		mixerWagon.nameWidthOffset, _ = getNormalizedScreenValues((mixerWagon.nameOffset[#mixerWagon.nameOffset] * mixerWagon.nameOffset[#mixerWagon.nameOffset]) * (1.25 * uiScale), uiScale)
	else
		mixerWagon.nameWidthOffset = mixerDisplayMill.nameWidthOffset
	end
end

function mixerDisplayMill:createMixerHud(mixerWagon, posY)
	local fillLevelPosY = posY
	setTextColor(unpack(mixerDisplayMill.textColor))
    posY = posY - mixerDisplayMill.mixerWagonHelpHeightPerFruit
    setTextBold(true)
	renderText(mixerDisplayMill.posX, posY + (mixerDisplayMill.mixerWagonHelpHeightPerFruit - mixerDisplayMill.textSize) * 0.5, mixerDisplayMill.textSize, g_i18n:getText("info_mixingRatio"))
    setTextBold(false)
    local totalFillLevel = 0
	if mixerWagon:getFillUnitFillLevel(mixerWagon.spec_MixerWagonconf.fillUnitIndex) > 0 then
		for _, mixerWagonFillType in pairs(mixerWagon.spec_MixerWagonconf.mixerWagonFillTypes) do
			if mixerWagonFillType.fillLevel ~= nil then
				totalFillLevel = totalFillLevel + mixerWagonFillType.fillLevel
			end
        end
    end
	if mixerDisplayMill.useBackgroundOverlay then
		mixerDisplayMill.hudFrameElement:setPosition(mixerDisplayMill.posX * 0.995, posY - (#mixerWagon.spec_MixerWagonconf.mixerWagonFillTypes * mixerDisplayMill.mixerWagonHelpHeightPerFruit) - (mixerDisplayMill.mixerWagonFillLevelTextOffsetY / 2))
		if totalFillLevel > 0 then
			mixerDisplayMill.hudFrameElement:setDimension(mixerDisplayMill.posX / 2.8 + mixerWagon.nameWidthOffset, (#mixerWagon.spec_MixerWagonconf.mixerWagonFillTypes + 2) * mixerDisplayMill.mixerWagonHelpHeightPerFruit + (mixerDisplayMill.mixerWagonFillLevelTextOffsetY / 2))
		else
			mixerDisplayMill.hudFrameElement:setDimension(mixerDisplayMill.posX / 2.8 + mixerWagon.nameWidthOffset, (#mixerWagon.spec_MixerWagonconf.mixerWagonFillTypes + 1) * mixerDisplayMill.mixerWagonHelpHeightPerFruit + (mixerDisplayMill.mixerWagonFillLevelTextOffsetY / 2))
		end
		mixerDisplayMill.hudFrameElement:draw()
	end
	local mixerWagonFillType = mixerWagon.spec_MixerWagonconf.fillTypeToMixerWagonFillType
	for _, fillType in pairs(mixerWagon.fillTypeOverlays) do
		if mixerWagonFillType[fillType.index] ~= nil then
			posY = posY - mixerDisplayMill.mixerWagonHelpHeightPerFruit
			local percentage = 0
			if mixerWagon:getFillUnitFillLevel(mixerWagon.spec_MixerWagonconf.fillUnitIndex) > 0 then
				percentage = mixerWagonFillType[fillType.index].fillLevel / totalFillLevel
			end
			if mixerWagonFillType[fillType.index].fillLevel > 0 then
				if mixerWagon:getFillUnitFillType(mixerWagon.spec_MixerWagonconf.fillUnitIndex) ~= g_fillTypeManager.nameToFillType["FORAGE_MIXING"].index or (percentage >= mixerWagonFillType[fillType.index].minPercentage and percentage <= mixerWagonFillType[fillType.index].maxPercentage) then
					fillType.statusBar:setColor(unpack(fillType.statusBarColor))
				else
					fillType.statusBar:setColor(unpack(fillType.statusBarColor2))
				end
			end
			fillType.statusBar:setPosition((mixerDisplayMill.posX2 - fillType.statusBar.width) + mixerWagon.nameWidthOffset, posY + (mixerDisplayMill.mixerWagonHelpHeightPerFruit - fillType.statusBar.height) * 0.5)
			fillType.statusBar:setValue(percentage)
			fillType.statusBar:render()
			if fillType.overlay ~= nil then
				fillType.overlay:setPosition(mixerDisplayMill.posX, posY + (mixerDisplayMill.mixerWagonHelpHeightPerFruit - fillType.overlay.height) * 0.5)
				fillType.overlay:render()
			end
			setTextAlignment(RenderText.ALIGN_LEFT)
			if mixerDisplayMill.useFillTypeNames then
				renderText(mixerDisplayMill.posX + mixerDisplayMill.mixerWagonFillLevelTextOffsetX, posY + mixerDisplayMill.mixerWagonFillLevelTextOffsetY, mixerDisplayMill.textSize, fillType.title)
			end
			renderText(mixerDisplayMill.posX + mixerDisplayMill.mixerWagonFillLevelTextOffsetX + mixerWagon.nameWidthOffset, posY + mixerDisplayMill.mixerWagonFillLevelTextOffsetY, mixerDisplayMill.textSize, string.format("%1.2f%%", percentage * 100))
			local y = fillType.statusBar.y + fillType.statusBar.height * 0.5
			local maxLeft = fillType.statusBar.x + fillType.statusBar.width
			local xLeft =  math.min(fillType.statusBar.x + fillType.statusBar.width * mixerWagonFillType[fillType.index].minPercentage, maxLeft)
			local xRight = math.min(fillType.statusBar.x + fillType.statusBar.width * mixerWagonFillType[fillType.index].maxPercentage, maxLeft)
			mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:setInvertX(false)
			mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:setPosition(xLeft, y)
			mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:render()
			mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:setInvertX(true)
			mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:setPosition(xRight - mixerDisplayMill.mixerWagonFillRangeMarkerOverlay.width, y)
			mixerDisplayMill.mixerWagonFillRangeMarkerOverlay:render()
		end
		local fillUnit = mixerWagon.spec_fillUnit.fillUnits[mixerWagon.spec_MixerWagonconf.fillUnitIndex]
		if fillUnit.fillType ~= nil and fillUnit.fillType == fillType.index then
			local fillLevelPercentage = fillUnit.fillLevel / fillUnit.capacity
			if fillUnit.fillLevel > 0 then
				fillType.statusBar:setColor(unpack(fillType.fillLevelStatusBarColor))
			end
			fillType.statusBar:setPosition(mixerDisplayMill.posX2 - fillType.statusBar.width, fillLevelPosY + (mixerDisplayMill.mixerWagonHelpHeightPerFruit - fillType.statusBar.height) * 0.5)
			fillType.statusBar:setValue(fillLevelPercentage)
			fillType.statusBar:render()
			if fillType.hudListElement ~= nil then
				fillType.hudListElement:setPosition(mixerDisplayMill.posX, fillLevelPosY + (mixerDisplayMill.mixerWagonHelpHeightPerFruit - fillType.overlay.height) * 0.5)
				fillType.hudListElement:draw()
			end
			renderText(mixerDisplayMill.posX + mixerDisplayMill.mixerWagonFillLevelTextOffsetX, fillLevelPosY + mixerDisplayMill.mixerWagonFillLevelTextOffsetY, mixerDisplayMill.textSize, string.format("%.2f", fillUnit.fillLevel))
		end
	end
end

function mixerDisplayMill:isDedicatedServer()
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then
		return true
	end
	return
end

addModEventListener(mixerDisplayMill)