----------------------------------------------------------------------------------------------------
-- SeasonsAvailabilityCheck
----------------------------------------------------------------------------------------------------
-- Purpose:  Removes Seasons-dependend store items from the store if Seasons is not available.
--
-- Copyright (c) Realismus Modding, 2019
----------------------------------------------------------------------------------------------------

local modDirectory = g_currentModDirectory

-- Active test: needed for console version where the code is always sourced.
function isActive()
    if GS_IS_CONSOLE_VERSION and not g_isDevelopmentConsoleScriptModTesting then
        return g_modIsLoaded["FS19_ManTGS_WinterService_console"]
    end

    -- Normally this code never runs if Seasons was not active. However, in development mode
    -- this might not always hold true.
    return g_modIsLoaded["FS19_ManTGS_WinterService"]
end

function isSeasonsActive()
    -- Might not be set at this point
    if g_seasons ~= nil then
        return true
    end

    if GS_IS_CONSOLE_VERSION then
        return g_modIsLoaded["FS19_RM_Seasons_console"]
    end

    return g_modIsLoaded["FS19_RM_Seasons"]
end

function ignoreSaltStoreItems(self, superFunc, xmlFilename, baseDir, ...)
    -- Do not load the salt sprayer
    if isActive() and not isSeasonsActive() and baseDir == modDirectory and xmlFilename == "tgs18500.xml" then
        log("Warning: Seasons is missing. Hauer salt gritter will be removed from the store.")
        return nil
    end

    return superFunc(self, xmlFilename, baseDir, ...)
end

StoreManager.loadItem = Utils.overwrittenFunction(StoreManager.loadItem, ignoreSaltStoreItems)
