--[[

Game:	Farming Simulator 19
Title:  LimitBreak
Script: Main
Author: ThundR

This work is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/4.0/

--]]

-- [Declarations] ***********************************************************************************************************************************

LimitBreak = {}
getfenv(0).FillTypeManager.SEND_NUM_BITS = 10 -- translates to 1024

-- [Local Functions] ********************************************************************************************************************************

-- pack2 ------------------------------------------------------------------------------------------
local function pack2(...)
-- upgraded version of default pack function
	-- [...]: values to pack

	return {n = select("#", ...), ...}
end

-- unpack2 ----------------------------------------------------------------------------------------
local function unpack2(tbl, index)
-- upgraded version of default unpack function
-- to be used only with pack2
	-- [tbl]: 	table to unpack
	-- [index]: index to start >> optional

	index = Utils.getNoNil(index, 1)

	local numEntries = tbl.n
	if index <= numEntries then
		return unpack(tbl, index, numEntries)
	end
end

-- [Function Overrides] *****************************************************************************************************************************

-- hook_addFillType -------------------------------------------------------------------------------
function LimitBreak:hook_addFillType(superFunc, fillTypeName, ...)
-- called from FillTypeManager.addFillType()

	local fillTypeInfo_orig -- original fillType table placeholder
	local doLimitBreak = false

	-- save original tables
	local fillTypes_orig = self.fillTypes
	local indexToName_orig = self.indexToName
	local nameToIndex_orig = self.nameToIndex
	local nameToFillType_orig = self.nameToFillType

	if type(fillTypeName) == "string" then
		fillTypeInfo_orig = self:getFillTypeByName(fillTypeName)
	end

	if #self.fillTypes >= 256 and not fillTypeInfo_orig then
		-- clear original tables
		self.fillTypes = {}
		self.indexToName = {}
		self.nameToIndex = {}
		self.nameToFillType = {}

		doLimitBreak = true
	end

	local ret = pack2(superFunc(self, fillTypeName, ...))
	local fillTypeInfo = ret[1]

	if doLimitBreak then
		-- restore original tables
		self.fillTypes = fillTypes_orig
		self.indexToName = indexToName_orig
		self.nameToIndex = nameToIndex_orig
		self.nameToFillType = nameToFillType_orig

		if fillTypeInfo then -- a fillType was added
			table.insert(self.fillTypes, fillTypeInfo)
			fillTypeInfo.index = #self.fillTypes

			self.indexToName[fillTypeInfo.index] = fillTypeInfo.name
			self.nameToIndex[fillTypeInfo.name] = fillTypeInfo.index
			self.nameToFillType[fillTypeInfo.name] = fillTypeInfo
			getfenv(0).FillType = self.nameToIndex
		end
	end

	return unpack2(ret)
end
FillTypeManager.addFillType = Utils.overwrittenFunction(FillTypeManager.addFillType, LimitBreak.hook_addFillType)

--[[ Not finished...
-- hook_addBaleType
function LimitBreak:hook_addBaleType(superFunc, filename, fillTypeName, isRoundBale, width, height, length, diameter, ...)
-- called from BaleTypeManager.addBaleType

	local doLimitBreak = false
	local baleKey = nil

	-- save original tables
	local squareBales_orig 	= self.squareBales
	local roundBales_orig 	= self.roundBales
	local nameToIndex_orig 	= self.nameToIndex
	local baleTypes_orig	= self.baleTypes

	if g_cxtension == nil then
		if #self.baleTypes >= 64 then
			baleKey = self.getBaleKey(fillTypeName, isRoundBale, width, height, length, diameter)
			if baleKey and not self.nameToBaleType[baleKey] then
				-- clear original tables
				self.squareBales = {}
				self.roundBales = {}
				self.nameToIndex = {}
				self.baleTypes = {}

				doLimitBreak = true
			end
		end
	end

	local ret = LimitBreak:pack(superFunc(self, filename, fillTypeName, isRoundBale, width, height, length, diameter, ...))
	local baleInfo = ret[1]

	if doLimitBreak then
		-- restore original tables
		self.squareBales = squareBales_orig
		self.roundBales  = roundBales_orig
		self.nameToIndex = nameToIndex_orig
		self.baleTypes	 = baleTypes_orig

		if baleInfo then -- a baleType was added
			table.insert(self.baleTypes, baleInfo)
			baleInfo.index = #self.baleTypes

			if isRoundBale == true then
				table.insert(self.roundBales, baleInfo)
			else
				table.insert(self.squareBales, baleInfo)
			end

			self.nameToIndex[baleKey] = baleInfo.index
			getfenv(0).BaleType = self.nameToIndex
		end
	end

	return LimitBreak:unpack(ret)
end
BaleTypeManager.addBaleType = Utils.overwrittenFunction(BaleTypeManager.addBaleType, LimitBreak.hook_addBaleType)
--]]