--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 06.03.2019

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 06.03.2019 - FS19 Release Version

Important:
Free for use in other mods - no permission needed.
No changes are to be made to this script without permission from GtX | Andy

Frei verwendbar - keine erlaubnis nötig
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden

** PLACEABLE ONLY! **
]]


Letterbox = {}
Letterbox.modName = g_currentModName
Letterbox.modDir = g_currentModDirectory

Letterbox.prefix = {
    "  INFO: [" .. Letterbox.modName .. "] - ",
    "  WARNING: [" .. Letterbox.modName .. "] - ",
    "  ERROR: [" .. Letterbox.modName .. "] - ",
    "  LOAD ERROR: [" .. Letterbox.modName .. "] - "
}

function Letterbox.loadPlaceable()
    local placeablePath = Letterbox.modDir .. "scripts/LetterboxPlaceable.lua"
    if fileExists(placeablePath) then
        g_placeableTypeManager:addPlaceableType("LetterboxPlaceable", "LetterboxPlaceable", placeablePath)

        source(Utils.getFilename("scripts/LetterboxEvent.lua", Letterbox.modDir))

        if g_gui ~= nil and g_gui.guis.LetterboxGui == nil then
            source(Utils.getFilename("scripts/LetterboxGui.lua", Letterbox.modDir))
            local letterBoxDialog = LetterboxGui:new(nil, nil)
            g_gui:loadGui(Letterbox.modDir .. "scripts/LetterboxGui.xml", "LetterboxGui", letterBoxDialog)
        end
    else
        local path = Letterbox.modDir .. "scripts/"
        Letterbox.logPrint(1, "Failed not load! LetterboxPlaceable.lua was not found at %s ", path)
    end
end

function Letterbox.getText(i18n, backup)
    if g_i18n:hasText(i18n) then
        return g_i18n:getText(i18n)
    end

    return backup
end

function Letterbox.logPrint(id, text, ...)
    local prefix = Letterbox.prefix[id]
    if prefix == nil then
        prefix = Letterbox.prefix[3]
    end

    print(prefix .. string.format(text, ...))
end

Letterbox.loadPlaceable()





