--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 06.03.2019

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 08.09.2018 - FS17 Release Version
V 1.1.0.0 @ 06.03.2019 - FS19 Release Version

Important:
Free for use in other mods - no permission needed.
No changes are to be made to this script without permission from GtX | Andy

Frei verwendbar - keine erlaubnis nötig
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden

** PLACEABLE ONLY! **
]]


LetterboxGui = {}
local LetterboxGui_mt = Class(LetterboxGui, YesNoDialog)

LetterboxGui.CONTROLS = {
    NUMBER_COLOUR_SELECT_BITMAP = "numberColourSelectBitmap",
    TEXT_COLOUR_SELECT_BITMAP = "textColourSelectBitmap",
    BOX_COLOUR_SELECT_BITMAP = "boxColourSelectBitmap",
    BOX_COLOUR_BUTTON = "setBoxColourButton",
    TEXT_COLOUR_SELECT = "textColourSelect",
    NUMBER_COLOUR_SELECT = "numberColourSelect",
    NUMBER_COLOUR_SELECT_BUTTON = "numberColourSelectButton",
    BOX_COLOUR_SELECT = "boxColourSelect",
    SET_FLAG_STATE = "setFlagState",
    SET_NUMBER = "setNumber",
    SET_LETTER = "setLetter",
    SET_NUMBER_INPUT_TEXT = "setNumberInputText",
    SET_LETTER_INPUT_TEXT = "setLetterInputText",
    SET_FLAG_STATE_TEXT = "setFlagStateText"
}

LetterboxGui.numberTableText = {" ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}

LetterboxGui.letterTableText = {
    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q",
    "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "Ü", "Ä", "Ö", "ß", "-", ".", " "
}

function LetterboxGui:new(target, custom_mt)
    local self = YesNoDialog:new(target, custom_mt or LetterboxGui_mt)

    self:registerControls(LetterboxGui.CONTROLS)

    self.letterboxTexts = {
        boxColour = "Object Colour",
        textColour = "Text Colour",
        numberColour = "Number Colour",
        flagDown = "Down",
        flagUp = "Up",
        numberInputText = "Numbers",
        letterInputText = "Text",
        flagStateText = "Rotation"
    }

    self.colourGroup = {{color = {0.1, 0.1, 0.1, 1}, name = "JET"}, {color = {0.9157, 0.9157, 0.9157, 1}, name = "WHITE"}}

    return self
end

function LetterboxGui:setTextsAndColours(textTable, colourTable)
    if textTable ~= nil then
        self.letterboxTexts = textTable
    end

    if colourTable ~= nil then
        self.colourGroup = colourTable
    end
end

function LetterboxGui:sendTableData(guiLetterTable, guiNumberTable, numberColourIndex, textColourIndex, flagState, boxColourIndex)
    self.guiLetterTable = {}
    self.guiNumberTable = {}

    if guiLetterTable == nil then
        guiLetterTable = {33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33}
    end

    if guiNumberTable == nil then
        guiNumberTable = {0, 0, 0, 0}
    end

    self:setNumberColour(numberColourIndex)
    self:setTextColour(textColourIndex)

    local boxText = "N/A"
    if boxColourIndex > 0 then
        self:setBoxColour(boxColourIndex)
        boxText = self.letterboxTexts.boxColour
        self.setBoxColourButton:setDisabled(false)
    else
        self:setBoxColour(8)
        self.setBoxColourButton:setDisabled(true)
    end

    self.textColourSelect:setText(self.letterboxTexts.textColour)
    self.numberColourSelect:setText(self.letterboxTexts.numberColour)
    self.boxColourSelect:setText(boxText)
    self.setNumberInputText:setText(self.letterboxTexts.numberInputText)
    self.setLetterInputText:setText(self.letterboxTexts.letterInputText)
    self.setFlagStateText:setText(self.letterboxTexts.flagStateText)

    self.numbersActive = true
    if guiNumberTable[1] <= 0 then
        self.numbersActive = false
    end

    for n = 1, 4 do
        self.setNumber[n]:setTexts(LetterboxGui.numberTableText)
        if self.numbersActive then
            self.setNumber[n]:setState(guiNumberTable[n], true)
            self.setNumber[n]:setDisabled(false)
            self.numberColourSelectButton:setDisabled(false)
        else
            self.setNumber[n]:setState(1, false)
            self.setNumber[n]:setDisabled(true)
            self.guiNumberTable = {0, 0, 0, 0}
            self.numberColourSelectButton:setDisabled(true)
        end
    end

    for l = 1, 14 do
        self.setLetter[l]:setTexts(LetterboxGui.letterTableText)
        self.setLetter[l]:setState(guiLetterTable[l], true)
    end

    if flagState == 1 or flagState == 2 then
        self.flagStateActive = true
        self.setFlagState:setTexts({self.letterboxTexts.flagDown, self.letterboxTexts.flagUp})
        self.setFlagState:setState(flagState, true)
        self.setFlagState:setDisabled(false)
    else
        self.flagStateActive = false
        self.setFlagState:setTexts({"N/A"})
        self.setFlagState:setState(1, false)
        self.setFlagState:setDisabled(true)
        self.flagState = 0
    end
end

function LetterboxGui:changeLetterOne(state)
    self.guiLetterTable[1] = state
end

function LetterboxGui:changeLetterTwo(state)
    self.guiLetterTable[2] = state
end

function LetterboxGui:changeLetterThree(state)
    self.guiLetterTable[3] = state
end

function LetterboxGui:changeLetterFour(state)
    self.guiLetterTable[4] = state
end

function LetterboxGui:changeLetterFive(state)
    self.guiLetterTable[5] = state
end

function LetterboxGui:changeLetterSix(state)
    self.guiLetterTable[6] = state
end

function LetterboxGui:changeLetterSeven(state)
    self.guiLetterTable[7] = state
end

function LetterboxGui:changeLetterEight(state)
    self.guiLetterTable[8] = state
end

function LetterboxGui:changeLetterNine(state)
    self.guiLetterTable[9] = state
end

function LetterboxGui:changeLetterTen(state)
    self.guiLetterTable[10] = state
end

function LetterboxGui:changeLetterEleven(state)
    self.guiLetterTable[11] = state
end

function LetterboxGui:changeLetterTwelve(state)
    self.guiLetterTable[12] = state
end

function LetterboxGui:changeLetterThirteen(state)
    self.guiLetterTable[13] = state
end

function LetterboxGui:changeLetterFourteen(state)
    self.guiLetterTable[14] = state
end

function LetterboxGui:changeNumberOne(state)
    self.guiNumberTable[1] = state
end

function LetterboxGui:changeNumberTwo(state)
    self.guiNumberTable[2] = state
end

function LetterboxGui:changeNumberThree(state)
    self.guiNumberTable[3] = state
end

function LetterboxGui:changeNumberFour(state)
    self.guiNumberTable[4] = state
end

function LetterboxGui:selectNumberColour()
    local defaultColor = self.colourGroup[self.numberColourIndex].color
    g_gui:showColorPickerDialog({colors = self.colourGroup, defaultColor = defaultColor, callback = self.setNumberColour, target = self})
end

function LetterboxGui:setNumberColour(colourIndex)
    if colourIndex ~= nil then
        self.numberColourIndex = colourIndex
        local r, g, b, a = self:getColour(colourIndex)
        self.numberColourSelectBitmap:setImageColor(nil, r, g, b, a)
    end
end

function LetterboxGui:selectTextColour()
    local defaultColor = self.colourGroup[self.textColourIndex].color
    g_gui:showColorPickerDialog({colors = self.colourGroup, defaultColor = defaultColor, callback = self.setTextColour, target = self})
end

function LetterboxGui:setTextColour(colourIndex)
    if colourIndex ~= nil then
        self.textColourIndex = colourIndex
        local r, g, b, a = self:getColour(colourIndex)
        self.textColourSelectBitmap:setImageColor(nil, r, g, b, a)
    end
end

function LetterboxGui:selectBoxColour()
    if self.boxColourIndex > 0 then
        local defaultColor = self.colourGroup[self.boxColourIndex].color
        g_gui:showColorPickerDialog({colors = self.colourGroup, defaultColor = defaultColor, callback = self.setBoxColour, target = self})
    end
end

function LetterboxGui:setBoxColour(colourIndex)
    if colourIndex ~= nil then
        self.boxColourIndex = colourIndex
        local r, g, b, a = self:getColour(colourIndex)
        self.boxColourSelectBitmap:setImageColor(nil, r, g, b, a)
    end
end

function LetterboxGui:changeFlagState(state)
    if self.flagStateActive then
        self.flagState = state
    end
end

function LetterboxGui:onClickOk()
    LetterboxGui:superClass().onClickOk(self)

    if self.callback ~= nil then
        if self.target ~= nil then
            local numColour = self.numberColourIndex
            local textColour = self.textColourIndex
            local boxColour = self.boxColourIndex
            local flagState = self.flagState
            self.callback(self.target, self.guiLetterTable, self.guiNumberTable, numColour, textColour, flagState, boxColour)
        else
            print("  ERROR: [LetterboxGui.lua]  Target is missing.")
        end
    end
end

function LetterboxGui:loadCallback(callback, target)
    self.callback = callback
    self.target = target
end

function LetterboxGui:onClickRefresh()
    if self.numbersActive then
        for n = 1, 4 do
            self.setNumber[n]:setState(1, true)
        end
    end

    for l = 1, 14 do
        self.setLetter[l]:setState(33, true)
    end

    local r, g, b, a = self:getColour(8)
    self.numberColourSelectBitmap:setImageColor(nil, r, g, b, a)
    self.numberColourIndex = 8
    self.textColourSelectBitmap:setImageColor(nil, r, g, b, a)
    self.textColourIndex = 8

    if self.boxColourIndex > 0 then
        local index = 8
        if self.target ~= nil and self.target.defaultBoxColour ~= nil then
            index = self.target.defaultBoxColour
        end
        self:setBoxColour(index)
    end

    if self.flagStateActive then
        self.setFlagState:setState(1, true)
    end
end

function LetterboxGui:getColour(index)
    local colour = self.colourGroup[index]
    if colour ~= nil and colour.color ~= nil then
        return colour.color[1], colour.color[2], colour.color[3], colour.color[4]
    end

    return 0.1, 0.1, 0.1, 1
end




