--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 06.03.2019

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 08.09.2018 - FS17 Release Version
V 1.1.0.0 @ 06.03.2019 - FS19 Release Version
V 1.1.0.2 @ 02.04.2020 - Add ability to have more than one letter or number group for Markus_77.

Important:
Important:
Free for use in other mods - permission needed by Markus_77.
No changes are to be made to this script without permission from GtX | Andy

Frei verwendbar - keine Erlaubnis nötig
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden

** PLACEABLE ONLY! **
]]


LetterboxPlaceable = {}

LetterboxPlaceable.CHARACTER_TABLE = {
    {letter = "A", posX = 1, posY = 9},
    {letter = "B", posX = 1, posY = 8},
    {letter = "C", posX = 1, posY = 7},
    {letter = "D", posX = 1, posY = 6},
    {letter = "E", posX = 1, posY = 5},
    {letter = "F", posX = 1, posY = 4},
    {letter = "G", posX = 1, posY = 3},
    {letter = "H", posX = 1, posY = 2},
    {letter = "I", posX = 1, posY = 1},
    {letter = "J", posX = 1, posY = 0},
    {letter = "K", posX = 1, posY = -1},
    {letter = "L", posX = 2, posY = 9},
    {letter = "M", posX = 2, posY = 8},
    {letter = "N", posX = 2, posY = 7},
    {letter = "O", posX = 2, posY = 6},
    {letter = "P", posX = 2, posY = 5},
    {letter = "Q", posX = 2, posY = 4},
    {letter = "R", posX = 2, posY = 3},
    {letter = "S", posX = 2, posY = 2},
    {letter = "T", posX = 2, posY = 1},
    {letter = "U", posX = 2, posY = 0},
    {letter = "V", posX = 2, posY = -1},
    {letter = "W", posX = 3, posY = 9},
    {letter = "X", posX = 3, posY = 8},
    {letter = "Y", posX = 3, posY = 7},
    {letter = "Z", posX = 3, posY = 6},
    {letter = "Ü", posX = 3, posY = 5},
    {letter = "Ä", posX = 3, posY = 4},
    {letter = "Ö", posX = 3, posY = 3},
    {letter = "ẞ", posX = 3, posY = 2},
    {letter = "-", posX = 3, posY = 1},
    {letter = ".", posX = 3, posY = 0},
    {letter = " ", posX = 3, posY = -1}
}

LetterboxPlaceable_mt = Class(LetterboxPlaceable, Placeable)
InitObjectClass(LetterboxPlaceable, "LetterboxPlaceable")

function LetterboxPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, customMt or LetterboxPlaceable_mt)
    registerObjectClassName(self, "LetterboxPlaceable")

    self.letterDisplays = {}
    self.numberDisplays = {}

    self.numLetterDisplays = 0
    self.numNumberDisplays = 0

    self.numberTable = {0, 0, 0, 0}
    self.letterTable = {33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33}

    return self
end

function LetterboxPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, initRandom)
    if not LetterboxPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, initRandom) then
        return false
    end

    local xmlFile = loadXMLFile("TempXML", xmlFilename)

    self.numLetterDisplays = self:loadDisplaysFromXML(self.letterDisplays, xmlFile, "letterDisplay")
    self.numNumberDisplays = self:loadDisplaysFromXML(self.numberDisplays, xmlFile, "numberDisplay")

    self.playerTrigger = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.letterbox.playerTrigger#node"))

    self.letterBoxFlagId = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.letterbox.flag#node"))
    if self.letterBoxFlagId ~= nil then
        local flagUp = getXMLString(xmlFile, "placeable.letterbox.flag#rotUp")
        self.letterBoxFlagUp = Utils.getNoNil(StringUtil.getRadiansFromString(flagUp, 3), {getRotation(self.letterBoxFlagId)})
        local flagDown = getXMLString(xmlFile, "placeable.letterbox.flag#rotDown")
        self.letterBoxFlagDown = Utils.getNoNil(StringUtil.getRadiansFromString(flagDown, 3), {getRotation(self.letterBoxFlagId)})
    end

    self.boxColourIndex = 0
    local i = 0
    while true do
        local key = string.format("placeable.letterbox.colorMat0Nodes.colorMat0Node(%d)", i)
        if not hasXMLProperty(xmlFile, key) then
            break
        end

        local node = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#node"))
        if node ~= nil then
            if getHasClassId(node, ClassIds.SHAPE) then
                if getHasShaderParameter(node, "colorMat0") then
                    if self.letterBoxColourNodes == nil then
                        self.letterBoxColourNodes = {}
                        self.defaultBoxColour = Utils.getNoNil(getXMLInt(xmlFile, "placeable.letterbox.colorMat0Nodes#defaultColourIndex"), 8)
                        self.boxColourIndex = self.defaultBoxColour
                    end
                    local dirt = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#dirt"), 0)
                    local wear = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#wear"), 0)
                    local mat = Utils.getNoNil(getXMLInt(xmlFile, key .. "#material"), 0)
                    table.insert(self.letterBoxColourNodes, {node = node, dirt = dirt, wear = wear, mat = mat})
                else
                    Letterbox.logPrint(3, "'vehicleShader' not found at node '%s'! 'colorMat0Node' could not be set.", getName(node))
                end
            else
                Letterbox.logPrint(2, "Could not set colour at '%s' because node is not a shape!", getName(node))
            end
        end
        i = i + 1
    end

    -- Allow the texts to be changed in each 'xml' so the script can be used for signs etc.
    local title = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#guiTitle"), "Letterbox_GUI_Title")
    local menu = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#openMenu"), "Letterbox_Menu")
    local boxColour = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#boxColourHeader"), "Letterbox_BoxColour")
    local textColour = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#textColourHeader"), "Letterbox_TextColour")
    local numberColour = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#numberColourHeader"), "Letterbox_NumberColour")
    local flagDown = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#flagDown"), "Letterbox_FlagDown")
    local flagUp = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#flagUp"), "Letterbox_FlagUp")
    local numberInputText = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#numberInputHeader"), "Letterbox_NumberInput")
    local letterInputText = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#textInputHeader"), "Letterbox_TextInput")
    local flagStateText = Utils.getNoNil(getXMLString(xmlFile, "placeable.letterbox.texts#flagStateHeader"), "Letterbox_FlagState")

    self.letterboxTexts = {
        guiTitle = Letterbox.getText(title, "Configuration"),
        boxColour = Letterbox.getText(boxColour, "Object Colour"),
        textColour = Letterbox.getText(textColour, "Text Colour"),
        numberColour = Letterbox.getText(numberColour, "Number Colour"),
        flagDown = Letterbox.getText(flagDown, "Down"),
        flagUp = Letterbox.getText(flagUp, "Up"),
        numberInputText = Letterbox.getText(numberInputText, "Numbers"),
        letterInputText = Letterbox.getText(letterInputText, "Text"),
        flagStateText = Letterbox.getText(flagStateText, "Rotation")
    }

    self.activateText = Letterbox.getText(menu, "Open menu")

    delete(xmlFile)

    if self.numLetterDisplays == 0 or self.playerTrigger == nil then
        Letterbox.logPrint(4, "Something went wrong. Please check that the placeable has the following. 'letterDisplay', 'playerTrigger'")
        return false
    end

    return true
end

function LetterboxPlaceable:loadDisplaysFromXML(displays, xmlFile, name)
    -- Still support old single display format. If not found then search for multiples at 'numberDisplays#display' or 'letterDisplays#display'
    local singleDisplay = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, string.format("placeable.letterbox.displays#%s", name)))

    if singleDisplay ~= nil then
        displays[1] = singleDisplay
        return 1
    else
        local i = 0
        while true do
            local key = string.format("placeable.letterbox.displays.%ss.display(%d)", name, i)
            if not hasXMLProperty(xmlFile, key) then
                break
            end

            local node = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, key .."#node"))
            if node ~= nil then
                table.insert(displays, node)
            else
                Letterbox.logPrint(4, "No '%s' node found or given at '%s'", name, key)
            end

            i = i + 1
        end

        return #displays
    end
end

function LetterboxPlaceable:finalizePlacement()
    LetterboxPlaceable:superClass().finalizePlacement(self)

    self.colourGroup = {}
    for i = 1, #g_vehicleColors do
        local colour = g_vehicleColors[i]
        local colourTable = {}
        if colour.r ~= nil and colour.g ~= nil and colour.b ~= nil then
            colourTable.color = {colour.r, colour.g, colour.b, 1}
        elseif colour.brandColor ~= nil then
            colourTable.color = g_brandColorManager:getBrandColorByName(colour.brandColor)
            if colourTable.color == nil then
                colourTable.color = {0.1, 0.1, 0.1, 1}
            end
        end
        colourTable.name = g_i18n:convertText(colour.name)
        self.colourGroup[i] = colourTable
    end

    self.objectActivated = false
    self.numberColourIndex = 8
    self.textColourIndex = 8
    self.flagState = 0

    if self.numLetterDisplays > 0 then
        for i = 1, self.numLetterDisplays do
            local letterDisplay = self.letterDisplays[i]
            local letterCount = getNumOfChildren(letterDisplay)

            if letterCount >= 14 then
                if getHasShaderParameter(getChildAt(letterDisplay, 0), "textColour") then
                    self:setLetterShader(letterDisplay, self.letterTable, self.textColourIndex)
                else
                    Letterbox.logPrint(3, "Correct 'textShader' was not found on children at '%s'", getName(letterDisplay))
                end
            else
                Letterbox.logPrint(3, "'letterDisplay(%d)' %s only contains %d children! 14 are required.", i, getName(letterDisplay), letterCount)
            end
        end
    end

    if self.numNumberDisplays > 0 then
        for i = 1, self.numNumberDisplays do
            local numberDisplay = self.numberDisplays[i]
            local numCount = getNumOfChildren(numberDisplay)

            if numCount >= 4 then
                if getHasShaderParameter(getChildAt(numberDisplay, 0), "numberColor") then
                    if self.numberTable[1] ~= 1 then
                        self.numberTable = {1, 1, 1, 1}
                    end

                    self:setNumberShader(numberDisplay, self.numberTable, self.numberColourIndex)
                else
                    table.remove(self.numberDisplays, i)
                    Letterbox.logPrint(3, "Correct 'numberShader' was not found on children at '%s'", getName(numberDisplay), numCount)
                end
            else
                Letterbox.logPrint(3, "'numberDisplay(%s)' %s only contains %d children! 4 are required.", i, getName(numberDisplay), numCount)
            end
        end
    end

    if self.letterBoxFlagId ~= nil then
        self.flagState = 1
        self.letterBoxFlag = {}
        self.letterBoxFlag.node = self.letterBoxFlagId
        self.letterBoxFlag.state = {self.letterBoxFlagDown, self.letterBoxFlagUp}
        setRotation(self.letterBoxFlag.node, self.letterBoxFlagDown[1], self.letterBoxFlagDown[2], self.letterBoxFlagDown[3])
    end

    if self.letterBoxColourNodes ~= nil then
        local r, g, b, _ = self:getColour(self.boxColourIndex)
        for _, node in pairs (self.letterBoxColourNodes) do
            setShaderParameter(node.node, "colorMat0", r, g, b, node.mat, false)
            local _, _, z, w = getShaderParameter(node.node, "RDT")
            setShaderParameter(node.node, "RDT", node.wear, node.dirt, z, w, false)
        end
    end

    if self.playerTrigger ~= nil then
        addTrigger(self.playerTrigger,"playerTriggerCallback", self)
    else
        Letterbox.logPrint(3, "No 'playerTrigger' found.")
    end

    return true
end

function LetterboxPlaceable:delete()
    if self.playerTrigger ~= nil then
        removeTrigger(self.playerTrigger)
    end

    if self.objectActivated then
        g_currentMission:removeActivatableObject(self)
    end

    unregisterObjectClassName(self)
    LetterboxPlaceable:superClass().delete(self)
end

function LetterboxPlaceable:readStream(streamId, connection)
    LetterboxPlaceable:superClass().readStream(self, streamId, connection)

    if connection:getIsServer() then
        local letterTable = {}
        for i = 1, 14 do
            letterTable[i] = streamReadInt8(streamId)
        end

        local numberTable = {}
        for i = 1, 4 do
            numberTable[i] = streamReadInt8(streamId)
        end

        local numberColour = streamReadInt8(streamId)
        local textColour = streamReadInt8(streamId)
        local flagState = streamReadInt8(streamId)
        local boxColour = streamReadInt8(streamId)

        self:setLetterboxData(letterTable, numberTable, numberColour, textColour, flagState, boxColour, true)
    end
end

function LetterboxPlaceable:writeStream(streamId, connection)
    LetterboxPlaceable:superClass().writeStream(self, streamId, connection)

    if not connection:getIsServer() then
        for i = 1, 14 do
            streamWriteInt8(streamId, self.letterTable[i])
        end

        for i = 1, 4 do
            streamWriteInt8(streamId, self.numberTable[i])
        end

        streamWriteInt8(streamId, self.numberColourIndex)
        streamWriteInt8(streamId, self.textColourIndex)
        streamWriteInt8(streamId, self.flagState)
        streamWriteInt8(streamId, self.boxColourIndex)
    end
end

function LetterboxPlaceable:saveToXMLFile(xmlFile, key, usedModNames)
    LetterboxPlaceable:superClass().saveToXMLFile(self, xmlFile, key, usedModNames)

    local letterCount, letterIds, text = 0, "", ""
    for _, id in pairs(self.letterTable) do
        if letterCount > 0 then
            letterIds = letterIds .. " "
        end

        letterIds = letterIds .. id
        text = text .. LetterboxPlaceable.CHARACTER_TABLE[id].letter

        letterCount = letterCount + 1
    end

    local numberCount, numberIds, numbers = 0, "", ""
    for _, id in pairs(self.numberTable) do
        if numberCount > 0 then
            numberIds = numberIds .. " "
        end

        numberIds = numberIds .. id

        local num = id - 2
        if num == -1 then
            num = " "
        end
        numbers = numbers .. num

        numberCount = numberCount + 1
    end

    setXMLString(xmlFile, key ..".letterBox.displayed#text", text)
    setXMLString(xmlFile, key ..".letterBox.displayed#numbers", numbers)

    setXMLString(xmlFile, key ..".letterBox.ids#letters", letterIds)
    setXMLString(xmlFile, key ..".letterBox.ids#numbers", numberIds)

    setXMLInt(xmlFile, key ..".letterBox.colourIndexs#text", self.textColourIndex)
    setXMLInt(xmlFile, key ..".letterBox.colourIndexs#number", self.numberColourIndex)
    setXMLInt(xmlFile, key ..".letterBox.colourIndexs#box", self.boxColourIndex)

    setXMLInt(xmlFile, key ..".letterBox.flagState#id", self.flagState)
end

function LetterboxPlaceable:loadFromXMLFile(xmlFile, key, resetVehicles)
    if not LetterboxPlaceable:superClass().loadFromXMLFile(self, xmlFile, key, resetVehicles) then
        return false
    end

    local letterTable = self.letterTable
    local numberTable = self.numberTable

    local letterIds = getXMLString(xmlFile, key .. ".letterBox.ids#letters")
    if letterIds ~= nil then
        local ids = StringUtil.splitString(" ", letterIds)
        if #ids == 14 then
            for l = 1, 14 do
                letterTable[l] = tonumber(ids[l])
            end
        end
    end

    local numberIds = getXMLString(xmlFile, key .. ".letterBox.ids#numbers")
    if numberIds ~= nil then
        local ids = StringUtil.splitString(" ", numberIds)
        if #ids == 4 then
            for n = 1, 4 do
                numberTable[n] = tonumber(ids[n])
            end
        end
    end

    local maxColours = #self.colourGroup

    local getTextColour = Utils.getNoNil(getXMLInt(xmlFile, key .. ".letterBox.colourIndexs#text"), 1)
    local textColour = math.max(math.min(getTextColour, maxColours), 1)

    local getNumberColour = Utils.getNoNil(getXMLInt(xmlFile, key .. ".letterBox.colourIndexs#number"), 1)
    local numberColour = math.max(math.min(getNumberColour, maxColours), 1)

    local boxColour = 0
    if self.letterBoxColourNodes ~= nil then
        local getBoxColour = Utils.getNoNil(getXMLInt(xmlFile, key .. ".letterBox.colourIndexs#box"), boxColour)
        boxColour = math.max(math.min(getBoxColour, maxColours), 1)
    end

    local flagState = 0
    if self.letterBoxFlag ~= nil then
        flagState = Utils.getNoNil(getXMLInt(xmlFile, key .. ".letterBox.flagState#id"), 1)
        if flagState < 1 or flagState > 2 then
            flagState = 1
        end
    end

    self:setLetterboxData(letterTable, numberTable, numberColour, textColour, flagState, boxColour, true)

    return true
end

function LetterboxPlaceable:onActivateObject()
    local dialog = g_gui:showDialog("LetterboxGui")
    if dialog ~= nil then
        dialog.target:setTitle(self.letterboxTexts.guiTitle)
        dialog.target:setTextsAndColours(self.letterboxTexts, self.colourGroup)
        dialog.target:sendTableData(self.letterTable,
                                    self.numberTable,
                                    self.numberColourIndex,
                                    self.textColourIndex,
                                    self.flagState,
                                    self.boxColourIndex)

        dialog.target:loadCallback(self.setLetterboxData, self)
    end
end

function LetterboxPlaceable:drawActivate()
    return
end

function LetterboxPlaceable:getIsActivatable()
    return g_currentMission.controlPlayer and (self:getOwnerFarmId() == 0 or g_currentMission:getFarmId() == self:getOwnerFarmId())
end

function LetterboxPlaceable:shouldRemoveActivatable()
    return false
end

function LetterboxPlaceable:playerTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter or onLeave then
        if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
            if onEnter then
                if not self.objectActivated then
                    g_currentMission:addActivatableObject(self)
                    self.objectActivated = true
                end
            else
                if self.objectActivated then
                    g_currentMission:removeActivatableObject(self)
                    self.objectActivated = false
                end
            end
        end
    end
end

function LetterboxPlaceable:setLetterboxData(letterTable, numberTable, numberColour, textColour, flagState, boxColour, noEventSend)
    LetterboxEvent.sendEvent(self, letterTable, numberTable, numberColour, textColour, flagState, boxColour, noEventSend)

    self.letterTable = letterTable
    self.numberTable = numberTable
    self.numberColourIndex = numberColour
    self.textColourIndex = textColour
    self.flagState = math.max(math.min(flagState, 2), 0)
    self.boxColourIndex = boxColour

    if self.letterBoxColourNodes ~= nil then
        local r, g, b, _ = self:getColour(boxColour)
        for _, node in pairs (self.letterBoxColourNodes) do
            setShaderParameter(node.node, "colorMat0", r, g, b, node.mat, false)
        end
    end

    if self.letterBoxFlag ~= nil then
        local flagRot = self.letterBoxFlag.state[self.flagState]
        local rx, ry, rz = flagRot[1], flagRot[2], flagRot[3]
        setRotation(self.letterBoxFlag.node, rx, ry, rz)
    end

    if self.numNumberDisplays > 0 then
        for i = 1, self.numNumberDisplays do
            self:setNumberShader(self.numberDisplays[i], self.numberTable, numberColour)
        end
    end

    if self.numLetterDisplays > 0 then
        for i = 1, self.numLetterDisplays do
            self:setLetterShader(self.letterDisplays[i], self.letterTable, textColour)
        end
    end
end

function LetterboxPlaceable:setLetterShader(index, textTable, colourIndex)
    if index ~= nil and textTable ~= nil then
        local r, g, b, a = self:getColour(colourIndex)

        for i = 1, 14 do
            local child = getChildAt(index, i - 1)
            local letterId = textTable[i]

            if letterId < 0 or letterId > 33 then
                letterId = 33
            end

            local letter = LetterboxPlaceable.CHARACTER_TABLE[letterId]
            setShaderParameter(child, "posX", letter.posX, 0, 0, 0, false)
            setShaderParameter(child, "posY", letter.posY, 0, 0, 0, false)
            setShaderParameter(child, "textColour", r, g, b, a, false)
        end
    end
end

function LetterboxPlaceable:setNumberShader(index, numberTable, colourIndex)
    if index ~= nil and numberTable ~= nil then
        local r, g, b, a = self:getColour(colourIndex)

        for i = 1, 4 do
            local child = getChildAt(index, i - 1)
            local numberId = numberTable[i] - 2

            if numberId < -1 or numberId > 9 then
                numberId = -1
            end

            setShaderParameter(child, "number", numberId, 0, 0, 0, false)
            setShaderParameter(child, "numberColor", r, g, b, a, false)
        end
    end
end

function LetterboxPlaceable:getColour(index)
    local colour = self.colourGroup[index]
    if colour ~= nil and colour.color ~= nil then
        return colour.color[1], colour.color[2], colour.color[3], colour.color[4]
    end

    return 0.1, 0.1, 0.1, 1
end
