--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 06.03.2019

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 08.09.2018 - FS17 Release Version
V 1.1.0.0 @ 06.03.2019 - FS19 Release Version
V 1.1.0.1 @ 05.05.2019 - Fix dedicated server 'broadcastEvent' mistake carried over from FS17. (FS19)

Important:
Free for use in other mods - no permission needed.
No changes are to be made to this script without permission from GtX | Andy

Frei verwendbar - keine erlaubnis nötig
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden

** PLACEABLE ONLY! **
]]


LetterboxEvent = {}
LetterboxEvent_mt = Class(LetterboxEvent, Event)
InitEventClass(LetterboxEvent, "LetterboxEvent")

function LetterboxEvent:emptyNew()
    local self = Event:new(LetterboxEvent_mt)

    return self
end

function LetterboxEvent:new(object, guiLetterTable, guiNumberTable, numberColour, textColour, flagState, boxColour)
    local self = LetterboxEvent:emptyNew()

    self.object = object
    self.guiLetterTable = guiLetterTable
    self.guiNumberTable = guiNumberTable
    self.numberColour = numberColour
    self.textColour = textColour
    self.flagState = flagState
    self.boxColour = boxColour

    return self
end

function LetterboxEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)

    self.guiLetterTable = {}
    for i = 1, 14 do
        self.guiLetterTable[i] = streamReadInt8(streamId)
    end

    self.guiNumberTable = {}
    for i = 1, 4 do
        self.guiNumberTable[i] = streamReadInt8(streamId)
    end

    self.numberColour = streamReadInt8(streamId)
    self.textColour = streamReadInt8(streamId)
    self.flagState = streamReadInt8(streamId)
    self.boxColour = streamReadInt8(streamId)

    self:run(connection)
end

function LetterboxEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)

    for i = 1, 14 do
        streamWriteInt8(streamId, self.guiLetterTable[i])
    end

    for i = 1, 4 do
        streamWriteInt8(streamId, self.guiNumberTable[i])
    end

    streamWriteInt8(streamId, self.numberColour)
    streamWriteInt8(streamId, self.textColour)
    streamWriteInt8(streamId, self.flagState)
    streamWriteInt8(streamId, self.boxColour)
end

function LetterboxEvent:run(connection)
    if self.object ~= nil then
        self.object:setLetterboxData(self.guiLetterTable, self.guiNumberTable, self.numberColour, self.textColour, self.flagState, self.boxColour, true)
    end

    if not connection:getIsServer() then
        g_server:broadcastEvent(LetterboxEvent:new(self.object, self.guiLetterTable, self.guiNumberTable, self.numberColour, self.textColour, self.flagState, self.boxColour), nil, connection, self.object)
    end
end

function LetterboxEvent.sendEvent(object, guiLetterTable, guiNumberTable, numberColour, textColour, flagState, boxColour, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(LetterboxEvent:new(object, guiLetterTable, guiNumberTable, numberColour, textColour, flagState, boxColour), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(LetterboxEvent:new(object, guiLetterTable, guiNumberTable, numberColour, textColour, flagState, boxColour))
        end
    end
end