﻿--
-- REA Script
-- author: 900Hasse
-- date: 30.07.2019
--
-- V1.4.2.0
--
-----------------------------------------
-- TO DO
---------------
-- 
-- Remake combine power need?
-- 
-- User help when pushing a button
-- 
-- What is wrong with the kramer?


-----------------------------------------
-- KNOWN ISSUES
---------------
-- Combines harvesters get to high power demand on cutter turning the combine off?
-- Extreme load on small wheels can get vehicles into spin

print("---------------------------")
print("----- REA by 900Hasse -----")
print("---------------------------")
REA = {};

function REA.prerequisitesPresent(specializations)
    return true
end;

function REA:loadMap(name)
end

function REA:deleteMap()
end

function REA:draw(dt)

	-- If Client draw vehicle status on GUI
	local UseGUI = true;
	if UseGUI then
		if g_client and not g_gui:getIsGuiVisible() and not g_flightAndNoHUDKeysEnabled and g_currentMission.hud:getIsVisible() then
			-- Calculate time since last draw
			if REA.LastDrawTime == nil then
				REA.LastDrawTime = 0;
			end;
			-- Calculate time
			local TimeSinceLastDraw = g_currentMission.time - REA.LastDrawTime;
			-- Save time for next draw
			REA.LastDrawTime = g_currentMission.time;
			-- Check number of vehicles
			numVehicles = table.getn(g_currentMission.vehicles);
			-- If vehicles present run code
			if numVehicles ~= nil then
				-- Run code for vehicles
				if numVehicles >= 1 then
					-- Search for controlled vehicle
					for VehicleIndex=1, numVehicles do
						-- Save "vehicle" to local
						local vehicle = g_currentMission.vehicles[VehicleIndex];			
						-- Check if current vehicle exists
						if vehicle ~= nil then
							if vehicle.spec_motorized then
								if vehicle.spec_wheels ~= nil then
									if vehicle:getIsControlled() then
										if g_currentMission.controlledVehicle == vehicle then
											REA:DrawStatus(vehicle,TimeSinceLastDraw);
											break
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function REA:update(dt)
	-----------------------------------------------------------------------------------
	-- Global settings
	-----------------------------------------------------------------------------------
	-- Save global values
	if REA.GlobalValuesSet ~= true then

		REA.SeasonsLoaded = g_modIsLoaded["FS19_RM_Seasons"];
		if REA.SeasonsLoaded then
			print("REA: RM Seasons loaded, use Seasons friction during wet ground state")
		end;
		REA.PrecisionFarmingLoaded = g_modIsLoaded["FS19_precisionFarming"];
		if REA.PrecisionFarmingLoaded then
			print("REA: Precision farming loaded, use functions supported")
		end;

		-- TireType sink parameters
		REA.TireTypeMaxSinkFrictionReduced = {1,1,1,1};
		REA.TireTypeSinkStuckLevel = {1,1,1,1};
		REA.TireTypeMinRollingCoeff = {1,1,1,1};
		REA.TireTypeSinkPerMeterSpinning = {0.1,0.1,0.1,0.1};

		-- Friction multipliers for implements
		REA.PlowMultiplier = {1,1,1,1,1,1};
		REA.CultivatorMultiplier = {1,1,1,1,1,1};
		REA.SowingMachineMultiplier = {1,1,1,1,1,1};
		-- Speed adjustments for implements
		REA.PlowSpeedAjust = {0,0,0,0,0,0};
		REA.CultivatorSpeedAjust = {0,0,0,0,0,0};
		REA.SowingMachineSpeedAjust = {0,0,0,0,0,0};

		-- Tiretypes
		local TireTypeMUD = 1;
		local TireTypeOFFROAD = 2;
		local TireTypeSTREET = 3;
		local TireTypeCRAWLER = 4;

		-- Groundtypes
		local ROAD = 1;
		local HARD_TERRAIN = 2;
		local SOFT_TERRAIN = 3;
		local FIELD = 4;

		-- Terrain values
		local Road = 0 -- Road
		local Cultivated = 1 -- Cultivated
		local Plowed = 2 -- Plowed
		local HarvestedSowed = 3 -- Harvested or sowed
		local RootCrops = 4 -- Rootcrops
		local Grass = 5 -- Grass

		-----------------------------------------------------------------------------------
		-- Global settings of wheel tiretypes and friction
		-----------------------------------------------------------------------------------
		-- Min wheel size(radius) to be effected by mod
		REA.MinWheelRadius = 0.15;
		-- Max sink of rootcrpos
		Wheels.MAX_SINK[RootCrops] = 0.1;
		-- Factor max sink of wheel based on radius(original value 0.2)
		REA.WheelRadiusMaxSinkFactor = 0.5;
		-- Sink parameters when wheel in conctact with a lowspot with water (percentage)
		REA.TireTypeMaxSinkFrictionReducedLowSpot = 100;
		REA.TireTypeSinkStuckLevelLowSpot = 75;
		-- Seasons vs Vanilla frictionCoeffsWet factor
		local SeasonsVsVanillaFrictionFactor = 0.5;
		-------------------------------------
		-- MUD
		-- TireType on different groundtypes
		REA:SetFrictionCoeff(TireTypeMUD,ROAD,1.0,0.9,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeMUD,HARD_TERRAIN,0.8,0.8,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeMUD,SOFT_TERRAIN,0.8,0.7,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeMUD,FIELD,0.7,0.7,SeasonsLoaded);
		-- Sink parameters (percentage)
		REA.TireTypeMaxSinkFrictionReduced[TireTypeMUD] = 35;
		REA.TireTypeSinkStuckLevel[TireTypeMUD] = 95;
		REA.TireTypeSinkPerMeterSpinning[TireTypeMUD] = 0.05;
		-- Min rolling coefficient
		REA.TireTypeMinRollingCoeff[TireTypeMUD] = 0.04;
		-------------------------------------
		-- OFFROAD
		-- TireType on different groundtypes
		REA:SetFrictionCoeff(TireTypeOFFROAD,ROAD,1.25,0.9,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeOFFROAD,HARD_TERRAIN,0.9,0.7,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeOFFROAD,SOFT_TERRAIN,0.8,0.6,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeOFFROAD,FIELD,0.7,0.5,SeasonsLoaded);
		-- Sink parameters (percentage)
		REA.TireTypeMaxSinkFrictionReduced[TireTypeOFFROAD] = 40;
		REA.TireTypeSinkStuckLevel[TireTypeOFFROAD] = 90;
		REA.TireTypeSinkPerMeterSpinning[TireTypeOFFROAD] = 0.035;
		-- Min rolling coefficient
		REA.TireTypeMinRollingCoeff[TireTypeOFFROAD] = 0.03;
		-------------------------------------
		-- STREET
		-- TireType on different groundtypes
		REA:SetFrictionCoeff(TireTypeSTREET,ROAD,1.5,0.9,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeSTREET,HARD_TERRAIN,0.7,0.6,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeSTREET,SOFT_TERRAIN,0.65,0.5,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeSTREET,FIELD,0.6,0.4,SeasonsLoaded);
		-- Sink parameters (percentage)
		REA.TireTypeMaxSinkFrictionReduced[TireTypeSTREET] = 50;
		REA.TireTypeSinkStuckLevel[TireTypeSTREET] = 80;
		REA.TireTypeSinkPerMeterSpinning[TireTypeSTREET] = 0.02;
		-- Min rolling coefficient
		REA.TireTypeMinRollingCoeff[TireTypeSTREET] = 0.02;
		-------------------------------------
		-- CRAWLER
		-- TireType on different groundtypes
		REA:SetFrictionCoeff(TireTypeCRAWLER,ROAD,1.0,0.7,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeCRAWLER,HARD_TERRAIN,1.0,0.7,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeCRAWLER,SOFT_TERRAIN,0.9,0.6,SeasonsLoaded);
		REA:SetFrictionCoeff(TireTypeCRAWLER,FIELD,0.8,0.5,SeasonsLoaded);
		-- Sink parameters (percentage)
		REA.TireTypeMaxSinkFrictionReduced[TireTypeCRAWLER] = 40;
		REA.TireTypeSinkStuckLevel[TireTypeCRAWLER] = 95;
		REA.TireTypeSinkPerMeterSpinning[TireTypeCRAWLER] = 0.03;
		-- Min rolling coefficient
		REA.TireTypeMinRollingCoeff[TireTypeCRAWLER] = 0.1;


		-----------------------------------------------------------------------------------
		-- Settings for implement and groundtype
		-----------------------------------------------------------------------------------
		-- Pulling multiplier on different groundtypes
		-- Plow
		REA.PlowMultiplier[Plowed] = 0.7;
		REA.PlowMultiplier[Cultivated] = 0.8;
		REA.PlowMultiplier[RootCrops] = 0.9;
		REA.PlowMultiplier[HarvestedSowed] = 1;
		REA.PlowMultiplier[Grass] = 1.2;
		REA.PlowMultiplier[Road] = 1.3;
		-- Cultivator
		REA.CultivatorMultiplier[Plowed] = 0.7;
		REA.CultivatorMultiplier[Cultivated] = 0.8;
		REA.CultivatorMultiplier[RootCrops] = 1.0;
		REA.CultivatorMultiplier[HarvestedSowed] = 1;
		REA.CultivatorMultiplier[Grass] = 1.3;
		REA.CultivatorMultiplier[Road] = 2;
		-- Sowing machine
		REA.SowingMachineMultiplier[Plowed] = 0.6;
		REA.SowingMachineMultiplier[Cultivated] = 1;
		REA.SowingMachineMultiplier[RootCrops] = 1;
		REA.SowingMachineMultiplier[HarvestedSowed] = 1.2;
		REA.SowingMachineMultiplier[Grass] = 1.4;
		REA.SowingMachineMultiplier[Road] = 2;
		-- Power needed for balers and foragewagons to fill 100l/s for filltype with a mass of 1 ton/m2
		REA.FillspeedPowerNeed = 450;

		-- Global values set
		REA.GlobalValuesSet = true
		print("Global REA variables loaded")
	end;

	-----------------------------------------------------------------------------------
	-- Check if REA.Dynamic dirt is loadad and all map is scanned for low spots
	-----------------------------------------------------------------------------------
	-- Initialize variable for Dynamic dirt
	if REA.DynamicDirtActivated == nil then
		REA.DynamicDirtFound = false;
		REA.DynamicDirtActivated = false;
	end;
	-- Check if Dynamic dirt is loaded and all map scanned
	if not REA.DynamicDirtActivated then
		-- Check if dynamic dirt is loaded
		if not REA.DynamicDirtFound and g_modIsLoaded.FS19_READynamicDirt ~= nil then
			print("REA Dynamic dirt: Found by REA")
			REA.DynamicDirtFound = true;
		end;
		-- If dynamic dirt is loaded wait until all area is scanned before starting functions
		if REA.DynamicDirtFound then
			if WheelsUtil.LowspotScanCompleted ~= nil then
				if WheelsUtil.LowspotScanCompleted then
					print("REA Dynamic dirt: Scan completed detected by REA")
					REA.DynamicDirtActivated = true;
				end;
			end;
		end;
	end;


	-----------------------------------------------------------------------------------
	-- Read wetness from gound with extra factor
	-----------------------------------------------------------------------------------
	local GroundWetness = g_currentMission.environment.weather:getGroundWetness();
	if REA.SeasonsLoaded then
		local ExtraFactor = 1.75;
		local StartLevel = 0.1;
		REA.GroundWetnessFactor = MathUtil.clamp(GroundWetness + (math.max(GroundWetness - StartLevel,0) * ExtraFactor), 0, 1);
	else
		REA.GroundWetnessFactor = GroundWetness;
	end;

	-- DEBUG
	--renderText(0.3, 0.4, 0.02,"Wet: " .. REA:RoundValueTwoDecimals(GroundWetness) .. ", REA wet: " .. REA:RoundValueTwoDecimals(REA.GroundWetnessFactor));


	-----------------------------------------------------------------------------------
	-- Add REA functionality
	-----------------------------------------------------------------------------------
	-- Get number of vehicles
	local numVehicles = table.getn(g_currentMission.vehicles);
	-- If vehicles present run code
	if numVehicles ~= nil then
		-- Run code for vehicles
		if numVehicles >= 1 then
			for VehicleIndex=1, numVehicles do
				-- Save "vehicle" to local
				local vehicle = g_currentMission.vehicles[VehicleIndex];			
				-- Check if current vehicle exists
				if vehicle ~= nil then

					-- Debug CenterOfMass
					local DebugCOF = false
					if DebugCOF then
						for _,component in pairs(vehicle.components) do
							-- Get translation
							cx, cy, cz = getCenterOfMass(component.node);
							local wx, wy, wz = localToWorld(component.node, cx, cy, cz);
							-- Create node for lowest spot
							local COGNode = createTransformGroup("NodeName");
							-- Create nodes for search region
							setTranslation(COGNode, wx, wy, wz);
						end;
					end;

					-----------------------------------------------------------------------------------
					-- Global calculations for vehicles
					-----------------------------------------------------------------------------------
					local MotorizedVehicle = false;
					-- If vehicle is motorized save for each wheel
					if vehicle.spec_motorized ~= nil then
						MotorizedVehicle = true;
					end;
					if vehicle.spec_wheels ~= nil then	
						local numWheels = table.getn(vehicle.spec_wheels.wheels);
						for WheelIndex=1,numWheels do
							-- Save wheel to local
							local wheel = vehicle.spec_wheels.wheels[WheelIndex];
							-- Update speed calculated from xDrive
							REA:WheelSpeedFromXdrive(wheel,dt);
							-- Update sideway speed and direction of active wheel
							REA:UpdateWheelDirectionAndSpeed(wheel,dt);
							-- Update wheel distance based on xDrive
							REA:WheelDistanceFromXdrive(wheel,dt)
							-- Save for wheel that it is attached to motorized vehicle
							if MotorizedVehicle then
								wheel.AttachedToMotorizedVehicle = true;
							else
								wheel.AttachedToMotorizedVehicle = false;
							end;
							-- If REA dynamic dirt activated check if wheel is in a lowspot with water
							if REA.DynamicDirtActivated then
								-- Get number of lowspots
								local NumOfLowspots = table.getn(WheelsUtil.LowspotWaterLevelNode);
								-- If any lowspot is created evaluate if wheel is in contact
								if NumOfLowspots > 0 then
									-- If wheel is moving update
									local MinSpeedForUpdate = 0.1;
									if wheel.SpeedBasedOnXdrive > MinSpeedForUpdate or wheel.RollingDirectionSpeed > MinSpeedForUpdate or wheel.SideWaySpeed > MinSpeedForUpdate then
										-- Get if wheel is in lowspot with water
										wheel.InLowspotWithWater = REA:GetIsInLowspotWithWater(wheel);
									end;
								else
									-- If no lowspots created
									wheel.InLowspotWithWater = false;
								end;
							end;
						end;
					end;

					-----------------------------------------------------------------------------------
					-- If Client draw vehicle status on GUI
					-----------------------------------------------------------------------------------
					-- Search for controlled vehicle
					if g_client and not g_gui:getIsGuiVisible() then
						if vehicle.spec_motorized then
							if vehicle.spec_wheels ~= nil then	
								if vehicle:getIsControlled() then
									if g_currentMission.controlledVehicle == vehicle then
										REA:CalcSlip(vehicle,dt);
									end;
								end;
							end;
						end;
					end;

					-----------------------------------------------------------------------------------
					-- If server run code for vehicles
					-----------------------------------------------------------------------------------
					if g_server ~= nil then
						-- If vehicle is motorized save speed to use for shifting gear
						if vehicle.spec_motorized ~= nil then
							if vehicle.spec_motorized.motor ~= nil then
								-- Adjust speed of vehicle if PTO demands more power than motor can give
								if vehicle.spec_motorized.isMotorStarted then
									-- Adjust speed if PTO tourqe reaches high levels
									REA:AdjustSpeedIfPtpPowerMaxed(vehicle,dt);
								end;
							end;
						end;
						-- If vehicle have wheels calculate friction,add rolling resistance and calculate new center of gravity
						if vehicle.spec_wheels ~= nil and vehicle.isAddedToPhysics then
							-- If vehicle is a powerconsumer and rolling resistance should be ignored when implement is working
							local IgnoreRollingResistance = false;
							if vehicle.spec_powerConsumer ~= nil then
								if vehicle.spec_powerConsumer.IgnoreRollingResistance ~= nil then
									IgnoreRollingResistance = vehicle.spec_powerConsumer.IgnoreRollingResistance;
								end;
							end;
							-- Update wheels
							REA:UpdateWheels(vehicle.spec_wheels,vehicle.spec_crawlers,MotorizedVehicle,IgnoreRollingResistance,dt);
						end;
						-- Adjust power need and speed of power consuming vehicle
						REA:UpdatePowerMultiplier(vehicle,dt);
					end;
				end;
			end;
		end;
	end;
end;


--------------------------------------------------------------------
-- Function to set friction coefficient of dry and wet ground
--------------------------------------------------------------------
function REA:SetFrictionCoeff(TireType,Groundtype,CoeffDry,CoeffFactorWetSeasons,SeasonsLoaded)
	-- Friction coefficient for dry ground
	WheelsUtil.tireTypes[TireType].frictionCoeffs[Groundtype] = CoeffDry;
	-- Friction coefficient for wet ground with seasons loaded
	WheelsUtil.tireTypes[TireType].frictionCoeffsWet[Groundtype] = CoeffDry*CoeffFactorWetSeasons;
	-- If seasons is not loaded increase friction for wet ground
	if not SeasonsLoaded then
		WheelsUtil.tireTypes[TireType].frictionCoeffsWet[Groundtype] = (CoeffDry*CoeffFactorWetSeasons)+((CoeffDry-(CoeffDry*CoeffFactorWetSeasons))*0.5);
	end;
	-- Names of tiretypes and groundtypes
	TireTypeName = {"MUD","OFFROAD","STREET","CRAWLERS"};
	GroundTypeName = {"ROAD","HARD TERRAIN","SOFT TERRAIN","FIELD"};
	print("REA: Friction coefficient for tiretype '" .. TireTypeName[TireType] .. "' on groundtype '" .. GroundTypeName[Groundtype] .. "' Dry / Wet =" .. WheelsUtil.tireTypes[TireType].frictionCoeffs[Groundtype] .. " / " .. WheelsUtil.tireTypes[TireType].frictionCoeffsWet[Groundtype])
end;


-----------------------------------------------------------------------------------	
-- Calculate new center of mass of vehicle
-----------------------------------------------------------------------------------
function REA:CalculateNewCenterOfMass(vehicle)
	-- Check if there are wheels on this vehicle
	if vehicle.spec_wheels ~= nil then
		if vehicle.spec_wheels.wheels ~= nil then 
			-- Print info
			print("----------------------------------------------------------------------------------------")
			print("Name: " .. vehicle:getFullName())
			-- Get number of components
			local NumOfComp = table.getn(vehicle.components);
			local CurrentComp = 0;
			-- Get number of wheels
			local numVehicleWheels = table.getn(vehicle.spec_wheels.wheels);
			-- Adjust center of mass on all components 
			for _,component in pairs(vehicle.components) do
				-- Count to next component
				CurrentComp = CurrentComp + 1;

				--Get original values
				cx, cy, cz = getCenterOfMass(component.node);
				local wx, wy, wz = localToWorld(component.node, cx, cy, cz);

				-- Get all childs
				local AllChild = {}
				REA:GetAllChilds(component.node,AllChild)
				-- Get total number of child
				local TotalNumberOfChild = table.getn(AllChild);

				-- Get wheel center value in relation to component
				local WheelLowestCenterY = 0;
				local WheelAvarageY = 0;
				local WheelAvarageZ = 0;
				local NumberOfWheel = 0;
				local DistanceWheelsZ = 0;
				local LastWheelZ = 0;
				local LargestWheelRadius = 0;
				for _,wheel in pairs(vehicle.spec_wheels.wheels) do
					for ChildIndex=1,TotalNumberOfChild do
						ActChild = AllChild[ChildIndex];
						-- Check if this wheel is connected to this component
						if wheel.driveNode == ActChild then
							-- Get translation relative to component
							local WheelX,WheelY,WheelZ = localToLocal(wheel.driveNode, component.node, 0, 0, 0);		
							if wheel.radiusOriginal > LargestWheelRadius then
								LargestWheelRadius = wheel.radiusOriginal;
							end;
							if WheelY < WheelLowestCenterY or WheelLowestCenterY == 0 then
								WheelLowestCenterY = WheelY;
							end;
							-- Calculate distance betweene wheels to determine wheel base
							if LastWheelZ == 0 then
								LastWheelZ = WheelZ;
							else
								-- Calculate distance
								local DistanceZ = math.abs(LastWheelZ - WheelZ);
								if DistanceZ > DistanceWheelsZ then
									DistanceWheelsZ = DistanceZ;
								end;
							end;
							-- Add total wheel Y value
							WheelAvarageY = WheelAvarageY + WheelY;
							-- Add total wheel Z value
							WheelAvarageZ = WheelAvarageZ + WheelZ;
							-- Count number of wheels
							NumberOfWheel = NumberOfWheel + 1;
						end;
					end;
				end;
				-- Calculate average wheel Z value
				if NumberOfWheel > 1 then
					WheelAvarageZ = WheelAvarageZ / NumberOfWheel;
				end;
				-- Calculate average wheel Y value
				if NumberOfWheel > 1 then
					WheelAvarageY = WheelAvarageY / NumberOfWheel;
				end;

				-- Get highest point
				local Highest = 0;
				for ChildIndex=1,TotalNumberOfChild do
					ActChild = AllChild[ChildIndex];
					-- Get translation
					local x,y,z = localToLocal(ActChild, component.node, 0, 0, 0);
					if y > Highest then
						Highest = y;
					end;
				end;

				-- Initialize updates
				if component.UpdateYValue == nil then
					component.UpdateYValue = false;
					component.UpdateZValue = false;
				end;

				-- Choose wheel height, use largest wheel
				local WheelHeight = WheelLowestCenterY;
				-- Choose wheel height, choose lowest wheel if vehicle have got a short wheel base;
				if DistanceWheelsZ > 1 then
					WheelHeight = WheelAvarageY;
				end;

				-- New center of mass Y value
				local MinCenterY = 0.05 + WheelHeight;
				local MaxCenterY = math.min(0.3 + WheelHeight,LargestWheelRadius*3);
				local NewCenterY = cy;
				if NumberOfWheel > 0 then
					NewCenterY = math.max((Highest - WheelHeight) + WheelHeight,MinCenterY);
					NewCenterY = math.min(NewCenterY,MaxCenterY);
					-- Round value with 2 decimals
					NewCenterY = REA:RoundValueTwoDecimals(NewCenterY);
					-- Update Y value
					if NewCenterY > cy then
						component.UpdateYValue = true;
					end;
				end;

				-- New center of mass Z value
				local MaxDistanceToWheels = 1.0;
				if WheelAvarageZ < -0.5 then
					MaxDistanceToWheels = 0.5;
				end;
				local NewCenterZ = cz;
				local DistanceToWheel = 0;
				-- If component has wheels and motor check distance to wheels and adjust
				if NumberOfWheel > 1 and numVehicleWheels > 2 then
					if vehicle.spec_motorized ~= nil then
						if vehicle.spec_motorized.motor ~= nil then
							DistanceToWheel = math.abs(cz - WheelAvarageZ);
							if DistanceToWheel > MaxDistanceToWheels then
								if WheelAvarageZ < 0 then
									NewCenterZ = cz - ((cz - WheelAvarageZ) - MaxDistanceToWheels);
								else
									NewCenterZ = cz - ((cz - WheelAvarageZ) + MaxDistanceToWheels);
								end;
								-- Round value with 2 decimals
								NewCenterZ = REA:RoundValueTwoDecimals(NewCenterZ);
								-- Update Z value
								component.UpdateZValue = true;
							end;
						end;
					end;
				end;
				-- Calculate changed COG from confuguration
				local AddX = 0;
				local AddY = 0;
				local AddZ = 0;
				if component.OriginalCOGX ~= nil then
					AddX = REA:RoundValueTwoDecimals(cx - component.OriginalCOGX);
					AddY = REA:RoundValueTwoDecimals(cy - component.OriginalCOGY);
					AddZ = REA:RoundValueTwoDecimals(cz - component.OriginalCOGZ);
				end;

				-- Updates
				local UpdateX = cx;
				local UpdateY = cy;
				local UpdateZ = cz;
				-- Update Y value
				if component.UpdateYValue then
					UpdateY = NewCenterY+AddY;
				end;
				-- Update Z value
				if component.UpdateZValue then
					UpdateZ = NewCenterZ+AddZ;
				end;
				-- Set new center of mass
				print("-----------------")
				print("Component: " .. getName(component.node) .. ", component: " .. CurrentComp .. " of " .. NumOfComp)
				if component.UpdateYValue or component.UpdateZValue then
					setCenterOfMass(component.node, UpdateX, UpdateY, UpdateZ);
					--Print info
					print("Center of mass changed by REA")
					if AddX ~= 0 or AddY ~= 0 or AddZ ~= 0 then
						print("Center of mass, Component XML: X=" .. component.OriginalCOGX .. "m, Y=" .. component.OriginalCOGY .. "m, Z=" .. component.OriginalCOGZ .. "m");
						print("Center of mass, After load finished: X=" .. REA:RoundValueTwoDecimals(cx) .. "m, Y=" .. REA:RoundValueTwoDecimals(cy) .. "m, Z=" .. REA:RoundValueTwoDecimals(cz) .. "m");
						print("Center of mass, adjustments by vehicle customization: X=" .. AddX .. "m, Y=" .. AddY .. "m, Z=" .. AddZ .. "m");
					end;
					print("Y(height) original: " .. REA:RoundValueTwoDecimals(cy) .. "m, new: " .. UpdateY .. "m");
					print("Z(length) original: " .. REA:RoundValueTwoDecimals(cz) .. "m, new: " .. UpdateZ .. "m");
					print("Number of wheels: " .. NumberOfWheel .. ", Wheel height: " .. REA:RoundValueTwoDecimals(WheelHeight) .. "m, Largest wheel radius: " .. LargestWheelRadius);
					print("Component Mass default: " .. component.defaultMass * 1000 .. "kg, current: " .. component.mass * 1000 .. "kg");
				else
					print("REA, Center of mass checked")
				end;
			end;
			print("----------------------------------------------------------------------------------------")
		end;
	end;
end


-----------------------------------------------------------------------------------	
-- Get child nodes, volume and mass of these
-----------------------------------------------------------------------------------
function REA:GetAllChilds(Node,AllChild)
	-- Save all child in table
	table.insert(AllChild,Node)
	-- Get number of child
	local NumChild = getNumOfChildren(Node);
	-- If more child to node get data from these as well
	if NumChild > 0 then
		for ChildIndex=0 ,NumChild-1 do
			local ChildNode = getChildAt(Node, ChildIndex);
			REA:GetAllChilds(ChildNode,AllChild);
		end;
	end;
end


-----------------------------------------------------------------------------------	
-- Draw status of vehicle
-----------------------------------------------------------------------------------
function REA:DrawStatus(vehicle,dt)

	--------------------------------------------------------------------
	-- Init global variables
	--------------------------------------------------------------------
	if vehicle.timer == nil or vehicle.GUISlip == nil then
		vehicle.timer = 0;
		vehicle.GUIMotorLoad = 0;
		vehicle.GUISlip = 0;
	end;
	
	--------------------------------------------------------------------
	-- Get engine Load
	--------------------------------------------------------------------
	local Slip = 0;
	if vehicle.spec_wheels.SlipSmoothed ~= nil then
		Slip = REA:RoundValue(vehicle.spec_wheels.SlipSmoothed);
		-- Slip is 0-100%
		if Slip > 100 then
			Slip = 100;
		elseif Slip < 0 then
			Slip = 0;
		end
	end;

	--------------------------------------------------------------------
	-- Get engine Load
	--------------------------------------------------------------------
	-- Calculate motor load
	local MotorLoad = REA:RoundValue(vehicle.spec_motorized.smoothedLoadPercentage * 100);
	-- Motor load is 0-100%
	if MotorLoad > 100 then
		MotorLoad = 100;
	elseif MotorLoad < 0 then
		MotorLoad = 0;
	end

	--------------------------------------------------------------------
	-- Uppdate every 50ms
	if vehicle.timer > 70 then
		--------------------------------------------------------------------
		-- slip
		if Slip ~= nil then
			vehicle.GUISlip = Slip;
		end;
		-- Motor load
		if MotorLoad ~= nil then
			vehicle.GUIMotorLoad = MotorLoad;
		end;
		-- Reset timer
		vehicle.timer = 0;
	end;
	-- Add time
	vehicle.timer = vehicle.timer + dt;

	--------------------------------------------------------------------
	-- Prepare overlays and text
	--------------------------------------------------------------------
	-- Create overlays
	local OverlaySlip = 1;
	local OverlayLoad = 2;
	-- Transparancy
	local Transparancy = 0.6;
	-- Create overlay for slip
	if REA.overlay[OverlaySlip] == nil then
		table.insert(REA.overlay,createImageOverlay(REA.FilePath .. "media/SLIP_ICON.dds"));
		setOverlayColor(REA.overlay[OverlaySlip], 0, 1, 0, Transparancy);
	end;
	-- Create overlay for load
	if REA.overlay[OverlayLoad] == nil then
		table.insert(REA.overlay,createImageOverlay(REA.FilePath .. "media/LOAD_ICON.dds"));
		setOverlayColor(REA.overlay[OverlayLoad], 0, 1, 0, Transparancy);
	end;

	-- Text settings
	local FontSize = 0.017;
	local TextPadding = 0.001;
	UiScale = 1;
	if g_gameSettings.uiScale ~= nil then
		UiScale = g_gameSettings.uiScale;
	end
	local Width = ((FontSize + TextPadding) * 0.8 ) * UiScale;
	local Height = (((FontSize + TextPadding) * 0.8 ) * 2 ) * UiScale;
	local FontsizeWithScale = FontSize * UiScale;

	-- Get speed gauge center
	local SpeedGaugeCenterX = g_currentMission.inGameMenu.hud.speedMeter.gaugeCenterX
	local SpeedGaugeCenterY = g_currentMission.inGameMenu.hud.speedMeter.gaugeCenterY
	local posY = SpeedGaugeCenterY * 0.05;
	local LoadPosX = SpeedGaugeCenterX * (1 - (0.10 * UiScale));
	local SlipPosX = SpeedGaugeCenterX * (1 - (0.15 * UiScale));

	--------------------------------------------------------------------
	-- Write GUI
	-- Render overlay
	renderOverlay(REA.overlay[OverlaySlip], SlipPosX, posY, Width, Height);
	renderOverlay(REA.overlay[OverlayLoad], LoadPosX, posY, Width, Height);
	-- Render text
	setTextColor(0,1,0,1)
	setTextAlignment(RenderText.ALIGN_LEFT)
	setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_BOTTOM)
	setTextBold(false)
	renderText(SlipPosX + Width + (TextPadding * 2), posY + (Height / 2) - (FontsizeWithScale / 2), FontsizeWithScale, vehicle.GUISlip .. " %")
	renderText(LoadPosX + Width + (TextPadding * 2), posY + (Height / 2) - (FontsizeWithScale / 2), FontsizeWithScale, vehicle.GUIMotorLoad .. " %")
	-- Thanks to Mogli fixing this
	setTextAlignment( RenderText.ALIGN_LEFT ) 
	setTextVerticalAlignment( RenderText.VERTICAL_ALIGN_BASELINE )
	setTextColor(1, 1, 1, 1) 


end


-----------------------------------------------------------------------------------	
-- Function to calculate friction and add rolling resistance
-----------------------------------------------------------------------------------
function REA:UpdateWheels(spec_wheels,spec_crawlers,MotorizedVehicle,IgnoreRollingResistance,dt)

	-- How many wheels do the vehicle have
	local numWheels = table.getn(spec_wheels.wheels);

	-- Check if wheels added to physics
	if spec_wheels.isAddedToPhysics then

		-- Tiretypes
		local TireTypeMUD = 1;
		local TireTypeOFFROAD = 2;
		local TireTypeSTREET = 3;
		local TireTypeCRAWLER = 4;

		-- Loop to calculate and update fricton, rolling resistance and sideway resistance for each wheel
		for Wheel=1,numWheels do
			-- Save to local variable wheel
			local wheel = spec_wheels.wheels[Wheel];

			-- Check if wheel shape is created
			if wheel.wheelShapeCreated then
				-- Factors for different wheel typs
				local RollingResistanceWheelFactor = 1;
				local SidewayResistanceWheelFactor = 1;
				local FrictionWheelFactor = 1;
				-- Small wheels
				if wheel.radiusOriginal < REA.MinWheelRadius then
					RollingResistanceWheelFactor = 0.5;
					SidewayResistanceWheelFactor = 1;
					FrictionWheelFactor = 2;
					-- print info
					if wheel.WheelToSmall == nil then
						-- Wheel name
						local Name = "";
						if wheel.repr ~= nil then
							if getName(wheel.repr) ~= nil then
								Name = getName(wheel.repr);
							end;
						end;
						--Print info
						print("----------------------")
						print("Small wheel, this wheel will get limited effects by REA")
						print("Name: " .. spec_wheels:getFullName() .. ": " .. Name ..  ", Wheel size: " .. wheel.radiusOriginal * 2 .. "m , Min size: " .. REA.MinWheelRadius * 2 .. "m")
						print("----------------------")					
						wheel.WheelToSmall = true;
					end;
				end;
				--Crawler tracks
				if wheel.tireType == TireTypeCRAWLER then
					RollingResistanceWheelFactor = 0.3;
				end;

				-- Ground types
				local ROAD = 1;
				local HARD_TERRAIN = 2;
				local SOFT_TERRAIN = 3;
				local FIELD = 4;
				-- Get ground type
				local groundType = 0;
				if wheel.densityType ~= nil and wheel.lastColor[4] ~= nil then
					local isOnField = wheel.densityType ~= 0;
					local depth = wheel.lastColor[4];
					groundType = WheelsUtil.getGroundType(isOnField, wheel.contact ~= Wheels.WHEEL_GROUND_CONTACT, depth);
				end;
				-- Read width and Radius to use when calculating frictino
				local ActWheeleWidth = wheel.width;
				local ActWheeleRadius = wheel.radiusOriginal;
				-- Read sink into the ground
				local ActWheelSink = 0.01;
				if wheel.sink ~= nil then
					ActWheelSink = math.abs(wheel.sink);
				end;
				-- If REA dynamic dirt activated check if wheel is in a lowspot with water
				local WheelInLowspotWithWater = false;
				if REA.DynamicDirtActivated then
					WheelInLowspotWithWater = wheel.InLowspotWithWater;
				end;

				------------------------------------------------------
				-- Calculate and update friction for wheel
				------------------------------------------------------
				-- Calculate friction of wheel
				if MotorizedVehicle then
					------------------------------------------------------
					-- Friction calculation
					local TireFriction = (ActWheeleWidth*2)+(ActWheeleRadius/2);
					-- If additinal wheels add more friction
					if wheel.additionalWheels ~= nil then
						local numAdditionalWheels = table.getn(wheel.additionalWheels);
						TireFriction = TireFriction+(numAdditionalWheels*(TireFriction*0.5));
					end;
					------------------------------------------------------
					-- Sink Friction calculation
					-- Read parameters for current tiretype
					local ActWheelMaxSinkReducedFrictionPercentage = REA.TireTypeMaxSinkFrictionReduced[wheel.tireType];
					local ActWheelStuckPerectangeLevel = REA.TireTypeSinkStuckLevel[wheel.tireType];
					-- If wheel is in a lowspot make wheel able to get stuck
					if WheelInLowspotWithWater then
						ActWheelMaxSinkReducedFrictionPercentage = REA.TireTypeMaxSinkFrictionReducedLowSpot;
						ActWheelStuckPerectangeLevel = REA.TireTypeSinkStuckLevelLowSpot;
					end;
					-- Calculate sink percentage
					local ActWheelSinkPercentage = (ActWheelSink / (REA.WheelRadiusMaxSinkFactor*ActWheeleRadius))*100;
					local FrictionFactorBySink = 1;
					local MinSpeedToUpdateFriction = 0.3;
					-- Update friction if wheel is turning
					if wheel.SpeedBasedOnXdrive > MinSpeedToUpdateFriction then
						-- Calculate reduced friction casued by sink
						if ActWheelSinkPercentage < ActWheelStuckPerectangeLevel then
							FrictionFactorBySink = 1-((ActWheelMaxSinkReducedFrictionPercentage*(ActWheelSinkPercentage/100))/100);
							-- If wheel is in a lowspot with water decrease friction
							if WheelInLowspotWithWater then
								FrictionFactorBySink = FrictionFactorBySink * 0.5;
							end;
						else
							FrictionFactorBySink = 0.05;
						end;
					end;

					--DebugUtil.drawDebugNode(wheel.driveNode,"Sinkfactor: " .. FrictionFactorBySink .. ", Sink: " .. ActWheelSink .. ", MaxSink: " .. REA.WheelRadiusMaxSinkFactor*ActWheeleRadius .. ", TireType: " .. wheel.tireType, false)

					------------------------------------------------------
					-- Add the calculated friction to wheel
					wheel.frictionScale = (TireFriction*FrictionFactorBySink)*FrictionWheelFactor;
				-- If vehicle not motorized use higher friction to avoid strange behavior when towing
				else
					-- use default value
					-- DEBUG
					--DebugUtil.drawDebugNode(wheel.driveNode,"Wheel: Ignored, attached to motorized vehicle", false)
				end;

				------------------------------------------------------
				-- Rolling and sideway resistance for wheel
				------------------------------------------------------
				if wheel.node ~= nil and wheel.wheelShape ~= nil then
					local MinSpeedToAddForce = 0.05;
					local ActWheelLoad = 0.000;

					-- Save load on wheel to use for rolling resistance calculation
					if getWheelShapeContactForce(wheel.node, wheel.wheelShape) ~= nil and wheel.contact ~= Wheels.WHEEL_NO_CONTACT then
						ActWheelLoad = math.max(getWheelShapeContactForce(wheel.node, wheel.wheelShape),ActWheelLoad);
					end;
					-- Smoothe force
					if wheel.SmootheWheelLoad == nil then
						wheel.SmootheWheelLoad = 0;
					end;
					wheel.SmootheWheelLoad =  (wheel.SmootheWheelLoad*0.9)+(ActWheelLoad*0.1);
					local MinLoad = 0.01;

					if (wheel.RollingDirectionSpeed >= MinSpeedToAddForce or wheel.SideWaySpeed >= MinSpeedToAddForce) and wheel.SmootheWheelLoad >= MinLoad then
						local SidewayForceToAdd = 0;
						local RollingForceToAdd = 0;

						-- Rolling resistance in rolling direction
						------------------------------------------------------
						-- Calculate force to add
						if wheel.RollingDirectionSpeed >= MinSpeedToAddForce and not IgnoreRollingResistance then
							-- Rolling reistance coefficient = sqrt(WheelSink(m)*((WheelRadius(m)*2)))
							-- Calculate coefficient
							local ActWheelRollConf = math.sqrt(ActWheelSink/(ActWheeleRadius*2));
							-- If coefficient to low use min value
							if ActWheelRollConf < REA.TireTypeMinRollingCoeff[wheel.tireType] then
								ActWheelRollConf  = REA.TireTypeMinRollingCoeff[wheel.tireType];
							end;
							-- Rolling resistance(kN) = coefficient*(Wheelload(kN)/WheelRadius(m))
							-- Calculate resistance force
							local ActWheelRollForce = ActWheelRollConf*(wheel.SmootheWheelLoad/ActWheeleRadius);
							-- In case of negative force, use zero force
							if ActWheelRollForce < 0 then
								ActWheelRollForce = 0;
							end;
							-- Factor of calulated force to add
							local RollingResistanceForceFactor = 0.4 * RollingResistanceWheelFactor;
							-- Calculate force with force factor
							RollingForceToAdd = ActWheelRollForce*RollingResistanceForceFactor;
							-- Add force slowly in low speed
							if wheel.RollingDirectionSpeed < 1 then
								RollingForceToAdd = RollingForceToAdd*(wheel.RollingDirectionSpeed * 1);
							end;
						end;
						-- Sideway resistance
						------------------------------------------------------
						-- Calculate force to add
						if wheel.SideWaySpeed >= MinSpeedToAddForce then
							-- Rolling reistance coefficient = sqrt(WheelSink(m)*((WheelRadius(m)*2)))
							-- Min sink depending on groundtype
							local MinSink = 0;
							if groundType == SOFT_TERRAIN then
								MinSink = 0.04;
							elseif groundType == FIELD then
								MinSink = 0.06;
							end;
							-- Calculate coefficient
							local ActWheelRollConf = math.sqrt(math.max(MinSink,ActWheelSink)/(ActWheeleRadius*2));
							-- If coefficient to low use min value
							if ActWheelRollConf < REA.TireTypeMinRollingCoeff[wheel.tireType] then
								ActWheelRollConf  = REA.TireTypeMinRollingCoeff[wheel.tireType];
							end;
							-- Rolling resistance(kN) = coefficient*(Wheelload(kN)/WheelRadius(m))
							-- Calculate resistance force
							local ActWheelRollForce = ActWheelRollConf*(wheel.SmootheWheelLoad/ActWheeleRadius);
							-- In case of negative force, use zero force
							if ActWheelRollForce < 0 then
								ActWheelRollForce = 0;
							end;
							-- Factor of calulated farco to add
							local SidewayResistanceForceFactor = 1.0 * SidewayResistanceWheelFactor;
							if IgnoreRollingResistance then
								SidewayResistanceForceFactor = SidewayResistanceForceFactor / 2;
							end;
							-- Calculate force with force factor
							SidewayForceToAdd = ActWheelRollForce*SidewayResistanceForceFactor;
							-- Add force slowly in low speed
							if wheel.SideWaySpeed < 1 then
								SidewayForceToAdd = SidewayForceToAdd*(wheel.SideWaySpeed * 1);
							end;
						end;
						------------------------------------------------------
						-- Add force in the other direction fo the moving direction
						local LForceX, LForceY, LForceZ = localDirectionToLocal(wheel.REASpeedNode,wheel.node,-(wheel.SideWayMovingDirection*SidewayForceToAdd),0,-(wheel.RollingMovingDirection*RollingForceToAdd));						
						local WForceX, WForceY, WForceZ = localDirectionToWorld(wheel.node,LForceX,LForceY,LForceZ);
						-- Get translation where force should be added
						local WheelX, WheelY, WheelZ = getTranslation(wheel.driveNode);
						-- Add the calculated force to physics
						addForce (wheel.node, WForceX, WForceY, WForceZ, WheelX, WheelY, WheelZ, true);

						-- DEBUG
						--local RollingDirection = "Rolling: D=" .. wheel.RollingMovingDirection
						--local SidewayDirection = "Sideway: D=" .. wheel.SideWayMovingDirection
						--local RollingDirection = "Rolling: D=" .. wheel.RollingMovingDirection .. " F=" .. REA:RoundValueTwoDecimals(-(wheel.RollingMovingDirection*RollingForceToAdd)) .. " S=" .. REA:RoundValueTwoDecimals(wheel.RollingDirectionSpeed)
						--local SidewayDirection = "Sideway: D=" .. wheel.SideWayMovingDirection .. " F=" .. REA:RoundValueTwoDecimals(-(wheel.SideWayMovingDirection*SidewayForceToAdd)) .. " S=" .. REA:RoundValueTwoDecimals(wheel.SideWaySpeed)
						--DebugUtil.drawDebugNode(wheel.driveNode,RollingDirection .. ", " .. SidewayDirection .. ", L / F: " .. REA:RoundValueTwoDecimals(wheel.SmootheWheelLoad) .. " / " .. REA:RoundValueTwoDecimals(wheel.frictionScale), false)
						--DebugUtil.drawDebugNode(wheel.driveNode,"Friction: " .. wheel.frictionScale, false)

						--DebugUtil.drawDebugReferenceAxisFromNode(wheel.repr)

					end;
				end;
			end;
		end;
	end;
end;


--------------------------------------------------------------------
-- Function to calculate slip
--------------------------------------------------------------------
function REA:CalcSlip(vehicle,dt)
	-- How many wheels do the vehicle have
	local numWheels = table.getn(vehicle.spec_wheels.wheels);
	-- Get speed
	local VehicleSpeed = vehicle:getLastSpeed();
	-- Loop to get average speed of all wheels
	local TotalWheelSpeed = 0;
	for Wheel=1,numWheels do
		-- Save active wheel to local wheel
		local Actwheel = vehicle.spec_wheels.wheels[Wheel];
		-- Get speed of wheel
		-- If speed was not calculated by server calculate speed based on xDrive
		if Actwheel.SpeedBasedOnXdrive ~= nil then
			TotalWheelSpeed = Actwheel.SpeedBasedOnXdrive + TotalWheelSpeed;			
		end;
	end;
	-- Smoothe average wheelspeed
	if vehicle.spec_wheels.AverageSpeedSmoothed == nil then
		vehicle.spec_wheels.AverageSpeedSmoothed = 0;
	end;
	vehicle.spec_wheels.AverageSpeedSmoothed = REA:SmootheValue(vehicle.spec_wheels.AverageSpeedSmoothed,TotalWheelSpeed / numWheels);
	-- Calculate slip
	if vehicle.spec_wheels.AverageSpeedSmoothed > 0.2 then
		-- Calculate differance
		local SpeedDiff = math.abs(VehicleSpeed - vehicle.spec_wheels.AverageSpeedSmoothed);
		if SpeedDiff > 0.2 and VehicleSpeed < vehicle.spec_wheels.AverageSpeedSmoothed then
			-- Calculate slip
			local Slip = (SpeedDiff / vehicle.spec_wheels.AverageSpeedSmoothed) * 100;
			vehicle.spec_wheels.SlipSmoothed = REA:RoundValue(REA:SmootheValue(vehicle.spec_wheels.SlipSmoothed,Slip));
		else
			vehicle.spec_wheels.SlipSmoothed = 0;
		end;
	else
		vehicle.spec_wheels.SlipSmoothed = 0;
	end;
end;


-----------------------------------------------------------------------------------	
-- Function to determine which tireType based on tireTrackAtlasIndex
-----------------------------------------------------------------------------------
function REA:DetermineTireType(tireTrackAtlasIndex)
	-- Constants to use for each tireTypeName
	local TireTypeMUD = "mud";
	local TireTypeOFFROAD = "offRoad";
	local TireTypeSTREET = "street";
	local TireTypeCRAWLER = "crawler";
	-- Value to return
	local tireTypeName = TireTypeMUD;
	-- Check tiretrackindex to see if value present
	if tireTrackAtlasIndex ~= nil then
		-- Check number to determine which tiretypename
		if tireTrackAtlasIndex == 0 then
			tireTypeName = TireTypeMUD;
		elseif tireTrackAtlasIndex == 1 then
			tireTypeName = TireTypeSTREET;
		elseif tireTrackAtlasIndex == 2 then
			tireTypeName = TireTypeOFFROAD;
		elseif tireTrackAtlasIndex == 3 then
			tireTypeName = TireTypeOFFROAD;
		elseif tireTrackAtlasIndex == 4 then
			tireTypeName = TireTypeSTREET;
		elseif tireTrackAtlasIndex == 5 then
			tireTypeName = TireTypeCRAWLER;
		elseif tireTrackAtlasIndex == 6 then
			tireTypeName = TireTypeCRAWLER;
		elseif tireTrackAtlasIndex == 7 then
			tireTypeName = TireTypeCRAWLER;
		elseif tireTrackAtlasIndex == 8 then
			tireTypeName = TireTypeSTREET;
		elseif tireTrackAtlasIndex == 9 then
			tireTypeName = TireTypeMUD;
		elseif tireTrackAtlasIndex == 10 then
			tireTypeName = TireTypeOFFROAD;
		elseif tireTrackAtlasIndex == 11 then
			tireTypeName = TireTypeOFFROAD;
		elseif tireTrackAtlasIndex == 12 then
			tireTypeName = TireTypeOFFROAD;
		elseif tireTrackAtlasIndex == 13 then
			tireTypeName = TireTypeCRAWLER;
		elseif tireTrackAtlasIndex == 14 then
			-- Not used
			tireTypeName = TireTypeMUD;
		elseif tireTrackAtlasIndex == 15 then
			-- Not used
			tireTypeName = TireTypeMUD;
		else
			tireTypeName = TireTypeMUD;
		end
	end	
	-- Return tireType
	return WheelsUtil.getTireType(tireTypeName);
end


-----------------------------------------------------------------------------------	
-- Function to round value, delete decimals
-----------------------------------------------------------------------------------
function REA:RoundValue(x)
	return x>=0 and math.floor(x+0.5) or math.ceil(x-0.5)
end


-----------------------------------------------------------------------------------	
-- Function to round value with two decimals
-----------------------------------------------------------------------------------
function REA:RoundValueTwoDecimals(x)
	x = x*100;
	x = x>=0 and math.floor(x+0.5) or math.ceil(x-0.5);
	x = x/100;
	return x;
end


-----------------------------------------------------------------------------------	
-- Function to get wheel sink on client side
-----------------------------------------------------------------------------------
function REA:GetWheelSinkClientSide(wheel)
	-- Get world translation of wheel and terrain height
	local x,y,z = getWorldTranslation(wheel.repr);
	local TerrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
	-- Calculate sink
	local WheelSink = math.abs(REA:RoundValueTwoDecimals((y - TerrainHeight)-wheel.radiusOriginal));
	return WheelSink;
end


-----------------------------------------------------------------------------------	
-- Function to get wheelslip
-----------------------------------------------------------------------------------
function REA:GetWheelSlipFactor(WheelSpeed,VehicleSpeed)
	local WheelSlip = 0;
	if WheelSpeed > 1 then
		-- Calculate differance
		local SpeedDiff = math.abs(VehicleSpeed - WheelSpeed);
		if SpeedDiff > 1 and VehicleSpeed < WheelSpeed then
			-- Calculate slip
			WheelSlip = REA:RoundValueTwoDecimals(SpeedDiff / WheelSpeed);
		end;
	end;
	return MathUtil.clamp(WheelSlip, 0, 1);
end


-----------------------------------------------------------------------------------	
-- Function to get if wheel is on soft ground
-----------------------------------------------------------------------------------
function REA:GetOnSoftGround(wheel)
	-- Get ground type
	local groundType = 0;
	if wheel.lastColor[4] ~= nil then
		local isOnField = false;
		local isOnRoad = false;
		local depth = wheel.lastColor[4];
		groundType = WheelsUtil.getGroundType(isOnField, isOnRoad, depth);
	end;
	local WheelIsOnSoftGround = false;
	if (groundType == 3 or groundType == 4) or (wheel.lastTerrainValue > 0 and wheel.lastTerrainValue < 5) then
		WheelIsOnSoftGround = true;
	end;
	return WheelIsOnSoftGround;
end

-----------------------------------------------------------------------------------	
-- Function to determine if wheel is in a lowspot with
-----------------------------------------------------------------------------------
function REA:GetIsInLowspotWithWater(Wheel)
	-- Get translation of wheel
	local WheelX, WheelY, WheelZ = getWorldTranslation(Wheel.driveNode);
	-- Get number of lowspots
	local NumOfLowspots = table.getn(WheelsUtil.LowspotWaterLevelNode);
	-- Loop to calculate and update fricton, rolling resistance and sideway resistance for each wheel
	for LowSpot=1,NumOfLowspots do
		-- Get depth of first lospot to determine if water in low spots
		local lX, WaterLevel, lZ = getTranslation(WheelsUtil.LowspotWaterLevelNode[LowSpot]);
		-- Check if there is water in lowspots
		if WaterLevel > 0 then
			-- Get distance betweene wheel and lowspot
			local LowspotX, LowspotY, LowspotZ = getWorldTranslation(WheelsUtil.LowspotRootNode[LowSpot]);
			-- Calculate distance
			local DistanceX = math.abs(WheelX-LowspotX);
			local DistanceY = math.abs(WheelY-LowspotY);
			local DistanceZ = math.abs(WheelZ-LowspotZ);
			-- Determine if the wheel in range of lowspot
			if DistanceX <= WheelsUtil.LowspotSize[LowSpot] and DistanceZ <= WheelsUtil.LowspotSize[LowSpot] then
				-- Check if wheel is below waterlevel
				if (DistanceY - WaterLevel) - Wheel.radiusOriginal <= 0 then
					return true;
				end;
			end;
		else
			return false;
		end;
	end;
	return false;
end


-----------------------------------------------------------------------------------	
-- Function to smoothe value
-----------------------------------------------------------------------------------
function REA:SmootheValue(SmoothedValue,RealValue)
	-- If no smoothevalue use the real value
	if SmoothedValue == nil then
		ActValue = RealValue;
	else
		ActValue = SmoothedValue;
	end;
	-- Return the smoothed value
	return (ActValue*0.9)+(RealValue*0.1);
end


-----------------------------------------------------------------------------------	
-- Function to set new value during set time
-----------------------------------------------------------------------------------
function REA:SetValueWithTime(ActValue,TargetValue,OriginalValue,Time,dt)
	-- If values nil return zero
	if ActValue == nil or TargetValue == nil then
		return 0;
	end;
	-- If differens change value over time
	if ActValue ~= TargetValue then
		-- If difference betweene original value and target value calculate differens
		local DiffValue = TargetValue - OriginalValue;
		-- Calculate how much is target should change
		local NewValue = ActValue + (DiffValue * (dt / Time));
		-- Check if new value is outside target area
		if NewValue > TargetValue and TargetValue > OriginalValue then
			NewValue = TargetValue;
		elseif NewValue < TargetValue and TargetValue < OriginalValue then
			NewValue = TargetValue;
		end;
		-- Return new value
		return NewValue;
	else
		-- If no differens return Target value
		return TargetValue;
	end;
end


-----------------------------------------------------------------------------------	
-- Function to calculate filling speed in thousend liters per second
-----------------------------------------------------------------------------------
function REA:CalcFillSpeed(LastFillLevel,NewFillLevel,dt)
	-- Initialize liters per second
	local ThousendLiterPerSecond  = 0;
	-- If Fill level changed calculate fill speed
	if NewFillLevel > LastFillLevel then
		-- Calculate fill speed
		ThousendLiterPerSecond = ((NewFillLevel - LastFillLevel) / 1000) / (dt / 1000);
	end;
	-- Return last fill level and liter per seconds
	return NewFillLevel, ThousendLiterPerSecond;
end


-----------------------------------------------------------------------------------	
-- Function to calculate speed based on xDrive(wheel position)
-----------------------------------------------------------------------------------
function REA:WheelSpeedFromXdrive(wheel,dt)
	-- initialize last xDrive
	if wheel.xDriveLast == nil then
		wheel.xDriveLast = 0;
		wheel.xDriveLastKMH = 0;
		wheel.xDriveDirection = 0;
		wheel.xDriveLastDirection = 0;
		wheel.xDriveSignedSpeedSmoothed = 0;
	end;
	-- Get differance from last call
	local RadDiff = wheel.netInfo.xDrive - wheel.xDriveLast;
	-- Save last xDrive
	wheel.xDriveLast = wheel.netInfo.xDrive;
	-- If wheel starts a new turn assume that the speed is constant and return last calulated speed
	if math.abs(RadDiff) > 3.14 then
		-- Return speed in KMH
		wheel.SpeedBasedOnXdrive = wheel.xDriveLastKMH;
		wheel.DirectionBasedOnXdrive = wheel.xDriveLastDirection;
	-- If not a new turn calculate a neww speed
	else
		-- Calculate speed
		local DistanceTraveled = REA:RoundValueTwoDecimals(RadDiff * wheel.radiusOriginal);
		local MeterPerSecond = DistanceTraveled/(dt/1000);
		-- Convert to KMH
		local WheelSpeedSigned = MeterPerSecond*3.6;
		-- Smoothe value
		wheel.xDriveSignedSpeedSmoothed =  (wheel.xDriveSignedSpeedSmoothed*0.7)+(WheelSpeedSigned*0.3);
		-- Save direction of wheel rotation
		local WheelSpeedSignedSmoothed = wheel.xDriveSignedSpeedSmoothed;
		local WheelSpeedSmoothed = math.abs(WheelSpeedSignedSmoothed);
		local MinSpeedForUpdate = 0.25;
		if WheelSpeedSmoothed >= MinSpeedForUpdate then
			if WheelSpeedSignedSmoothed > 0 then
				wheel.xDriveDirection = 1;
			elseif WheelSpeedSignedSmoothed < 0 then
				wheel.xDriveDirection = -1;
			end;
		elseif WheelSpeedSmoothed < MinSpeedForUpdate then
			wheel.xDriveDirection = 0;
			wheel.xDriveSignedSpeedSmoothed = 0;
		end;
		-- Save speed if wheel starts a new turn
		wheel.xDriveLastKMH = WheelSpeedSmoothed;
		wheel.xDriveLastDirection = wheel.xDriveDirection;
		-- Return speed in KMH
		wheel.SpeedBasedOnXdrive = WheelSpeedSmoothed;
		wheel.DirectionBasedOnXdrive = wheel.xDriveDirection;
	end;
end


-----------------------------------------------------------------------------------	
-- Function to calculate expected and actual moved distance of wheel 
-----------------------------------------------------------------------------------
function REA:WheelDistanceFromXdrive(wheel,dt)
	-- initialize last xDrive
	if wheel.DistancexDriveLast == nil then
		wheel.DistanceLastPosition = {0,0,0};
		wheel.DistancexDriveLast = 0;
	end;
	-- Get position of wheel
	local x,y,z = getWorldTranslation(wheel.repr);
	-- Calculate differance in position from last call
	local dx, dy, dz = worldDirectionToLocal(wheel.repr, x-wheel.DistanceLastPosition[1], y-wheel.DistanceLastPosition[2], z-wheel.DistanceLastPosition[3]);
	-- Save position for next call
	wheel.DistanceLastPosition[1], wheel.DistanceLastPosition[2], wheel.DistanceLastPosition[3] = x, y, z;

	-- Get differance from last call
	local RadDiff = math.abs(wheel.DistancexDriveLast - wheel.netInfo.xDrive);
	-- Save last xDrive
	wheel.DistancexDriveLast = wheel.netInfo.xDrive;
	-- If wheel starts a new turn assume no change and return zero change
	if RadDiff > 3.14 then
		wheel.ExpectedDistanceTraveled = 0;
		wheel.ActualDistanceTraveled = 0;
	-- If not a new turn calculate distance traveled
	else
		-- Calculate expected moved distance
		wheel.ExpectedDistanceTraveled = RadDiff * wheel.radiusOriginal;
		wheel.ActualDistanceTraveled = MathUtil.vector3Length(dx, dy, dz)
	end;
end


-----------------------------------------------------------------------------------	
-- Calculate sideway speed of wheel
-----------------------------------------------------------------------------------
function REA:UpdateWheelDirectionAndSpeed(wheel,dt)
	-- Create node to calculate speed and direction
	if wheel.REASpeedNode == nil then
		local REASpeedNode = createTransformGroup("REASpeedNode")
		link(wheel.node, REASpeedNode);
		setTranslation(REASpeedNode, getTranslation(wheel.driveNode));
		setRotation(REASpeedNode,0,0,0);
		setScale(REASpeedNode, 1, 1, 1)
		wheel.REASpeedNode = REASpeedNode;
	end;
	-- Update steeting angle of wheel
	if wheel.steeringAngle ~= 0 then 
		setRotation(wheel.REASpeedNode,0,wheel.steeringAngle,0);
	end;

	-- Calculate speed based on the position change
	local x,y,z = getWorldTranslation(wheel.REASpeedNode);
	if wheel.REASpeedLastPosition == nil then
		wheel.REASpeedLastPosition = {x,y,z};
	end;
	local SpeedDiffX, SpeedDiffY, SpeedDiffZ = worldDirectionToLocal(wheel.REASpeedNode, x-wheel.REASpeedLastPosition[1], y-wheel.REASpeedLastPosition[2], z-wheel.REASpeedLastPosition[3]);
	wheel.REASpeedLastPosition[1], wheel.REASpeedLastPosition[2], wheel.REASpeedLastPosition[3] = x, y, z;

	-- Rolling direction, calculate speed of wheel in direction
	wheel.RollingDirectionSpeed, wheel.RollingDirectionSpeedSigned, wheel.RollingMovingDirection = REA:CalcSpeedAndDirection(wheel.RollingDirectionSpeedSigned,SpeedDiffZ,dt)
	-- SideWay direction, calculate speed of wheel in direction
	wheel.SideWaySpeed, wheel.SideWaySpeedSigned, wheel.SideWayMovingDirection = REA:CalcSpeedAndDirection(wheel.SideWaySpeedSigned,SpeedDiffX,dt)

end;


-----------------------------------------------------------------------------------	
-- Function to calculate speed and direcrtion based on movement
-----------------------------------------------------------------------------------
function REA:CalcSpeedAndDirection(LastSpeedSigned,MovedDistance,dt)
	-- Calculate speed of wheel
	local SpeedSigned = (MovedDistance / dt)*3600;
	local SpeedSignedSmoothe = REA:SmootheValue(LastSpeedSigned,SpeedSigned)
	local Speed = SpeedSignedSmoothe;
	-- Remove sign
	if Speed < 0 then
		Speed = Speed*(-1); 
	end;
	-- Moving direction
	local MovingDirection = 0;
	if SpeedSigned > 0.01 then
		MovingDirection = 1;
	elseif SpeedSigned < -0.01 then
		MovingDirection = -1;
	end;
	-- Return result
	return Speed, SpeedSignedSmoothe, MovingDirection;
end


-----------------------------------------------------------------------------------	
-- Function for adjusting speed if PTO tourqe reaches max motor tourqe
-----------------------------------------------------------------------------------
function REA:AdjustSpeedIfPtpPowerMaxed(vehicle,dt)
	local motor = vehicle.spec_motorized.motor;

	-- Calculate avalible power
	local PowerAvalible = motor.motorAvailableTorque * motor.lastMotorRpm *math.pi/30
	-- Lowest speed setpoint
	local LowSpeedSetpoint = 3;
	-- Get speedlimit of motor
	local SpeedLimit = 1000;
	if motor.speedLimit ~= nil then
		if motor.speedLimit < SpeedLimit then
			SpeedLimit = motor.speedLimit;
		end;
	end;
	-- Get total power need by filling from all implements
	local TotalPowerNeedByFilling = 0;
	local HighestPowerNeed = 0;
	local attachedImplements;
	if vehicle.getAttachedImplements ~= nil then
		attachedImplements = vehicle:getAttachedImplements();
		for _, implement in pairs(attachedImplements) do
			if implement.object ~= nil then
				if implement.object.spec_powerConsumer ~= nil then
					-- Save to local power consumer
					local PowerConsumer = implement.object.spec_powerConsumer;
					-- If power is consumed by implement add power to total amount consumed by all implements
					if PowerConsumer.PowerToAddPTOSmoothed ~= nil then
						-- Initialize original speed limit of implement
						if PowerConsumer.OriginalSpeedlimit == nil then
							PowerConsumer.OriginalSpeedlimit = implement.object.speedLimit;
							PowerConsumer.CurrentSpeedLimit = PowerConsumer.OriginalSpeedlimit;
							PowerConsumer.SpeedRegulatorTimer = 0;
						end;
						-- Speedlimit of implement
						if implement.object:doCheckSpeedLimit() then
							-- Power consumed by filling
							TotalPowerNeedByFilling = PowerConsumer.PowerToAddPTOSmoothed + TotalPowerNeedByFilling;
							-- Save highest power need and speedlimit to know which implemnt to use as speedlimiter
							if PowerConsumer.PowerToAddPTOSmoothed > HighestPowerNeed then
								HighestPowerNeed = PowerConsumer.PowerToAddPTOSmoothed;
								SpeedLimit = PowerConsumer.OriginalSpeedlimit;
							end;
						end;
					end;
				end;
			end;
		end;
		-- Adjust speed depending on power need
		for _, implement in pairs(attachedImplements) do
			if implement.object ~= nil then
				if implement.object.spec_powerConsumer ~= nil then
					-- Save to local power consumer
					local PowerConsumer = implement.object.spec_powerConsumer;
					if PowerConsumer.PowerToAddPTOSmoothed ~= nil then
						-- If implement uses power from filling check if power needed and is the most consuming adjust speedlimit
						if PowerConsumer.PowerToAddPTOSmoothed == HighestPowerNeed and HighestPowerNeed ~= 0 then
							-- Regulator for adjusting speed depending on poweruse by filling
							PowerConsumer.CurrentSpeedLimit,PowerConsumer.SpeedRegulatorTimer = REA:SpeedPowerRegulator(TotalPowerNeedByFilling,PowerAvalible*0.9,LowSpeedSetpoint,SpeedLimit,PowerConsumer.CurrentSpeedLimit,PowerConsumer.SpeedRegulatorTimer,dt);
							-- Add speed limit to implement
							implement.object.speedLimit = PowerConsumer.CurrentSpeedLimit;
						-- Implement is not the one consuming the most set original speedlimt
						else
							implement.object.speedLimit = PowerConsumer.OriginalSpeedlimit;
						end;
					end;
				end;
			end;
		end;
	end;
end;


-----------------------------------------------------------------------------------	
-- Update power multiplier for power consumers
-----------------------------------------------------------------------------------
function REA:UpdatePowerMultiplier(vehicle,dt)
	---------------------------------------------------------------------
	-- Check if this is a Plow, cultivator or sowingmachine
	local Plow = false;
	local Cultivator = false;
	local SowingMachine = false;
	local Combine = false;
	local Baler = false;
	local ForageWagon = false;
	-- Plow
	if vehicle.spec_plow ~= nil then
		Plow = true;
	-- Cultivator
	elseif vehicle.spec_cultivator ~= nil then
		Cultivator = true;
	-- Sowing machine
	elseif vehicle.spec_sowingMachine ~= nil then
		SowingMachine = true;
	-- Combine
	elseif vehicle.spec_combine ~= nil then
		Combine = true;
	-- Baler
	elseif vehicle.spec_baler ~= nil then
		Baler = true;
	-- Forage wagon
	elseif vehicle.spec_forageWagon ~= nil then
		ForageWagon = true;
	end;
	-- Adjust force and speed for plows, Cultivators and sowing machines
	if vehicle.spec_powerConsumer ~= nil and ( Plow or Cultivator or SowingMachine ) then
		local PowerConsumer = vehicle.spec_powerConsumer;
		if PowerConsumer.forceNode ~= nil then
			-- Save original max force
			if PowerConsumer.OriginalMaxForce == nil then
				PowerConsumer.OriginalMaxForce = PowerConsumer.maxForce;
			end;
			-- Calculate multiplier depending on type of implement and ground type
			local TargetMaxForce = PowerConsumer.OriginalMaxForce;
			-- Do not ignore rolling resistance of wheels
			PowerConsumer.IgnoreRollingResistance = true;
			if vehicle:doCheckSpeedLimit() then
				-- Get density att "ForceNode"
				local SizeOfDenityArea = 0.5;
				local SizeOffset = SizeOfDenityArea/2;
				local x0,_,z0 = localToWorld(PowerConsumer.forceNode, SizeOffset, 0, -SizeOffset);
				local x1,_,z1 = localToWorld(PowerConsumer.forceNode, -SizeOffset, 0, -SizeOffset);
				local x2,_,z2 = localToWorld(PowerConsumer.forceNode, SizeOffset, 0, SizeOffset);
				local density, area = FSDensityMapUtil.getFieldValue(x0, z0, x1, z1, x2, z2);
				-- Determine which groundtype it is
				local terrainValue = 0;
				if area > 0 then
					terrainValue = math.floor(density/area + 0.5);
				end;
				-- Determine type of implement and which multiplier to use
				-- Initialize multiplier
				local multiplier = 1;
				-- Plow
				if Plow then
					if REA.PlowMultiplier[terrainValue] ~= nil and REA.PlowSpeedAjust[terrainValue] ~= nil then
						multiplier = REA.PlowMultiplier[terrainValue];
					end;
				-- Cultivator
				elseif Cultivator then
					if REA.CultivatorMultiplier[terrainValue] ~= nil and REA.CultivatorSpeedAjust[terrainValue] ~= nil then
						multiplier = REA.CultivatorMultiplier[terrainValue];
					end;
				-- Sowing machine
				elseif SowingMachine then
					if REA.SowingMachineMultiplier[terrainValue] ~= nil and REA.SowingMachineSpeedAjust[terrainValue] ~= nil then
						multiplier = REA.SowingMachineMultiplier[terrainValue];				
					end;
				end;
				-- Adjust pulling max force
				TargetMaxForce = PowerConsumer.OriginalMaxForce * multiplier;
				-- Ignore Wheele roling resistance
				PowerConsumer.IgnoreRollingResistance = true;
			end;
			-- Save new values
			PowerConsumer.maxForce = REA:SmootheValue(PowerConsumer.maxForce,TargetMaxForce);
		end;
	end;

	---------------------------------------------------------------------
	-- Adjust force needed on PTO by filling a fillunit
	-- !COMBINE IS DISABLED AND UNDER DEVELOPMENT!
	if vehicle.spec_fillUnit ~= nil and ((vehicle.spec_powerConsumer ~= nil and (Baler or ForageWagon)) or (Combine and false)) then
		-- Save local copy of FillUnit
		local FillUnit = vehicle.spec_fillUnit;
		-- Get number of fillunits
		local numFillUnits = table.getn(FillUnit.fillUnits);
		-- Total fill level for all fillunits
		local TotalFillLevel = 0;
		-- Highest fillspeed
		local HighestFillLevel = 0;
		-- Mass of filltype in Ton/m2
		local HighestFillLevelMassTM2 = 1;
		-- Create variables for calculating fill speed
		if FillUnit.TimeLastChange == nil then
			FillUnit.TimeLastChange = 0;
			FillUnit.LastTotalFillLevel = 0;
			FillUnit.AddedFillLevel = 0;
			FillUnit.FillSpeedLS = 0;
			FillUnit.FillSpeedLSSmoothed = 0;
		end;
		-- Add time change since last fill, max 1 second
		if FillUnit.TimeLastChange < 1000 then
			FillUnit.TimeLastChange = FillUnit.TimeLastChange + dt;
		end;
		-- Search for correct fill unit and get current filllevel
		for FillUnitIndex=1, numFillUnits do
			local ActFillUnit = FillUnit.fillUnits[FillUnitIndex];
			if ActFillUnit.fillType ~= FillType.DIESEL and ActFillUnit.fillType ~= FillType.DEF then
				-- Calculate total fill speed
				TotalFillLevel = TotalFillLevel + ActFillUnit.fillLevel;
				-- Get mass of filltype from the fillunit with highest fillspeed, Ton/m2
				if ActFillUnit.fillLevel > HighestFillLevel then
					HighestFillLevel = ActFillUnit.fillLevel;
					HighestFillLevelMassTM2 = g_currentMission.fillTypeManager.fillTypes[ActFillUnit.fillType].massPerLiter * 1000;
				end;
			end;
		end;
		-- Calculate change in fill level
		FillUnit.AddedFillLevel = TotalFillLevel - FillUnit.LastTotalFillLevel;
		-- Save fill level
		FillUnit.LastTotalFillLevel = TotalFillLevel;
		-- If fillunit added fill since last update calculate fillspeed and reset value
		FillUnit.FillSpeedLS = 0;
		if FillUnit.AddedFillLevel > 0 then
			-- Calculate fillspeed Liter / second
			FillUnit.FillSpeedLS = FillUnit.AddedFillLevel / (FillUnit.TimeLastChange / 1000);
			FillUnit.TimeLastChange = 0;
			FillUnit.AddedFillLevel = 0;
		end;
		-- Smoothe fillspeed value
		FillUnit.FillSpeedLSSmoothed = REA:SmootheValue(FillUnit.FillSpeedLSSmoothed,FillUnit.FillSpeedLS);
		if FillUnit.FillSpeedLSSmoothed < 0.001 then
			FillUnit.FillSpeedLSSmoothed = 0;
		end;

		-- DEBUG
		--renderText(0.2, 0.35, 0.05,"Mass: " .. HighestFillLevelMassTM2);
		--renderText(0.2, 0.15, 0.05,"Fillspeed smoothed: " .. tostring(FillUnit.FillSpeedLSSmoothed));

		-- If combine use cutter as power consumer
		local CutterWorking = false;
		local PowerConsumer;
		if Combine then
			if vehicle.spec_combine.attachedCutters ~= nil then
				local cutters = vehicle.spec_combine.attachedCutters;
				for cutter, _ in pairs(cutters) do
					if cutter:doCheckSpeedLimit() and cutter.spec_powerConsumer ~= nil then
						PowerConsumer = cutter.spec_powerConsumer;
						CutterWorking = true;
					end;
				end;
			end;
		elseif vehicle.spec_powerConsumer ~= nil then
			PowerConsumer = vehicle.spec_powerConsumer;
		end;
		-- If vehicle is working add fillspeed power need
		if PowerConsumer ~= nil then
			-- Initiate variables
			if PowerConsumer.PowerToAddPTOSmoothed == nil then
				PowerConsumer.PowerToAddPTOSmoothed = 0;
			end;
			-- Save original values
			if PowerConsumer.OriginalNeededMinPtoPower == nil and PowerConsumer.neededMinPtoPower ~= nil then
				PowerConsumer.OriginalNeededMinPtoPower = PowerConsumer.neededMinPtoPower;
			end;
			if PowerConsumer.OriginalNeededMaxPtoPower == nil and PowerConsumer.neededMaxPtoPower ~= nil then
				PowerConsumer.OriginalNeededMaxPtoPower = PowerConsumer.neededMaxPtoPower;
			end;
			-- Add power to PTO if vehicle is working
			if vehicle:doCheckSpeedLimit() or (Combine and CutterWorking) then
				local PowerToAddPTO = 0;
				local PowerNeedByFilling = 0;
				-- If fillspeed present add power
				if FillUnit.FillSpeedLSSmoothed > 0.001 then
					-- Calculate power to be added to PTO based on filling speed
					PowerNeedByFilling = (REA.FillspeedPowerNeed * (FillUnit.FillSpeedLSSmoothed/100)) * HighestFillLevelMassTM2;
					-- Power to add PTO
					local PowerFactorForImplement = 0.5;
					if PowerConsumer.neededMinPtoPower ~= nil then
						if PowerNeedByFilling > (PowerConsumer.OriginalNeededMinPtoPower * PowerFactorForImplement) then
							PowerToAddPTO = PowerNeedByFilling - (PowerConsumer.OriginalNeededMinPtoPower * PowerFactorForImplement);
						end;
					end;
					if PowerConsumer.neededMaxPtoPower ~= nil then
						if PowerToAddPTO == 0 then
							if PowerNeedByFilling > (PowerConsumer.OriginalNeededMaxPtoPower * PowerFactorForImplement) then
								PowerToAddPTO = PowerNeedByFilling - (PowerConsumer.OriginalNeededMaxPtoPower * PowerFactorForImplement);
							end;
						end;
					end;
				end;
				-- Smoothe power to add
				PowerConsumer.PowerToAddPTOSmoothed = REA:SmootheValue(PowerConsumer.PowerToAddPTOSmoothed,PowerToAddPTO);
				-- If power to add is low set zero value
				if PowerConsumer.PowerToAddPTOSmoothed < 0.001 then
					PowerConsumer.PowerToAddPTOSmoothed = 0;
				end;
				-- Add power need
				if PowerConsumer.PowerToAddPTOSmoothed > 0 then
					if PowerConsumer.neededMinPtoPower ~= nil then
						PowerConsumer.neededMinPtoPower = PowerConsumer.OriginalNeededMinPtoPower + PowerConsumer.PowerToAddPTOSmoothed;
					end;
					if PowerConsumer.neededMaxPtoPower ~= nil then
						PowerConsumer.neededMaxPtoPower = PowerConsumer.OriginalNeededMaxPtoPower + PowerConsumer.PowerToAddPTOSmoothed;
					end;
				end;

				-- DEBUG
				--renderText(0.2, 0.15, 0.05,"Mass: " .. tostring(HighestFillspeedMassTM2));
				--renderText(0.2, 0.20, 0.05,"Power need by filling: " .. tostring(PowerNeedByFilling));
				--renderText(0.2, 0.25, 0.05,"PTO Power to add: " .. tostring(PowerConsumer.PowerToAddPTOSmoothed));

			else
				-- No power needed
				PowerConsumer.PowerToAddPTOSmoothed = 0;
				-- Reset to original values
				if PowerConsumer.neededMinPtoPower ~= nil then
					PowerConsumer.neededMinPtoPower = PowerConsumer.OriginalNeededMinPtoPower;
				end;
				if PowerConsumer.neededMaxPtoPower ~= nil then
					PowerConsumer.neededMaxPtoPower = PowerConsumer.OriginalNeededMaxPtoPower;
				end;
			end;
		end;
	end;
end


-----------------------------------------------------------------------------------	
-- Update power multiplier for power consumers
-----------------------------------------------------------------------------------
function REA:SpeedPowerRegulator(Input,Setpoint,outputMin,outputMax,LastOutput,Timer,dt)
	local timeStep = 50
	-- Add time to timer
	Timer = Timer + dt
	-- Run regulator
	if Timer > timeStep then
		-- Restart intervall timer
		Timer = 0;
		-- Calculate error
		local err = Setpoint - Input;
		-- Calculate ajustment value
		local Adjust = 0;
		if err ~= 0 then
			Adjust = err / 100;
		end;
		-- Calculate new output value
		local output = Adjust + LastOutput;
		-- Check if output in bounds
		if output > outputMax then
			output = outputMax
		elseif output < outputMin then
			output = outputMin
		end
		-- Smoothe value
		LastOutput = REA:SmootheValue(LastOutput,output);
		-- Return new output
		return LastOutput, Timer;
	end;
	-- Return last output
	return LastOutput, Timer;
end;


-----------------------------------------------------------------------------------	
-- Edited loadWheelData
-----------------------------------------------------------------------------------
function FrontloaderAttacher:onLoad(savegame)
    if self.configurations["frontloader"] ~= nil then
        local spec = self.spec_frontloaderAttacher
        local attacherJointsSpec = self.spec_attacherJoints

        spec.attacherJoint = {}
        local key = string.format("vehicle.frontloaderConfigurations.frontloaderConfiguration(%d)", self.configurations["frontloader"]-1)
        if hasXMLProperty(self.xmlFile, key..".attacherJoint") and self:loadAttacherJointFromXML(spec.attacherJoint, self.xmlFile, key..".attacherJoint") then
            table.insert(attacherJointsSpec.attacherJoints, spec.attacherJoint)

            local frontAxisLimitJoint = Utils.getNoNil(getXMLBool(self.xmlFile, key..".attacherJoint#frontAxisLimitJoint"), false)
            if frontAxisLimitJoint then
                local frontAxisJoint = Utils.getNoNil(getXMLInt(self.xmlFile, key..".attacherJoint#frontAxisJoint"), 1)
                if self.componentJoints[frontAxisJoint] ~= nil then
                    spec.frontAxisJoint = frontAxisJoint
                else
                    print("Warning: Invalid front-axis joint '"..tostring(frontAxisJoint).."' in '"..self.configFileName.."'")
                end
            end

            ObjectChangeUtil.updateObjectChanges(self.xmlFile, "vehicle.frontloaderConfigurations.frontloaderConfiguration", self.configurations["frontloader"], self.components, self)
        else
            -- first config is "no-frontloader"-option
            ObjectChangeUtil.updateObjectChanges(self.xmlFile, "vehicle.frontloaderConfigurations.frontloaderConfiguration", 1, self.components, self)
            spec.attacherJoint = nil
        end
    end
end


-----------------------------------------------------------------------------------	
-- Edited loadWheelData
-----------------------------------------------------------------------------------
function Wheels:loadWheelData(wheel, xmlFile, configKey)
	local key = "nodeLeft"
	if not wheel.isLeft then
		key = "nodeRight"
	end
	
	wheel.radius = getXMLFloat(xmlFile, configKey..".physics#radius") or wheel.radius
	if wheel.radius == nil then
		g_logManager:xmlWarning(self.configFileName, "No radius defined for wheel '%s'! Using default value of 0.5!", configKey..".physics#radius")
		wheel.radius = 0.5
	end
	
	wheel.width = getXMLFloat(xmlFile, configKey..".physics#width") or wheel.width
	if wheel.width == nil then
		g_logManager:xmlWarning(self.configFileName, "No width defined for wheel '%s'! Using default value of 0.5!", configKey..".physics#width")
		wheel.width = 0.5
	end
	
	wheel.mass = getXMLFloat(xmlFile, configKey..".physics#mass") or wheel.mass or 0.1
	local tireTypeName = getXMLString(xmlFile, configKey..".tire#tireType")
	wheel.frictionScale = getXMLFloat(xmlFile, configKey..".physics#frictionScale") or wheel.frictionScale
	wheel.maxLongStiffness = getXMLFloat(xmlFile, configKey..".physics#maxLongStiffness") or wheel.maxLongStiffness -- [t / rad]
	wheel.maxLatStiffness = getXMLFloat(xmlFile, configKey..".physics#maxLatStiffness") or wheel.maxLatStiffness -- xml is ratio to restLoad [1/rad], final value is [t / rad]
	wheel.maxLatStiffnessLoad = getXMLFloat(xmlFile, configKey..".physics#maxLatStiffnessLoad") or wheel.maxLatStiffnessLoad -- xml is ratio to restLoad, final value is [t]
	wheel.tireTrackAtlasIndex = getXMLInt(xmlFile, configKey..".tire#tireTrackAtlasIndex") or wheel.tireTrackAtlasIndex or 0

	wheel.tireType = WheelsUtil.getTireType(tireTypeName)

	wheel.widthOffset = getXMLFloat(xmlFile, configKey..".tire#widthOffset") or wheel.widthOffset or 0.0
	wheel.xOffset = getXMLFloat(xmlFile, configKey..".tire#xOffset") or wheel.xOffset or 0
	wheel.maxDeformation = getXMLFloat(xmlFile, configKey..".tire#maxDeformation") or wheel.maxDeformation or 0
	wheel.deformation = 0
	wheel.isCareWheel = Utils.getNoNil(Utils.getNoNil(getXMLBool(xmlFile, configKey..".tire#isCareWheel"), wheel.isCareWheel), true)
	wheel.smoothGroundRadius = getXMLFloat(xmlFile, configKey..".physics#smoothGroundRadius") or math.max(0.6, wheel.width*0.75)
	
	wheel.tireFilename = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".tire#filename", "", getXMLString, wheel.tireFilename)
	wheel.tireIsInverted = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".tire#isInverted", "", getXMLBool, wheel.tireIsInverted)
	wheel.tireNodeStr = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".tire#node", "", getXMLString, nil) or XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".tire#"..key, "", getXMLString, wheel.tireNodeStr)
	wheel.outerRimFilename = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".outerRim#filename", "", getXMLString, wheel.outerRimFilename)
	wheel.outerRimNodeStr = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".outerRim#node", "", getXMLString, wheel.outerRimNodeStr) or "0|0"
	wheel.outerRimWidthAndDiam = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".outerRim#widthAndDiam", "", getXMLString,  wheel.outerRimWidthAndDiam, StringUtil.getVectorNFromString, 2)
	wheel.outerRimScale = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".outerRim#scale", "", getXMLString, wheel.outerRimScale, StringUtil.getVectorNFromString, 3)
	wheel.innerRimFilename = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".innerRim#filename", "", getXMLString, wheel.innerRimFilename)
	wheel.innerRimNodeStr = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".innerRim#node", "", getXMLString, nil) or XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".innerRim#"..key, "", getXMLString, wheel.innerRimNodeStr)
	wheel.innerRimWidthAndDiam = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".innerRim#widthAndDiam", "", getXMLString, wheel.innerRimWidthAndDiam, StringUtil.getVectorNFromString, 2)
	wheel.innerRimOffset = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".innerRim#offset", "", getXMLFloat, wheel.innerRimOffset) or 0
	wheel.innerRimScale = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".innerRim#scale", "", getXMLString, wheel.innerRimScale, StringUtil.getVectorNFromString, 3);
	wheel.additionalFilename = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".additional#filename", "", getXMLString, wheel.additionalFilename)
	wheel.additionalNodeStr = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".additional#node", "", getXMLString, nil) or XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".additional#"..key, "", getXMLString, wheel.additionalNodeStr)
	wheel.additionalOffset = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".additional#offset", "", getXMLFloat,  wheel.additionalOffset) or 0
	wheel.additionalScale = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".additional#scale", "", getXMLString, wheel.additionalScale, StringUtil.getVectorNFromString, 3)
	wheel.additionalMass = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".additional#mass", "", getXMLFloat, wheel.additionalMass) or 0
	wheel.additionalWidthAndDiam = XMLUtil.getXMLOverwrittenValue(xmlFile, configKey, ".additional#widthAndDiam", "", getXMLString, wheel.additionalWidthAndDiam, StringUtil.getVectorNFromString, 2)
end


-----------------------------------------------------------------------------------	
-- Edited loadWheelPhysicsData
-----------------------------------------------------------------------------------
function Wheels:loadWheelPhysicsData(xmlFile, key, wheelnamei, wheel)
	local physicsKey = wheelnamei .. ".physics"
	if wheel.repr ~= nil then
		wheel.node = self:getParentComponent(wheel.repr)
		if wheel.node ~= 0 then
			XMLUtil.checkDeprecatedXMLElements(xmlFile, self.configFileName, key..wheelnamei.."#steeringNode", string.format("vehicle.wheels.wheelConfigurations.wheelConfiguration.wheels%s.steering#node", wheelnamei))
			local driveNodeStr = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#driveNode", getXMLString, nil, nil, nil)
			wheel.driveNode = I3DUtil.indexToObject(self.components, driveNodeStr, self.i3dMappings)
			if wheel.driveNode == wheel.repr then
				g_logManager:xmlWarning(self.configFileName, "repr and driveNode may not be equal for '%s'. Using default driveNode instead!", key.."."..physicsKey)
				wheel.driveNode = nil
			end
			wheel.linkNode = I3DUtil.indexToObject(self.components, ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#linkNode", getXMLString, nil, nil, nil), self.i3dMappings)
			if wheel.driveNode == nil then
				-- create a new repr and use repr as drivenode
				local newRepr = createTransformGroup("wheelReprNode")
				local reprIndex = getChildIndex(wheel.repr)
				link(getParent(wheel.repr), newRepr, reprIndex)
				setTranslation(newRepr, getTranslation(wheel.repr))
				setRotation(newRepr, getRotation(wheel.repr))
				setScale(newRepr, getScale(wheel.repr))
				wheel.driveNode = wheel.repr
				link(newRepr, wheel.driveNode)
				setTranslation(wheel.driveNode, 0, 0, 0)
				setRotation(wheel.driveNode, 0, 0, 0)
				setScale(wheel.driveNode, 1, 1, 1)
				wheel.repr = newRepr
			end
			if wheel.driveNode ~= nil then
				local driveNodeDirectionNode = createTransformGroup("driveNodeDirectionNode")
				link(getParent(wheel.repr), driveNodeDirectionNode)
				setWorldTranslation(driveNodeDirectionNode, getWorldTranslation(wheel.driveNode))
				setWorldRotation(driveNodeDirectionNode, getWorldRotation(wheel.driveNode))
				wheel.driveNodeDirectionNode = driveNodeDirectionNode
			end
			if wheel.linkNode == nil then
				wheel.linkNode = wheel.driveNode
			end
			wheel.yOffset = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#yOffset", getXMLFloat, 0.0, nil, nil)
			if wheel.yOffset ~= 0 then
				-- move drivenode in y direction. Use convert yOffset from driveNode local space to driveNodeParent local space to translate according to directions
				setTranslation(wheel.driveNode, localToLocal(wheel.driveNode, getParent(wheel.driveNode), 0, wheel.yOffset, 0))
			end
			wheel.showSteeringAngle = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#showSteeringAngle", getXMLBool, true, nil, nil)
			wheel.suspTravel = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#suspTravel", getXMLFloat, 0.01, nil, nil)
			local initialCompression = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#initialCompression", getXMLFloat, nil, nil, nil)
			if initialCompression ~= nil then
				wheel.deltaY = (1-initialCompression*0.01)*wheel.suspTravel
			else
				wheel.deltaY = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#deltaY", getXMLFloat, 0.0, nil, nil)
			end
			wheel.spring = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#spring", getXMLFloat, 0, nil, nil)*Vehicle.SPRING_SCALE
			wheel.torque = 0
			wheel.brakeFactor = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#brakeFactor", getXMLFloat, 1, nil, nil)
			wheel.autoHoldBrakeFactor = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#autoHoldBrakeFactor", getXMLFloat, wheel.brakeFactor, nil, nil)
			wheel.damperCompressionLowSpeed = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#damperCompressionLowSpeed", getXMLFloat, nil, nil, nil)
			wheel.damperRelaxationLowSpeed = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#damperRelaxationLowSpeed", getXMLFloat, nil, nil, nil)
			if wheel.damperRelaxationLowSpeed == nil then
				wheel.damperRelaxationLowSpeed = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#damper", getXMLFloat, Utils.getNoNil(wheel.damperCompressionLowSpeed, 0), nil, nil)
			end
			-- by default, the high speed relaxation damper is set to 90% of the low speed relaxation damper
			wheel.damperRelaxationHighSpeed = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#damperRelaxationHighSpeed", getXMLFloat, wheel.damperRelaxationLowSpeed * 0.7, nil, nil)
			-- by default, we set the low speed compression damper to 90% of the low speed relaxation damper
			if wheel.damperCompressionLowSpeed == nil then
				wheel.damperCompressionLowSpeed = wheel.damperRelaxationLowSpeed * 0.9
			end
			-- by default, the high speed compression damper is set to 20% of the low speed compression damper
			wheel.damperCompressionHighSpeed = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#damperCompressionHighSpeed", getXMLFloat, wheel.damperCompressionLowSpeed * 0.2, nil, nil)
			wheel.damperCompressionLowSpeedThreshold = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#damperCompressionLowSpeedThreshold", getXMLFloat, 0.1016, nil, nil) -- default 4 inch / s
			wheel.damperRelaxationLowSpeedThreshold = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#damperRelaxationLowSpeedThreshold", getXMLFloat, 0.1524, nil, nil) -- default 6 inch / s
			wheel.forcePointRatio = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#forcePointRatio", getXMLFloat, 0, nil, nil)
			wheel.driveMode = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#driveMode", getXMLInt, 0, nil, nil)
			wheel.xOffset = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#xOffset", getXMLFloat, 0, nil, nil)
			wheel.transRatio = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#transRatio", getXMLFloat, 0.0, nil, nil)
			wheel.isSynchronized = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#isSynchronized", getXMLBool, true, nil, nil)
			wheel.tipOcclusionAreaGroupId = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#tipOcclusionAreaGroupId", getXMLInt, nil, nil, nil)
			wheel.positionX, wheel.positionY, wheel.positionZ = localToLocal(wheel.driveNode, wheel.node, 0,0,0)
			wheel.useReprDirection = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#useReprDirection", getXMLBool, false, nil, nil)
			wheel.useDriveNodeDirection = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#useDriveNodeDirection", getXMLBool, false, nil, nil)
			wheel.mass = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#mass", getXMLFloat, wheel.mass, nil, nil)
			wheel.radius = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#radius", getXMLFloat, Utils.getNoNil(wheel.radius, 0.5), nil, nil)
			wheel.width = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#width", getXMLFloat, Utils.getNoNil(wheel.width, 0.6), nil, nil)
			wheel.wheelshapeWidth = wheel.width
			wheel.widthOffset = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#widthOffset", getXMLFloat, 0, nil, nil)
			wheel.restLoad = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#restLoad", getXMLFloat, Utils.getNoNil(wheel.restLoad, 1.0), nil, nil) -- [t]
			wheel.maxLongStiffness = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#maxLongStiffness", getXMLFloat, Utils.getNoNil(wheel.maxLongStiffness, 30.0), nil, nil) -- [t / rad]
			wheel.maxLatStiffness = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#maxLatStiffness", getXMLFloat, Utils.getNoNil(wheel.maxLatStiffness, 40.0), nil, nil) -- xml is ratio to restLoad [1/rad], final value is [t / rad]
			wheel.maxLatStiffnessLoad = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#maxLatStiffnessLoad", getXMLFloat, Utils.getNoNil(wheel.maxLatStiffnessLoad, 2), nil, nil) -- xml is ratio to restLoad, final value is [t]
			wheel.frictionScale = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#frictionScale", getXMLFloat, Utils.getNoNil(wheel.frictionScale, 1.0), nil, nil)
			wheel.rotationDamping = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#rotationDamping", getXMLFloat, wheel.mass * 0.035, nil, nil)
			wheel.tireGroundFrictionCoeff = 1.0 -- This will be changed dynamically based on the tire-ground pair

			if wheel.tireType == nil then
				local tireTypeName = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#tireType", getXMLString, nil, nil, nil)				
				if tireTypeName == nil then
					-- Check if tiretrackindex present else use "mud"
					wheel.tireType = REA:DetermineTireType(wheel.tireTrackAtlasIndex)
				else
					wheel.tireType = WheelsUtil.getTireType(tireTypeName)
				end
			end

			wheel.fieldDirtMultiplier = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#fieldDirtMultiplier", getXMLFloat, 75, nil, nil)
			wheel.streetDirtMultiplier = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#streetDirtMultiplier", getXMLFloat, -150, nil, nil)
			wheel.minDirtPercentage = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#minDirtPercentage", getXMLFloat, 0.35, nil, nil)
	
			wheel.smoothGroundRadius = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#smoothGroundRadius", getXMLFloat, Utils.getNoNil(wheel.smoothGroundRadius, math.max(0.6, wheel.width*0.75)), nil, nil)
			wheel.versatileYRot = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#versatileYRot", getXMLBool, false, nil, nil)
			wheel.forceVersatility = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#forceVersatility", getXMLBool, false, nil, nil)
			wheel.supportsWheelSink = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#supportsWheelSink", getXMLBool, true, nil, nil)
			wheel.maxWheelSink = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#maxWheelSink", getXMLFloat, math.huge, nil, nil)
	
			wheel.hasTireTracks = ConfigurationUtil.getConfigurationValue(xmlFile, key, wheelnamei, "#hasTireTracks", getXMLBool, false, nil, nil)
			wheel.hasParticles = ConfigurationUtil.getConfigurationValue(xmlFile, key, wheelnamei, "#hasParticles", getXMLBool, false, nil, nil)
	
			local steeringKey = wheelnamei .. ".steering"
			wheel.steeringNode = I3DUtil.indexToObject(self.components, ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringKey, "#node", getXMLString, nil, nil, nil), self.i3dMappings)
			wheel.steeringRotNode = I3DUtil.indexToObject(self.components, ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringKey, "#rotNode", getXMLString, nil, nil, nil), self.i3dMappings)
			wheel.steeringNodeMinTransX = ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringKey, "#nodeMinTransX", getXMLFloat, nil, nil, nil)
			wheel.steeringNodeMaxTransX = ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringKey, "#nodeMaxTransX", getXMLFloat, nil, nil, nil)
			wheel.steeringNodeMinRotY = MathUtil.degToRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringKey, "#nodeMinRotY", getXMLFloat, nil, nil, nil))
			wheel.steeringNodeMaxRotY = MathUtil.degToRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringKey, "#nodeMaxRotY", getXMLFloat, nil, nil, nil))
	
			local fenderKey = wheelnamei .. ".fender"
			wheel.fenderNode = I3DUtil.indexToObject(self.components, ConfigurationUtil.getConfigurationValue(xmlFile, key, fenderKey, "#node", getXMLString, nil, nil, nil), self.i3dMappings)
			wheel.fenderRotMax = ConfigurationUtil.getConfigurationValue(xmlFile, key, fenderKey, "#rotMax", getXMLFloat, nil, nil, nil)
			wheel.fenderRotMin = ConfigurationUtil.getConfigurationValue(xmlFile, key, fenderKey, "#rotMin", getXMLFloat, nil, nil, nil)
	
			local steeringAxleKey = wheelnamei .. ".steeringAxle"
			wheel.steeringAxleScale = ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringAxleKey, "#scale", getXMLFloat, 0, nil, nil)
			wheel.steeringAxleRotMax = MathUtil.degToRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringAxleKey, "#rotMax", getXMLFloat, 0, nil, nil))
			wheel.steeringAxleRotMin = MathUtil.degToRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, steeringAxleKey, "#rotMin", getXMLFloat, -0, nil, nil))
	
			wheel.rotSpeed = MathUtil.degToRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#rotSpeed", getXMLFloat, nil, nil, nil))
			wheel.rotSpeedNeg = Utils.getNoNilRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#rotSpeedNeg", getXMLFloat, nil, nil, nil), nil)
			wheel.rotMax = MathUtil.degToRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#rotMax", getXMLFloat, nil, nil, nil))
			wheel.rotMin = MathUtil.degToRad(ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#rotMin", getXMLFloat, nil, nil, nil))
	
			wheel.rotSpeedLimit = ConfigurationUtil.getConfigurationValue(xmlFile, key, physicsKey, "#rotSpeedLimit", getXMLFloat, nil, nil, nil)
		else
			g_logManager:xmlWarning(self.configFileName, "Invalid repr for wheel '%s'. Needs to be a child of a collision!", key..physicsKey)
		end
	else
		g_logManager:xmlWarning(self.configFileName, "Invalid repr for wheel '%s'!", key..physicsKey)
	end
    return true
end


-----------------------------------------------------------------------------------	
-- Edited update wheel sink
-----------------------------------------------------------------------------------
function REA:REAupdateWheelSink(wheel, dt)
    if wheel.supportsWheelSink then
        if self.isServer and self.isAddedToPhysics then
            local spec = self.spec_wheels
			-- Get wheel speed
			local WheelSpeed = 0;
			if wheel.RollingDirectionSpeed ~= nil and wheel.SideWaySpeed ~= nil and wheel.SpeedBasedOnXdrive ~= nil then
				WheelSpeed = math.max(wheel.RollingDirectionSpeed, wheel.SideWaySpeed, wheel.SpeedBasedOnXdrive);
			else
				WheelSpeed = self:getLastSpeed();
			end;

			-- Init smoothe NoiseValue
			if wheel.NoiseValueSmoothed == nil then
				wheel.NoiseValueSmoothed = 0;
			end
			-- Sink update min speed
			local MinWheelSpeed = 0.1

            -- map noise to an asbolute value or to a certain percentage of the wheel radius?
            local maxSink = 0.20
            local sinkTarget = 0

            if wheel.mirroredWheel == nil then
                for _, mirWheel in ipairs(spec.wheels) do
                    if mirWheel.mirroredWheel == nil and mirWheel ~= wheel then -- only the first wheel got the mirrored one
                        local x1, y1, z1 = localToLocal(wheel.node, wheel.repr, 0, 0, 0)
                        local x2, y2, z2 = localToLocal(wheel.node, mirWheel.repr, 0, 0, 0)
                        local diff = math.abs(x1-(-x2)) + math.abs(y1-y2) + math.abs(z1-z2)
                        if diff < 0.25 then
                            wheel.mirroredWheel = mirWheel
                            mirWheel.invMirroredWheel = wheel
                        end
                    end
                end
            end

            local force = false
			-- Min force for adjusting sink
			if WheelSpeed >= MinWheelSpeed then
				-- If wheel has contact add sink
				local noiseValue = 0
				local loadFactor = 1;
				if wheel.contact ~= Wheels.WHEEL_NO_CONTACT then
					wheel.avgSink = nil
					local width = 0.25 * wheel.width
					local length = 0.25 * wheel.width
					local x,_,z = localToLocal(wheel.driveNode, wheel.repr, 0,0,0)
					local x0,_,z0 = localToWorld(wheel.repr, x + width, 0, z - length)
					local x1,_,z1 = localToWorld(wheel.repr, x - width, 0, z - length)
					local x2,_,z2 = localToWorld(wheel.repr, x + width, 0, z + length)
					local x,z, widthX,widthZ, heightX,heightZ = MathUtil.getXZWidthAndHeight(x0, z0, x1, z1, x2, z2)
					local density, area = FSDensityMapUtil.getFieldValue(x0, z0, x1, z1, x2, z2)
					local terrainValue = 0
					if area > 0 then
						terrainValue = math.floor(density/area + 0.5)
					end
					wheel.lastTerrainValue = terrainValue
					if terrainValue > 0 then
						local xPerlin = x + 0.5*widthX + 0.5*heightX
						local zPerlin = z + 0.5*widthZ + 0.5*heightZ
						-- REA: increased from 1cm to 2cm
						-- Round to 2cm to avoid sliding when not moving
						xPerlin = math.floor(xPerlin*100)*0.02
						zPerlin = math.floor(zPerlin*100)*0.02

						local perlinNoise;
						perlinNoise = Wheels.perlinNoiseSink
						if wheel.radiusOriginal > 0.4 then
							perlinNoise.randomFrequency = 0.8;
						else
							perlinNoise.randomFrequency = 0.9;
						end
						perlinNoise.numOctaves = 4;
						local noiseSink = 0.5 * (1 + getPerlinNoise2D(xPerlin*perlinNoise.randomFrequency, zPerlin*perlinNoise.randomFrequency, perlinNoise.persistence, perlinNoise.numOctaves, perlinNoise.randomSeed))

						perlinNoise = Wheels.perlinNoiseWobble
						local noiseWobble = 0.5 * (1 + getPerlinNoise2D(xPerlin*perlinNoise.randomFrequency, zPerlin*perlinNoise.randomFrequency, perlinNoise.persistence, perlinNoise.numOctaves, perlinNoise.randomSeed))
	
						-- estimiate pressure on surface
						local gravity = 9.81
						local tireLoad = getWheelShapeContactForce(wheel.node, wheel.wheelShape)
						if tireLoad ~= nil then
							local nx,ny,nz = getWheelShapeContactNormal(wheel.node, wheel.wheelShape)
							local dx,dy,dz = localDirectionToWorld(wheel.node, 0,-1,0)
							tireLoad = -tireLoad*MathUtil.dotProduct(dx,dy,dz, nx,ny,nz)
							tireLoad = tireLoad + math.max(ny*gravity, 0.0) * wheel.mass -- add gravity force of tire
						else
							tireLoad = 0
						end
						-- Calculate tireload
						tireLoad = tireLoad / gravity
						-- Check if crawlertracks and if present in crawler
						local TireTypeCRAWLER = 4;
						local CrawlersFactor = 1;
						if wheel.tireType == TireTypeCRAWLER then
							CrawlersFactor = 1.5;
						end;
						-- Calculate width of wheel
						local WheelWidth = wheel.width * CrawlersFactor;
						-- Get width of additional wheels
						local AdditionalWidth = 0;
						if wheel.additionalWheels ~= nil then
							local numAdditionalWheels = table.getn(wheel.additionalWheels);
							for AddWheel=1,numAdditionalWheels do
								-- Add width off additional wheels
								AdditionalWidth = AdditionalWidth + (wheel.additionalWheels[AddWheel].width * 0.75);
							end;
						end;
						-- Calculate loadfactor
						loadFactor = math.min(1.0, math.max(0, (tireLoad / (WheelWidth + AdditionalWidth)) / 10));
						local wetnessFactor = REA.GroundWetnessFactor;
						-- Id REA dynamic dirt is loaded and wheel in standing
						if REA.DynamicDirtActivated and wheel.InLowspotWithWater then
							wetnessFactor = 1;
						end;
						noiseSink = (1.40*loadFactor + wetnessFactor*1.60) * noiseSink
						noiseValue = math.max(noiseSink,(loadFactor*0.4) + (wetnessFactor*0.6));

						-- DEBUG
--						DebugUtil.drawDebugNode(wheel.driveNode,"Wetness: " .. REA.GroundWetnessFactor, false)
--						DebugUtil.drawDebugNode(wheel.driveNode,"Tireload: " .. tireLoad .. ", loadFactor: " .. loadFactor .. ", total width: " .. WheelWidth + AdditionalWidth .. ", Friction scale: " .. wheel.frictionScale, false)
--						DebugUtil.drawDebugNode(wheel.driveNode,"Sink: " .. wheel.NoiseValueSmoothed .. ", Wobble" .. noiseWobble .. ", loadFactordiff New/Org: " .. loadFactor .. " / " .. OrgloadFactor .. ", Friction scale: " .. wheel.frictionScale, false)
--						DebugUtil.drawDebugNode(wheel.driveNode,"loadFactordiff New/Org: " .. loadFactor .. " / " .. OrgloadFactor .. ", Friction scale: " .. wheel.frictionScale, false)

					end
				end
				-- Smoothe noise value
				if noiseValue > 0 then
					wheel.NoiseValueSmoothed = (wheel.NoiseValueSmoothed*0.8)+(noiseValue*0.2);
				else
					wheel.NoiseValueSmoothed = 0;
				end;
				
				-- Get max sink
				maxSink = Wheels.MAX_SINK[wheel.lastTerrainValue] or maxSink
				local WheelRadiusMaxSink = REA.WheelRadiusMaxSinkFactor*wheel.radiusOriginal;


				-- plowing effect
				if wheel.lastTerrainValue == 2 and wheel.oppositeWheelIndex ~= nil then
					local oppositeWheel = spec.wheels[wheel.oppositeWheelIndex]
					if oppositeWheel.lastTerrainValue ~= nil and oppositeWheel.lastTerrainValue ~= 2 then
						maxSink = maxSink * 1.3
					end
				end

				-- Minimum max sink if wheel is in lowspot with water
				local SinkOfLowSpot = 0.1;
				if REA.DynamicDirtActivated and wheel.InLowspotWithWater then
					maxSink = math.max(maxSink,SinkOfLowSpot);
				end;

				------------------------------------------------------
				-- Sink from spinning the wheel
				------------------------------------------------------
				-- initialize sink from spinning the wheel without movement
				if wheel.SinkFromSpinning == nil then
					wheel.SinkFromSpinning = 0;
				end;
				-- Get expected and actual moved distance for wheel
				local ExpectedDistance = wheel.ExpectedDistanceTraveled;
				local ActualDistance = wheel.ActualDistanceTraveled;
				-- Increas sink
				if wheel.contact ~= Wheels.WHEEL_NO_CONTACT and REA:GetOnSoftGround(wheel) then
					if ExpectedDistance > ActualDistance then
						-- If sink has not reached the limit add more sink
						if wheel.SinkFromSpinning >= WheelRadiusMaxSink then
							-- Max sink reached
							wheel.SinkFromSpinning = WheelRadiusMaxSink;
						else
							-- Constant for sink per meter
							local AddSinkPerMeter = REA.TireTypeSinkPerMeterSpinning[wheel.tireType];
							-- Factor by load
							local MinSpinLoadFactor = 0.5;
							local SpinLoadFactor = MathUtil.clamp(loadFactor*2, MinSpinLoadFactor, 1)

							-- DEBUG
							--DebugUtil.drawDebugNode(wheel.driveNode,"LoadFactor: " .. SpinLoadFactor, false)

							-- Lower sink when not in field
							if wheel.densityType == 0 then
								AddSinkPerMeter = AddSinkPerMeter * 0.5;
							end;
							-- Calculate sink by spinning
							local DistanceDiff = ExpectedDistance - ActualDistance;
							local SinkToAddFromSpinning = DistanceDiff * (AddSinkPerMeter * SpinLoadFactor);
							-- Increase sink when low
							local ExtraSinkFromSpinningFactor = 1;
							if wheel.SinkFromSpinning < (WheelRadiusMaxSink/2) and wheel.SinkFromSpinning > 0 then
								ExtraSinkFromSpinningFactor = 2 - (wheel.SinkFromSpinning / (WheelRadiusMaxSink/2));
							end;
							-- Add sink
							wheel.SinkFromSpinning = math.min(wheel.SinkFromSpinning + (SinkToAddFromSpinning * ExtraSinkFromSpinningFactor),WheelRadiusMaxSink);

							-- DEBUG
							--DebugUtil.drawDebugNode(wheel.driveNode, "factor: " .. ExtraSinkFromSpinningFactor, false)

						end;
					end;
				end;
				-- Decrease sink
				if wheel.SinkFromSpinning > 0 then
					-- Calculate how much sink should be lowered
					local MinDecreaseSinkPerMeter = 0.3;
					-- Decrease sink by rolling the wheel
					if ActualDistance > 0 then
						wheel.SinkFromSpinning = wheel.SinkFromSpinning - (ActualDistance * MinDecreaseSinkPerMeter);
					end;
					if wheel.SinkFromSpinning < 0 then
						wheel.SinkFromSpinning = 0;
					end;
				end;

				-- Sinktarget
				-- Sink fom wobble, max 65% of max sink
				local sinkTargetNoise = math.min(math.min(maxSink, wheel.maxWheelSink) * wheel.NoiseValueSmoothed, WheelRadiusMaxSink*0.65);
				-- Add sink from spinning
				sinkTarget = math.min(wheel.SinkFromSpinning+sinkTargetNoise, WheelRadiusMaxSink);

			else
				-- REA: removed the equalizing of sink when stoping as the vehicle makes a jump if done in field
				if wheel.sinkTarget ~= nil then
					sinkTarget = wheel.sinkTarget;
				else
					sinkTarget = 0;
				end
			end

            if wheel.sinkTarget < sinkTarget then
                wheel.sinkTarget = math.min(sinkTarget, wheel.sinkTarget + (0.05 * math.min(30, math.max(0, WheelSpeed-(MinWheelSpeed/2))) * (dt/1000)))
            elseif wheel.sinkTarget > sinkTarget then
                wheel.sinkTarget = math.max(sinkTarget, wheel.sinkTarget - (0.05 * math.min(30, math.max(0, WheelSpeed-(MinWheelSpeed/2))) * (dt/1000)))
            end

            if math.abs(wheel.sink - wheel.sinkTarget) > 0.001 or force then
                wheel.sink = wheel.sinkTarget

                local radius = wheel.radiusOriginal - wheel.sink
                if radius ~= wheel.radius then
                    wheel.radius = radius
                    if self.isServer then
                        self:setWheelPositionDirty(wheel)
                        local sinkFactor = (wheel.sink/maxSink) * (1 + (0.4 * REA.GroundWetnessFactor))
                        wheel.sinkLongStiffnessFactor = (1.0 - (0.10 * sinkFactor))
                        wheel.sinkLatStiffnessFactor  = (1.0 - (0.20 * sinkFactor))
                        self:setWheelTireFrictionDirty(wheel)
                    end
                end
            end
        end
    end
end


-----------------------------------------------------------------------------------	
-- Edited addToPhysics
-----------------------------------------------------------------------------------
function REA:REAaddToPhysics()
    if not self.isAddedToPhysics then

		-- Calculate new center of mass
        if self.isServer then
			if self.COGChangedByREA == nil then
				REA:CalculateNewCenterOfMass(self);
				self.COGChangedByREA = true;
			end;
		end;

        local lastMotorizedNode = nil
        for _, component in pairs(self.components) do
            addToPhysics(component.node)
            if component.motorized then
                if lastMotorizedNode ~= nil then
                    if self.isServer then
                        addVehicleLink(lastMotorizedNode, component.node)
                    end
                end
                lastMotorizedNode = component.node
            end
        end
        self.isAddedToPhysics = true
        if self.isServer then
            for _, jointDesc in pairs(self.componentJoints) do
                self:createComponentJoint(self.components[jointDesc.componentIndices[1]], self.components[jointDesc.componentIndices[2]], jointDesc)
            end
            -- if rootnode is sleeping all other components are sleeping as well
            addWakeUpReport(self.rootNode, "onVehicleWakeUpCallback", self)
        end
        for _, collisionPair in pairs(self.collisionPairs) do
            setPairCollision(collisionPair.component1.node, collisionPair.component2.node, collisionPair.enabled)
        end
        self:setMassDirty()
    end
    return true
end


-----------------------------------------------------------------------------------	
-- Edited loadComponentFromXML
-----------------------------------------------------------------------------------
function REA:REAloadComponentFromXML(component, xmlFile, key, rootPosition, i)
    if not self.isServer then
        if getRigidBodyType(component.node) == "Dynamic" then
            setRigidBodyType(component.node, "Kinematic")
        end
    end
    link(getRootNode(), component.node)
    if i == 1 then
        rootPosition[1], rootPosition[2], rootPosition[3] = getTranslation(component.node)
        if rootPosition[2] ~= 0 then
            g_logManager:xmlWarning(self.configFileName, "Y-Translation of component 1 (node 0>) has to be 0. Current value is: %.5f", rootPosition[2])
        end
    end
    if getRigidBodyType(component.node) == "Static" then
        component.isStatic = true
    elseif getRigidBodyType(component.node) == "Kinematic" then
        component.isKinematic = true
    elseif getRigidBodyType(component.node) == "Dynamic" then
        component.isDynamic = true
    end
    -- the position of the first component is the zero
    translate(component.node, -rootPosition[1], -rootPosition[2], -rootPosition[3])
    local x,y,z = getTranslation(component.node)
    local rx,ry,rz = getRotation(component.node)
    component.originalTranslation = {x,y,z}
    component.originalRotation = {rx,ry,rz}
    component.sentTranslation = {x,y,z}
    component.sentRotation = {rx,ry,rz}
    component.defaultMass = nil
    component.mass = nil
    local mass = getXMLFloat(xmlFile, key.."#mass")
    if mass ~= nil then
        if mass < 10 then
            g_logManager:xmlDevWarning(self.configFileName, "Mass is lower than 10kg for '%s'. Mass unit is kilogramms. Is this correct?", key)
        end
        if component.isDynamic then
            setMass(component.node, mass/1000)
        end
        component.defaultMass = mass/1000
        component.mass = component.defaultMass
        component.lastMass = component.mass
    else
        g_logManager:xmlWarning(self.configFileName, "Missing 'mass' for '%s'. Using default mass 500kg instead!", key)
        component.defaultMass = 0.5
        component.mass = 0.5
        component.lastMass = component.mass
    end
    local comStr = getXMLString(xmlFile, key .. "#centerOfMass");
    if comStr ~= nil then
        local com = StringUtil.getVectorNFromString(comStr, 3)
        if com ~= nil then
            setCenterOfMass(component.node, com[1], com[2], com[3])
			component.OriginalCOGX = com[1];
			component.OriginalCOGY = com[2];
			component.OriginalCOGZ = com[3];
		else
            g_logManager:xmlWarning(self.configFileName, "Invalid center of mass given for '%s'. Ignoring this definition", key)
        end
    end
    local count = getXMLInt(xmlFile, key .. "#solverIterationCount")
    if count ~= nil then
        setSolverIterationCount(component.node, count)
        component.solverIterationCount = count
    end
    component.motorized = getXMLBool(xmlFile, key .. "#motorized") -- Note: motorized is nil if not set in the xml, and can be set by the wheels
    self.vehicleNodes[component.node] = {component=component}
    local clipDistance = getClipDistance(component.node)
    if clipDistance >= 1000000 and getVisibility(component.node) then
        local defaultClipdistance = 300
        g_logManager:xmlWarning(self.configFileName, "No clipdistance is set to component node '%s' (%s>). Set default clipdistance '%d'", getName(component.node), i-1, defaultClipdistance)
        setClipDistance(component.node, defaultClipdistance)
    end
    component.collideWithAttachables = Utils.getNoNil(getXMLBool(xmlFile, key.."#collideWithAttachables"), false)
    if getRigidBodyType(component.node) ~= "NoRigidBody" then
        if getLinearDamping(component.node) > 0.01 then
            g_logManager:xmlDevWarning(self.configFileName, "Non-zero linear damping (%.4f) for component node '%s' (%s>). Is this correct?", getLinearDamping(component.node), getName(component.node), i-1)
        elseif getAngularDamping(component.node) > 0.05 then
            g_logManager:xmlDevWarning(self.configFileName, "Large angular damping (%.4f) for component node '%s' (%s>). Is this correct?", getAngularDamping(component.node), getName(component.node), i-1)
        elseif getAngularDamping(component.node) < 0.0001 then
            g_logManager:xmlDevWarning(self.configFileName, "Zero damping for component node '%s' (%s>). Is this correct?", getName(component.node), i-1)
        end
    end
    local name = getName(component.node)
    if not StringUtil.endsWith(name, "component"..i) then
        g_logManager:xmlDevWarning(self.configFileName, "Name of component '%d' ('%s') does not correpond with the component naming convention! (vehicleName_componentName_component%d)", i, name, i)
    end
    return true
end


-----------------------------------------------------------------------------------	
-- Edited onUpdateTick
-----------------------------------------------------------------------------------
function REA:REAonUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local spec = self.spec_wheels
    for _, wheel in pairs(spec.wheels) do
        if wheel.rotSpeedLimit ~= nil then
            local dir = -1
            if self:getLastSpeed() <= wheel.rotSpeedLimit then
                dir = 1
            end
            wheel.currentRotSpeedAlpha = MathUtil.clamp(wheel.currentRotSpeedAlpha + dir*(dt/1000), 0, 1)
            wheel.rotSpeed    = wheel.rotSpeedDefault * wheel.currentRotSpeedAlpha
            wheel.rotSpeedNeg = wheel.rotSpeedNegDefault * wheel.currentRotSpeedAlpha
        end
    end
    if self.isClient then
        local groundWetness = REA.GroundWetnessFactor;
        local groundIsWet = groundWetness > 0.15
        for _,wheel in pairs(spec.wheels) do
            if wheel.driveGroundParticleSystems ~= nil then

                local states = wheel.driveGroundParticleStates
                local enableSoilPS = false

				-- Get speed and direction from wheel
                local wheelSpeed = 0;
                local wheelActualSpeed = 0;
                local wheelDirection = 0;
				local wheelSlip = 0;
				local MinSpeed = 0.5;
				if wheel.SpeedBasedOnXdrive ~= nil and wheel.RollingDirectionSpeed ~= nil then
					wheelActualSpeed = wheel.RollingDirectionSpeed;
					wheelDirection = wheel.DirectionBasedOnXdrive;
					wheelSpeed = wheel.SpeedBasedOnXdrive;
					-- Get slip factor
					wheelSlip = REA:GetWheelSlipFactor(wheelSpeed,wheelActualSpeed);
				end;

				-- Get wheel sink
				local WheelSink = REA:GetWheelSinkClientSide(wheel);

				-- Enable soil particles
				if (wheel.lastTerrainValue > 0 and wheel.lastTerrainValue < 5) or (wheelSlip > 0.05 and REA:GetOnSoftGround(wheel)) then
					enableSoilPS = wheelDirection ~= 0;
                end

				-- Save wheel direction and use REA wheel direction
				local OriginalWheelDirecton = self.movingDirection;
				self.movingDirection = wheelDirection;

                local sizeScale = 2 * wheel.width * wheel.radiusOriginal
                states.driving_dry = enableSoilPS
                states.driving_wet = enableSoilPS and groundIsWet
                states.driving_dust = not groundIsWet
                for psName, state in pairs(states) do
                    local typedPs = wheel.driveGroundParticleSystems[psName]
                    for _, ps in ipairs(typedPs) do
                        if state and wheelDirection ~= 0 then
                            if self.movingDirection < 0 then
                                setRotation(ps.emitterShape, 0, math.pi+wheel.steeringAngle, 0)
                            else
                                setRotation(ps.emitterShape, 0, wheel.steeringAngle, 0)
                            end
                            local scale
                            if psName ~= "driving_dust" then
                                scale = self:getDriveGroundParticleSystemsScale(ps, math.min(wheelSpeed,50)) * math.min(wheelSlip * 20,1)
								-- Compensate for wheel sink
								ps.offsets[2] = WheelSink*0.7;
								ps.offsets[3] = ((WheelSink*0.7)*wheelDirection)*(-1);
                            else
                                scale = self:getDriveGroundParticleSystemsScale(ps, self.lastSpeedReal)
                            end
 
							if ps.isTintable then
                                -- interpolate between different ground colors to avoid unrealisitic particle color changes
                                if ps.lastColor == nil then
                                    ps.lastColor = {ps.wheel.lastColor[1],ps.wheel.lastColor[2],ps.wheel.lastColor[3]}
                                    ps.targetColor = {ps.wheel.lastColor[1],ps.wheel.lastColor[2],ps.wheel.lastColor[3]}
                                    ps.currentColor = {ps.wheel.lastColor[1],ps.wheel.lastColor[2],ps.wheel.lastColor[3]}
                                    ps.alpha = 1
                                end
                                if ps.alpha ~= 1 then
                                    ps.alpha = math.min(ps.alpha + dt/1000, 1)
                                    ps.currentColor = {MathUtil.vector3ArrayLerp(ps.lastColor, ps.targetColor, ps.alpha)}
                                    if ps.alpha == 1 then
                                        ps.lastColor[1] = ps.currentColor[1]
                                        ps.lastColor[2] = ps.currentColor[2]
                                        ps.lastColor[3] = ps.currentColor[3]
                                    end
                                end
                                if ps.alpha == 1 and ps.wheel.lastColor[1] ~= ps.targetColor[1] and ps.wheel.lastColor[2] ~= ps.targetColor[2] and ps.wheel.lastColor[3] ~= ps.targetColor[3] then
                                    ps.alpha = 0
                                    ps.targetColor[1] = ps.wheel.lastColor[1]
                                    ps.targetColor[2] = ps.wheel.lastColor[2]
                                    ps.targetColor[3] = ps.wheel.lastColor[3]
                                end
                            end
                            if scale > 0 then
                                ParticleUtil.setEmittingState(ps, true)
                                if ps.isTintable then
                                    setShaderParameter(ps.shape, "psColor", ps.currentColor[1], ps.currentColor[2], ps.currentColor[3], 1, false)
                                end
                            else
                                ParticleUtil.setEmittingState(ps, false)
                            end
                            -- emit count
                            local maxSpeed = 50
                            local circum = wheel.radiusOriginal
                            local maxWheelRpm = maxSpeed / circum
							local WheelFactorMin = 0.01;
							local WheelFactorMax = 1.0;
							local wheelRotFactor = MathUtil.clamp(wheelSpeed/maxSpeed,WheelFactorMin,WheelFactorMax);
                            local emitScale = scale * wheelRotFactor * sizeScale
                            if psName ~= "driving_dust" then
								-- If dynamic dirt is activated get if wheel is located inside a lowspot with water
								local WheelInLowspotWithWater = false;
								if REA.DynamicDirtActivated then
									WheelInLowspotWithWater = wheel.InLowspotWithWater;
								end;
								-- Dirt factor from wetness
								local WetnessFactor = 0;
								local MaxWetnessFromGround = 2;
								if WheelInLowspotWithWater then
									WetnessFactor = 3;
								else
									WetnessFactor = math.min((groundWetness * 2) + 1,MaxWetnessFromGround);
								end;
								-- Emitscale
								emitScale = (emitScale * 3) * WetnessFactor;
								-- During low speed add scale slowly
								if wheelSpeed < 1 then
									emitScale = wheelSpeed * emitScale;
								end;
							end;

							-- DEBUG
                            --if psName ~= "driving_dust" then
								---DebugUtil.drawDebugNode(wheel.driveNode, "Emit: " .. REA:RoundValueTwoDecimals(emitScale) .. ", Wheel direction: " .. self.movingDirection .. ", Wheelspeed: " .. REA:RoundValueTwoDecimals(wheelSpeed), false)
							--end;

                            ParticleUtil.setEmitCountScale(ps, MathUtil.clamp(emitScale, ps.minScale, ps.maxScale))
                            ParticleUtil.setParticleSystemSpeed(ps, ps.particleSpeed * wheelRotFactor)
                            ParticleUtil.setParticleSystemSpeedRandom(ps, ps.particleRandomSpeed * wheelRotFactor)
                        else
                            ParticleUtil.setEmittingState(ps, false)
                        end
                    end
                    states[psName] = false
                end

				-- Return original wheel direction
				self.movingDirection  = OriginalWheelDirecton;

            end
        end
    end
end


-----------------------------------------------------------------------------------	
-- Edited updateWheelTireTracks
-----------------------------------------------------------------------------------
function REA:REAupdateWheelTireTracks(wheel)
	if wheel.CreatingTracks == nil then
		wheel.CreatingTracks = false;
		wheel.TrackSystemRutsActive = false;
		wheel.TrackSystemTracksActive = false;
		wheel.TireTrackAlphaSmoothed = 0;
		wheel.TimerDelayChangePattern = 0;
		wheel.AttachedToMotorizedVehicle = false;
	end;
	-- Get speed and direction from wheel
	local wheelSpeed = 0;
	local wheelActualSpeed = 0;
	local wheelDirection = 0;
	if wheel.SpeedBasedOnXdrive ~= nil and wheel.RollingDirectionSpeed then
		wheelSpeed = wheel.SpeedBasedOnXdrive;
		wheelActualSpeed = wheel.RollingDirectionSpeed;
		wheelDirection = wheel.DirectionBasedOnXdrive;
	end;
	-- Get wheel sink
	local WheelSink = REA:GetWheelSinkClientSide(wheel)
	-- Calculated to get correct radius on client side
	local wheelActualRadius = wheel.radiusOriginal - WheelSink;
    -- using netinfo because of tire deformation
    local wx, wy, wz = wheel.netInfo.x, wheel.netInfo.y, wheel.netInfo.z
    wx = wx + wheel.xOffset

	-- Depending on wheel contact choose tiretrack height
	local WheelContactObject = 1;
	local WheelContactGround = 2;
	if wheel.contact == WheelContactObject then
		wy = wy - wheel.radiusOriginal
	else
		wy = wy - wheelActualRadius
	end;

	if wheel.TrackSystemRutsActive then
		wz = wz + ((WheelSink * 1) * wheelDirection);
	end;
	wx, wy, wz = localToWorld(wheel.node, wx,wy,wz)

	-- If wheel is not in contact with an object use terrain height
	local WheelContactGround = 2;
	if wheel.contact == WheelContactGround then
		wy = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, wx, 0, wz);
	end;

    local r, g, b, a, t = self:getTireTrackColor(wheel, wx, wy, wz)
    if wheel.tireTrackIndex ~= nil then

		-- Determine if wheel should create a rut
		local StartRutFactor = 0.3;
		local StopRutFactor = 0.1;
		-- Get slip factor
		local wheelSlip = REA:GetWheelSlipFactor(wheelSpeed,wheelActualSpeed);
		-- Start and stop rut
		local RequestRuts = wheelSlip > StartRutFactor and wheel.AttachedToMotorizedVehicle;
		local RequestTracks = ((wheelSlip < StopRutFactor) and WheelSink < (REA.WheelRadiusMaxSinkFactor*wheel.radiusOriginal) * 0.3) or not wheel.AttachedToMotorizedVehicle;
		-- Request change pattern
		local RequestChangedPattern = (RequestRuts and not wheel.TrackSystemRutsActive) or (RequestTracks and not wheel.TrackSystemTracksActive);
		local ChangePattern = false;
		local PatternChanged = false;

		-- Delay changing of pattern
		local NumberOfDelaysBeforeChange = 5;
		if RequestChangedPattern then
			if wheel.TimerDelayChangePattern < NumberOfDelaysBeforeChange then
				wheel.TimerDelayChangePattern = wheel.TimerDelayChangePattern + 1;
			end;
		else
			wheel.TimerDelayChangePattern = 0;
		end;
		-- Delay finished
		local RequestDelayed = false;
		if wheel.TimerDelayChangePattern >= NumberOfDelaysBeforeChange then
			RequestDelayed = true;
		end;
		-- Change pattern
		if RequestDelayed and wheel.TireTrackAlphaSmoothed < 0.1 then
			ChangePattern = true;
		end;

		-- Change track pattern
		if not wheel.CreatingTracks then
			if g_currentMission.tireTrackSystem ~= nil and wheel.hasTireTracks then
				if ChangePattern then
					local WidthFactor = 0;
					local TrackAtlasIndex = 0;
					local RutAtlasIndex = 4;
					local AdditionalWheelTrackAtlasIndex = 0;
					-- Activate ruts track system
					if RequestRuts then
						WidthFactor = 1.75;
						TrackAtlasIndex = RutAtlasIndex;
						wheel.TrackSystemRutsActive = true;
						wheel.TrackSystemTracksActive = false;
					-- Activate tracks track system
					elseif RequestTracks then
						WidthFactor = 1;
						TrackAtlasIndex = wheel.tireTrackAtlasIndex;
						wheel.TrackSystemRutsActive = false;
						wheel.TrackSystemTracksActive = true;
					end;
					-- Delete tire track for wheel before changing pattern
					g_currentMission.tireTrackSystem:destroyTrack(wheel.tireTrackIndex);
					wheel.tireTrackIndex = g_currentMission.tireTrackSystem:createTrack(wheel.width * WidthFactor, TrackAtlasIndex);
					if wheel.additionalWheels ~= nil then
						for _, additionalWheel in pairs(wheel.additionalWheels) do
							if g_currentMission.tireTrackSystem ~= nil and additionalWheel.tireTrackIndex ~= nil then
								if RequestRuts then
									TrackAtlasIndex = RutAtlasIndex;
								else
									TrackAtlasIndex = additionalWheel.tireTrackAtlasIndex;
								end;
								-- Destroy current track index and create new one with new pattern.
								g_currentMission.tireTrackSystem:destroyTrack(additionalWheel.tireTrackIndex)
								additionalWheel.tireTrackIndex = g_currentMission.tireTrackSystem:createTrack(additionalWheel.width * WidthFactor, TrackAtlasIndex)
								PatternChanged = true;
							end
						end
					end
				end;
			end;
		end;

		-- Allow track system to make tracks or ruts
		local AllowTracksystem = r ~= nil and self:getAllowTireTracks() and not ChangePattern;

		-- Create tracks
        if AllowTracksystem then
			-- Settings for ruts
			local RequestedAlpha = 0;
			if wheel.TrackSystemRutsActive then
				if WheelSink < (REA.WheelRadiusMaxSinkFactor*wheel.radiusOriginal) * 0.7 then
					RequestedAlpha = math.max(math.min(wheelSlip*3,1),WheelSink*10);
				else
					RequestedAlpha = 1;
				end;
			else
				RequestedAlpha = math.max(math.min(WheelSink*20,1),wheel.dirtAmount);
			end;
			-- Smoothe value
			if RequestDelayed then
				if wheel.TireTrackAlphaSmoothed > 0.05 then
					wheel.TireTrackAlphaSmoothed = wheel.TireTrackAlphaSmoothed * 0.5;
				end;
			else
				wheel.TireTrackAlphaSmoothed =  (wheel.TireTrackAlphaSmoothed*0.8)+(RequestedAlpha*0.2);
			end;

			-- DEBUG
			--DebugUtil.drawDebugNode(wheel.driveNode,"WS: " .. REA:RoundValueTwoDecimals(wheelSpeed) .. ", MS: " .. REA:RoundValueTwoDecimals(wheelActualSpeed), false)
			--DebugUtil.drawDebugNode(wheel.driveNode,"Contact: " .. wheel.contact, false)

            -- we are using wheel node instead of root node -> direction of wheel component could be different compared to the root component
            local ux,uy,uz = localDirectionToWorld(wheel.node, 0, 1, 0)
            local tireDirection = self.movingDirection
            if wheel.tireIsInverted then
                tireDirection = tireDirection * -1
            end
            -- we are using dirtAmount as alpha value -> realistic dirt fadeout
            g_currentMission.tireTrackSystem:addTrackPoint(wheel.tireTrackIndex, wx, wy, wz, ux, uy, uz, r, g, b, wheel.TireTrackAlphaSmoothed, a, tireDirection)
            if wheel.additionalWheels ~= nil then
                for _, additionalWheel in pairs(wheel.additionalWheels) do
                    if additionalWheel.tireTrackIndex ~= nil then
                        wx, wy, wz = worldToLocal(wheel.node, getWorldTranslation(additionalWheel.wheelTire))
                        wy = wy - wheel.radius
                        wx = wx + wheel.xOffset
                        wx, wy, wz = localToWorld(wheel.node, wx,wy,wz)
                        wy = math.max(wy, getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, wx, wy, wz))
                        tireDirection = self.movingDirection
                        if additionalWheel.tireIsInverted then
                            tireDirection = tireDirection * -1
                        end
                        g_currentMission.tireTrackSystem:addTrackPoint(additionalWheel.tireTrackIndex, wx, wy, wz, ux, uy, uz, r, g, b, wheel.TireTrackAlphaSmoothed, a, tireDirection)
                    end
                end
            wheel.CreatingTracks = true;
			end
        else
            g_currentMission.tireTrackSystem:cutTrack(wheel.tireTrackIndex)
            if wheel.additionalWheels ~= nil then
                for _, additionalWheel in pairs(wheel.additionalWheels) do
                    if additionalWheel.tireTrackIndex ~= nil then
                        g_currentMission.tireTrackSystem:cutTrack(additionalWheel.tireTrackIndex)
                    end
                end
            end
			wheel.CreatingTracks = false;
        end
    end
end


function Wheels:updateWheelFriction(wheel, dt)
    if self.isServer then
        local isOnField = wheel.densityType ~= 0
        local depth = wheel.lastColor[4]
        local groundType = WheelsUtil.getGroundType(isOnField, wheel.contact ~= Wheels.WHEEL_GROUND_CONTACT, depth)
        local coeff = WheelsUtil.getTireFriction(wheel.tireType, groundType, g_currentMission.environment.weather:getGroundWetness())
        if coeff ~= wheel.tireGroundFrictionCoeff then
            wheel.tireGroundFrictionCoeff = coeff
            self:setWheelTireFrictionDirty(wheel)
        end
    end
end


if REA.ModActivated == nil then

	addModEventListener(REA);

	REA.ModActivated = true;
	REA.FilePath = g_currentModDirectory;
	REA.overlay = {};
	REA.GroundWetnessFactor = 0;
	REA.SeasonsLoaded = false;
	REA.PrecisionFarmingLoaded = false;
	print("mod activated")

	-- Exchange standard GIANT'S functions for editet by REA
	-- Change Giant's "Wheels" with REA adjusted
	Wheels.updateWheelSink = REA.REAupdateWheelSink;
	Wheels.onUpdateTick = REA.REAonUpdateTick;
	Wheels.updateWheelTireTracks = REA.REAupdateWheelTireTracks;
	-- Change Giant's "Vehicle" with REA adjusted
	Vehicle.addToPhysics = REA.REAaddToPhysics;
	Vehicle.loadComponentFromXML = REA.REAloadComponentFromXML;

	-- Standard functions exchanged
	print("New REA functions loaded")

end;
