---
-- AnimatedObjectExtend
--
-- 
--
-- 


function load(self, superFunc, nodeId, xmlFile, key, xmlFilename)
	local success = superFunc(self, nodeId, xmlFile, key, xmlFilename)
    local autoopenkey = key .. ".autoOpen"
    self.autoopen= Utils.getNoNil(getXMLBool(xmlFile, autoopenkey.."#use"), false)
	self.objectcount = 0
	--local changetriggerId = I3DUtil.indexToObject(nodeId, getXMLString(xmlFile, key..".controls#triggerNode"))
	if self.controls.triggerId ~= nil then
		setCollisionMask(self.controls.triggerId, 1056768)
	end
	
	
	return success
end

function AnimatedObject:autoOpen(objectcount,noEventSend)
	if self.isServer then
		self.objectcount = objectcount
		if (self.objectcount > 0 ) then
			if self.animation.time ~= 1 then
				self.animation.direction = 1
			end
		else
			if self.animation.time ~= 0 then
				self.animation.direction = -1
			end
		end
        self:raiseActive()
	end
	sendtriggervalues.sendEvent(self, self.objectcount, noEventSend)
end

function triggerCallback(self, superfunc, triggerId, otherId, onEnter, onLeave, onStay, anotherID)   
	

		local vehicle = g_currentMission.nodeToObject[otherId]
		local pvehicle = false
		local vehiclecanaccess = false
		if vehicle ~= nil then			
			if vehicle.vehicleType ~= nil then
				pvehicle = true
				if vehicle:getActiveFarm() ~= nil then
					vehiclecanaccess = g_currentMission.accessHandler:canFarmAccessOtherId(vehicle:getActiveFarm(), self.ownerFarmId)
				else
					vehiclecanaccess = false
				end
			end
		end
		local oldobjectcount = self.objectcount
		local useauto = false
		if self.autoopen then
			if self.openingHours ~=nil then
				if self.openingHours.isOpen then
					useauto = true
				else
					useauto = false
				end
			else
				useauto = true
			end
		end
		if onEnter or onLeave then
				if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
	
					if onEnter then
						if self.ownerFarmId == nil or self.ownerFarmId == AccessHandler.EVERYONE or g_currentMission.accessHandler:canFarmAccessOtherId(g_currentMission:getFarmId(), self.ownerFarmId) then
							self.playerInRange = true
						end
					else 	
						self.playerInRange = nil
					end				
					self:raiseActive()	
				else
					if pvehicle then
						if self.ownerFarmId == nil or self.ownerFarmId == AccessHandler.EVERYONE or vehiclecanaccess then
							if onEnter then
								if useauto then
									self.objectcount = self.objectcount + 1
								end
							else 
								if useauto then
									self.objectcount = math.max(self.objectcount - 1, 0) 
								end
							end			
						end
					end
				end
			
		
			if useauto and oldobjectcount ~= self.objectcount then
				self:autoOpen(self.objectcount)							
			end
		end
end

function readStream(aniobj, streamId, connection)
     if connection:getIsServer() then
		aniobj.objectcount = streamReadUInt8(streamId)
    end
end

function writeStream(aniobj, streamId, connection)
    if not connection:getIsServer() then
		streamWriteUInt8(streamId, aniobj.objectcount)
    end
end


sendtriggervalues = {}
local sendtriggervalues_mt = Class(sendtriggervalues, Event)

InitEventClass(sendtriggervalues, "sendtriggervalues")

function sendtriggervalues:emptyNew()
    local self = Event:new(sendtriggervalues_mt)
    return self
end

function sendtriggervalues:new(aniobj, objectcount)
    local self = sendtriggervalues:emptyNew()
    self.aniobj = aniobj
	self.objectcount = objectcount
    return self
end

function sendtriggervalues:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.aniobj)
	streamWriteUInt8(streamId, self.objectcount)
end

function sendtriggervalues:readStream(streamId, connection)
	self.aniobj = NetworkUtil.readNodeObject(streamId)
	self.objectcount = streamReadUInt8(streamId)
    self:run(connection)
end

function sendtriggervalues:run(connection)
	self.aniobj:autoOpen(self.objectcount,true)
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, nil, connection, self.aniobj)
    end
end

function sendtriggervalues.sendEvent(aniobj,objectcount, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(sendtriggervalues:new(aniobj, objectcount), nil, nil, aniobj)
		else
			g_client:getServerConnection():sendEvent(sendtriggervalues:new(aniobj,objectcount))
		end
	end
end
		
	
AnimatedObject.load = Utils.overwrittenFunction(AnimatedObject.load, load)
AnimatedObject.readStream = Utils.appendedFunction(AnimatedObject.readStream, readStream)
AnimatedObject.writeStream = Utils.appendedFunction(AnimatedObject.writeStream, writeStream)
AnimatedObject.triggerCallback = Utils.overwrittenFunction(AnimatedObject.triggerCallback, triggerCallback)
