--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 25.08.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 25.08.2019 - Release Version

Important:
Free for use in other mods - no permission needed.
No changes are to be made to this script without permission from GtX | Andy

Frei verwendbar - keine erlaubnis nötig
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


ObjectStorageLoader = {}
ObjectStorageLoader.guiPath = ""

ObjectStorageLoader.BUILD_ID = 6

local modName = g_currentModName
local modDirectory = g_currentModDirectory

local eventFiles = {
    "ObjectStorageSpawnEvent.lua",
    "ObjectStorageStoreEvent.lua",
    "ObjectStorageFermentEvent.lua",
    "ObjectStorageSpecialStoreEvent.lua"
}

function ObjectStorageLoader.init()
    local xmlFile = loadXMLFile("modDesc", modDirectory .. "modDesc.xml")
    if xmlFile ~= 0 then
        local canLoadPlaceable = true

        local mainPath = ObjectStorageLoader.getValidPath(xmlFile, "modDesc.objectStorageLoader#filePath", modDirectory)
        local eventsPath = ObjectStorageLoader.getValidPath(xmlFile, "modDesc.objectStorageLoader#eventsPath", modDirectory)
        local guiPath = ObjectStorageLoader.getValidPath(xmlFile, "modDesc.objectStorageLoader#guiPath", modDirectory)

        ObjectStorageLoader.guiPath = guiPath

        for i = 1, #eventFiles do
            local sourceFile = eventsPath .. eventFiles[i]

            if fileExists(sourceFile) then
                source(sourceFile)
            else
                canLoadPlaceable = false
                print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required event file '%s' could not be found!", modName, sourceFile))
            end
        end

        if ObjectStorageLoader:loadGUI(canLoadPlaceable, guiPath) then
            local placeablePath = mainPath .. "ObjectStorage.lua"

            if fileExists(placeablePath) then
                g_placeableTypeManager:addPlaceableType("objectStoragePlaceable", "ObjectStorage", placeablePath)
            else
                print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required file '%s' could not be found!", modName, placeablePath))
            end
        else
            print(string.format("  Info: [ObjectStorageLoader] - placeableType '%s.objectStoragePlaceable' failed to load! Supporting files are missing.", modName))
        end

        delete(xmlFile)
        xmlFile = nil
    end
end

function ObjectStorageLoader:loadGUI(canLoad, guiPath)
    if ObjectStorageLoader.getLoadGUI(canLoad) then
        local luaPath = guiPath .. "ObjectStorageGui.lua"
        if fileExists(luaPath) then
            source(luaPath)
        else
            canLoad = false
            print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required file '%s' could not be found!", modName, luaPath))
        end

        if canLoad then
            local xmlPath = guiPath .. "ObjectStorageGui.xml"
            if fileExists(xmlPath) then
                local objectStorageGui = ObjectStorageGui:new(nil, nil)
                g_gui:loadGui(xmlPath, "ObjectStorageGui", objectStorageGui)
            else
                print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required file '%s' could not be found!", modName, xmlPath))
            end
        end
    end

    return canLoad
end

function ObjectStorageLoader.getLoadGUI(canLoad)
    if canLoad and g_gui ~= nil then
        local currentGUI = g_gui.guis.ObjectStorageGui

        if currentGUI == nil or currentGUI.target == nil then
            return true
        end

        local buildId = currentGUI.target.buildId or 1
        if buildId < ObjectStorageLoader.BUILD_ID then
            return true
        end
    end

    return false
end

function ObjectStorageLoader.getValidPath(xmlFile, key, path)
    local filePath = getXMLString(xmlFile, key)

    if filePath ~= nil then
        if filePath:sub(-1) ~= "/" then
            filePath = filePath .. "/"
        end

        return path .. filePath
    end

    return path
end

ObjectStorageLoader.init()
