--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 25.08.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 25.08.2019 - Release Version

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


ObjectStorageFermentEvent = {}
local ObjectStorageFermentEvent_mt = Class(ObjectStorageFermentEvent, Event)

InitEventClass(ObjectStorageFermentEvent, "ObjectStorageFermentEvent")

function ObjectStorageFermentEvent:emptyNew()
    local self = Event:new(ObjectStorageFermentEvent_mt)

    return self
end

function ObjectStorageFermentEvent:new(storage, numberFermenting)
    local self = ObjectStorageFermentEvent:emptyNew()

    self.storage = storage
    self.numberFermenting = numberFermenting

    return self
end

function ObjectStorageFermentEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.storage)
    streamWriteUInt16(streamId, self.numberFermenting)
end

function ObjectStorageFermentEvent:readStream(streamId, connection)
    local storage = NetworkUtil.readNodeObject(streamId)
    local numberFermenting = streamReadUInt16(streamId)

    if storage ~= nil then
        storage.numberFermenting = numberFermenting
    end
end

function ObjectStorageFermentEvent.sendEvent(storage, numberFermenting)
    if g_server ~= nil then
        g_server:broadcastEvent(ObjectStorageFermentEvent:new(storage, numberFermenting), nil, nil, storage)
    else
        print("  Error: [ObjectStorageFermentEvent] This is a Server > Client event only!")
    end
end
