--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 25.08.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 25.08.2019 - Release Version

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


ObjectStorageStoreEvent = {}
local ObjectStorageStoreEvent_mt = Class(ObjectStorageStoreEvent, Event)

InitEventClass(ObjectStorageStoreEvent, "ObjectStorageStoreEvent")

function ObjectStorageStoreEvent:emptyNew()
    local self = Event:new(ObjectStorageStoreEvent_mt)

    return self
end

function ObjectStorageStoreEvent:new(storage, fillTypeIndex, fillLevel)
    local self = ObjectStorageStoreEvent:emptyNew()

    self.storage = storage
    self.fillTypeIndex = fillTypeIndex
    self.fillLevel = fillLevel

    return self
end

function ObjectStorageStoreEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.storage)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)
    streamWriteFloat32(streamId, self.fillLevel)
end

function ObjectStorageStoreEvent:readStream(streamId, connection)
    self.storage = NetworkUtil.readNodeObject(streamId)
    self.fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
    self.fillLevel = streamReadFloat32(streamId)

    self:run(connection)
end

function ObjectStorageStoreEvent:run(connection)
    if self.storage ~= nil then
        self.storage:updateStoredObjects(self.fillTypeIndex, self.fillLevel, false, nil, nil, false)
    end
end

function ObjectStorageStoreEvent.sendEvent(storage, fillTypeIndex, fillLevel)
    if g_server ~= nil then
        g_server:broadcastEvent(ObjectStorageStoreEvent:new(storage, fillTypeIndex, fillLevel), nil, nil, storage)
    else
        print("  Error: [ObjectStorageStoreEvent] This is a Server > Client event only!")
    end
end
