-- New function to search for items, either globally or in a specific category type
function ShopController:searchItems(searchTerm, pageName)
	local items = {}

	for _, storeItem in pairs(self.storeManager:getItems()) do
    local brand = self.brandManager:getBrandByIndex(storeItem.brandIndex) or {name = ""}

    if not storeItem.isBundleItem and storeItem.showInStore then

      if string.find(storeItem.name:lower(), searchTerm) or string.find(brand.name:lower(), searchTerm) then
        local category = self.storeManager:getCategoryByName(storeItem.categoryName)

        if pageName == 'brands' or (pageName == 'vehicles' and category.type == 'VEHICLE') or (pageName == 'objects' and category.type == 'OBJECT') or (pageName == 'placeables' and category.type == 'PLACEABLE') or (pageName == 'tools' and category.type == 'TOOL') then
			    local displayItem = self:makeDisplayItem(storeItem)

			    table.insert(items, displayItem)
        end
      end
		end
	end

	return items
end

-- Search function for searching owned items
function ShopController:searchOwnedItems(searchTerm)
	local items = {}

	for _, displayItem in pairs(self:getOwnedItems()) do
    local brand = self.brandManager:getBrandByIndex(displayItem.storeItem.brandIndex) or {name = ""}

    print ('displayItem.name')
    print (displayItem.name)
    print ('displayItem.storeItem.name')
    print (displayItem.storeItem.name)

    if string.find(displayItem.storeItem.name:lower(), searchTerm) or string.find(displayItem.concreteItem.getName ~= nil and displayItem.concreteItem:getName():lower() or '', searchTerm) or string.find(brand.name:lower(), searchTerm) then
      table.insert(items, displayItem)
		end
	end

	return items
end

-- Search function for searching leased items
-- Same logic as above, but refactoring it into its own method
-- would not improve readability for novice viewers
function ShopController:searchLeasedItems(searchTerm)
	local items = {}

	for _, displayItem in pairs(self:getLeasedVehicles()) do
    local brand = self.brandManager:getBrandByIndex(displayItem.storeItem.brandIndex) or {name = ""}

    if string.find(displayItem.storeItem.name:lower(), searchTerm) or string.find(displayItem.concreteItem.getName ~= nil and displayItem.concreteItem:getName():lower() or '', searchTerm) or string.find(brand.name:lower(), searchTerm) then
      table.insert(items, displayItem)
		end
	end

	return items
end
