-- New callback function to respond to a search request
-- Placed in the ShopMenu calls for code consistency with 
-- the other display functions in that class
function ShopMenu:onSearchFinished(text, ok)
	if ok and text:len() > 0 then

    local searchTerm = text:lower()
    local items = self.shopController:searchItems(searchTerm, self.currentPageName)
    self.currentDisplayItems = items

    local pageName = self.currentPageName
    if pageName == 'brands' then
      pageName = 'shop'
    end

    self.pageShopItemDetails:setDisplayItems(items, false)
    self.pageShopItemDetails:setCategory(getNormalizedUVs(self.TAB_UV[self.currentPageName:upper()]), g_i18n:getText('ui_' .. pageName), g_i18n:getText('modHub_search') .. " '" .. text .. "'")
    self:pushDetail(self.pageShopItemDetails)
	end
end

-- Overriding the base class onButtonBack behavior by implementing it in ShopMenu
-- To make keyboard 'ESC' behavior work, search results are pushed to the stack
-- However, on pop, because the UI elements and bottom buttons are shared, the
-- search mode needs to be cancelled and all headers and buttons reset
-- Ideally, this should call the superclass method, but that caused errors, so
-- that code is duplicated
function ShopMenu:onButtonBack()
  local comingFromSearch = self.garageSearchActive

  local owned = {}
  local leased = {}

  if self.garageSearchActive == true then

    owned = self.shopController:getOwnedItems()
    leased = self.shopController:getLeasedVehicles()

    self.pageShopGarageOwned:setDisplayItems(owned, true)
	  self.pageShopGarageLeased:setDisplayItems(leased, true)
    
    self.pageShopGarageOwned:setCategory(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText('shop_category'), '')
    self.pageShopGarageOwned:setHeader(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText(self.L10N_SYMBOL.HEADER_GARAGE_OWNED))
    self.pageShopGarageLeased:setCategory(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText('shop_category'), '')
    self.pageShopGarageLeased:setHeader(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText(self.L10N_SYMBOL.HEADER_GARAGE_LEASED))

    self.garageSearchActive = false
  else
    if self:isAtRoot() then
      self:exitMenu()
    else
      self:popDetail()
    end
  end

  if comingFromSearch then
    local detail = self:getTopFrame()

    self:updateGarageButtonInfo(detail, detail == self.pageShopGarageOwned, detail == self.pageShopGarageOwned and #owned or #leased, false)
  end

end

-- Callback to respond to a garage search request
-- Both owned and leased are always searched using controller methods
-- This is done so tabbing between owned and leased also works in search mode
function ShopMenu:onSearchGarageFinished(text, ok)
	if ok and text:len() > 0 then

    local searchTerm = text:lower()
    
    local detail = self:getTopFrame()

    local ownedItems = self.shopController:searchOwnedItems(searchTerm)
    local leasedItems = self.shopController:searchLeasedItems(searchTerm)

    self.pageShopGarageOwned:setDisplayItems(ownedItems, true)
    self.pageShopGarageOwned:setCategory(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText('modHub_search'), g_i18n:getText('modHub_search') .. " '" .. text .. "'")
    -- setCategory also sets the header, set it back
    self.pageShopGarageOwned:setHeader(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText(ShopMenu.L10N_SYMBOL.HEADER_GARAGE_OWNED))

    self.pageShopGarageLeased:setDisplayItems(leasedItems, true)
    self.pageShopGarageLeased:setCategory(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText('modHub_search'), g_i18n:getText('modHub_search') .. " '" .. text .. "'")
    -- setCategory also sets the header, set it back
    self.pageShopGarageLeased:setHeader(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText(ShopMenu.L10N_SYMBOL.HEADER_GARAGE_LEASED))

    self.garageSearchActive = true
    self:updateGarageButtonInfo(detail, detail == self.pageShopGarageOwned, detail == self.pageShopGarageOwned and #ownedItems or #leasedItems, false)

    -- self:pushDetail(self.lastGaragePage)
	end
end