ShopSearch = {}

local ShopSearch_mt = Class(ShopSearch)

function ShopSearch:new(mission, i18n, gui)
  local self = setmetatable({}, ShopSearch_mt)

  self.i18n = i18n
  self.gui = gui
  self.mission = mission

  ShopMenu.updateGarageButtonInfo = Utils.overwrittenFunction(ShopMenu.updateGarageButtonInfo, self.shopMenu_insteadOf_updateGarageButtonInfo)

  return self
end

-- Overwritten function to update garage buttons
-- Because the method used a local table and calls and update method at the end,
-- it's not possible to prepend or append, also the additional button logic is 
-- quite interwoven, so overriding is the most efficient solution
function ShopSearch.shopMenu_insteadOf_updateGarageButtonInfo(me, superFunc, detailPage, isOwned, numItems, canRepair)
	if detailPage ~= nil then
		local pageButtonInfo = detailPage:getMenuButtonInfo()

		for k in pairs(pageButtonInfo) do
			pageButtonInfo[k] = nil
		end

		if numItems > 0 then
			table.insert(pageButtonInfo, me.sellButtonInfo)
		end


    if not me.garageSearchActive then
		  table.insert(pageButtonInfo, me.backButtonInfo)
    else
      table.insert(pageButtonInfo, me.resetGarageSearchButtonInfo)
    end

    if not me.garageSearchActive then
      table.insert(pageButtonInfo, me.searchGarageButton)
    end

		table.insert(pageButtonInfo, me.switchOwnedLeasedButtonInfo)

		if canRepair then
      print('repair enabled')
			table.insert(pageButtonInfo, me.repairButtonInfo)
		end

		me:updateButtonsPanel(detailPage)
	end
end

-- Function to add the definitions for all the new and updated buttons
-- The ShopMenu class that defines these is called very early, so just
-- adding them at our own convenience works better
function ShopSearch:setupSearchButtons()
  local shopMenu = self.mission.shopMenu

  shopMenu.searchButton = {
    inputAction = InputAction.MENU_ACTIVATE,
    text = self.i18n:getText('modHub_search'),
    callback = function ()
			self:onSearchButton(shopMenu)
		end,
    clickSound = GuiSoundPlayer.SOUND_SAMPLES.PAGING
  }

  shopMenu.searchGarageButton = {
    inputAction = InputAction.MENU_ACTIVATE,
    text = self.i18n:getText('modHub_search'),
    callback = function ()
			self:onSearchGarageButton(shopMenu)
		end,
    clickSound = GuiSoundPlayer.SOUND_SAMPLES.PAGING
  }

  shopMenu.switchOwnedLeasedButtonInfo = {
		inputAction = InputAction.MENU_CANCEL,
		text = self.i18n:getText(ShopMenu.L10N_SYMBOL.LEASED_ITEMS),
		callback = shopMenu:makeSelfCallback(shopMenu.onButtonSwitchOwnedLeased)
	}

  shopMenu.shopMenuButtonInfo = {
		shopMenu.backButtonInfo,
		{
			inputAction = InputAction.MENU_CANCEL,
			text = self.i18n:getText(ShopMenu.L10N_SYMBOL.BUTTON_GARAGE),
			callback = function()
        self:onButtonGarage(shopMenu)
      end,
			clickSound = GuiSoundPlayer.SOUND_SAMPLES.PAGING
		},
    shopMenu.searchButton
	}

  shopMenu.resetGarageSearchButtonInfo = {
    inputAction = InputAction.MENU_BACK,
		text = self.i18n:getText('button_reset'),
		callback = function()
      shopMenu:onButtonBack()
    end,
  }
end

-- As there's many paths out of the garage (any of the header buttons), we also reset the header text back to default when the garage button is clicked again
function ShopSearch:onButtonGarage(shopMenu)
  self:resetGarageHeaders(shopMenu)

  shopMenu:onButtonGarage()
end

function ShopSearch:resetGarageHeaders(shopMenu)
  shopMenu.pageShopGarageOwned:setCategory(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), self.i18n:getText('shop_category'), '')
  shopMenu.pageShopGarageOwned:setHeader(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText(ShopMenu.L10N_SYMBOL.HEADER_GARAGE_OWNED))
  shopMenu.pageShopGarageLeased:setCategory(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), self.i18n:getText('shop_category'), '')
  shopMenu.pageShopGarageLeased:setHeader(getNormalizedUVs(ShopMenu.TAB_UV.GARAGE), g_i18n:getText(ShopMenu.L10N_SYMBOL.HEADER_GARAGE_LEASED))
end


function ShopSearch:onSearchButton(shopMenu)
  local pageName = shopMenu.currentPageName
  if pageName == 'brands' then
    pageName = 'shop'
  end

  self.gui:showTextInputDialog({
		disableFilter = true,
		maxCharacters = 40,
		callback = function (text, ok) 
      shopMenu:onSearchFinished(text, ok)
    end,
		dialogPrompt = self.i18n:getText('modHub_search') .. ' ' .. self.i18n:getText('ui_' .. pageName),
		imePrompt = self.i18n:getText('modHub_search'),
		confirmText = self.i18n:getText('modHub_search'),
	})
end

function ShopSearch:onSearchGarageButton(shopMenu)
  local pageName = shopMenu.currentPageName
  if pageName == 'brands' then
    pageName = 'shop'
  end

  self.gui:showTextInputDialog({
		disableFilter = true,
		maxCharacters = 40,
		callback = function (text, ok) 
      shopMenu:onSearchGarageFinished(text, ok)
    end,
		dialogPrompt = self.i18n:getText('modHub_search') .. ' ' .. self.i18n:getText('button_garage'),
		imePrompt = self.i18n:getText('modHub_search'),
		confirmText = self.i18n:getText('modHub_search'),
	})
end