-- script for tuning Motorized vehicles
-- V.1
-- By Marv63 2020
-- credits to PeterAH for base structure
   
if g_specializationManager:getSpecializationByName("tuning") == nil then
    g_specializationManager.addSpecialization('tuning', 'tuning', "tuning", Utils.getFilename("tuning.lua", g_currentModDirectory))
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.vehicleTypes) do 
    if vehicleType == nil then
    elseif SpecializationUtil.hasSpecialization(tuning, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(SplineVehicle, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'tuning')
    else
    end
end

function initNewStoreConfig()
    g_configurationManager:addConfigurationType("tuning", g_i18n:getText("CONFIG_TITLE"), "tuning", nil, nil, nil, ConfigurationUtil.SELECTOR_MULTIOPTION)
	StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, addNewStoreConfig)    
end

function addNewStoreConfig(xmlFile, superFunc, baseXMLName, baseDir, customEnvironment, isMod, storeItem)
	local configurations = superFunc(xmlFile, baseXMLName, baseDir, customEnvironment, isMod, storeItem)    
    local tPower 
    
    if storeItem ~= nil then
        if storeItem.specs.power == nil then
            tPower = 0
        elseif storeItem.specs.power == "" then
            tPower = 0
        else
            tPower = Utils.getNoNil(tonumber(storeItem.specs.power), 0)
        end
--        if tPower == 0 and configurations == nil then
--            print(storeItem.categoryName)
--        end
        if tPower > 0 then
            if configurations == nil then
                if storeItem.categoryName == "ANIMALPENS" then
                elseif storeItem.categoryName == "PLACEABLEMISC" then
                elseif storeItem.categoryName == "DECORATION" then
                elseif storeItem.categoryName == "FARMHOUSES" then
                elseif storeItem.categoryName == "SILOS" then
                elseif storeItem.categoryName == "WOOD" then
                elseif storeItem.categoryName == "ANIMALS" then
                else
                    configurations = {}
--                    print(configurations .. storeItemXmlFilename)
                end
            end
        end
    end
    
    local integrateConfig = false
    if storeItem == nil then
        elseif configurations == nil then
        elseif configurations["tuning"] ~= nil then
        else
            integrateConfig = true
    end

    if tPower > 0 and integrateConfig == true then
--        print(tPower .. tostring(integrateConfig))

        local cName
        local cCost 
        local dUpKeep 
		local con = tMotor.config.shopConfig.configuration
		local vCost = StoreItemUtil.getDefaultPrice(storeItem, storeItem.configurations)
		
		configurations["tuning"] = {}
		for i = 1, tMotor.config.shopConfig.configurationsN, 1 do
			cName = "+" .. tostring((con[i].tunMultiplier - 1) * 100) .. "%"
			cCost = tonumber(con[i].cost * vCost + con[i].baseCost) 
			dUpKeep = tonumber(con[i].dUpkeep * vCost)
			
			table.insert(configurations["tuning"], i, {name = cName, index = i, isDefault = false, price = cCost, dailyUpkeep = dUpKeep, desc ="", configMultiplier= con[i].tunMultiplier, repairMultiplier = con[i].repMultiplier})
			if i == 1 then
				configurations["tuning"][i].isDefault = true
			end
		end     

        tMotor.i = tMotor.i + 1
        table.insert(tMotor.xmls, tMotor.i, {filename = storeItem.xmlFilename, first = true, oPower = tPower})
        tMotor.xmls[tMotor.i].filename = storeItem.xmlFilename
    end
    
    return configurations
end

tMotor = {}
tMotor.xmls = {}
tMotor.i = 0
tMotor.configuration = {}

tMotor.config = { 
	VERSION = 1,
	configFile = nil,
	shopConfig = {
		configurationsN = 16, 
		realPowerText = true,
		allowRentTuned = false,
		useDUpkeep = false,
		useSRepair = true,
		configuration = {}
	}
}

function tMotor:deleteMap()
	tMotor:saveConfig()
end

function tMotor:loadConfig()
	if tMotor.config.configFile == nil then
		return
	end
	local xml = loadXMLFile("Tuning_XML", tMotor.config.configFile, "Tuning")
	local xmlVersion = Utils.getNoNil(getXMLInt(xml, "Tuning#Version"), 0)
	if xmlVersion > 0 then 
		tMotor.config.shopConfig.allowRentTuned = Utils.getNoNil(getXMLBool(xml, "Tuning.shopConfig.rentTuned#allowed"), tMotor.config.shopConfig.allowRentTuned)
		tMotor.config.shopConfig.realPowerText = Utils.getNoNil(getXMLBool(xml, "Tuning.shopConfig.realPowerText#Show_real_power_text_in_config_Window"), tMotor.config.shopConfig.realPowerText)
		tMotor.config.shopConfig.configurationsN = Utils.getNoNil(getXMLInt(xml, "Tuning.shopConfig.configurations#Number_of_Configs"), tMotor.config.shopConfig.configurationsN)
		tMotor.config.shopConfig.useDUpkeep = Utils.getNoNil(getXMLBool(xml, "Tuning.shopConfig.runningTuningCosts#Use_daily_Upkeep_costs_as_damage_Simulation"), tMotor.config.shopConfig.useDUpkeep)
		tMotor.config.shopConfig.useSRepair = Utils.getNoNil(getXMLBool(xml, "Tuning.shopConfig.runningTuningCosts#Use_shortened_Repair_intervall_as_damage_Simulation"), tMotor.config.shopConfig.useSRepair)
		for i = 1, tMotor.config.shopConfig.configurationsN, 1 do
			if tMotor.config.shopConfig.configuration[i] == nil then
				table.insert(tMotor.config.shopConfig.configuration, i, {})
			end
			tMotor.config.shopConfig.configuration[i].tunMultiplier = Utils.getNoNil(getXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Tuning_Multiplier"), tMotor.config.shopConfig.configuration[i].tunMultiplier)
			tMotor.config.shopConfig.configuration[i].cost = Utils.getNoNil(getXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Buycost_in_percent_of_Full_price_that_adds_to_chip_Base_cost"), tMotor.config.shopConfig.configuration[i].cost)
			tMotor.config.shopConfig.configuration[i].baseCost = Utils.getNoNil(getXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Basecost_of_a_chip"), tMotor.config.shopConfig.configuration[i].baseCost)
			tMotor.config.shopConfig.configuration[i].dUpkeep = Utils.getNoNil(getXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Daily_Upkeep_Cost_in_percent_of_Full_price"), tMotor.config.shopConfig.configuration[i].dUpkeep)
			tMotor.config.shopConfig.configuration[i].repMultiplier = Utils.getNoNil(getXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Repairtime_Multiplier"), tMotor.config.shopConfig.configuration[i].repMultiplier)
		end
	end
	if delete ~= nil then
		delete(xml)
	end
	if xmlVersion ~= tMotor.config.VERSION then
		tMotor:saveConfig()
	end
    initNewStoreConfig()
end

function tMotor:saveConfig()
	if tMotor.config.configFile == nil then
		return
	end
	print("saving Config")
	local xml = createXMLFile("Tuning_XML", tMotor.config.configFile, "Tuning")
	setXMLInt(xml, "Tuning#Version", tMotor.config.VERSION)
	setXMLBool(xml, "Tuning.shopConfig.rentTuned#allowed", tMotor.config.shopConfig.allowRentTuned)
	setXMLBool(xml, "Tuning.shopConfig.realPowerText#Show_real_power_text_in_config_Window", tMotor.config.shopConfig.realPowerText)
	setXMLInt(xml, "Tuning.shopConfig.configurations#Number_of_Configs",tMotor.config.shopConfig.configurationsN)
	setXMLBool(xml, "Tuning.shopConfig.runningTuningCosts#Use_daily_Upkeep_costs_as_damage_Simulation", tMotor.config.shopConfig.useDUpkeep)
	setXMLBool(xml, "Tuning.shopConfig.runningTuningCosts#Use_shortened_Repair_intervall_as_damage_Simulation", tMotor.config.shopConfig.useSRepair)
	local tunMultiplier = {1, 1.05, 1.1, 1.15, 1.2, 1.25, 1.3, 1.35, 1.4, 1.45, 1.5, 1.6, 1.7, 1.8, 1.9, 2}
	for i = 1, tMotor.config.shopConfig.configurationsN, 1  do
		if tMotor.config.shopConfig.configuration[i] == nil then
			table.insert(tMotor.config.shopConfig.configuration, i, {})
		end
		setXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Tuning_Multiplier", Utils.getNoNil(tMotor.config.shopConfig.configuration[i].tunMultiplier, tunMultiplier[i]))
		setXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Buycost_in_percent_of_Full_price_that_adds_to_chip_Base_cost", Utils.getNoNil(tMotor.config.shopConfig.configuration[i].cost, (math.log10(i + 1)+0.5) * 0.01))
		setXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Basecost_of_a_chip",Utils.getNoNil(tMotor.config.shopConfig.configuration[i].baseCost, 2000))
		setXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Daily_Upkeep_Cost_in_percent_of_Full_price", Utils.getNoNil(tMotor.config.shopConfig.configuration[i].dUpKeep, math.pow(i - 0.8, 2) / 3200))
		setXMLFloat(xml, "Tuning.shopConfig.configurations.conf".. tostring(i).."#Repairtime_Multiplier",Utils.getNoNil(tMotor.config.shopConfig.configuration[i].repMultiplier, 1 - math.pow(i - 0.8, 2.3) / 2100))
	end
	
	saveXMLFile(xml)
	
	if delete ~= nil then
		delete(xml)
	end
    tMotor.loadConfig()
end

function tMotor:update(dt)
    if g_gui.guis.ShopMenu.target.isOpen == true then
        local ii = 0
        for ii = 1, tMotor.i do
            local oPowerPS = tMotor.xmls[ii].oPower 
            if tMotor.xmls[ii].first == true then
                local storeItem = g_storeManager:getItemByXMLFilename(tMotor.xmls[ii].filename)
                if storeItem ~= nil and storeItem.configurations ~= nil then
                    if storeItem.configurations["tuning"] ~= nil and storeItem.configurations["motor"] ~= nil then
                        local con = tMotor.config.shopConfig.configuration
						local i = 1
                        local powerkW
                        local powerPS
                        local vCost = StoreItemUtil.getDefaultPrice(storeItem, storeItem.configurations)
                        for i = 1, 16, 1 do
                            multiplier = storeItem.configurations["tuning"][i].configMultiplier
                            powerPS = math.floor(oPowerPS * multiplier)
                            powerkW = math.floor(powerPS / 1.35962)
                            storeItem.configurations["tuning"][i].name = "+" .. tostring((tMotor.round(storeItem.configurations["tuning"][i].configMultiplier, 2) - 1 ) * 100) .. "%" 
-- .. "% (" .. tostring(powerkW) .. "kW/" .. tostring(powerPS) .. g_i18n:getText("CONFIG_HPPOWER") .. ")"
                            if i == 1 then
                                storeItem.configurations["tuning"][i].price = 0
                                storeItem.configurations["tuning"][i].dailyUpkeep = 0

                            else
								storeItem.configurations["tuning"][i].price = tonumber(con[i].cost * vCost + con[i].baseCost)
								if tMotor.config.shopConfig.useDUpkeep then
									storeItem.configurations["tuning"][i].dailyUpkeep = tonumber(con[i].dUpkeep * vCost)
								end
							end
                            tMotor.xmls[ii].first = false
                        end
                    end
                end
            elseif tMotor.xmls[ii].first == false then
                local storeItem = g_storeManager:getItemByXMLFilename(tMotor.xmls[ii].filename)
                if storeItem ~= nil and storeItem.configurations ~= nil then
                    if storeItem.configurations["tuning"] ~= nil and storeItem.configurations["motor"] ~= nil then
                        local con = tMotor.config.shopConfig.configuration
						local i = 1
                        local powerkW
                        local powerPS
                        local vCost = StoreItemUtil.getDefaultPrice(storeItem, storeItem.configurations)
                        for i = 1, 16, 1 do
                            
                            multiplier = tMotor.round(storeItem.configurations["tuning"][i].configMultiplier, 2)
                            powerPS = math.floor(oPowerPS * multiplier)
                            powerkW = math.floor(powerPS / 1.35962)
                            storeItem.configurations["tuning"][i].name = "+" .. tostring((multiplier - 1 ) * 100) .. "%"
-- .. "% (" .. tostring(powerkW) .. "kW/" .. tostring(powerPS) .. g_i18n:getText("CONFIG_HPPOWER") .. ")"
                            if i == 1 then
                                storeItem.configurations["tuning"][i].price = 0
                                storeItem.configurations["tuning"][i].dailyUpkeep = 0
                                
                            else
								storeItem.configurations["tuning"][i].price = tonumber(con[i].cost * vCost + con[i].baseCost)
								if tMotor.config.shopConfig.useDUpkeep then
									storeItem.configurations["tuning"][i].dailyUpkeep = tonumber(con[i].dUpkeep * vCost)                            
								end
							end
                            
                        end
                    end
                end
            else
            end        
        end
    elseif g_shopConfigScreen.isOpen == true and g_shopConfigScreen.storeItem ~= nil then
        
        local storeItem = g_shopConfigScreen.target.shopConfigScreen.storeItem
        local cScreen = g_shopConfigScreen.target.shopConfigScreen
        if storeItem ~= nil and storeItem.configurations ~= nil then
            if storeItem.configurations["tuning"] ~= nil and storeItem.configurations["motor"] ~= nil then             
                local con = tMotor.config.shopConfig.configuration
				local tConfigId = g_shopConfigScreen.configurations.tuning
                local oPowerPS = Utils.getNoNil(storeItem.configurations["motor"][Utils.getNoNil(g_shopConfigScreen.configurations.motor, 1)].power, storeItem.specs.power) --the get no nil is because giants didn´t indexed some of their motor configs.... this also makes it cumbersome to have the correct power shown for this in the original field, so i left it (its only the first harvester and tractor, who wants to tune them anyways?)
                local multiplier = tMotor.round(Utils.getNoNil(storeItem.configurations["tuning"][Utils.getNoNil(tConfigId, 1)].configMultiplier, 1), 2)
                local powerPS = math.floor(oPowerPS * multiplier)
                local powerkW = math.floor(powerPS / 1.35962)
                local vCost = storeItem.price
                storeItem.configurations["tuning"][tConfigId].name = "+" .. tostring((multiplier - 1 ) * 100) .. "%"
-- .. "% (" .. tostring(powerkW) .. "kW/" .. tostring(powerPS) .. g_i18n:getText("CONFIG_HPPOWER") .. ")"
                if tConfigId == 1 then
                    storeItem.configurations["tuning"][tConfigId].price = 0
                    storeItem.configurations["tuning"][tConfigId].dailyUpkeep = 0
                    storeItem.allowLeasing = true
                    g_shopConfigScreen.target.shopConfigScreen.leaseButton.disabled = false
                else
                    storeItem.configurations["tuning"][tConfigId].price = tonumber(con[tConfigId].cost * vCost + con[tConfigId].baseCost)
                    if tMotor.config.shopConfig.useDUpkeep then 
						storeItem.configurations["tuning"][tConfigId].dailyUpkeep = tonumber(con[tConfigId].dUpkeep * vCost)
                    end
					if not tMotor.config.shopConfig.allowRentTuned then
						--storeItem.allowLeasing = false
						g_shopConfigScreen.target.shopConfigScreen.leaseButton.disabled = true
					else
						--storeItem.allowLeasing = true
						g_shopConfigScreen.target.shopConfigScreen.leaseButton.disabled = false
					end
-- this line allows seeing the real power in the intended place by giants, but its always one mouseklick behind... so very confusing and i left it out                    storeItem.specs.power = powerPS
                end
-- list of not working shit to update the name, the original power value and disable the leasing button(it only loses the function, but won´t be invisible only if you reenter the vehicle:
-- as you can see i update all values in the target of the view, so, it should be automaticly be updated on change when you assume that the storeconfigscreen works like other guis, which it seemingly doesn´t or im fucking retardet
--              g_shopConfigStore.updateData()
--              ShopConfigScreen.updateData()
--              g_shopConfigStore.updateDisplay()
--              ShopConfigScreen.updateDisplay()
-- i stoped taking notes but i tried many many more in the script console of the anoying giants debugger
-- since nothing works to update this UI and i tried for aproximatly 20 hours  to let the config name adjust and HP sign on the attributes(this kinda works, but it always lags one klick behind... idk if you got any suggestions let me know, im on pretty much every online Modding comunity known as Marv63. I really got pissed by this. So don´t expect any updates to soon. But there will be updates because its so anoying. I think.
                if tMotor.config.shopConfig.realPowerText then
					renderText(0.12, 0.35, 0.02,tostring(g_i18n:getText("STORE_SUCKS_EMERGENCYSOLUTION") .. tostring(powerkW) .. "kW/" .. tostring(powerPS) .. g_i18n:getText("CONFIG_HPPOWER")))
				end
			end
        end
    else
    end
end

function tMotor.round(num, numDecimalPlaces)
    return tonumber(string.format("%." .. (numDecimalPlaces or 0) .. "f", num))
end

if tMotor.active == nil then
	tMotor.active = true
	addModEventListener(tMotor)
end

if g_configurationManager.configurations["tuning"] == nil then
	local modSettingsDir = getUserProfileAppPath() .. "modsSettings/"
	createFolder(modSettingsDir)
	local mySettingsDir = modSettingsDir .. "Tuning/"
	createFolder(mySettingsDir)
	tMotor.config.configFile = mySettingsDir .. "Tuning.xml"
	print("Using config file " .. tMotor.config.configFile)
	if fileExists(tMotor.config.configFile) then
		tMotor:loadConfig()
	else
		tMotor:saveConfig()
	end
end