--[[
Interface: 1.7.1.0 b10490

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 10.10.2018

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


UniversalPassengerEnterEvent = {}

local UniversalPassengerEnterEvent_mt = Class(UniversalPassengerEnterEvent, Event)
InitEventClass(UniversalPassengerEnterEvent, "UniversalPassengerEnterEvent")

function UniversalPassengerEnterEvent:emptyNew()
    local self = Event:new(UniversalPassengerEnterEvent_mt)
    return self
end

function UniversalPassengerEnterEvent:new(objectId, passenger, seatId)
    local self = UniversalPassengerEnterEvent:emptyNew()

    self.objectId = objectId
    self.passenger = passenger
    self.seatId = seatId

    return self
end

function UniversalPassengerEnterEvent:readStream(streamId, connection)
    self.objectId = NetworkUtil.readNodeObjectId(streamId)
    self.passenger = NetworkUtil.readNodeObject(streamId)
    self.seatId = streamReadUInt8(streamId)

    self:run(connection)
end

function UniversalPassengerEnterEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObjectId(streamId, self.objectId)
    NetworkUtil.writeNodeObject(streamId, self.passenger)
    streamWriteUInt8(streamId, self.seatId)
end

function UniversalPassengerEnterEvent:run(connection)
    local object = NetworkUtil.getObject(self.objectId)

    if object ~= nil then
        if self.passenger == g_currentMission.player then
            object:enterPassengerSeat(true, self.seatId, self.passenger)
        else
            if object:getIsSeatAvailable(self.seatId) then
                object:enterPassengerSeat(false, self.seatId, self.passenger)
            end
        end
    end
end
