--[[
Interface: 1.7.1.0 b10490

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 10.10.2018

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


UniversalPassengerNextSeatEvent = {}

local UniversalPassengerNextSeatEvent_mt = Class(UniversalPassengerNextSeatEvent, Event)
InitEventClass(UniversalPassengerNextSeatEvent, "UniversalPassengerNextSeatEvent")

function UniversalPassengerNextSeatEvent:emptyNew()
    local self = Event:new(UniversalPassengerNextSeatEvent_mt)
    return self
end

function UniversalPassengerNextSeatEvent:new(object, oldSeatId, newSeatId)
    local self = UniversalPassengerNextSeatEvent:emptyNew()

    self.object = object
    self.oldSeatId = oldSeatId
    self.newSeatId = newSeatId

    return self
end

function UniversalPassengerNextSeatEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.oldSeatId = streamReadUInt8(streamId)
    self.newSeatId = streamReadUInt8(streamId)

    self:run(connection)
end

function UniversalPassengerNextSeatEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUInt8(streamId, self.oldSeatId)
    streamWriteUInt8(streamId, self.newSeatId)
end

function UniversalPassengerNextSeatEvent:run(connection)
    if not connection:getIsServer() then
        local newSeatId = self.object:getNextSeat(self.oldSeatId)

        if newSeatId ~= 0 then
            self.newSeatId = newSeatId
            self.object:setConnectionToSeatId(connection, newSeatId, true)
            g_server:broadcastEvent(UniversalPassengerNextSeatEvent:new(self.object, self.oldSeatId, self.newSeatId), nil, connection, self.object)
            connection:sendEvent(UniversalPassengerNextSeatEvent:new(self.object, self.oldSeatId, self.newSeatId))
        end
    end

    self.object:cyclePassengerSeats(self.oldSeatId, self.newSeatId)
end
