-- author: DD ModPassion
-- date: 04.02.2020
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: farming simulator 19
attacherJointControlCutter = {} function attacherJointControlCutter.prerequisitesPresent(specializations) return SpecializationUtil.hasSpecialization(AttacherJointControl, specializations) end function attacherJointControlCutter.registerOverwrittenFunctions(vehicleType) SpecializationUtil.registerOverwrittenFunction(vehicleType, "loadInputAttacherJoint", attacherJointControlCutter.loadInputAttacherJoint) SpecializationUtil.registerOverwrittenFunction(vehicleType, "getIsLowered", attacherJointControlCutter.getIsLowered) end function attacherJointControlCutter.registerEventListeners(vehicleType) SpecializationUtil.registerEventListener(vehicleType, "onLoad", attacherJointControlCutter) SpecializationUtil.registerEventListener(vehicleType, "onPostAttach", attacherJointControlCutter) SpecializationUtil.registerEventListener(vehicleType, "onAIImplementStart", attacherJointControlCutter) SpecializationUtil.registerEventListener(vehicleType, "onAIImplementEnd", attacherJointControlCutter) SpecializationUtil.registerEventListener(vehicleType, "onTurnedOn", attacherJointControlCutter) SpecializationUtil.registerEventListener(vehicleType, "onTurnedOff", attacherJointControlCutter) end function attacherJointControlCutter:onLoad(savegame) local spec = self.spec_attacherJointControl spec.attacherVehicle = nil spec.inputJointDescIndex = nil spec.jointDescIndex = nil if #spec.controls == 0 then local control = {} local controlFunc = "controlAttacherJointHeight" if controlFunc ~= nil and self[controlFunc] ~= nil then control.func = self[controlFunc] if control.func == self.controlAttacherJointHeight then spec.heightController = control end end local actionBindingName = "AXIS_TOOL_HAVEREST" if actionBindingName ~= nil and InputAction[actionBindingName] ~= nil then control.controlAction = InputAction[actionBindingName] end local iconName = "IMPLEMENT_ATTACHER_TRANS" if InputHelpElement.AXIS_ICON[iconName] == nil then iconName = (self.customEnvironment or "") .. iconName end control.axisActionIcon = iconName control.invertAxis = true control.mouseSpeedFactor = 0.5 control.moveAlpha = 0 spec.nameToControl[actionBindingName] = control table.insert(spec.controls, control) if self.isClient then spec.lastMoveTime = 0 spec.samples = {} spec.samples.hydraulic = g_soundManager:loadSampleFromXML(self.xmlFile, "vehicle.cylindered.sounds", "hydraulic", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self) end spec.jointDesc = nil spec.dirtyFlag = self:getNextDirtyFlag() end end function attacherJointControlCutter:onPostAttach(attacherVehicle, inputJointDescIndex, jointDescIndex) local spec = self.spec_attacherJointControl spec.attacherVehicle = attacherVehicle spec.inputJointDescIndex = inputJointDescIndex spec.jointDescIndex = jointDescIndex end function attacherJointControlCutter:onTurnedOn() local spec = self.spec_attacherJointControl if spec.jointDesc ~= nil then spec.jointDesc.allowsLowering = false end end function attacherJointControlCutter:onTurnedOff() local spec = self.spec_attacherJointControl if spec.jointDesc ~= nil then spec.jointDesc.allowsLowering = false end end function attacherJointControlCutter:onAIImplementStart() local spec = self.spec_attacherJointControl local inputAttacherJoints = self:getInputAttacherJoints() inputAttacherJoints[spec.inputJointDescIndex].isControllable = false if spec.jointDesc ~= nil then spec.jointDesc.allowsLowering = true spec.jointDesc.upperRotationOffset = spec.jointDesc.upperRotationOffsetBackup spec.jointDesc.lowerRotationOffset = spec.jointDesc.lowerRotationOffsetBackup spec.jointDesc = nil end end function attacherJointControlCutter:onAIImplementEnd() local spec = self.spec_attacherJointControl local inputAttacherJoints = self:getInputAttacherJoints() inputAttacherJoints[spec.inputJointDescIndex].isControllable = true if inputAttacherJoints[spec.inputJointDescIndex] ~= nil and inputAttacherJoints[spec.inputJointDescIndex].isControllable then local attacherJoints = spec.attacherVehicle:getAttacherJoints() local jointDesc = attacherJoints[spec.jointDescIndex] jointDesc.allowsLowering = true jointDesc.upperRotationOffsetBackup = jointDesc.upperRotationOffset jointDesc.lowerRotationOffsetBackup = jointDesc.lowerRotationOffset spec.jointDesc = jointDesc for _, control in ipairs(spec.controls) do control.moveAlpha = control.func(self) end spec.heightTargetAlpha = spec.jointDesc.upperAlpha self:requestActionEventUpdate() end end function attacherJointControlCutter:loadInputAttacherJoint(superFunc, xmlFile, key, inputAttacherJoint, i) if not superFunc(self, xmlFile, key, inputAttacherJoint, i) then return false end inputAttacherJoint.isControllable = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isControllable"), true) return true end function attacherJointControlCutter:getIsLowered(superFunc, default) local spec = self.spec_foldable if spec ~= nil then if self:getIsFoldMiddleAllowed() then if spec.foldMiddleAnimTime ~= nil and spec.foldMiddleInputButton ~= nil then if spec.foldMoveDirection ~= 0 then if spec.foldMiddleDirection > 0 then if spec.foldAnimTime < spec.foldMiddleAnimTime + 0.01 then return spec.foldMoveDirection < 0 and spec.moveToMiddle ~= true end else if spec.foldAnimTime > spec.foldMiddleAnimTime - 0.01 then return spec.foldMoveDirection > 0 and spec.moveToMiddle ~= true end end else if spec.foldMiddleDirection > 0 and spec.foldAnimTime < 0.01 then return true elseif spec.foldMiddleDirection < 0 and math.abs(1.0 - spec.foldAnimTime) < 0.01 then return true end end return false end end end spec = self.spec_attacherJointControl if spec.heightController then local showText = spec.jointDesc ~= nil if showText then if self:getControlAttacherJointDirection() then return false else return true end end end return superFunc(self, default) end