--
-- LoweringSprayer
-- Specialization for LoweringSprayer
--
-- @author John Deere 6930
-- @date 22/08/2019
--

--[[XML

    <sprayer ...>
		<loweringSprayer onlySprayIfLowered="" startSpraySpeedLevel="" effectAnimationName="" />
		...
    </sprayer>
]]

LoweringSprayer = {};
LoweringSprayer.modDir = g_currentModDirectory;
LoweringSprayer.MOD_NAME = g_currentModName;
	
function LoweringSprayer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function LoweringSprayer.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "stopSprayerEffects", 	LoweringSprayer.stopSprayerEffects);
    SpecializationUtil.registerFunction(vehicleType, "startSprayerEffects", LoweringSprayer.startSprayerEffects);
end;

function LoweringSprayer.registerOverwrittenFunctions(vehicleType)
end;

function LoweringSprayer.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", 					LoweringSprayer);
    SpecializationUtil.registerEventListener(vehicleType, "onTurnedOn", 				LoweringSprayer);
    SpecializationUtil.registerEventListener(vehicleType, "onStartWorkAreaProcessing", 	LoweringSprayer);
end

function LoweringSprayer:onLoad(savegame)
    self.spec_loweringSprayer = self[string.format("spec_%s.loweringSprayer", LoweringSprayer.MOD_NAME)];
    local spec = self.spec_loweringSprayer;
	
	spec.onlySprayIfLowered = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.sprayer.loweringSprayer#onlySprayIfLowered"), false);
	spec.startSpraySpeedLevel = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.sprayer.loweringSprayer#startSpraySpeedLevel"), 1.0);
	spec.lastSprayerEffectState = false;
	
    spec.effectAnimationName = getXMLString(self.xmlFile, "vehicle.sprayer.loweringSprayer#effectAnimationName");
	if spec.effectAnimationName ~= nil then
		self:playAnimation(spec.effectAnimationName, -1, nil, true);
	end;
end;

function LoweringSprayer:stopSprayerEffects()
    local spec = self.spec_sprayer;
    if self.isClient then
		g_effectManager:stopEffects(spec.effects);
		g_soundManager:stopSample(spec.samples.work);
		for _, sprayType in ipairs(spec.sprayTypes) do
			g_effectManager:stopEffects(sprayType.effects);
			g_soundManager:stopSample(sprayType.samples.work);
		end;		
		if self.spec_loweringSprayer.effectAnimationName ~= nil then
			self:playAnimation(self.spec_loweringSprayer.effectAnimationName, -1, nil, true);
		end;
    end;
	spec.lastSprayerEffectState = false;
end;

function LoweringSprayer:startSprayerEffects()
    local spec = self.spec_sprayer;
    if self.isClient then
		local sprayType = self:getActiveSprayType();
		if self:getAreEffectsVisible() then
			local fillType = self:getFillUnitLastValidFillType(self:getSprayerFillUnitIndex());
			if fillType == FillType.UNKNOWN then
				fillType = self:getFillUnitFirstSupportedFillType(self:getSprayerFillUnitIndex());
			end;
			g_effectManager:setFillType(spec.effects, fillType);
			g_effectManager:startEffects(spec.effects);
			if sprayType ~= nil then
				g_effectManager:setFillType(sprayType.effects, fillType);
				g_effectManager:startEffects(sprayType.effects);
			end;
		end;
		g_soundManager:playSample(spec.samples.work);
		if sprayType ~= nil then
			g_soundManager:playSample(sprayType.samples.work);
		end;		
		if self.spec_loweringSprayer.effectAnimationName ~= nil then
			self:playAnimation(self.spec_loweringSprayer.effectAnimationName, 1, nil, true);
		end;
    end;
	spec.lastSprayerEffectState = true;
end;

function LoweringSprayer:onTurnedOn()
    local spec = self.spec_sprayer;
	if self.spec_loweringSprayer.onlySprayIfLowered then
		if self.isClient then
			self:stopSprayerEffects();
		end;
	end;
end;

function LoweringSprayer:onStartWorkAreaProcessing(dt)
    local spec = self.spec_sprayer;	
    local spec_loweringSprayer = self.spec_loweringSprayer;	
	if spec_loweringSprayer.onlySprayIfLowered then
		if self.isClient then
			local start = false;			
			if self:getIsTurnedOn() then 
				local lastSpeed = self:getLastSpeed();
				if lastSpeed >= spec_loweringSprayer.startSpraySpeedLevel and self.movingDirection > 0 then
					if self:getIsLowered() then 
						start = true;
					end;
				end;
			end;			
			if start then
				if spec.lastSprayerEffectState == false then
					self:startSprayerEffects();
				end;			
			else
				if spec.lastSprayerEffectState == true then
					self:stopSprayerEffects();
				end;			
			end;			
		end;
	end;
end;
