--
-- HelperAdminGui
-- V1.0.0.0
--
-- @author apuehri|LS-Modcompany
-- Parts of this script are based on code from @Wopster.
-- Thanks for the permission to use it... :-)
-- @date 03/02/2019
--
-- Copyright (C) apuehri|LS-Modcompany
-- V1.0.0.0 ..... LS19 first implementation

haGui = {};
local haGui_mt = Class(haGui, TabbedMenu);

haGui.CONTROLS = {
    PAGE_GENSETTINGS = "pagehaGeneralSettings",
	PAGE_HELPERNAME = "pagehaHelperName",
}

-- Page tab UV coordinates for display elements
haGui.TAB_UV = {
    GENERALSETTINGS = { 65, 209, 65, 65 },
	HELPERNAME = { 455, 209, 65, 65 },
}

haGui.actGuiNumHelper = 0;
haGui.actGuiShowHelp = false;
haGui.actGuiNameMHelp = {};
haGui.actGuiNameWHelp = {};
haGui.actPricePerHour = 0;
haGui.actOvertimeFact1 = 0;
haGui.actOvertimeFact2 = 0;

function haGui:new(messageCenter, i18n, inputManager)
    local self = TabbedMenu:new(nil, haGui_mt, messageCenter, i18n, inputManager);

	self.i18n = i18n;
	
	self:registerControls(haGui.CONTROLS);
	
    return self;	
end;

function haGui:onGuiSetupFinished()
    haGui:superClass().onGuiSetupFinished(self)
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGui:onGuiSetupFinished...");
	end;
	
	self:initData();
	
    self.pagehaGeneralSettings:initialize();
	self.pagehaHelperName:initialize();
	
    self:setupPages();	
end;

function haGui:onOpen()
    haGui:superClass().onOpen(self)
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGui:onOpen...");
	end;
	
	self:initData();
	
    self.pagehaGeneralSettings:initialize();
	self.pagehaHelperName:initialize();
	
end;

function haGui:initData()
	haGui.actGuiNumHelper = (g_currentMission.maxNumHirables / 2);	
	haGui.actGuiShowHelp = helperadmin.showHelp;
	for i = 1, (helperadmin.maxHelper / 2), 1 do
		if (helperadmin.nameMan[i] == nil) or (helperadmin.nameMan[i] == "") then
			haGui.actGuiNameMHelp[i] = "Man"..tostring(i);
		else
			haGui.actGuiNameMHelp[i] = helperadmin.nameMan[i];
		end;
		if (helperadmin.nameWoman[i] == nil) or (helperadmin.nameWoman[i] == "") then
			haGui.actGuiNameWHelp[i] = "Woman"..tostring(i);
		else
			haGui.actGuiNameWHelp[i] = helperadmin.nameWoman[i];
		end;		
	end;
		
	haGui.actPricePerHour = helperadmin.pricePerHour;
	haGui.actOvertimeFact1 = helperadmin.overtimeFact1;
	haGui.actOvertimeFact2 = helperadmin.overtimeFact2;
end;

function haGui:setupPages()
    local predicate = self:makeIsAlwaysVisiblePredicate();

    local orderedPages = {
        -- default pages, their enabling state predicate functions and tab icon UVs in order
        { self.pagehaGeneralSettings, predicate, haGui.TAB_UV.GENERALSETTINGS },
		{ self.pagehaHelperName, predicate, haGui.TAB_UV.HELPERNAME },
    }

    for i, pageDef in ipairs(orderedPages) do
        local page, predicate, iconUVs = unpack(pageDef)
        self:registerPage(page, i, predicate);

        local normalizedUVs = getNormalizedUVs(iconUVs)
        self:addPageTab(page, g_baseUIFilename, normalizedUVs)
    end
end;


function haGui:setupMenuButtonInfo()
	local onButtonActivateFunction = self.clickActivateCallback;
    self.defaultMenuButtonInfo = {
        { inputAction = InputAction.MENU_BACK, text = self.i18n:getText('gui_hat_MenuExit'), callback = self.onButtonBack },
		{ inputAction = InputAction.MENU_ACTIVATE, text = self.i18n:getText('gui_hat_MenuAccept'), callback = self.onButtonActivate },
    }

    self.defaultMenuButtonInfoByActions[InputAction.MENU_BACK] = self.defaultMenuButtonInfo[1]
	self.defaultMenuButtonInfoByActions[InputAction.MENU_ACTIVATE] = self.defaultMenuButtonInfo[2]

    self.defaultButtonActionCallbacks = {
        [InputAction.MENU_BACK] = self.onButtonBack,
		[InputAction.MENU_ACTIVATE] = self.onButtonActivate,
    }
end

function haGui:makeIsAlwaysVisiblePredicate()
    return function()
        return true
    end
end;

function haGui:onButtonActivate()
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGui:onButtonActivate was pressed");
	end;
	helperadmin:UpdFromGui();
end;
