--
-- HelperAdminGui
-- GeneralSettingsFrame
-- V1.0.0.0
--
-- @author apuehri|LS-Modcompany
-- Parts of this script are based on code from @Wopster.
-- Thanks for the permission to use it... :-)
-- @date 03/02/2019
--
-- Copyright (C) apuehri|LS-Modcompany
-- V1.0.0.0 ..... LS19 first implementation

haGuiGeneralSettingsFrame = {};
local haGuiGeneralSettingsFrame_mt = Class(haGuiGeneralSettingsFrame, TabbedMenuFrameElement);

haGuiGeneralSettingsFrame.CONTROLS = {
    CONTAINER = "haContainer",
    NUM_HELPER = "guiNumHelper",
	SHOW_HELP = "guiShowHelp",
	PRICE_PER_HOUR = "guiPricePerHour",
	OVERTIME_FACT1 = "guiOvertimeFact1",
	OVERTIME_FACT2 = "guiOvertimeFact2",
}

haGuiGeneralSettingsFrame.PRICEPERHOUR = {
    [1] = 150.0,
    [2] = 200.0,
    [3] = 250.0,
    [4] = 300.0,
    [5] = 500.0,
	[6] = 1000.0,
	[7] = 2000.0,	
}

haGuiGeneralSettingsFrame.OTFACT1 = {
    [1] = 1.2,
    [2] = 1.5,
    [3] = 1.8,	
}

haGuiGeneralSettingsFrame.OTFACT2 = {
    [1] = 2.2,
    [2] = 2.8,
    [3] = 3.4,	
}

function haGuiGeneralSettingsFrame:new()
    local self = TabbedMenuFrameElement:new(nil, haGuiGeneralSettingsFrame_mt);
	
	self:registerControls(haGuiGeneralSettingsFrame.CONTROLS);

    return self;	
end;

function haGuiGeneralSettingsFrame:initialize()	
    local countHelper = {};
	local startval = helperadmin.minHelper
	local maxcount = ((helperadmin.maxHelper - startval) / 2) + 1;
	
    for i = 1, maxcount, 1 do
        countHelper[i] = tostring(startval);
		startval = startval + 2;	
    end	
	self.guiNumHelper:setTexts(countHelper);
	
	local index = ((g_currentMission.maxNumHirables - helperadmin.minHelper) / 2) + 1;
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGuiGeneralSettingsFrame:initialize(self.guiNumHelper:setState= "..tostring(index)..")");
	end;
	self.guiNumHelper:setState(index, false);
		
	self.guiShowHelp:setIsChecked(haGui.actGuiShowHelp);
	
	self.guiPricePerHour:setTexts(haGuiGeneralSettingsFrame.PRICEPERHOUR);
	for k, v in ipairs(haGuiGeneralSettingsFrame.PRICEPERHOUR) do
		if (v == haGui.actPricePerHour) then
			self.guiPricePerHour:setState(k, false);
			break;
		end;
	end;
	
	self.guiOvertimeFact1:setTexts(haGuiGeneralSettingsFrame.OTFACT1);
	for k, v in ipairs(haGuiGeneralSettingsFrame.OTFACT1) do
		local value = math.round(v,0.1);	
		if (value == haGui.actOvertimeFact1) then
			self.guiOvertimeFact1:setState(k, false);
			break;
		end;
	end;
	
	self.guiOvertimeFact2:setTexts(haGuiGeneralSettingsFrame.OTFACT2);
	for k, v in ipairs(haGuiGeneralSettingsFrame.OTFACT2) do
		local value = math.round(v,0.1);
		if (value == haGui.actOvertimeFact2) then
			self.guiOvertimeFact2:setState(k, false);
			break;
		end;
	end;
end;

function haGuiGeneralSettingsFrame:onFrameOpen()
    haGuiGeneralSettingsFrame:superClass().onFrameOpen(self);
	
end;

function haGuiGeneralSettingsFrame:onFrameClose()
    haGuiGeneralSettingsFrame:superClass().onFrameClose(self);
	
end;

--- Get the frame's main content element's screen size.
function haGuiGeneralSettingsFrame:getMainElementSize()
    return self.haContainer.size
end;

--- Get the frame's main content element's screen position.
function haGuiGeneralSettingsFrame:getMainElementPosition()
    return self.haContainer.absPosition
end;

-- ------------------ USER ------------------
function haGuiGeneralSettingsFrame:onClickNumHelper()
	haGui.actGuiNumHelper = self.guiNumHelper:getState() + 2;
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGuiGeneralSettingsFrame:onClickNumHelper(haGui.actGuiNumHelper = ".. tostring(haGui.actGuiNumHelper)..")");
	end;
end;

function haGuiGeneralSettingsFrame:onClickShowHelp()
	haGui.actGuiShowHelp = Utils.getNoNil(self.guiShowHelp:getIsChecked(), true);
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGuiGeneralSettingsFrame:onClickShowHelp(haGui.actGuiShowHelp = ".. tostring(haGui.actGuiShowHelp)..")");
	end;
end;

function haGuiGeneralSettingsFrame:onClickPricePerHour()
	local state = self.guiPricePerHour:getState();
	haGui.actPricePerHour = haGuiGeneralSettingsFrame.PRICEPERHOUR[state];
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGuiGeneralSettingsFrame:onClickPricePerHour(haGui.actPricePerHour = ".. tostring(haGui.actPricePerHour)..")");
	end;
end;

function haGuiGeneralSettingsFrame:onClickOvertimeFact1()
	local state = self.guiOvertimeFact1:getState();
	haGui.actOvertimeFact1 = haGuiGeneralSettingsFrame.OTFACT1[state];
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGuiGeneralSettingsFrame:onClickOvertimeFact1(haGui.actOvertimeFact1 = ".. tostring(haGui.actOvertimeFact1)..")");
	end;
end;

function haGuiGeneralSettingsFrame:onClickOvertimeFact2()
	local state = self.guiOvertimeFact2:getState();
	haGui.actOvertimeFact2 = haGuiGeneralSettingsFrame.OTFACT2[state];
	if helperadmin.debug then
		print("--- HelperAdminGui Debug ... haGuiGeneralSettingsFrame:onClickOvertimeFact2(haGui.actOvertimeFact2 = ".. tostring(haGui.actOvertimeFact2)..")");
	end;
end;