--
-- HelperAdminTools
-- V1.0.0.0
--
-- @author apuehri|LS-Modcompany
-- @date 11/02/2019
--
-- Copyright (C) apuehri|LS-Modcompany
-- V1.0.0.0 ..... LS19 first implementation

helperAdminTools = {};
helperAdminTools.debug = false;

function helperAdminTools:getData(hatDebug, hatPricePerHour, hatOvertimeFact1, hatOvertimeFact2)
	helperAdminTools.debug = hatDebug;
	helperAdminTools.pricePerHour = hatPricePerHour;
	helperAdminTools.OvertimeFact1 = hatOvertimeFact1;
	helperAdminTools.OvertimeFact2 = hatOvertimeFact2;
end;

function helperAdminTools.prerequisitesPresent(specializations)
	return true;
end;

function helperAdminTools.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onUpdateTick",
		"onWriteStream",
		"onReadStream"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, helperAdminTools);
	end;
end;

function helperAdminTools:onLoad(savegame)
	local specAiVehicle = self.spec_aiVehicle
	local specHelperAdminTools = self.spec_helperAdminTools;
	specHelperAdminTools.debugPrintDone = false;
	
	if helperAdminTools.debug then
		print("--- HelperAdminTools Debug --- helperAdminTools:onLoad(old pricePerMS= "..tostring(specAiVehicle.pricePerMS)..")");		
	end;

	local pricePerHour = Utils.getNoNil(helperAdminTools.pricePerHour, 300.0);
	specAiVehicle.pricePerMS = pricePerHour/60/60/1000;
	if helperAdminTools.debug then
		print("--- HelperAdminTools Debug --- helperAdminTools:onLoad(NEW pricePerHour= "..tostring(pricePerHour)..", pricePerMS= "..tostring(specAiVehicle.pricePerMS)..")");		
	end;	
end;

function helperAdminTools:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local specAiVehicle = self.spec_aiVehicle;
	local specHelperAdminTools = self.spec_helperAdminTools;

    if self.isServer then
        if self:getIsAIActive() then
            local difficultyMultiplier = g_currentMission.missionInfo.buyPriceMultiplier;
			local actPricePerMS = Utils.getNoNil(helperAdminTools.pricePerHour, 1000.0)/60/60/1000;
			local overtimeFact1 = Utils.getNoNil(helperAdminTools.OvertimeFact1, 1.8);
			local overtimeFact2 = Utils.getNoNil(helperAdminTools.OvertimeFact2, 3.4);
		
			local basicPrice = -dt * difficultyMultiplier * specAiVehicle.pricePerMS;
			local actPrice = -dt * difficultyMultiplier * actPricePerMS;
			
			local priceDiff = actPrice - basicPrice;
			if (math.abs(g_currentMission.environment.currentHour) >= 18) and (math.abs(g_currentMission.environment.currentHour) <= 21) then
				priceDiff = (actPrice * overtimeFact1) - basicPrice;
			end;
			if ((math.abs(g_currentMission.environment.currentHour) >= 0) and (math.abs(g_currentMission.environment.currentHour) <= 5)) or ((math.abs(g_currentMission.environment.currentHour) >= 22) and (math.abs(g_currentMission.environment.currentHour) <= 23)) then
				priceDiff = (actPrice * overtimeFact2) - basicPrice;
			end;	
	
			g_currentMission:addMoney(priceDiff, specAiVehicle.startedFarmId, MoneyType.AI, true);
			
			if helperAdminTools.debug and not specHelperAdminTools.debugPrintDone then
				print("--- HelperAdminTools Debug --- helperAdminTools:onUpdateTick(basicPrice= "..tostring(basicPrice)..")");
				print("--- HelperAdminTools Debug --- helperAdminTools:onUpdateTick(actPrice  = "..tostring(actPrice)..")");
				print("--- HelperAdminTools Debug --- helperAdminTools:onUpdateTick(overtimeFact1  = "..tostring(overtimeFact1)..")");
				print("--- HelperAdminTools Debug --- helperAdminTools:onUpdateTick(overtimeFact2  = "..tostring(overtimeFact2)..")");
				print("--- HelperAdminTools Debug --- helperAdminTools:onUpdateTick(priceDiff = "..tostring(priceDiff)..")");
				specHelperAdminTools.debugPrintDone = true
			end
		else
			specHelperAdminTools.debugPrintDone = false;
		end;
	end;
	
end;

function helperAdminTools:onWriteStream(streamId, connection)
end;

function helperAdminTools:onReadStream(streamId, connection)
end;