--
-- HelperAdmin
-- V1.1.0.0
--
-- @author apuehri|LS-Modcompany
-- @date 03/02/2019
--
-- Copyright (C) apuehri|LS-Modcompany
-- V1.0.0.0 ..... LS19 first implementation
-- V1.0.1.0 ..... added spanish translation
-- V1.1.0.0 ..... multiplayer integration
-- V1.1.0.1 ..... bugfix Error print

helperadmin = {};
helperadmin.Version = "1.1.0.1";
helperadmin.debug = false;
helperadmin.dir = g_currentModDirectory;
helperadmin.minHelper = 6;
helperadmin.maxHelper = 20;

source(Utils.getFilename("l10n/l10nGuiModul.lua", helperadmin.dir));
source(Utils.getFilename("gui/haGui.lua", helperadmin.dir));
source(Utils.getFilename("gui/haGuiGeneralSettingsFrame.lua", helperadmin.dir));
source(Utils.getFilename("gui/haGuiHelperNameFrame.lua", helperadmin.dir));
source(Utils.getFilename("scripts/utils.lua", helperadmin.dir));
source(Utils.getFilename("scripts/RegisterSpecialization.lua", helperadmin.dir));

addModEventListener(helperadmin);

function helperadmin.prerequisitesPresent(specializations)
    return true;
end;

function helperadmin:loadMap(name)
	if helperadmin.debug then
		print("--- HelperAdmin Debug ... helperadmin:loadMap ++ isClient="..tostring(g_currentMission:getIsClient()).." ,isServer="..tostring(g_currentMission:getIsServer()).." ,isMasterUser="..tostring(g_currentMission.isMasterUser).." ,isMultiplayer="..tostring(g_currentMission.missionDynamicInfo.isMultiplayer).." ---");
	end;
    -- Only needed for action event for player
    Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, helperadmin.registerActionEventsPlayer);
	Player.removeActionEvents = Utils.appendedFunction(Player.removeActionEvents, helperadmin.removeActionEventsPlayer);		
		
	-- SaveSettings
	FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, helperadmin.saveSettings);
	
	-- make text global for Gui
	setModTextGlobal(g_i18n);
	
	--initialize
	helperadmin.nameMan = {};
	helperadmin.nameWoman = {};
	helperadmin.newNumHirables = 6;
	helperadmin.showHelp = true;
	helperadmin.eventName = {};
	helperadmin.pricePerHour = 1000.0;
	helperadmin.overtimeFact1 = 1.8;
	helperadmin.overtimeFact2 = 3.4;
	
	--load Savegame
	local savegameIndex = g_currentMission.missionInfo.savegameIndex;
	local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
	if savegameFolderPath == nil then
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
	end;

	if g_currentMission:getIsServer() then
		if fileExists(savegameFolderPath .. '/careerSavegame.xml') then
			if fileExists(savegameFolderPath .. '/helperAdmin.xml') then
				print("--- loading HelperAdmin V".. helperadmin.Version .. " (c) by apuehri|LS-Modcompany --- loading savegame ---");
				local key = "helperAdmin";
				local xmlFile = loadXMLFile("helperAdmin", savegameFolderPath .. "/helperAdmin.xml", key);			
				if xmlFile ~= nil then
					for i=1, helperadmin.maxHelper do
						-- man
						local XmlNameMan = getXMLString(xmlFile, key .."#nameMan"..i);
						if XmlNameMan ~= nil then
							helperadmin.nameMan[i] = XmlNameMan;
						end;
						-- woman
						local XmlNameWoman = getXMLString(xmlFile, key .."#nameWoman"..i);
						if XmlNameWoman ~= nil then
							helperadmin.nameWoman[i] = XmlNameWoman;
						else
							break;						
						end;
					end;
					-- ShowHelp
					helperadmin.showHelp = Utils.getNoNil(getXMLBool(xmlFile, key.."#showHelp"), true);
					-- PricePerHour
					helperadmin.pricePerHour = Utils.getNoNil(getXMLFloat(xmlFile, key.."#pricePerHour"), 1000.0);
					-- Overtime Factors
					helperadmin.overtimeFact1 = Utils.getNoNil(getXMLFloat(xmlFile, key.."#overtimeFact1"), 1.8);
					helperadmin.overtimeFact1 = math.round(helperadmin.overtimeFact1, 0.1);
					helperadmin.overtimeFact2 = Utils.getNoNil(getXMLFloat(xmlFile, key.."#overtimeFact2"), 3.4);
					helperadmin.overtimeFact2 = math.round(helperadmin.overtimeFact2, 0.1);
				end;
				delete(xmlFile);
			else
				helperadmin.nameMan = {"Andy";"Phillip";"Franz";};
				helperadmin.nameWoman = {"Betty";"Sarah";"Elisabeth";};
				print("--- loading HelperAdmin V".. helperadmin.Version .. " (c) by apuehri|LS-Modcompany --- loading initialvalues ---");			
			end;		
		else
			helperadmin.nameMan = {"Andy";"Phillip";"Franz";};
			helperadmin.nameWoman = {"Betty";"Sarah";"Elisabeth";};
			print("--- loading HelperAdmin V".. helperadmin.Version .. " (c) by apuehri|LS-Modcompany --- loading initialvalues ---");	
		end;	

		-- register new helpers
		if (g_currentMission ~= nil) and (HelperManager ~= nil) and (g_helperManager ~= nil) then
			helperadmin:regNewHelpers();
		end;
	end;
		
	--gui
	local generalSettingsFrame = haGuiGeneralSettingsFrame:new();
	local HelperNameFrame = haGuiHelperNameFrame:new();

    helperadmin.gui = {};
    helperadmin.gui["haSettingGui"] = haGui:new(g_messageCenter, g_i18n, g_gui.inputManager);
	
	g_gui:loadGui(helperadmin.dir .. "gui/haGuiGeneralSettingsFrame.xml", "haGuiGeneralSettingsFrame", generalSettingsFrame, true);
	g_gui:loadGui(helperadmin.dir .. "gui/haGuiHelperNameFrame.xml", "haGuiHelperNameFrame", HelperNameFrame, true);
    g_gui:loadGui(helperadmin.dir .. "gui/haGui.xml", "haGui", helperadmin.gui.haSettingGui);

	--Data to helperAdminTools
	helperAdminTools:getData(helperadmin.debug, helperadmin.pricePerHour, helperadmin.overtimeFact1, helperadmin.overtimeFact2);
end;

function helperadmin:loadSavegame() 
end;

function helperadmin:registerActionEventsPlayer()
	-- HelperAdmin Setting	
	local result, eventName = InputBinding.registerActionEvent(g_inputBinding, 'hat_setting',self, helperadmin.actionHelperadmin_Setting ,false ,true ,false ,true)
	if result then
		table.insert(helperadmin.eventName, eventName);
        g_inputBinding.events[eventName].displayIsVisible = helperadmin.showHelp;
    end
	if helperadmin.debug then
		print("--- HelperAdmin Debug ... helperadmin:registerActionEventsPlayer(helperadmin.eventName)");
		DebugUtil.printTableRecursively(helperadmin.eventName,"----",0,1)
	end;	
end;

function helperadmin:removeActionEventsPlayer()
	helperadmin.eventName = {};
	if helperadmin.debug then
		print("--- HelperAdmin Debug ... helperadmin:removeActionEventsPlayer(helperadmin.eventName)");
		DebugUtil.printTableRecursively(helperadmin.eventName,"----",0,1)
	end;
end;

function helperadmin:mouseEvent(posX, posY, isDown, isUp, button)
end;

function helperadmin:keyEvent(unicode, sym, modifier, isDown)
end;

function helperadmin:update(dt)
end;

function helperadmin:draw()   
end;

function helperadmin:UpdFromGui()   
	--Update Show Help
	helperadmin.showHelp = haGui.actGuiShowHelp;
	for i=1, #helperadmin.eventName, 1 do
		if (g_inputBinding.events[helperadmin.eventName[i]] ~= nil) then
			g_inputBinding.events[helperadmin.eventName[i]].displayIsVisible = helperadmin.showHelp;
		end;	
	end;	
	
	if (haGui.actGuiNumHelper ~= nil) then
		helperadmin.nameMan = {};
		helperadmin.nameWoman = {};		
		for i = 1, haGui.actGuiNumHelper, 1 do
			if (haGui.actGuiNameMHelp[i] ~= nil) and (haGui.actGuiNameMHelp[i] ~= "") then
				helperadmin.nameMan[i] = haGui.actGuiNameMHelp[i];
			else
				helperadmin.nameMan[i] = "Man"..tostring(i);
			end;
			if (haGui.actGuiNameWHelp[i] ~= nil) and (haGui.actGuiNameWHelp[i] ~= "") then
				helperadmin.nameWoman[i] = haGui.actGuiNameWHelp[i];
			else
				helperadmin.nameWoman[i] = "Woman" ..i;
			end;
		end

		helperadmin.pricePerHour = haGui.actPricePerHour;
		helperadmin.overtimeFact1 = haGui.actOvertimeFact1;
		helperadmin.overtimeFact2 = haGui.actOvertimeFact2;
		--Data to helperAdminTools
		helperAdminTools:getData(helperadmin.debug, helperadmin.pricePerHour, helperadmin.overtimeFact1, helperadmin.overtimeFact2);		
		
		if helperadmin.debug then
			print("--- HelperAdmin Debug ... helperadmin:UpdFromGui(haGui.actGuiNumHelper = "..tostring(haGui.actGuiNumHelper)..")");
			print("--- HelperAdmin Debug ... helperadmin:UpdFromGui(haGui.actGuiShowHelp = "..tostring(haGui.actGuiShowHelp)..")");
			print("--- HelperAdmin Debug ... helperadmin:UpdFromGui(helperadmin.nameMan)");
			DebugUtil.printTableRecursively(helperadmin.nameMan,"*n* ", 0, 1);
			print("--- HelperAdmin Debug ... helperadmin:UpdFromGui(helperadmin.nameWoman)");
			DebugUtil.printTableRecursively(helperadmin.nameWoman,"*n* ", 0, 1);
			print("--- HelperAdmin Debug ... helperadmin:UpdFromGui(haGui.actPricePerHour = "..tostring(haGui.actPricePerHour)..")");
			print("--- HelperAdmin Debug ... helperadmin:UpdFromGui(haGui.actOvertimeFact1 = "..tostring(haGui.actOvertimeFact1)..")");
			print("--- HelperAdmin Debug ... helperadmin:UpdFromGui(haGui.actOvertimeFact2 = "..tostring(haGui.actOvertimeFact2)..")");
		end;		
	end;
	
	-- send data from gui to server
	haMultiplayerUpdEvent.sendEvent();
	
end;

function helperadmin:regNewHelpers()
	if (#helperadmin.nameMan == #helperadmin.nameWoman) then
		if helperadmin.debug then
			print("--- HelperAdmin Debug --- helperadmin:RegNewHelpers List of old Helpers........");
			DebugUtil.printTableRecursively(g_helperManager,"--- HelperAdmin Debug --- ", 0, 5);		
		end;		
		
		helperadmin.newNumHirables = #helperadmin.nameMan + #helperadmin.nameWoman;
		if (helperadmin.newNumHirables ~= nil) and (helperadmin.newNumHirables >= helperadmin.minHelper) and (helperadmin.newNumHirables <= helperadmin.maxHelper) then
			g_currentMission.maxNumHirables	= helperadmin.newNumHirables;
			if helperadmin.debug then
				print("--- HelperAdmin Debug ... helperadmin:RegNewHelpers(g_currentMission.maxNumHirables) = ".. g_currentMission.maxNumHirables);
			end;
		else
			print("--- HelperAdmin Error ... Number of helpers too low (min " ..tostring(helperadmin.minHelper)..") or too high (max" ..tostring(helperadmin.maxHelper).."), no changes have been made !! ---");
			return;
		end;
		
		g_helperManager:initDataStructures(); --Init Datas		
		
		-- Register new Helpers
		-- Info helperxx.xml
		-- 		man (helper01.xml,helper02.xml,helper03.xml,helper05.xml,helper06.xml)
		-- 		woman (helper04.xml,helper07.xml,helper08.xml,helper09.xml,helper10.xml)
		local HelperManXml = {[1]="dataS2/character/helper/helper01.xml",[2]="dataS2/character/helper/helper02.xml",[3]="dataS2/character/helper/helper03.xml",[4]="dataS2/character/helper/helper05.xml",[5]="dataS2/character/helper/helper06.xml"};
		local HelperWomanXml = {[1]="dataS2/character/helper/helper04.xml",[2]="dataS2/character/helper/helper07.xml",[3]="dataS2/character/helper/helper08.xml",[4]="dataS2/character/helper/helper09.xml",[5]="dataS2/character/helper/helper10.xml"};	

		local manNameIndex = 1;
		local womanNameIndex = 1;
				
		for i=1, g_currentMission.maxNumHirables do
			local calcmod = math.fmod(i,2);
			local maxNameIndex = 0;
			if calcmod == 1 then				
				local xmlIndex = math.random(1,5);
				g_helperManager:addHelper(helperadmin.nameMan[manNameIndex], helperadmin.nameMan[manNameIndex], HelperManXml[xmlIndex], nil, true);
				maxNameIndex = #helperadmin.nameMan;
				if manNameIndex < maxNameIndex then
					manNameIndex = manNameIndex + 1;
				else
					manNameIndex = 1;
				end;				
			else				
				local xmlIndex = math.random(1,5);
				g_helperManager:addHelper(helperadmin.nameWoman[womanNameIndex], helperadmin.nameWoman[womanNameIndex], HelperWomanXml[xmlIndex], nil, true);
				maxNameIndex = #helperadmin.nameWoman;
				if womanNameIndex < maxNameIndex then
					womanNameIndex = womanNameIndex + 1;
				else
					womanNameIndex = 1;
				end;
			end;	
		end;

		if helperadmin.debug then
			print("--- HelperAdmin Debug --- helperadmin:RegNewHelpers List of new Helpers........");
			DebugUtil.printTableRecursively(g_helperManager,"--- HelperAdmin Debug --- ", 0, 5);		
		end;
	else
		print("--- HelperAdmin Error ... Number of male and female helpers is different, no changes have been made !! ---");
	end;
end;

function helperadmin:saveSettings()
	local savegameIndex = g_currentMission.missionInfo.savegameIndex;
	local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
	if savegameFolderPath == nil then
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
	end;
	
	local key = "helperAdmin";
	local xmlFile = createXMLFile("helperAdmin", savegameFolderPath .. "/helperAdmin.xml", key);
	
	for i=1, #helperadmin.nameMan do			
		setXMLString(xmlFile, key .."#nameMan"..i, helperadmin.nameMan[i]);
	end;
	for i=1, #helperadmin.nameWoman do
		setXMLString(xmlFile, key .."#nameWoman"..i, helperadmin.nameWoman[i]);
	end;
	-- ShowHelp
	setXMLBool(xmlFile, key .. "#showHelp", helperadmin.showHelp);
	-- PricePerHour
	setXMLFloat(xmlFile, key.."#pricePerHour", helperadmin.pricePerHour);
	-- Overtime Factors
	setXMLFloat(xmlFile, key.."#overtimeFact1", helperadmin.overtimeFact1);
	setXMLFloat(xmlFile, key.."#overtimeFact2", helperadmin.overtimeFact2);

	saveXMLFile(xmlFile);
	delete(xmlFile);	
end;

function helperadmin:actionHelperadmin_Setting(actionName, keyStatus, arg3, arg4, arg5)
	if g_currentMission.isMasterUser then
		if (#g_helperManager.availableHelpers == g_helperManager.numHelpers) then
			if g_gui.currentGui == nil then		
				g_gui:showGui("haGui")
			end
		end;
	end;
end;

-- *****+++++*****+++++ Multiplayer *****+++++*****+++++
local origServerSendObjects = Server.sendObjects;

function Server:sendObjects(connection, x, y, z, viewDistanceCoeff)
	connection:sendEvent(haMultiplayerJoinEvent:new());
	return origServerSendObjects(self, connection, x, y, z, viewDistanceCoeff);
end;

haMultiplayerJoinEvent = {};
haMultiplayerJoinEvent_mt = Class(haMultiplayerJoinEvent, Event);
InitEventClass(haMultiplayerJoinEvent, 'haMultiplayerJoinEvent');

function haMultiplayerJoinEvent:emptyNew()
	local self = Event:new(haMultiplayerJoinEvent_mt);
	self.className = 'helperadmin.haMultiplayerJoinEvent';
	return self;
end;

function haMultiplayerJoinEvent:new()
	local self = haMultiplayerJoinEvent:emptyNew()
	return self;
end;

-- Send data from the server to the client haMultiplayerJoinEvent
function haMultiplayerJoinEvent:writeStream(streamId, connection)
	if not connection:getIsServer() then	
		if helperadmin.debug then
			print("--- HelperAdmin Debug ... sending data to joining client: ..... ---");
		end;
		streamWriteUInt8(streamId, g_currentMission.maxNumHirables);
		for i = 1, (g_currentMission.maxNumHirables / 2) do
			streamWriteString(streamId, helperadmin.nameMan[i]);
			streamWriteString(streamId, helperadmin.nameWoman[i]);
		end;
		streamWriteBool(streamId, helperadmin.showHelp);
		streamWriteFloat32(streamId, helperadmin.pricePerHour);
		streamWriteFloat32(streamId, helperadmin.overtimeFact1);
		streamWriteFloat32(streamId, helperadmin.overtimeFact2);
	end;	
end;

-- Read from the server haMultiplayerJoinEvent
function haMultiplayerJoinEvent:readStream(streamId, connection)
	if connection:getIsServer() then
		if helperadmin.debug then
			print("--- HelperAdmin Debug ... reading data from server: ..... ---");
		end;
		g_currentMission.maxNumHirables = streamReadUInt8(streamId);
		for i = 1, (g_currentMission.maxNumHirables / 2) do
			helperadmin.nameMan[i] = streamReadString(streamId);
			helperadmin.nameWoman[i] = streamReadString(streamId);
		end;
		helperadmin.showHelp = streamReadBool(streamId);
		helperadmin.pricePerHour = streamReadFloat32(streamId);
		helperadmin.overtimeFact1 = math.round(streamReadFloat32(streamId), 0.1);
		helperadmin.overtimeFact2 = math.round(streamReadFloat32(streamId), 0.1);
		
		-- register new helpers
		if (g_currentMission ~= nil) and (HelperManager ~= nil) and (g_helperManager ~= nil) then
			helperadmin:regNewHelpers();
		end;		
	end;
end;


haMultiplayerUpdEvent = {};
haMultiplayerUpdEvent_mt = Class(haMultiplayerUpdEvent, Event);
InitEventClass(haMultiplayerUpdEvent, 'haMultiplayerUpdEvent');

function haMultiplayerUpdEvent:emptyNew()
	local self = Event:new(haMultiplayerUpdEvent_mt);
	self.className = 'helperadmin.haMultiplayerUpdEvent';
	return self;
end;

function haMultiplayerUpdEvent:new()
	local self = haMultiplayerUpdEvent:emptyNew()
	return self;
end;

-- Send data from the client to the server haMultiplayerUpdEvent
function haMultiplayerUpdEvent:writeStream(streamId, connection)
	if connection:getIsServer() then	
		if helperadmin.debug then
			print("--- HelperAdmin Debug ... sending data to server: ..... ---");
		end;
		streamWriteUInt8(streamId, haGui.actGuiNumHelper);
		for i = 1, haGui.actGuiNumHelper do
			streamWriteString(streamId, helperadmin.nameMan[i]);
			streamWriteString(streamId, helperadmin.nameWoman[i]);
		end;
		streamWriteBool(streamId, helperadmin.showHelp);
		streamWriteFloat32(streamId, helperadmin.pricePerHour);
		streamWriteFloat32(streamId, helperadmin.overtimeFact1);
		streamWriteFloat32(streamId, helperadmin.overtimeFact2);
	end;	
end;

-- Read from the client haMultiplayerUpdEvent
function haMultiplayerUpdEvent:readStream(streamId, connection)
	if not connection:getIsServer() then
		if helperadmin.debug then
			print("--- HelperAdmin Debug ... reading data from client: ..... ---");
		end;
		local newNumHelpGui = streamReadUInt8(streamId);
		for i = 1, newNumHelpGui do
			helperadmin.nameMan[i] = streamReadString(streamId);
			helperadmin.nameWoman[i] = streamReadString(streamId);
		end;
		helperadmin.showHelp = streamReadBool(streamId);
		helperadmin.pricePerHour = streamReadFloat32(streamId);
		helperadmin.overtimeFact1 = math.round(streamReadFloat32(streamId), 0.1);
		helperadmin.overtimeFact2 = math.round(streamReadFloat32(streamId), 0.1);
	end;
end;

function haMultiplayerUpdEvent:sendEvent()
	if g_currentMission.missionDynamicInfo.isMultiplayer and not g_currentMission:getIsServer() then
        -- Send to server
        g_client:getServerConnection():sendEvent(haMultiplayerUpdEvent:new());
	end;
end
